/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.SyncedEntity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A metric represents a monitored \"quality\". Its metric type specifies the unit in which the metric reports its values and the collection interval specifies how often the feed should be collecting the metric for changes in value.", parent=SyncedEntity.class)
public final class Metric
extends SyncedEntity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.m;
    private final MetricType type;
    private final Long collectionInterval;

    private Metric() {
        this.type = null;
        this.collectionInterval = null;
    }

    public Metric(CanonicalPath path, String identityHash, String contentHash, String syncHash, MetricType type) {
        this(null, path, identityHash, contentHash, syncHash, type, null, null);
    }

    public Metric(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, MetricType type) {
        this(name, path, identityHash, contentHash, syncHash, type, null, null);
    }

    public Metric(CanonicalPath path, String identityHash, String contentHash, String syncHash, MetricType type, Long collectionInterval) {
        this(null, path, identityHash, contentHash, syncHash, type, collectionInterval, null);
    }

    public Metric(CanonicalPath path, String identityHash, String contentHash, String syncHash, MetricType type, Map<String, Object> properties) {
        this(null, path, identityHash, contentHash, syncHash, type, null, properties);
    }

    public Metric(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, MetricType type, Long collectionInterval, Map<String, Object> properties) {
        super(name, path, identityHash, contentHash, syncHash, properties);
        this.type = type;
        this.collectionInterval = collectionInterval;
    }

    @Override
    public AbstractElement.Updater<Update, Metric> update() {
        return new AbstractElement.Updater<Update, Metric>(u -> new Metric(u.getName(), this.getPath(), this.getIdentityHash(), this.getContentHash(), this.getSyncHash(), this.getType(), u.getCollectionInterval(), u.getProperties()), this, Update.builder());
    }

    public MetricType getType() {
        return this.type;
    }

    public Long getCollectionInterval() {
        return this.collectionInterval;
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", definition=").append(this.type);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetric(this, parameter);
    }

    @ApiModel(value="MetricUpdate")
    public static final class Update
    extends Entity.Update {
        private final Long collectionInterval;

        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this((Map<String, Object>)null, (Long)null);
        }

        public Update(Map<String, Object> properties, Long collectionInterval) {
            super(null, properties);
            this.collectionInterval = collectionInterval;
        }

        public Update(String name, Map<String, Object> properties, Long collectionInterval) {
            super(name, properties);
            this.collectionInterval = collectionInterval;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetric(this, parameter);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Update update = (Update)o;
            return this.collectionInterval != null ? this.collectionInterval.equals(update.collectionInterval) : update.collectionInterval == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.collectionInterval != null ? this.collectionInterval.hashCode() : 0);
            return result;
        }

        public static final class Builder
        extends Entity.Update.Builder<Metric, Update, Builder> {
            private Long collectionInterval;

            public Builder withInterval(Long interval) {
                this.collectionInterval = interval;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.name, this.properties, this.collectionInterval);
            }

            @Override
            public Builder withDifference(Metric original, Metric updated) {
                if (!Objects.equals(original.getCollectionInterval(), updated.getCollectionInterval())) {
                    this.withInterval(updated.getCollectionInterval());
                }
                return (Builder)super.withDifference(original, updated);
            }
        }
    }

    @ApiModel(value="MetricBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        private final String metricTypePath;
        private final Long collectionInterval;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this.metricTypePath = null;
            this.collectionInterval = null;
        }

        public Blueprint(String metricTypePath, String id) {
            this(metricTypePath, id, Collections.emptyMap());
        }

        public Blueprint(String metricTypePath, String id, Map<String, Object> properties) {
            super(id, properties);
            this.metricTypePath = metricTypePath;
            this.collectionInterval = null;
        }

        public Blueprint(String metricTypePath, String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.metricTypePath = metricTypePath;
            this.collectionInterval = null;
        }

        public Blueprint(String metricTypePath, String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
            this.metricTypePath = metricTypePath;
            this.collectionInterval = null;
        }

        public Blueprint(String metricTypePath, String id, String name, Long collectionInterval, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
            this.metricTypePath = metricTypePath;
            this.collectionInterval = collectionInterval;
        }

        public String getMetricTypePath() {
            return this.metricTypePath;
        }

        public Long getCollectionInterval() {
            return this.collectionInterval;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetric(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String metricTypeId;
            private Long collectionInterval;

            public Builder withMetricTypePath(String metricTypePath) {
                this.metricTypeId = metricTypePath;
                return this;
            }

            public Builder withInterval(Long interval) {
                this.collectionInterval = interval;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.metricTypeId, this.id, this.name, this.collectionInterval, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

