/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.SyncedEntity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A resource has a type, can have configuration and connection configuration and can incorporate metrics.", parent=SyncedEntity.class)
public final class Resource
extends SyncedEntity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.r;
    private final ResourceType type;

    private Resource() {
        this.type = null;
    }

    public Resource(CanonicalPath path, String identityHash, String contentHash, String syncHash, ResourceType type) {
        this(path, identityHash, contentHash, syncHash, type, null);
    }

    public Resource(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, ResourceType type) {
        this(name, path, identityHash, contentHash, syncHash, type, null);
    }

    public Resource(CanonicalPath path, String identityHash, String contentHash, String syncHash, ResourceType type, Map<String, Object> properties) {
        super(path, identityHash, contentHash, syncHash, properties);
        this.type = type;
    }

    public Resource(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, ResourceType type, Map<String, Object> properties) {
        super(name, path, identityHash, contentHash, syncHash, properties);
        this.type = type;
    }

    @Override
    public AbstractElement.Updater<Update, Resource> update() {
        return new AbstractElement.Updater<Update, Resource>(u -> new Resource(u.getName(), this.getPath(), this.getIdentityHash(), this.getContentHash(), this.getSyncHash(), this.getType(), u.getProperties()), this, Update.builder());
    }

    public ResourceType getType() {
        return this.type;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitResource(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", type=").append(this.type);
    }

    @ApiModel(value="ResourceUpdate")
    public static final class Update
    extends Entity.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(null, properties);
        }

        public Update(String name, Map<String, Object> properties) {
            super(name, properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitResource(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Resource, Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.name, this.properties);
            }
        }
    }

    @ApiModel(value="ResourceBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        private final String resourceTypePath;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this.resourceTypePath = null;
        }

        public Blueprint(String id, String resourceTypePath) {
            this(id, resourceTypePath, Collections.emptyMap());
        }

        public Blueprint(String id, String resourceTypePath, Map<String, Object> properties) {
            super(id, properties);
            this.resourceTypePath = resourceTypePath;
        }

        public Blueprint(String id, String resourceTypePath, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.resourceTypePath = resourceTypePath;
        }

        public Blueprint(String id, String name, String resourceTypePath, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
            this.resourceTypePath = resourceTypePath;
        }

        public String getResourceTypePath() {
            return this.resourceTypePath;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitResource(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String resourceTypePath;

            public Builder withResourceTypePath(String resourceTypePath) {
                this.resourceTypePath = resourceTypePath;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.resourceTypePath, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

