/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.spi.Discriminator;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.EntityHistory;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;

public class BackendTransaction<E>
implements Transaction<E> {
    private final InventoryBackend<E> backend;
    private final Transaction.PreCommit<E> preCommit;

    public BackendTransaction(InventoryBackend<E> backend, Transaction.PreCommit<E> preCommit) {
        this.backend = backend;
        this.preCommit = preCommit;
    }

    @Override
    public InventoryBackend<E> directAccess() {
        return this.backend;
    }

    @Override
    public void registerCommittedPayload(TransactionPayload.Committing<?, E> committedPayload) {
    }

    @Override
    public Transaction.PreCommit<E> getPreCommit() {
        return this.preCommit;
    }

    @Override
    public <T> T convert(Discriminator discriminator, E entityRepresentation, Class<T> entityType) {
        return this.backend.convert(discriminator, entityRepresentation, entityType);
    }

    @Override
    public void markDeleted(Discriminator discriminator, E entity) {
        this.backend.markDeleted(discriminator, entity);
    }

    @Override
    public void deleteStructuredData(E dataRepresentation) {
        this.backend.deleteStructuredData(dataRepresentation);
    }

    @Override
    public E descendToData(Discriminator discriminator, E dataEntityRepresentation, RelativePath dataPath) {
        return this.backend.descendToData(discriminator, dataEntityRepresentation, dataPath);
    }

    @Override
    public void eradicate(E entityRepresentation) {
        this.backend.eradicate(entityRepresentation);
    }

    @Override
    public CanonicalPath extractCanonicalPath(E entityRepresentation) {
        return this.backend.extractCanonicalPath(entityRepresentation);
    }

    @Override
    public String extractId(E entityRepresentation) {
        return this.backend.extractId(entityRepresentation);
    }

    @Override
    public String extractIdentityHash(Discriminator discriminator, E entityRepresentation) {
        return this.backend.extractIdentityHash(discriminator, entityRepresentation);
    }

    @Override
    public String extractContentHash(Discriminator discriminator, E entityRepresentation) {
        return this.backend.extractContentHash(discriminator, entityRepresentation);
    }

    @Override
    public String extractSyncHash(Discriminator discriminator, E entityRepresentation) {
        return this.backend.extractSyncHash(discriminator, entityRepresentation);
    }

    @Override
    public String extractRelationshipName(E relationship) {
        return this.backend.extractRelationshipName(relationship);
    }

    @Override
    public Class<?> extractType(E entityRepresentation) {
        return this.backend.extractType(entityRepresentation);
    }

    @Override
    public E find(Discriminator discriminator, CanonicalPath element) throws ElementNotFoundException {
        return this.backend.find(discriminator, element);
    }

    @Override
    public InputStream getGraphSON(Discriminator discriminator, String tenantId) {
        return this.backend.getGraphSON(discriminator, tenantId);
    }

    @Override
    public E getRelationship(Discriminator discriminator, E source, E target, String relationshipName) throws ElementNotFoundException {
        return this.backend.getRelationship(discriminator, source, target, relationshipName);
    }

    @Override
    public Set<E> getRelationships(Discriminator discriminator, E entity, Relationships.Direction direction, String ... names) {
        return this.backend.getRelationships(discriminator, entity, direction, names);
    }

    @Override
    public E getRelationshipSource(Discriminator discriminator, E relationship) {
        return this.backend.getRelationshipSource(discriminator, relationship);
    }

    @Override
    public E getRelationshipTarget(Discriminator discriminator, E relationship) {
        return this.backend.getRelationshipTarget(discriminator, relationship);
    }

    @Override
    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(Discriminator discriminator, CanonicalPath startingPoint, Relationships.Direction direction, Class<T> clazz, String ... relationshipNames) {
        return this.backend.getTransitiveClosureOver(discriminator, startingPoint, direction, clazz, relationshipNames);
    }

    @Override
    public Iterator<E> getTransitiveClosureOver(Discriminator discriminator, E startingPoint, Relationships.Direction direction, String ... relationshipNames) {
        return this.backend.getTransitiveClosureOver(discriminator, startingPoint, direction, relationshipNames);
    }

    @Override
    public boolean hasRelationship(Discriminator discriminator, E entity, Relationships.Direction direction, String relationshipName) {
        return this.backend.hasRelationship(discriminator, (Relationships.Direction)((Object)entity), direction, relationshipName);
    }

    @Override
    public boolean hasRelationship(Discriminator discriminator, E source, E target, String relationshipName) {
        return this.backend.hasRelationship(discriminator, source, target, relationshipName);
    }

    @Override
    public boolean isBackendInternal(E element) {
        return this.backend.isBackendInternal(element);
    }

    @Override
    public boolean isUniqueIndexSupported() {
        return this.backend.isUniqueIndexSupported();
    }

    @Override
    public E persist(Discriminator discriminator, CanonicalPath path, Blueprint blueprint) {
        return this.backend.persist(discriminator, path, blueprint);
    }

    @Override
    public E persist(StructuredData structuredData) {
        return this.backend.persist(structuredData);
    }

    @Override
    public Page<E> query(Discriminator discriminator, Query query, Pager pager) {
        return this.backend.query(discriminator, query, pager);
    }

    @Override
    public <T> Page<T> query(Discriminator discriminator, Query query, Pager pager, Function<E, T> conversion, Function<T, Boolean> filter) {
        return this.backend.query(discriminator, query, pager, conversion, filter);
    }

    @Override
    public E querySingle(Discriminator discriminator, Query query) {
        return this.backend.querySingle(discriminator, query);
    }

    @Override
    public E relate(Discriminator discriminator, E sourceEntity, E targetEntity, String name, Map<String, Object> properties) {
        return this.backend.relate(discriminator, sourceEntity, targetEntity, name, properties);
    }

    @Override
    public Page<E> traverse(Discriminator discriminator, E startingPoint, Query query, Pager pager) {
        return this.backend.traverse(discriminator, startingPoint, query, pager);
    }

    @Override
    public E traverseToSingle(Discriminator discriminator, E startingPoint, Query query) {
        return this.backend.traverseToSingle(discriminator, startingPoint, query);
    }

    @Override
    public void update(Discriminator discriminator, E entity, AbstractElement.Update update) {
        this.backend.update(discriminator, entity, update);
    }

    @Override
    public void updateHashes(Discriminator discriminator, E entity, Hashes hashes) {
        this.backend.updateHashes(discriminator, entity, hashes);
    }

    @Override
    public boolean requiresRollbackAfterFailure(Throwable t) {
        return this.backend.requiresRollbackAfterFailure(t);
    }

    @Override
    public <T extends Entity<?, U>, U extends Entity.Update> EntityHistory<T> getHistory(E entity, Class<T> entityType, Instant from, Instant to) {
        return this.backend.getHistory(entity, entityType, from, to);
    }
}

