/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.RecurseFilter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.base.BaseFeeds;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.Discriminator;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;

public final class BaseEnvironments {
    private BaseEnvironments() {
    }

    private static <BE> BaseResources.Read<BE> proceedToResources(TraversalContext<BE, Environment> context, Environments.ResourceParents ... parents) {
        return new BaseResources.Read(context.proceedWithParents(Resource.class, Environments.ResourceParents.class, Environments.ResourceParents.ENVIRONMENT, parents, (p, extender) -> {
            switch (p) {
                case ENVIRONMENT: {
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Resource.class));
                    break;
                }
                case FEED: {
                    extender.path().with(Related.by(Relationships.WellKnown.incorporates), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Resource.class));
                    break;
                }
                case RESOURCE: {
                    extender.path().with(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}, {Related.by(Relationships.WellKnown.incorporates), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}});
                    extender.path().with(RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.isParentOf), With.type(Resource.class)).build());
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled type of resource parent under environment.");
                }
            }
        }));
    }

    private static <BE> BaseMetrics.Read<BE> proceedToMetrics(TraversalContext<BE, Environment> context, Environments.MetricParents ... parents) {
        return new BaseMetrics.Read(context.proceedWithParents(Metric.class, Environments.MetricParents.class, Environments.MetricParents.ENVIRONMENT, parents, (p, extender) -> {
            switch (p) {
                case ENVIRONMENT: {
                    extender.path().with(Related.by(Relationships.WellKnown.contains), With.type(Metric.class));
                    break;
                }
                case FEED: {
                    extender.path().with(Related.by(Relationships.WellKnown.incorporates), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Metric.class));
                    break;
                }
                case RESOURCE: {
                    extender.path().with(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}, {Related.by(Relationships.WellKnown.incorporates), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(Resource.class)}});
                    extender.path().with(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}, {RecurseFilter.builder().addChain(Related.by(Relationships.WellKnown.contains), With.type(Resource.class)).build(), Related.by(Relationships.WellKnown.contains), With.type(Metric.class)}});
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unhandled type of metric parent under environment.");
                }
            }
        }));
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Environment, Environment.Update>
    implements Environments.Multiple {
        public Multiple(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Feeds.Read feeds() {
            return new BaseFeeds.Read(this.context.proceedTo(Relationships.WellKnown.incorporates, Feed.class).get());
        }

        @Override
        public Resources.ReadContained resources() {
            return new BaseResources.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadContained metrics() {
            return new BaseMetrics.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.Read metricsUnder(Environments.MetricParents ... parents) {
            return BaseEnvironments.proceedToMetrics(this.context, parents);
        }

        @Override
        public Resources.Read resourcesUnder(Environments.ResourceParents ... parents) {
            return BaseEnvironments.proceedToResources(this.context, parents);
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Environment, Environment.Update>
    implements Environments.Single {
        public Single(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Feeds.ReadAssociate feeds() {
            return new BaseFeeds.ReadAssociate(this.context.proceedTo(Relationships.WellKnown.incorporates, Feed.class).get());
        }

        @Override
        public Resources.ReadWrite resources() {
            return new BaseResources.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadWrite metrics() {
            return new BaseMetrics.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public Metrics.Read metricsUnder(Environments.MetricParents ... parents) {
            return BaseEnvironments.proceedToMetrics(this.context, parents);
        }

        @Override
        public Resources.Read resourcesUnder(Environments.ResourceParents ... parents) {
            return BaseEnvironments.proceedToResources(this.context, parents);
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Environment>
    implements Environments.Read {
        public Read(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, Environment>
    implements Environments.ReadContained {
        public ReadContained(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Environment, Environment.Blueprint, Environment.Update, String>
    implements Environments.ReadWrite {
        public ReadWrite(TraversalContext<BE, Environment> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Transaction<BE> tx, Environment.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<BE, Environment> wireUpNewEntity(Discriminator discriminator, BE entity, Environment.Blueprint blueprint, CanonicalPath parentPath, BE parent, Transaction<BE> tx) {
            return new EntityAndPendingNotifications<BE, Environment>(entity, new Environment(blueprint.getName(), parentPath.extend(Environment.SEGMENT_TYPE, tx.extractId(entity)).get(), null, blueprint.getProperties()), Collections.emptyList());
        }

        @Override
        public void copy(String sourceEnvironmentId, String targetEnvironmentId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Environments.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Environments.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public Environments.Single create(Environment.Blueprint blueprint, boolean cache) throws EntityAlreadyExistsException {
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint), cache));
        }
    }
}

