/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Map;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.QueryFragment;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.SwitchElementType;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.BaseEnvironments;
import org.hawkular.inventory.base.BaseFeeds;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.BaseTenants;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.Discriminator;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;

public final class BaseRelationships {
    private BaseRelationships() {
    }

    public static class Multiple<BE>
    extends Fetcher<BE, Relationship, Relationship.Update>
    implements Relationships.Multiple {
        private final Relationships.Direction direction;

        public Multiple(Relationships.Direction direction, TraversalContext<BE, Relationship> context) {
            super(context);
            this.direction = direction;
        }

        @Override
        public Tenants.Read tenants() {
            return new BaseTenants.Read(this.context.proceedFromRelationshipsTo(this.direction, Tenant.class).get());
        }

        @Override
        public Environments.Read environments() {
            return new BaseEnvironments.Read(this.context.proceedFromRelationshipsTo(this.direction, Environment.class).get());
        }

        @Override
        public Feeds.Read feeds() {
            return new BaseFeeds.Read(this.context.proceedFromRelationshipsTo(this.direction, Feed.class).get());
        }

        @Override
        public MetricTypes.Read metricTypes() {
            return new BaseMetricTypes.Read(this.context.proceedFromRelationshipsTo(this.direction, MetricType.class).get());
        }

        @Override
        public Metrics.Read metrics() {
            return new BaseMetrics.Read(this.context.proceedFromRelationshipsTo(this.direction, Metric.class).get());
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedFromRelationshipsTo(this.direction, Resource.class).get());
        }

        @Override
        public ResourceTypes.Read resourceTypes() {
            return new BaseResourceTypes.Read(this.context.proceedFromRelationshipsTo(this.direction, ResourceType.class).get());
        }
    }

    public static class Single<BE>
    extends Fetcher<BE, Relationship, Relationship.Update>
    implements Relationships.Single {
        public Single(TraversalContext<BE, Relationship> context) {
            super(context);
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Relationship>
    implements Relationships.Read {
        private final Relationships.Direction direction;

        public Read(TraversalContext<BE, Relationship> context) {
            super(context);
            QueryFragment[] filters = context.selectCandidates.getFragments();
            this.direction = filters.length == 0 ? Relationships.Direction.outgoing : ((SwitchElementType)filters[filters.length - 1].getFilter()).getDirection();
        }

        @Override
        public Relationships.Multiple named(String name) {
            return new Multiple(this.direction, this.context.proceed().where(RelationWith.name(name)).get());
        }

        @Override
        public Relationships.Multiple named(Relationships.WellKnown name) {
            return this.named(name.name());
        }

        @Override
        public Relationships.Single get(String id) throws EntityNotFoundException, RelationNotFoundException {
            return new Single(this.context.proceed().where(RelationWith.id(id)).get());
        }

        @Override
        public Relationships.Multiple getAll(RelationFilter ... filters) {
            return new Multiple(this.direction, this.context.proceed().where(filters).get());
        }
    }

    public static class ReadWrite<BE>
    extends Traversal<BE, Relationship>
    implements Relationships.ReadWrite {
        private final Relationships.Direction direction;
        private final Class<? extends Entity<?, ?>> originEntityType;

        public ReadWrite(TraversalContext<BE, Relationship> context, Class<? extends Entity<?, ?>> originEntityType) {
            super(context);
            QueryFragment[] filters = context.selectCandidates.getFragments();
            this.direction = ((SwitchElementType)filters[filters.length - 1].getFilter()).getDirection();
            this.originEntityType = originEntityType;
        }

        @Override
        public Relationships.Multiple named(String name) {
            return new Multiple(this.direction, this.context.proceed().where(RelationWith.name(name)).get());
        }

        @Override
        public Relationships.Multiple named(Relationships.WellKnown name) {
            return this.named(name.name());
        }

        @Override
        public Relationships.Single get(String id) throws EntityNotFoundException, RelationNotFoundException {
            return new Single(this.context.proceed().where(RelationWith.id(id)).get());
        }

        @Override
        public Relationships.Multiple getAll(RelationFilter ... filters) {
            return new Multiple(this.direction, this.context.proceed().where(filters).get());
        }

        @Override
        public Relationships.Single linkWith(String name, Path targetOrSource, Map<String, Object> properties) throws IllegalArgumentException {
            if (null == name) {
                throw new IllegalArgumentException("name was null");
            }
            if (null == targetOrSource) {
                throw new IllegalArgumentException("targetOrSource was null");
            }
            return this.inTx(tx -> {
                EntityAndPendingNotifications<Object, Relationship> relationshipObject;
                Object incidenceObject = Util.find(this.context.discriminator(), tx, this.context.sourcePath, targetOrSource);
                Object origin = tx.querySingle(this.context.discriminator(), this.context.sourcePath);
                if (origin == null) {
                    throw new EntityNotFoundException(this.originEntityType, Query.filters(this.context.select().get()));
                }
                RelationshipRules.checkCreate(this.context.discriminator(), tx, origin, this.direction, name, incidenceObject);
                EntityAndPendingNotifications relationshipObject2 = null;
                Discriminator disc = this.context.discriminator();
                switch (this.direction) {
                    case incoming: {
                        relationshipObject = Util.createAssociation(disc, tx, incidenceObject, name, origin, properties);
                        break;
                    }
                    case outgoing: {
                        relationshipObject = Util.createAssociation(disc, tx, origin, name, incidenceObject, properties);
                        break;
                    }
                    case both: {
                        relationshipObject2 = Util.createAssociation(disc, tx, origin, name, incidenceObject, properties);
                        relationshipObject = Util.createAssociation(disc, tx, incidenceObject, name, origin, properties);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unhandled direction when linking. This shouldn't have happened.");
                    }
                }
                tx.getPreCommit().addNotifications(relationshipObject);
                if (relationshipObject2 != null) {
                    tx.getPreCommit().addNotifications(relationshipObject2);
                }
                return new Single(this.context.toCreatedEntity(relationshipObject.getEntity(), true));
            });
        }

        @Override
        public void update(String id, Relationship.Update update) throws RelationNotFoundException {
            this.inTx(tx -> {
                try {
                    Object relationshipObject = tx.find(this.context.discriminator(), (CanonicalPath)((CanonicalPath.RelationshipBuilder)CanonicalPath.of().relationship(id)).get());
                    tx.update(this.context.discriminator(), relationshipObject, update);
                    Relationship r = tx.convert(this.context.discriminator(), relationshipObject, Relationship.class);
                    tx.getPreCommit().addNotifications(new EntityAndPendingNotifications(relationshipObject, r, new Notification(new Action.Update<Relationship, Relationship.Update>(r, update), r, Action.updated())));
                    return null;
                }
                catch (ElementNotFoundException e) {
                    throw new RelationNotFoundException(id, Query.filters(this.context.select().with(RelationWith.id(id)).get()));
                }
            });
        }

        @Override
        public void delete(String id) throws RelationNotFoundException {
            this.inTx(tx -> {
                try {
                    Object relationshipObject = tx.find(this.context.discriminator(), (CanonicalPath)((CanonicalPath.RelationshipBuilder)CanonicalPath.of().relationship(id)).get());
                    Object source = tx.getRelationshipSource(this.context.discriminator(), relationshipObject);
                    Object target = tx.getRelationshipTarget(this.context.discriminator(), relationshipObject);
                    String relationshipName = tx.extractRelationshipName(relationshipObject);
                    RelationshipRules.checkDelete(this.context.discriminator(), tx, source, Relationships.Direction.outgoing, relationshipName, target);
                    Relationship r = tx.convert(this.context.discriminator(), relationshipObject, Relationship.class);
                    tx.markDeleted(this.context.discriminator(), relationshipObject);
                    tx.getPreCommit().addNotifications(new EntityAndPendingNotifications(relationshipObject, r, Action.deleted()));
                    return null;
                }
                catch (ElementNotFoundException e) {
                    throw new RelationNotFoundException(id, Query.filters(this.context.select().with(RelationWith.id(id)).get()));
                }
            });
        }
    }
}

