/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Change;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.base.BaseRelationships;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.EntityHistory;
import org.hawkular.inventory.base.spi.EntityStateChange;

class SingleEntityFetcher<BE, E extends Entity<?, U>, U extends Entity.Update>
extends Fetcher<BE, E, U> {
    public SingleEntityFetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    public List<Change<E>> history(Instant from, Instant to) {
        EntityHistory history = this.inTx(tx -> {
            Object myEntity = tx.querySingle(null, this.context.select().get());
            if (myEntity == null) {
                throw new EntityNotFoundException(Query.filters(this.context.select().get()));
            }
            Instant f = from == null ? Instant.ofEpochMilli(0L) : from;
            Instant t = to == null ? Instant.ofEpochMilli(Long.MAX_VALUE) : to;
            return tx.getHistory(myEntity, this.context.entityClass, f, t);
        });
        ArrayList ret = new ArrayList(history.getChanges().size());
        int processed = 0;
        Action.Enumerated created = Action.Enumerated.CREATED;
        Action.Enumerated updated = Action.Enumerated.UPDATED;
        for (EntityStateChange ch : history.getChanges()) {
            Action.Enumerated chAction = ch.getAction().asEnum();
            if (chAction == updated) {
                Object previous = processed == 0 ? history.getInitialState() : history.getChanges().get(processed - 1).getEntity();
                Object current = ch.getEntity();
                Entity.Update update = (Entity.Update)((AbstractElement)previous).update().to(current);
                ret.add(new Change(ch.getOccurrenceTime(), Action.updated(), new Action.Update(previous, update)));
            } else if (chAction == created) {
                ret.add(new Change(ch.getOccurrenceTime(), Action.created(), ch.getEntity()));
            } else {
                ret.add(new Change(ch.getOccurrenceTime(), Action.deleted(), ch.getEntity()));
            }
            ++processed;
        }
        return ret;
    }

    public Relationships.ReadWrite relationships() {
        return this.relationships(Relationships.Direction.outgoing);
    }

    public Relationships.ReadWrite relationships(Relationships.Direction direction) {
        return new BaseRelationships.ReadWrite(this.context.proceedToRelationships(direction).get(), this.context.entityClass);
    }
}

