/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.List;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.ResultFilter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Transaction;
import org.hawkular.inventory.base.TransactionPayload;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.paths.SegmentType;

public abstract class Traversal<BE, E extends AbstractElement<?, ?>> {
    protected final TraversalContext<BE, E> context;

    protected Traversal(TraversalContext<BE, E> context) {
        this.context = context;
    }

    protected boolean isApplicable(AbstractElement<?, ?> result) {
        ResultFilter filter = this.context.configuration.getResultFilter();
        return filter == null || filter.isApplicable(result);
    }

    protected BE getSingle(Query query, SegmentType entityType) {
        return (BE)this.inTx(tx -> Util.getSingle(this.context.discriminator(), tx, query, entityType));
    }

    protected <R> R inTx(TransactionPayload<R, BE> payload) {
        return Traversal.inTx(this.context, payload);
    }

    protected <R> ResultWithNofifications<R, BE> inTxWithNotifications(TransactionPayload<R, BE> payload) {
        return Traversal.inCommittableTxWithNotifications(this.context, TransactionPayload.Committing.committing(payload));
    }

    protected static <R, BE, E extends AbstractElement<?, ?>> R inTx(TraversalContext<BE, E> context, TransactionPayload<R, BE> payload) {
        return Traversal.inCommittableTx(context, TransactionPayload.Committing.committing(payload));
    }

    protected <R> R inCommittableTx(TransactionPayload.Committing<R, BE> payload) {
        return Traversal.inCommittableTx(this.context, payload);
    }

    protected static <R, BE, E extends AbstractElement<?, ?>> R inCommittableTx(TraversalContext<BE, E> context, TransactionPayload.Committing<R, BE> payload) {
        return (R)Util.inCommittableTx(context, (Transaction.Committable<BE> tx) -> {
            Object v = payload.run(tx);
            tx.getPreCommit().getFinalNotifications().forEach(context::notifyAll);
            return v;
        });
    }

    protected static <R, BE, E extends AbstractElement<?, ?>> ResultWithNofifications<R, BE> inCommittableTxWithNotifications(TraversalContext<BE, E> context, TransactionPayload.Committing<R, BE> payload) {
        return Util.inCommittableTx(context, (Transaction.Committable<BE> tx) -> {
            Object v = payload.run(tx);
            List notifs = tx.getPreCommit().getFinalNotifications();
            notifs.forEach(context::notifyAll);
            return new ResultWithNofifications(v, notifs);
        });
    }

    protected static final class ResultWithNofifications<R, BE> {
        private final R result;
        private final List<EntityAndPendingNotifications<BE, ?>> sentNotifications;

        private ResultWithNofifications(R result, List<EntityAndPendingNotifications<BE, ?>> sentNotifications) {
            this.result = result;
            this.sentNotifications = sentNotifications;
        }

        public R getResult() {
            return this.result;
        }

        public List<EntityAndPendingNotifications<BE, ?>> getSentNotifications() {
            return this.sentNotifications;
        }
    }
}

