/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import java.time.Instant;

public final class Discriminator {
    private final Instant time;
    private final boolean preferExistence;
    private final boolean queryLatest;

    public static Discriminator time(Instant time) {
        return new Discriminator(time, true);
    }

    public static Discriminator latest() {
        return new Discriminator(null, true);
    }

    public static Discriminator timeExcludingMillisecondDeletes(Instant time) {
        return new Discriminator(time, false);
    }

    private Discriminator(Instant time, boolean preferExistence) {
        this.time = time == null ? Instant.now() : time;
        this.preferExistence = preferExistence;
        this.queryLatest = time == null;
    }

    public Instant getTime() {
        return this.time;
    }

    public boolean isQueryLatest() {
        return this.queryLatest;
    }

    public boolean isPreferExistence() {
        return this.preferExistence;
    }

    public Discriminator excludeDeletedInMillisecond() {
        return new Discriminator(this.time, false);
    }
}

