/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import java.time.Instant;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;

public final class EntityStateChange<E extends Entity<?, ?>>
implements Comparable<EntityStateChange<E>> {
    private final Action<?, E> action;
    private final E entity;
    private final Instant occurrenceTime;

    public EntityStateChange(Action<?, E> action, E entity, Instant occurrenceTime) {
        this.action = action;
        this.entity = entity;
        this.occurrenceTime = occurrenceTime;
    }

    public Action<?, E> getAction() {
        return this.action;
    }

    public E getEntity() {
        return this.entity;
    }

    public Instant getOccurrenceTime() {
        return this.occurrenceTime;
    }

    @Override
    public int compareTo(EntityStateChange<E> o) {
        int ret = this.occurrenceTime.compareTo(o.getOccurrenceTime());
        if (ret == 0) {
            ret = this.action.asEnum().compareTo(o.getAction().asEnum());
        }
        if (ret == 0) {
            return ((AbstractElement)this.entity).getPath().toString().compareTo(((AbstractElement)o.entity).getPath().toString());
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityStateChange that = (EntityStateChange)o;
        if (!this.action.equals(that.action)) {
            return false;
        }
        if (!((AbstractElement)this.entity).equals(that.entity)) {
            return false;
        }
        return this.occurrenceTime.equals(that.occurrenceTime);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + ((AbstractElement)this.entity).hashCode();
        result = 31 * result + this.occurrenceTime.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityStateChange[");
        sb.append("action=").append((Object)this.action.asEnum());
        sb.append(", entity=").append(this.entity);
        sb.append(", occurrenceTime=").append(this.occurrenceTime);
        sb.append(']');
        return sb.toString();
    }
}

