/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base.spi;

import java.io.InputStream;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Hashes;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.Discriminator;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.EntityHistory;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.RelativePath;

public interface InventoryBackend<E>
extends AutoCloseable {
    public boolean isPreferringBigTransactions();

    public boolean isUniqueIndexSupported();

    public InventoryBackend<E> startTransaction();

    public E find(Discriminator var1, CanonicalPath var2) throws ElementNotFoundException;

    public Page<E> query(Discriminator var1, Query var2, Pager var3);

    public E querySingle(Discriminator var1, Query var2);

    public Page<E> traverse(Discriminator var1, E var2, Query var3, Pager var4);

    public E traverseToSingle(Discriminator var1, E var2, Query var3);

    public <T> Page<T> query(Discriminator var1, Query var2, Pager var3, Function<E, T> var4, Function<T, Boolean> var5);

    public Iterator<E> getTransitiveClosureOver(Discriminator var1, E var2, Relationships.Direction var3, String ... var4);

    public boolean hasRelationship(Discriminator var1, E var2, Relationships.Direction var3, String var4);

    public boolean hasRelationship(Discriminator var1, E var2, E var3, String var4);

    public Set<E> getRelationships(Discriminator var1, E var2, Relationships.Direction var3, String ... var4);

    public E getRelationship(Discriminator var1, E var2, E var3, String var4) throws ElementNotFoundException;

    public E getRelationshipSource(Discriminator var1, E var2);

    public E getRelationshipTarget(Discriminator var1, E var2);

    public String extractRelationshipName(E var1);

    public String extractId(E var1);

    public Class<?> extractType(E var1);

    public CanonicalPath extractCanonicalPath(E var1);

    public String extractIdentityHash(Discriminator var1, E var2);

    public String extractContentHash(Discriminator var1, E var2);

    public String extractSyncHash(Discriminator var1, E var2);

    public <T> T convert(Discriminator var1, E var2, Class<T> var3);

    public E descendToData(Discriminator var1, E var2, RelativePath var3);

    public E relate(Discriminator var1, E var2, E var3, String var4, Map<String, Object> var5);

    public E persist(Discriminator var1, CanonicalPath var2, Blueprint var3);

    public E persist(StructuredData var1);

    public void update(Discriminator var1, E var2, AbstractElement.Update var3);

    public void updateHashes(Discriminator var1, E var2, Hashes var3);

    public void markDeleted(Discriminator var1, E var2);

    public void eradicate(E var1);

    public void deleteStructuredData(E var1);

    public void commit() throws CommitFailureException;

    public void rollback();

    public boolean isBackendInternal(E var1);

    public InputStream getGraphSON(Discriminator var1, String var2);

    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(Discriminator var1, CanonicalPath var2, Relationships.Direction var3, Class<T> var4, String ... var5);

    default public boolean requiresRollbackAfterFailure(Throwable t) {
        return true;
    }

    public <T extends Entity<?, U>, U extends Entity.Update> EntityHistory<T> getHistory(E var1, Class<T> var2, Instant var3, Instant var4);
}

