/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import rx.Observable;

public interface Inventory
extends AutoCloseable {
    public void initialize(Configuration var1);

    public Tenants.ReadWrite tenants();

    public Relationships.Read relationships();

    default public Tenants.Single inspect(Tenant tenant) throws EntityNotFoundException {
        return (Tenants.Single)this.tenants().get(tenant.getId());
    }

    default public Environments.Single inspect(Environment environment) throws EntityNotFoundException {
        return (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(environment.getTenantId())).environments()).get(environment.getId());
    }

    default public Feeds.Single inspect(Feed feed) throws EntityNotFoundException {
        return (Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(feed.getTenantId())).environments()).get(feed.getEnvironmentId())).feeds()).get(feed.getId());
    }

    default public Metrics.Single inspect(Metric metric) throws EntityNotFoundException {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(metric.getTenantId())).environments()).get(metric.getEnvironmentId());
        if (metric.getFeedId() == null) {
            return (Metrics.Single)((Metrics.ReadWrite)env.feedlessMetrics()).get(metric.getId());
        }
        return (Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(metric.getFeedId())).metrics()).get(metric.getId());
    }

    default public MetricTypes.Single inspect(MetricType metricType) throws EntityNotFoundException {
        if (metricType.getFeedId() == null) {
            return (MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.tenants().get(metricType.getId())).feedlessMetricTypes()).get(metricType.getId());
        }
        return (MetricTypes.Single)((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(metricType.getId())).environments()).get(metricType.getEnvironmentId())).feeds()).get(metricType.getFeedId())).metricTypes()).get(metricType.getId());
    }

    default public Resources.Single inspect(Resource resource) throws EntityNotFoundException {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(resource.getTenantId())).environments()).get(resource.getEnvironmentId());
        if (resource.getFeedId() == null) {
            return (Resources.Single)((Resources.ReadWrite)env.feedlessResources()).get(resource.getId());
        }
        return (Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(resource.getFeedId())).resources()).get(resource.getId());
    }

    default public ResourceTypes.Single inspect(ResourceType resourceType) throws EntityNotFoundException {
        if (resourceType.getFeedId() == null) {
            return (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.tenants().get(resourceType.getId())).feedlessResourceTypes()).get(resourceType.getId());
        }
        return (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(resourceType.getId())).environments()).get(resourceType.getEnvironmentId())).feeds()).get(resourceType.getFeedId())).resourceTypes()).get(resourceType.getId());
    }

    default public Relationships.Single inspect(Relationship relationship) {
        return (Relationships.Single)this.relationships().get(relationship.getId());
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(E entity, final Class<Single> accessInterface) {
        return (Single)((ResolvableToSingle)entity.accept(new ElementVisitor.Simple<Single, Void>(){

            @Override
            public Single visitTenant(Tenant tenant, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(tenant));
            }

            @Override
            public Single visitEnvironment(Environment environment, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(environment));
            }

            @Override
            public Single visitFeed(Feed feed, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(feed));
            }

            @Override
            public Single visitMetric(Metric metric, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metric));
            }

            @Override
            public Single visitMetricType(MetricType definition, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(definition));
            }

            @Override
            public Single visitResource(Resource resource, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(resource));
            }

            @Override
            public Single visitResourceType(ResourceType type, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(type));
            }

            @Override
            public Single visitRelationship(Relationship relationship, Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(relationship.getId()));
            }
        }, null));
    }

    default public <E extends AbstractElement<?, U>, U extends AbstractElement.Update, Single extends ResolvableToSingle<E, U>> Single inspect(final CanonicalPath path, final Class<Single> accessInterface) {
        return (Single)((ResolvableToSingle)path.accept(new ElementTypeVisitor<Single, Void>(){

            @Override
            public Single visitTenant(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.tenants().get(path.ids().getTenantId()));
            }

            @Override
            public Single visitEnvironment(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).environments()).get(path.ids().getEnvironmentId()));
            }

            @Override
            public Single visitFeed(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).environments()).get(path.ids().getEnvironmentId())).feeds()).get(path.ids().getFeedId()));
            }

            @Override
            public Single visitMetric(Void parameter) {
                Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).environments()).get(path.ids().getEnvironmentId());
                return (ResolvableToSingle)accessInterface.cast(path.ids().getFeedId() == null ? ((Metrics.ReadWrite)env.feedlessMetrics()).get(path.ids().getMetricId()) : ((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(path.ids().getFeedId())).metrics()).get(path.ids().getMetricId()));
            }

            @Override
            public Single visitMetricType(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((MetricTypes.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).feedlessMetricTypes()).get(path.ids().getMetricTypeId()));
            }

            @Override
            public Single visitResource(Void parameter) {
                Resources.Single access;
                Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).environments()).get(path.ids().getEnvironmentId());
                RelativePath parentResource = path.ids().getResourcePath().up();
                if (path.ids().getFeedId() == null) {
                    access = parentResource.isDefined() ? (Resources.Single)((Resources.ReadWrite)env.feedlessResources()).descend(path.ids().getResourcePath().getPath().get(0).getElementId(), this.allResourceSegments(path, 1, 1)).get(path) : (Resources.Single)((Resources.ReadWrite)env.feedlessResources()).get(path.getSegment().getElementId());
                } else {
                    Feeds.Single feed = (Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(path.ids().getFeedId());
                    access = parentResource.isDefined() ? (Resources.Single)((Resources.ReadWrite)feed.resources()).descend(path.ids().getResourcePath().getPath().get(0).getElementId(), this.allResourceSegments(path, 1, 1)).get(path) : (Resources.Single)((Resources.ReadWrite)feed.resources()).get(path.getSegment().getElementId());
                }
                return (ResolvableToSingle)accessInterface.cast(access);
            }

            @Override
            public Single visitResourceType(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(((ResourceTypes.ReadWrite)((Tenants.Single)Inventory.this.tenants().get(path.ids().getTenantId())).feedlessResourceTypes()).get(path.ids().getResourceTypeId()));
            }

            @Override
            public Single visitRelationship(Void parameter) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.relationships().get(path.ids().getRelationshipId()));
            }

            @Override
            public Single visitData(Void parameter) {
                if (path.ids().getResourceTypeId() == null) {
                    Resources.Single res = Inventory.this.inspect(path.up(), Resources.Single.class);
                    return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)res.data()).get(path.ids().getDataRole()));
                }
                ResourceTypes.Single rt = Inventory.this.inspect(path.up(), ResourceTypes.Single.class);
                return (ResolvableToSingle)accessInterface.cast(((Data.ReadWrite)rt.data()).get(path.ids().getDataRole()));
            }

            @Override
            public Single visitUnknown(Void parameter) {
                return null;
            }

            private CanonicalPath[] allResourceSegments(CanonicalPath path2, int leaveOutTop, int leaveOutBottom) {
                ArrayList<CanonicalPath> ret = new ArrayList<CanonicalPath>();
                Iterator<CanonicalPath> it = path2.descendingIterator();
                int leftOutTop = 0;
                while (it.hasNext()) {
                    CanonicalPath p = it.next();
                    if (!Resource.class.equals(p.getSegment().getElementType()) || leftOutTop++ < leaveOutTop) continue;
                    ret.add(p);
                }
                if (ret.size() - leaveOutBottom > 0) {
                    int len = ret.size() - leaveOutBottom;
                    return ret.subList(0, len).toArray(new CanonicalPath[len]);
                }
                return new CanonicalPath[0];
            }
        }, null));
    }

    public boolean hasObservers(Interest<?, ?> var1);

    public <C, E> Observable<C> observable(Interest<C, E> var1);

    public InputStream getGraphSON(String var1);
}

