/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseMetrics;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseFeeds {
    private BaseFeeds() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Feed, Feed.Update>
    implements Feeds.Multiple {
        public Multiple(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Resources.ReadContained resources() {
            return new BaseResources.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadContained metrics() {
            return new BaseMetrics.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public MetricTypes.ReadContained metricTypes() {
            return new BaseMetricTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public ResourceTypes.ReadContained resourceTypes() {
            return new BaseResourceTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Feed, Feed.Update>
    implements Feeds.Single {
        public Single(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Resources.ReadWrite resources() {
            return new BaseResources.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Resource.class).get());
        }

        @Override
        public Metrics.ReadWrite metrics() {
            return new BaseMetrics.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Metric.class).get());
        }

        @Override
        public MetricTypes.ReadWrite metricTypes() {
            return new BaseMetricTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public ResourceTypes.ReadWrite resourceTypes() {
            return new BaseResourceTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, Feed, Feed.Update>
    implements Feeds.Read {
        public Read(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, Feed, Feed.Update>
    implements Feeds.ReadContained {
        public ReadContained(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Feed, Feed.Blueprint, Feed.Update, String>
    implements Feeds.ReadWrite {
        public ReadWrite(TraversalContext<BE, Feed> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Feed.Blueprint blueprint) {
            Page envs = this.context.backend.query(this.context.sourcePath.extend().filter().with(With.type(Environment.class)).get(), Pager.single());
            if (envs.isEmpty()) {
                throw new EntityNotFoundException(Environment.class, Query.filters(this.context.sourcePath));
            }
            Object envObject = envs.get(0);
            Environment env = this.context.backend.convert(envObject, Environment.class);
            String envId = env.getId();
            String tenantId = env.getTenantId();
            return this.context.configuration.getFeedIdStrategy().generate(this.context.inventory, new Feed(CanonicalPath.of().tenant(tenantId).environment(envId).feed(blueprint.getId()).get()));
        }

        @Override
        protected EntityAndPendingNotifications<Feed> wireUpNewEntity(BE entity, Feed.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            return new EntityAndPendingNotifications<Feed>(new Feed(parentPath.extend(Feed.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new EntityAndPendingNotifications.Notification[0]);
        }

        @Override
        public Feeds.Single create(Feed.Blueprint blueprint) {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }

        @Override
        public Feeds.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Feeds.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }
}

