/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.AbstractElement;

public final class EntityAndPendingNotifications<E extends AbstractElement<?, ?>> {
    private final E entity;
    private final List<Notification<?, ?>> notifications;

    EntityAndPendingNotifications(E entity, Notification<?, ?> ... notifications) {
        this.entity = entity;
        this.notifications = new ArrayList();
        Collections.addAll(this.notifications, notifications);
    }

    EntityAndPendingNotifications(E entity, Iterable<Notification<?, ?>> notifications) {
        this.entity = entity;
        this.notifications = new ArrayList();
        notifications.forEach(this.notifications::add);
    }

    public E getEntity() {
        return this.entity;
    }

    public List<Notification<?, ?>> getNotifications() {
        return this.notifications;
    }

    public static final class Notification<C, V> {
        private final C actionContext;
        private final V value;
        private final Action<C, V> action;

        public Notification(C actionContext, V value, Action<C, V> action) {
            this.actionContext = actionContext;
            this.value = value;
            this.action = action;
        }

        public Action<C, V> getAction() {
            return this.action;
        }

        public C getActionContext() {
            return this.actionContext;
        }

        public V getValue() {
            return this.value;
        }
    }
}

