/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.util.Iterator;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.Tenant;
import org.junit.Assert;
import org.junit.Test;

public class CanonicalPathTest {
    @Test
    public void testParse() throws Exception {
        CanonicalPath p = CanonicalPath.fromString((String)"/t;t/e;e/f;f/r;r");
        this.checkPath(p, Tenant.class, "t", Environment.class, "e", Feed.class, "f", Resource.class, "r");
        try {
            CanonicalPath.fromString((String)"/t;t/e;e/f;f/t;t");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CanonicalPath.fromString((String)"/e;e/f;f");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CanonicalPath.fromString((String)"");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        p = CanonicalPath.fromString((String)"/rl;r");
        this.checkPath(p, Relationship.class, "r");
        try {
            CanonicalPath.fromString((String)"/rl;r/t/t");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CanonicalPath.fromString((String)"/t;t/e;e/f;f/m;m1/m;m2");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            CanonicalPath.fromString((String)"/t;t/e;e/f;f/m1/m2//");
            Assert.fail((String)"Invalid path parse should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithEscapedChars() throws Exception {
        CanonicalPath p = CanonicalPath.fromString((String)"/t;te%2Fn;a%2fnt/e;e%2fnv/f;f%2f%25eed/r;r;;%2fes");
        this.checkPath(p, Tenant.class, "te/n;a/nt", Environment.class, "e/nv", Feed.class, "f/%eed", Resource.class, "r;;/es");
        p = CanonicalPath.fromString((String)"/t;te%2Fn;a%2Fnt/e;e%2Fnv/f;f%2F%25eed/r;r;;%2Fes1/r;r;;%2Fes2/r;r;;%2Fes3");
        this.checkPath(p, Tenant.class, "te/n;a/nt", Environment.class, "e/nv", Feed.class, "f/%eed", Resource.class, "r;;/es1", Resource.class, "r;;/es2", Resource.class, "r;;/es3");
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"/t;t/e;e/r;r", (Object)((CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("r").get()).toString());
        Assert.assertEquals((Object)"/t;t/e;e/f;f/r;r", (Object)((CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").resource("r").get()).toString());
        Assert.assertEquals((Object)"/rl;r", (Object)((CanonicalPath)CanonicalPath.of().relationship("r").get()).toString());
        Assert.assertEquals((Object)"/t;t/e;e/r;r/d;configuration/blah/1/key", (Object)((CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("r").data(Resources.DataRole.configuration).key("blah").index(1).key("key").get()).toString());
        Assert.assertEquals((Object)"/t;t/e;e/r;r/d;connectionConfiguration/bl%2Fah", (Object)((CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("r").data(Resources.DataRole.connectionConfiguration).key("bl/ah").get()).toString());
        Assert.assertEquals((Object)"/t;te%2Fnant/e;e;nv/r;r%25%2Fes;;", (Object)((CanonicalPath)CanonicalPath.of().tenant("te/nant").environment("e;nv").resource("r%/es;;").get()).toString());
        Assert.assertEquals((Object)"/t;t/e;e/r;res%2F1;res%252/r;res;%203", (Object)((CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("res/1;res%2").resource("res; 3").get()).toString());
    }

    @Test
    public void testTraversals() throws Exception {
        CanonicalPath p = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").metric("m").get();
        Assert.assertEquals((long)3L, (long)p.getDepth());
        Assert.assertFalse((boolean)p.down().isDefined());
        CanonicalPath cp = p.getRoot();
        Assert.assertEquals((Object)"/t;t", (Object)cp.toString());
        Assert.assertEquals((Object)p.toString(), (Object)cp.getLeaf().toString());
        Assert.assertFalse((boolean)cp.up().isDefined());
        Assert.assertEquals((Object)"/t;t/e;e", (Object)cp.down().toString());
        Assert.assertEquals((Object)"/t;t/e;e", (Object)p.up().up().toString());
        CanonicalPath p2 = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").metric("m/e;t%r%|%C").get();
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;m%2Fe;t%25r%25%7C%25C", (Object)p2.down().up().toString());
        CanonicalPath p3 = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").resource("res1").resource("res2").get();
        Assert.assertEquals((Object)"/t;t/e;e/f;f/r;res1/r;res2", (Object)p3.down().up().toString());
    }

    @Test
    public void testExtending() throws Exception {
        CanonicalPath p = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").get();
        CanonicalPath p2 = p.extend(Metric.class, "m").get();
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;m", (Object)p2.toString());
        p2 = p.getRoot().extend(MetricType.class, "mt").get();
        Assert.assertEquals((Object)"/t;t/mt;mt", (Object)p2.toString());
    }

    @Test
    public void testExtendingWithEscapedChars() throws Exception {
        CanonicalPath p = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").get();
        CanonicalPath p2 = p.extend(Metric.class, "m%et%/ric").get();
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;m%25et%25%2Fric", (Object)p2.toString());
        p2 = p.getRoot().extend(MetricType.class, "m%et%/ric;type").get();
        Assert.assertEquals((Object)"/t;t/mt;m%25et%25%2Fric;type", (Object)p2.toString());
        CanonicalPath p3 = p.extend(Metric.class, "/;/%").get();
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;%2F;%2F%25", (Object)p3.toString());
    }

    @Test
    public void testIdExtraction() throws Exception {
        CanonicalPath p = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("r").get();
        Assert.assertEquals((Object)"t", (Object)p.ids().getTenantId());
        Assert.assertEquals((Object)"e", (Object)p.ids().getEnvironmentId());
        Assert.assertEquals((Object)"r;r", (Object)p.ids().getResourcePath().toString());
        Assert.assertEquals((Object)"f", (Object)p.up().extend(Feed.class, "f").get().ids().getFeedId());
        Assert.assertEquals((Object)"r;r", (Object)p.up().extend(Feed.class, "f").extend(Resource.class, "r").get().ids().getResourcePath().toString());
    }

    @Test
    public void testIdExtractionWithEscapedChars() throws Exception {
        CanonicalPath p = (CanonicalPath)CanonicalPath.of().tenant("t/e;n/%").environment("/;env/").resource("/res/").get();
        Assert.assertEquals((Object)"t/e;n/%", (Object)p.ids().getTenantId());
        Assert.assertEquals((Object)"/;env/", (Object)p.ids().getEnvironmentId());
        Assert.assertEquals((Object)"/res/", (Object)p.ids().getResourcePath().getSegment().getElementId());
        Assert.assertEquals((Object)"f/;e", (Object)p.up().extend(Feed.class, "f/;e").get().ids().getFeedId());
    }

    @Test
    public void testEntityInstantiationWithWrongPath() throws Exception {
        try {
            new Environment((CanonicalPath)CanonicalPath.of().tenant("t").get());
            Assert.fail((String)"Creating an entity with a path pointing to a different entity type should not be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIteration() throws Exception {
        CanonicalPath cp = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").metric("m").get();
        int i = 3;
        for (CanonicalPath p : cp) {
            Assert.assertEquals(cp.getPath().get(i--), (Object)p.getSegment());
        }
        i = 0;
        Iterator it = cp.descendingIterator();
        while (it.hasNext()) {
            Assert.assertEquals(cp.getPath().get(i++), (Object)((CanonicalPath)it.next()).getSegment());
        }
        i = 3;
        it = cp.ascendingIterator();
        while (it.hasNext()) {
            Assert.assertEquals(cp.getPath().get(i--), (Object)((CanonicalPath)it.next()).getSegment());
        }
    }

    @Test
    public void testRelativePathConstruction() throws Exception {
        RelativePath rp = (RelativePath)RelativePath.to().up().metric("kachna").get();
        Assert.assertEquals((Object)"../m;kachna", (Object)rp.toString());
        rp = RelativePath.fromString((String)"../e;e/../t;t");
        Assert.assertEquals((Object)"../e;e/../t;t", (Object)rp.toString());
        rp = RelativePath.fromString((String)"../e;e%2f;nv/../t;t%2fenant");
        Assert.assertEquals((Object)"../e;e%2F;nv/../t;t%2Fenant", (Object)rp.toString());
        try {
            RelativePath.fromString((String)"../r");
            Assert.fail((String)"Invalid relative path should have failed to parse.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            RelativePath.fromString((String)"../r;");
            Assert.fail((String)"Invalid relative path should have failed to parse.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            RelativePath.fromString((String)"/../t;t");
            Assert.fail((String)"Invalid relative path should have failed to parse.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            RelativePath.fromString((String)"..;boom/r;r");
            Assert.fail((String)"Invalid relative path should have failed to parse.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            RelativePath.fromString((String)"f;f/r;r/../e;e");
            Assert.fail((String)"Invalid relative path should have failed to parse.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRelativePathApplication() throws Exception {
        CanonicalPath cp = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").resource("r").get();
        RelativePath rp = (RelativePath)RelativePath.to().up().metric("m").get();
        cp = rp.applyTo(cp);
        Assert.assertEquals((Object)CanonicalPath.of().tenant("t").environment("e").metric("m").get(), (Object)cp);
        CanonicalPath cp2 = (CanonicalPath)CanonicalPath.of().tenant("t\\/enant").environment("e\\;nv").resource("r").get();
        RelativePath rp2 = (RelativePath)RelativePath.to().up().metric("m\\/\\;etric").get();
        cp2 = rp2.applyTo(cp2);
        Assert.assertEquals((Object)CanonicalPath.of().tenant("t\\/enant").environment("e\\;nv").metric("m\\/\\;etric").get(), (Object)cp2);
        try {
            cp = RelativePath.to().up().get().applyTo(cp);
            rp.applyTo(cp);
            Assert.fail((String)"Should not be possible to construct invalid canonical path by applying a relative one.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUntypedRelativePath() throws Exception {
        CanonicalPath cp = (CanonicalPath)CanonicalPath.of().tenant("t").environment("e").feed("f").get();
        Path mp = Path.fromPartiallyUntypedString((String)"g", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"r;g", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"../g", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"../r;g", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"../f;x/g", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"../f;x/r;g", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"../r;g/h/i", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"../r;g/r;h/r;i", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"../../env/me", (CanonicalPath)cp, (CanonicalPath)cp, Metric.class);
        Assert.assertEquals((Object)"../../e;env/m;me", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"/g", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"/t;t/e;e/f;f/r;g", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"/g/h", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"/t;t/e;e/f;f/r;g/r;h", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"/g", (CanonicalPath)cp, (CanonicalPath)cp, Metric.class);
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;g", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"/res%2F1/res%2F2", (CanonicalPath)cp, (CanonicalPath)cp, Resource.class);
        Assert.assertEquals((Object)"/t;t/e;e/f;f/r;res%2F1/r;res%2F2", (Object)mp.toString());
        mp = Path.fromPartiallyUntypedString((String)"/%2fg;", (CanonicalPath)cp, (CanonicalPath)cp, Metric.class);
        Assert.assertEquals((Object)"/t;t/e;e/f;f/m;%2Fg;", (Object)mp.toString());
    }

    private void checkPath(CanonicalPath path, Object ... pathSpec) {
        Assert.assertEquals((long)(pathSpec.length / 2), (long)path.getPath().size());
        for (int i = 0; i < pathSpec.length; i += 2) {
            Class t = (Class)pathSpec[i];
            String id = (String)pathSpec[i + 1];
            Path.Segment s = (Path.Segment)path.getPath().get(i / 2);
            Assert.assertEquals((Object)t, (Object)s.getElementType());
            Assert.assertEquals((Object)id, (Object)s.getElementId());
        }
    }
}

