/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;

public class EntityAlreadyExistsException
extends InventoryException {
    private final String entityId;
    private final Filter[][] paths;

    public EntityAlreadyExistsException(Entity entity) {
        this(entity.getId(), EntityAlreadyExistsException.asPaths(entity));
    }

    public EntityAlreadyExistsException(String entityId, Filter[][] paths) {
        this.entityId = entityId;
        this.paths = paths;
    }

    public EntityAlreadyExistsException(Throwable cause, String entityId, Filter[][] paths) {
        super(cause);
        this.entityId = entityId;
        this.paths = paths;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Filter[][] getPaths() {
        return this.paths;
    }

    @Override
    public String getMessage() {
        return "Entity with id '" + this.entityId + "' already exists at some of the positions: " + Arrays.deepToString((Object[])this.paths);
    }

    static Filter[][] asPaths(Entity entity) {
        Filter[][] ret = new Filter[][]{Filter.pathTo(entity)};
        return ret;
    }
}

