/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public final class PathSegmentCodec {
    private static final ThreadLocal<CharsetDecoder> DECODER = new ThreadLocal();
    private static final ThreadLocal<CharsetEncoder> ENCODER = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> BYTE_BUFFER = new ThreadLocal();
    private static final ThreadLocal<CharBuffer> CHAR_BUFFER = new ThreadLocal();

    private PathSegmentCodec() {
    }

    public static String decode(String str) {
        char[] ret = new char[str.length()];
        int len = str.length();
        int state = 0;
        int octet = -1;
        CharsetDecoder dec = PathSegmentCodec.getDecoder();
        ByteBuffer bytes = PathSegmentCodec.getByteBuffer();
        bytes.clear();
        CharBuffer chars = PathSegmentCodec.getCharBuffer();
        chars.clear();
        boolean decoded = true;
        int oi = 0;
        block6: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '%') {
                        decoded = false;
                        state = 1;
                        continue block6;
                    }
                    if (!decoded) {
                        throw new IllegalArgumentException("Could not decode URL-encoded octets ending at position: " + i + " of input string: " + str);
                    }
                    ret[oi++] = c;
                    continue block6;
                }
                case 1: {
                    if (octet == -1) {
                        octet = PathSegmentCodec.asHexDigitValue(c) * 16;
                        continue block6;
                    }
                    bytes.put((byte)(octet += PathSegmentCodec.asHexDigitValue(c)));
                    bytes.flip();
                    CoderResult res = dec.decode(bytes, chars, i == len - 1);
                    if (res.isOverflow()) {
                        throw new AssertionError((Object)"Decoder failed with insufficient room for new character.This should never happen.");
                    }
                    if (res.isUnderflow()) {
                        bytes.position(bytes.limit());
                        bytes.limit(bytes.capacity());
                    } else if (res.isError()) {
                        try {
                            res.throwException();
                        }
                        catch (CharacterCodingException e) {
                            throw new IllegalArgumentException("Failed to decode: " + str, e);
                        }
                    }
                    if (chars.remaining() == 0) {
                        chars.flip();
                        ret[oi++] = chars.get();
                        chars.clear();
                        bytes.clear();
                        dec.reset();
                        decoded = true;
                    }
                    state = 0;
                    octet = -1;
                }
            }
        }
        if (state == 1) {
            throw new IllegalArgumentException("Incomplete trailing escape pattern in input string: " + str);
        }
        if (bytes.position() != 0) {
            throw new IllegalArgumentException("Could not decode URL-encoded octets ending at position: " + len + " of input string: " + str);
        }
        return new String(ret, 0, oi);
    }

    public static String encode(String str) {
        StringBuilder bld = new StringBuilder(str.length());
        ByteBuffer bytes = PathSegmentCodec.getByteBuffer();
        CharBuffer chars = PathSegmentCodec.getCharBuffer();
        CharsetEncoder enc = PathSegmentCodec.getEncoder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (PathSegmentCodec.isURISafe(c)) {
                bld.append(c);
                continue;
            }
            chars.clear();
            bytes.clear();
            chars.append(c);
            chars.flip();
            CoderResult res = enc.encode(chars, bytes, i == len - 1);
            if (res.isOverflow()) {
                throw new AssertionError((Object)"Encoder failed with insufficient room for new character.This should never happen.");
            }
            if (res.isUnderflow()) {
                if (bytes.remaining() == bytes.capacity()) {
                    throw new AssertionError((Object)("Underflow while converting character at position " + i + " of input: " + str));
                }
            } else if (res.isError()) {
                try {
                    res.throwException();
                }
                catch (CharacterCodingException e) {
                    throw new IllegalArgumentException("Failed to encode: " + str, e);
                }
            }
            bytes.flip();
            while (bytes.hasRemaining()) {
                byte b = bytes.get();
                bld.append('%');
                bld.append(PathSegmentCodec.asHexDigit((b & 0xF0) >> 4));
                bld.append(PathSegmentCodec.asHexDigit(b & 0xF));
            }
            enc.reset();
        }
        return bld.toString();
    }

    private static CharsetDecoder getDecoder() {
        CharsetDecoder ret = DECODER.get();
        if (ret == null) {
            ret = Charset.forName("UTF-8").newDecoder();
            DECODER.set(ret);
        }
        return ret;
    }

    private static CharsetEncoder getEncoder() {
        CharsetEncoder ret = ENCODER.get();
        if (ret == null) {
            ret = Charset.forName("UTF-8").newEncoder();
            ENCODER.set(ret);
        }
        return ret;
    }

    private static ByteBuffer getByteBuffer() {
        ByteBuffer ret = BYTE_BUFFER.get();
        if (ret == null) {
            ret = ByteBuffer.allocateDirect(6);
            BYTE_BUFFER.set(ret);
        }
        return ret;
    }

    private static CharBuffer getCharBuffer() {
        CharBuffer ret = CHAR_BUFFER.get();
        if (ret == null) {
            ret = CharBuffer.allocate(1);
            CHAR_BUFFER.set(ret);
        }
        return ret;
    }

    private static int asHexDigitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + (c - 97);
        }
        if ('A' <= c && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new IllegalArgumentException("Invalid hex digit: " + c);
    }

    private static char asHexDigit(int b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        return (char)(65 + (b - 10));
    }

    private static boolean isURISafe(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || "-._~!$&'()*+,;=:@".indexOf(c) >= 0;
    }
}

