/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.base.Associator;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.ElementNotFoundException;

public final class BaseMetrics {
    private BaseMetrics() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Metric, Metric.Update>
    implements Metrics.Multiple {
        public Multiple(TraversalContext<BE, Metric> context) {
            super(context);
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Metric, Metric.Update>
    implements Metrics.Single {
        public Single(TraversalContext<BE, Metric> context) {
            super(context);
        }
    }

    public static class ReadAssociate<BE>
    extends Associator<BE, Metric>
    implements Metrics.ReadAssociate {
        public ReadAssociate(TraversalContext<BE, Metric> context) {
            super(context);
        }

        @Override
        public Relationship associate(Path id) throws EntityNotFoundException, RelationAlreadyExistsException {
            Query getMetric = Util.queryTo(this.context, id);
            Object metric = this.getSingle(getMetric, Metric.class);
            return this.createAssociation(Resource.class, Relationships.WellKnown.incorporates, metric);
        }

        @Override
        public Relationship disassociate(Path id) throws EntityNotFoundException {
            Query getMetric = Util.queryTo(this.context, id);
            Object metric = this.getSingle(getMetric, Metric.class);
            return this.deleteAssociation(Resource.class, Relationships.WellKnown.incorporates, metric);
        }

        @Override
        public Relationship associationWith(Path path) throws RelationNotFoundException {
            return this.getAssociation(Resource.class, path, Relationships.WellKnown.incorporates);
        }

        @Override
        public Metrics.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Metrics.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Metric>
    implements Metrics.Read {
        public Read(TraversalContext<BE, Metric> context) {
            super(context);
        }

        @Override
        public Metrics.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Metrics.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, Metric>
    implements Metrics.ReadContained {
        public ReadContained(TraversalContext<BE, Metric> context) {
            super(context);
        }

        @Override
        public Metrics.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Metrics.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Metric, Metric.Blueprint, Metric.Update, String>
    implements Metrics.ReadWrite {
        public ReadWrite(TraversalContext<BE, Metric> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Metric.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<Metric> wireUpNewEntity(BE entity, Metric.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            Object metricTypeObject;
            try {
                CanonicalPath tenant = CanonicalPath.of().tenant(parentPath.ids().getTenantId()).get();
                CanonicalPath metricTypePath = Util.canonicalize(blueprint.getMetricTypePath(), tenant, parentPath, MetricType.class);
                metricTypeObject = this.context.backend.find(metricTypePath);
            }
            catch (ElementNotFoundException e) {
                throw new IllegalArgumentException("A metric type with id '" + blueprint.getMetricTypePath() + "' not found in tenant '" + parentPath.getRoot().getSegment().getElementId() + "'.");
            }
            Object r = this.relate(metricTypeObject, entity, Relationships.WellKnown.defines.name());
            CanonicalPath entityPath = this.context.backend.extractCanonicalPath(entity);
            MetricType metricType = this.context.backend.convert(metricTypeObject, MetricType.class);
            Metric ret = new Metric(parentPath.extend(Metric.class, this.context.backend.extractId(entity)).get(), metricType, blueprint.getProperties());
            Relationship rel = new Relationship(this.context.backend.extractId(r), Relationships.WellKnown.defines.name(), parentPath, entityPath);
            return new EntityAndPendingNotifications<Metric>(ret, new EntityAndPendingNotifications.Notification<Relationship, Relationship>(rel, rel, Action.created()));
        }

        @Override
        public Metrics.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Metrics.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public Metrics.Single create(Metric.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

