/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.ReadWriteInterface;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ValidationException;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;

public final class Data {
    private Data() {
    }

    public static interface Multiple
    extends ResolvableToMany<DataEntity> {
        @Override
        public Page<DataEntity> entities(Pager var1);

        public Page<StructuredData> data(RelativePath var1, Pager var2);

        public Page<StructuredData> flatData(RelativePath var1, Pager var2);

        @Override
        default public boolean anyExists() {
            return !this.flatData(RelativePath.empty().get(), Pager.builder().withPageSize(1).orderBy(Order.unspecified()).build()).isEmpty();
        }
    }

    public static interface Single
    extends ResolvableToSingle<DataEntity, DataEntity.Update> {
        @Override
        public DataEntity entity() throws EntityNotFoundException;

        public StructuredData data(RelativePath var1);

        public StructuredData flatData(RelativePath var1);

        @Override
        default public boolean exists() {
            try {
                this.flatData(RelativePath.empty().get());
                return true;
            }
            catch (EntityNotFoundException | RelationNotFoundException ignored) {
                return false;
            }
        }

        @Override
        public void update(DataEntity.Update var1) throws EntityNotFoundException, RelationNotFoundException, ValidationException;
    }

    public static interface ReadWrite<Role extends DataEntity.Role>
    extends ReadWriteInterface<DataEntity.Update, DataEntity.Blueprint<Role>, Single, Multiple, Role> {
        @Override
        public Single create(DataEntity.Blueprint<Role> var1) throws EntityAlreadyExistsException, ValidationException;

        @Override
        public void update(Role var1, DataEntity.Update var2) throws EntityNotFoundException, ValidationException;
    }

    public static interface Read<Role extends DataEntity.Role>
    extends ReadInterface<Single, Multiple, Role> {
    }
}

