/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;

public abstract class AbstractElement<B extends org.hawkular.inventory.api.model.Blueprint, U extends Update> {
    public static final String ID_PROPERTY = "id";
    @XmlAttribute(name="path")
    private final CanonicalPath path;
    protected final Map<String, Object> properties;

    AbstractElement() {
        this.properties = null;
        this.path = null;
    }

    AbstractElement(CanonicalPath path, Map<String, Object> properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            this.properties = new HashMap<String, Object>(properties);
            this.properties.remove(ID_PROPERTY);
        }
        this.path = path;
    }

    public abstract <R, P> R accept(ElementVisitor<R, P> var1, P var2);

    public CanonicalPath getPath() {
        return this.path;
    }

    public String getId() {
        return this.path.getSegment().getElementId();
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    protected static <T> T valueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public abstract Updater<U, ? extends AbstractElement<?, U>> update();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractElement entity = (AbstractElement)o;
        return this.path.equals(entity.path);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public static abstract class Blueprint
    implements org.hawkular.inventory.api.model.Blueprint {
        @XmlElement
        private final Map<String, Object> properties;

        protected Blueprint(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public static abstract class Builder<B, This extends Builder<B, This>> {
            protected Map<String, Object> properties = new HashMap<String, Object>();

            public This withProperty(String key, Object value) {
                this.properties.put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.properties.putAll(properties);
                return this.castThis();
            }

            public abstract B build();

            protected This castThis() {
                return (This)this;
            }
        }
    }

    public static final class Updater<U extends Update, E extends AbstractElement<?, U>> {
        private final Function<U, E> updater;

        Updater(Function<U, E> updater) {
            this.updater = updater;
        }

        public E with(U update) {
            return (E)((AbstractElement)this.updater.apply(update));
        }
    }

    public static abstract class Update {
        private final Map<String, Object> properties;

        public Update(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public abstract <R, P> R accept(ElementUpdateVisitor<R, P> var1, P var2);

        public static abstract class Builder<U extends Update, This extends Builder<U, This>> {
            protected Map<String, Object> properties;

            private Map<String, Object> getProperties() {
                if (this.properties == null) {
                    this.properties = new HashMap<String, Object>();
                }
                return this.properties;
            }

            public This withProperty(String key, Object value) {
                this.getProperties().put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.getProperties().putAll(properties);
                return this.castThis();
            }

            public abstract U build();

            protected This castThis() {
                return (This)this;
            }
        }
    }
}

