/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseResourceTypes {
    private BaseResourceTypes() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Multiple {
        public Multiple(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.ReadContained metricTypes() {
            return new BaseMetricTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public Data.Read<ResourceTypes.DataRole> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Single {
        public Single(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.ReadAssociate metricTypes() {
            return new BaseMetricTypes.ReadAssociate(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public Data.ReadWrite<ResourceTypes.DataRole> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get());
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Read {
        public Read(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.ReadContained {
        public ReadContained(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, ResourceType, ResourceType.Blueprint, ResourceType.Update, String>
    implements ResourceTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(ResourceType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<ResourceType> wireUpNewEntity(BE entity, ResourceType.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            this.context.backend.update(entity, ResourceType.Update.builder().build());
            return new EntityAndPendingNotifications<ResourceType>(new ResourceType(parentPath.extend(ResourceType.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new EntityAndPendingNotifications.Notification[0]);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public ResourceTypes.Single create(ResourceType.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

