/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.base.spi.InventoryBackend;

public final class RelationshipRules {
    private static final Map<Relationships.WellKnown, List<RuleCheck<?>>> CREATE_RULES;
    private static final Map<Relationships.WellKnown, List<RuleCheck<?>>> DELETE_RULES;
    private static final List<RuleCheck<?>> GLOBAL_CREATE_RULES;

    private RelationshipRules() {
    }

    public static <E> void checkCreate(InventoryBackend<E> backend, E origin, Relationships.Direction direction, Relationships.WellKnown relationship, E target) {
        RelationshipRules.check(backend, origin, direction, relationship.name(), target, CheckType.CREATE);
    }

    public static <E> void checkCreate(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        RelationshipRules.check(backend, origin, direction, relationship, target, CheckType.CREATE);
    }

    public static <E> void checkDelete(InventoryBackend<E> backend, E origin, Relationships.Direction direction, Relationships.WellKnown relationship, E target) {
        RelationshipRules.check(backend, origin, direction, relationship.name(), target, CheckType.DELETE);
    }

    public static <E> void checkDelete(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        RelationshipRules.check(backend, origin, direction, relationship, target, CheckType.DELETE);
    }

    private static <E> void check(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target, CheckType checkType) {
        List<RuleCheck<?>> rules = checkType.getRuleChecks(relationship);
        rules.forEach(r -> r.check(backend, origin, direction, relationship, target));
    }

    private static <E> void checkDiamonds(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        if (direction == Relationships.Direction.outgoing && backend.hasRelationship((Relationships.Direction)((Object)target), Relationships.Direction.incoming, relationship)) {
            throw new IllegalArgumentException("The target is already connected with another entity using the relationship: '" + relationship + "'. It is illegal for such relationships to form" + " diamonds.");
        }
        if (direction == Relationships.Direction.incoming && backend.hasRelationship((Relationships.Direction)((Object)origin), Relationships.Direction.incoming, relationship)) {
            throw new IllegalArgumentException("The source is already connected with another entity using the relationship: '" + relationship + "'. It is illegal for such relationships to form" + " diamonds.");
        }
    }

    private static <E> void checkLoops(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        block5: {
            block4: {
                if (direction == Relationships.Direction.both) {
                    throw new IllegalArgumentException("Relationship '" + relationship + "' cannot form a loop" + " between 2 entities.");
                }
                if (origin.equals(target)) {
                    throw new IllegalArgumentException("Relationship '" + relationship + "' cannot both start and end" + " on the same entity.");
                }
                if (direction != Relationships.Direction.incoming) break block4;
                Iterator<E> closure = backend.getTransitiveClosureOver(origin, Relationships.Direction.outgoing, relationship);
                while (closure.hasNext()) {
                    E e = closure.next();
                    if (!e.equals(target)) continue;
                    throw new IllegalArgumentException("The target and the source (indirectly) form a loop while traversing over '" + relationship + "' relationships. This is illegal for that" + " relationship.");
                }
                break block5;
            }
            if (direction != Relationships.Direction.outgoing) break block5;
            Iterator<E> closure = backend.getTransitiveClosureOver(origin, Relationships.Direction.incoming, relationship);
            while (closure.hasNext()) {
                E e = closure.next();
                if (!e.equals(target)) continue;
                throw new IllegalArgumentException("The source and the target (indirectly) form a loop while traversing over '" + relationship + "' relationships. This is illegal for that" + " relationship.");
            }
        }
    }

    private static <E> void disallowDelete(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        throw new IllegalArgumentException("Relationship '" + relationship + "' cannot be explicitly deleted.");
    }

    private static <E> void disallowCreate(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        throw new IllegalArgumentException("Relationship '" + relationship + "' cannot be explicitly created.");
    }

    private static <E> void disallowDeleteOfIsParentOfWhenTheresContainsToo(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
        if (backend.hasRelationship(origin, target, Relationships.WellKnown.contains.name())) {
            throw new IllegalArgumentException("'" + relationship + "' relationship cannot be deleted if there is" + " also a '" + (Object)((Object)Relationships.WellKnown.contains) + "' relationship between the same two entities. This would mean that a" + " sub-resource would no longer be considered a child of the parent resource, which doesn't make" + " sense.");
        }
    }

    private static <E> void disallowCreateAcrossTenants(InventoryBackend<E> backend, E origin, Relationships.Direction direction, String relationship, E target) {
    }

    static {
        GLOBAL_CREATE_RULES = new ArrayList();
        CREATE_RULES = new HashMap();
        DELETE_RULES = new HashMap();
        GLOBAL_CREATE_RULES.add(RelationshipRules::disallowCreateAcrossTenants);
        CREATE_RULES.put(Relationships.WellKnown.contains, Arrays.asList(RelationshipRules::checkDiamonds, RelationshipRules::checkLoops));
        CREATE_RULES.put(Relationships.WellKnown.isParentOf, Collections.singletonList(RelationshipRules::checkLoops));
        CREATE_RULES.put(Relationships.WellKnown.hasData, Collections.singletonList(RelationshipRules::disallowCreate));
        DELETE_RULES.put(Relationships.WellKnown.contains, Collections.singletonList(RelationshipRules::disallowDelete));
        DELETE_RULES.put(Relationships.WellKnown.isParentOf, Collections.singletonList(RelationshipRules::disallowDeleteOfIsParentOfWhenTheresContainsToo));
        DELETE_RULES.put(Relationships.WellKnown.hasData, Collections.singletonList(RelationshipRules::disallowDelete));
    }

    private static enum CheckType {
        CREATE{

            @Override
            public List<RuleCheck<?>> getRuleChecks(String relationship) {
                List additional;
                ArrayList ret = new ArrayList(GLOBAL_CREATE_RULES);
                Relationships.WellKnown r = CheckType.getWellKnown(relationship);
                if (r != null && (additional = (List)CREATE_RULES.get((Object)r)) != null) {
                    ret.addAll(additional);
                }
                return ret;
            }
        }
        ,
        DELETE{

            @Override
            public List<RuleCheck<?>> getRuleChecks(String relationship) {
                List checks;
                Relationships.WellKnown r = CheckType.getWellKnown(relationship);
                if (r != null && (checks = (List)DELETE_RULES.get((Object)r)) != null) {
                    return checks;
                }
                return Collections.emptyList();
            }
        };


        public abstract List<RuleCheck<?>> getRuleChecks(String var1);

        private static Relationships.WellKnown getWellKnown(String relationship) {
            for (Relationships.WellKnown r : Relationships.WellKnown.values()) {
                if (!r.name().equals(relationship)) continue;
                return r;
            }
            return null;
        }
    }

    @FunctionalInterface
    private static interface RuleCheck<E> {
        public void check(InventoryBackend<E> var1, E var2, Relationships.Direction var3, String var4, E var5);
    }
}

