/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.AssociationInterface;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.ReadWriteInterface;
import org.hawkular.inventory.api.ResolvableToManyWithRelationships;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;

public final class Resources {
    private Resources() {
    }

    public static interface ReadAssociate
    extends Read,
    AssociationInterface {
        @Override
        public Relationship disassociate(Path var1) throws EntityNotFoundException, IllegalArgumentException;
    }

    public static interface ReadWrite
    extends ReadWriteInterface<Resource.Update, Resource.Blueprint, Single, Multiple, String>,
    ReadContained {
    }

    public static interface Read
    extends ReadBase<Path> {
    }

    public static interface ReadContained
    extends ReadBase<String> {
    }

    public static interface ReadBase<Address>
    extends ReadInterface<Single, Multiple, Address> {
        default public Read descend(Address firstChild, Path ... furtherChildren) {
            if (firstChild == null) {
                throw new IllegalArgumentException("no first child");
            }
            Read last = (Read)((Single)this.get(firstChild)).allChildren();
            for (Path p : furtherChildren) {
                if (!Resource.class.equals(p.getSegment().getElementType())) {
                    throw new IllegalArgumentException("Descend can only traverse child resources.");
                }
                last = (Read)((Single)last.get(p)).allChildren();
            }
            return last;
        }
    }

    public static interface Multiple
    extends ResolvableToManyWithRelationships<Resource>,
    BrowserBase<Metrics.Read, Data.Read<DataRole>, ReadContained, Read> {
    }

    public static interface Single
    extends ResolvableToSingleWithRelationships<Resource, Resource.Update>,
    BrowserBase<Metrics.ReadAssociate, Data.ReadWrite<DataRole>, ReadWrite, ReadAssociate> {
        public Single parent();
    }

    private static interface BrowserBase<Metrics, Data, ContainedAccess, AllAccess> {
        public Metrics metrics();

        public ContainedAccess containedChildren();

        public AllAccess allChildren();

        public Read parents();

        public Data data();
    }

    public static enum DataRole implements DataEntity.Role
    {
        configuration,
        connectionConfiguration;

    }
}

