/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.model.CanonicalPath;

public class ValidationException
extends InventoryException {
    private final List<ValidationMessage> messages;
    private final CanonicalPath dataPath;

    public ValidationException(CanonicalPath dataPath, Iterable<ValidationMessage> messages, Throwable cause) {
        super(cause);
        this.dataPath = dataPath;
        ArrayList tmp = new ArrayList();
        messages.forEach(tmp::add);
        this.messages = Collections.unmodifiableList(tmp);
    }

    public CanonicalPath getDataPath() {
        return this.dataPath;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    @Override
    public String getMessage() {
        StringBuilder bld = new StringBuilder("Validation of data entity at '").append(this.dataPath);
        if (this.messages.isEmpty()) {
            bld.append("' failed without any explicitly mentioned problems.");
        } else {
            bld.append("' failed with the following problems found:\n");
            this.messages.forEach(m -> bld.append(m.getSeverity()).append(": ").append(m.getMessage()).append("\n"));
        }
        return bld.toString();
    }

    public static final class ValidationMessage {
        private final String severity;
        private final String message;

        public ValidationMessage(String severity, String message) {
            this.message = message;
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSeverity() {
            return this.severity;
        }
    }
}

