/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.FeedBasedEntity;
import org.hawkular.inventory.api.model.ResourceType;

@XmlRootElement
public final class Resource
extends FeedBasedEntity<Blueprint, Update> {
    private final ResourceType type;

    private Resource() {
        this.type = null;
    }

    public Resource(CanonicalPath path, ResourceType type) {
        this(path, type, null);
    }

    public Resource(CanonicalPath path, ResourceType type, Map<String, Object> properties) {
        super(path, properties);
        this.type = type;
    }

    @Override
    public AbstractElement.Updater<Update, Resource> update() {
        return new AbstractElement.Updater<Update, Resource>(u -> new Resource(this.getPath(), this.getType(), u.getProperties()));
    }

    public ResourceType getType() {
        return this.type;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitResource(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", type=").append(this.type);
    }

    public static final class Update
    extends AbstractElement.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitResource(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        private final String resourceTypePath;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this((String)null, (String)null);
        }

        public Blueprint(String id, String resourceTypePath) {
            this(id, resourceTypePath, Collections.emptyMap());
        }

        public Blueprint(String id, String resourceTypePath, Map<String, Object> properties) {
            super(id, properties);
            this.resourceTypePath = resourceTypePath;
        }

        public String getResourceTypePath() {
            return this.resourceTypePath;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitResource(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String resourceTypePath;

            public Builder withResourceTypePath(String resourceTypePath) {
                this.resourceTypePath = resourceTypePath;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.resourceTypePath, this.properties);
            }
        }
    }
}

