/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
@XmlJavaTypeAdapter(value=JaxbAdapter.class)
public final class Version {
    private final String value;
    private final String canonical;
    private final ListItem items;

    public Version(String version) {
        this.value = version;
        this.items = new ListItem();
        version = version.toLowerCase(Locale.ENGLISH);
        ListItem list = this.items;
        Stack<ListItem> stack = new Stack<ListItem>();
        stack.push(list);
        boolean isDigit = false;
        int startIndex = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(Version.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                continue;
            }
            if (c == '-') {
                if (i == startIndex) {
                    list.add(IntegerItem.ZERO);
                } else {
                    list.add(Version.parseItem(isDigit, version.substring(startIndex, i)));
                }
                startIndex = i + 1;
                if (!isDigit) continue;
                list.normalize();
                if (i + 1 >= version.length() || !Character.isDigit(version.charAt(i + 1))) continue;
                ListItem listItem = list;
                list = new ListItem();
                listItem.add(list);
                stack.push(list);
                continue;
            }
            if (Character.isDigit(c)) {
                if (!isDigit && i > startIndex) {
                    list.add(new StringItem(version.substring(startIndex, i), true));
                    startIndex = i;
                }
                isDigit = true;
                continue;
            }
            if (isDigit && i > startIndex) {
                list.add(Version.parseItem(true, version.substring(startIndex, i)));
                startIndex = i;
            }
            isDigit = false;
        }
        if (version.length() > startIndex) {
            list.add(Version.parseItem(isDigit, version.substring(startIndex)));
        }
        while (!stack.isEmpty()) {
            list = (ListItem)stack.pop();
            list.normalize();
        }
        this.canonical = this.items.toString();
    }

    private static Item parseItem(boolean isDigit, String buf) {
        return isDigit ? new IntegerItem(buf) : new StringItem(buf, false);
    }

    public int compareTo(Version o) {
        return this.items.compareTo(o.items);
    }

    public boolean equals(Object o) {
        return o instanceof Version && this.canonical.equals(((Version)o).canonical);
    }

    public int hashCode() {
        return this.canonical.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static final class JaxbAdapter
    extends XmlAdapter<Version, MappedVersion> {
        public MappedVersion unmarshal(Version v) throws Exception {
            return new MappedVersion(v.value);
        }

        public Version marshal(MappedVersion v) throws Exception {
            return new Version(v.value);
        }
    }

    @XmlRootElement(name="version")
    private static final class MappedVersion {
        @XmlAttribute
        private String value;

        private MappedVersion(String value) {
            this.value = value;
        }
    }

    private static class ListItem
    extends ArrayList<Item>
    implements Item {
        private ListItem() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean isNull() {
            return this.size() == 0;
        }

        void normalize() {
            Item item;
            ListIterator iterator = this.listIterator(this.size());
            while (iterator.hasPrevious() && (item = (Item)iterator.previous()).isNull()) {
                iterator.remove();
            }
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                if (this.size() == 0) {
                    return 0;
                }
                Item first = (Item)this.get(0);
                return first.compareTo(null);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    Iterator left = this.iterator();
                    Iterator right = ((ListItem)item).iterator();
                    while (left.hasNext() || right.hasNext()) {
                        Item l = left.hasNext() ? (Item)left.next() : null;
                        Item r = right.hasNext() ? (Item)right.next() : null;
                        int result = l == null ? -r.compareTo(l) : l.compareTo(r);
                        if (result == 0) continue;
                        return result;
                    }
                    return 0;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append('(');
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(')');
            return buffer.toString();
        }
    }

    private static class StringItem
    implements Item {
        private static final Map<String, String> QUALIFIERS = new HashMap<String, String>();
        private static final Map<String, String> ALIASES = new HashMap<String, String>();
        private static final String RELEASE_VERSION_INDEX;
        private static final String LEXICAL_PREFIX;
        private final String value;

        public StringItem(String value, boolean followedByDigit) {
            String alias;
            if (followedByDigit && value.length() == 1) {
                switch (value.charAt(0)) {
                    case 'a': {
                        value = "alpha";
                        break;
                    }
                    case 'b': {
                        value = "beta";
                        break;
                    }
                    case 'm': {
                        value = "milestone";
                    }
                }
            }
            this.value = (alias = ALIASES.get(value)) != null ? alias : value;
        }

        private static String comparableQualifier(String qualifier) {
            String i = QUALIFIERS.get(qualifier);
            return i != null ? i : LEXICAL_PREFIX + qualifier;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean isNull() {
            return this.value.length() <= 0;
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return StringItem.comparableQualifier(this.value).compareTo(RELEASE_VERSION_INDEX);
            }
            switch (item.getType()) {
                case 0: {
                    return -1;
                }
                case 1: {
                    return StringItem.comparableQualifier(this.value).compareTo(StringItem.comparableQualifier(((StringItem)item).value));
                }
                case 2: {
                    return -1;
                }
            }
            throw new IllegalStateException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value;
        }

        static {
            String[] qualifiers = new String[]{"alpha", "beta", "milestone", "rc", "snapshot", "", "sp"};
            for (int i = 0; i < qualifiers.length; ++i) {
                QUALIFIERS.put(qualifiers[i], String.valueOf(i));
            }
            ALIASES.put("ga", "");
            ALIASES.put("final", "");
            ALIASES.put("cr", "rc");
            RELEASE_VERSION_INDEX = QUALIFIERS.get("");
            LEXICAL_PREFIX = String.valueOf(QUALIFIERS.size());
        }
    }

    private static class IntegerItem
    implements Item {
        public static final IntegerItem ZERO = new IntegerItem();
        private final BigInteger value;

        private IntegerItem() {
            this.value = BigInteger.ZERO;
        }

        public IntegerItem(String str) {
            this.value = new BigInteger(str);
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean isNull() {
            return BigInteger.ZERO.equals(this.value);
        }

        @Override
        public int compareTo(Item item) {
            if (item == null) {
                return BigInteger.ZERO.equals(this.value) ? 0 : 1;
            }
            switch (item.getType()) {
                case 0: {
                    return this.value.compareTo(((IntegerItem)item).value);
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
            }
            throw new RuntimeException("invalid item: " + item.getClass());
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static interface Item {
        public static final int INTEGER_ITEM = 0;
        public static final int STRING_ITEM = 1;
        public static final int LIST_ITEM = 2;

        public int compareTo(Item var1);

        public int getType();

        public boolean isNull();
    }
}

