/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Collections;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.PartiallyApplied;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

abstract class Mutator<BE, E extends Entity<?, U>, B extends Blueprint, U extends AbstractElement.Update, Id>
extends Traversal<BE, E> {
    protected Mutator(TraversalContext<BE, E> context) {
        super(context);
    }

    protected abstract String getProposedId(B var1);

    protected final Query doCreate(B blueprint) {
        return this.mutating(transaction -> {
            CanonicalPath entityPath;
            String id = this.getProposedId(blueprint);
            Query existenceCheck = this.context.hop().filter().with(With.id(id)).get();
            Page results = this.context.backend.query(existenceCheck, Pager.single());
            if (!results.isEmpty()) {
                throw new EntityAlreadyExistsException(id, Query.filters(existenceCheck));
            }
            BE parent = this.getParent();
            CanonicalPath parentCanonicalPath = parent == null ? null : this.context.backend.extractCanonicalPath(parent);
            Object containsRel = null;
            if (parent == null) {
                if (this.context.entityClass != Tenant.class) throw new IllegalStateException("Could not find the parent of the entity to be created,yet the entity is not a tenant: " + blueprint);
                entityPath = CanonicalPath.of().tenant(id).get();
            } else {
                entityPath = parentCanonicalPath.extend(this.context.entityClass, id).get();
            }
            Object entityObject = this.context.backend.persist(entityPath, (Blueprint)blueprint);
            if (parentCanonicalPath != null) {
                containsRel = this.context.backend.relate(parent, entityObject, Relationships.WellKnown.contains.name(), Collections.emptyMap());
            }
            EntityAndPendingNotifications<E> newEntity = this.wireUpNewEntity(entityObject, blueprint, parentCanonicalPath, parent);
            this.context.backend.commit(transaction);
            this.context.notify(newEntity.getEntity(), Action.created());
            if (containsRel != null) {
                this.context.notify(this.context.backend.convert(containsRel, Relationship.class), Action.created());
            }
            this.context.notifyAll(newEntity);
            return Query.to(entityPath);
        });
    }

    public final void update(Id id, U update) throws EntityNotFoundException {
        Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
        Util.update(this.context, q, update, (e, u) -> this.preUpdate(id, e, u));
    }

    public final void delete(Id id) throws EntityNotFoundException {
        Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
        Util.delete(this.context, q, PartiallyApplied.procedure(this::cleanup).first(id).asConsumer());
    }

    protected void cleanup(Id id, BE entityRepresentation) {
    }

    protected void preUpdate(Id id, BE entityRepresentation, U update) {
    }

    private BE getParent() {
        return (BE)ElementTypeVisitor.accept(this.context.entityClass, new ElementTypeVisitor.Simple<BE, Void>(){

            @Override
            protected BE defaultAction() {
                Page res = Mutator.this.context.backend.query(Mutator.this.context.sourcePath, Pager.single());
                if (res.isEmpty()) {
                    Class parentEntityClass = null;
                    if (Mutator.this.context.previous != null && Entity.class.isAssignableFrom(Mutator.this.context.previous.entityClass)) {
                        parentEntityClass = Mutator.this.context.previous.entityClass;
                    }
                    throw new EntityNotFoundException(parentEntityClass, Query.filters(Mutator.this.context.sourcePath));
                }
                return res.get(0);
            }

            @Override
            public BE visitTenant(Void parameter) {
                return null;
            }
        }, null);
    }

    protected BE relate(BE source, BE target, String relationshipName) {
        RelationshipRules.checkCreate(this.context.backend, source, Relationships.Direction.outgoing, relationshipName, target);
        return this.context.backend.relate(source, target, relationshipName, null);
    }

    protected abstract EntityAndPendingNotifications<E> wireUpNewEntity(BE var1, B var2, CanonicalPath var3, BE var4);
}

