/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.StructuredData;

public final class DataEntity
extends Entity<Blueprint<?>, Update> {
    private final StructuredData value;

    private DataEntity() {
        this.value = null;
    }

    public DataEntity(CanonicalPath owner, Role role, StructuredData value) {
        super(owner.extend(DataEntity.class, role.name()).get());
        this.value = value;
    }

    public DataEntity(CanonicalPath owner, Role role, StructuredData value, Map<String, Object> properties) {
        super(owner.extend(DataEntity.class, role.name()).get(), properties);
        this.value = value;
    }

    public DataEntity(CanonicalPath path, StructuredData value, Map<String, Object> properties) {
        this(path.up(), Role.valueOf(path.getSegment().getElementId()), value, properties);
    }

    public StructuredData getValue() {
        return this.value;
    }

    public Role getRole() {
        return Role.valueOf(this.getId());
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitData(this, null);
    }

    @Override
    public AbstractElement.Updater<Update, DataEntity> update() {
        return new AbstractElement.Updater<Update, DataEntity>(u -> new DataEntity(this.getPath().up(), this.getRole(), DataEntity.valueOrDefault(u.getValue(), this.getValue()), u.getProperties()));
    }

    public static final class Update
    extends AbstractElement.Update {
        private final StructuredData value;

        public static Builder builder() {
            return new Builder();
        }

        public Update(StructuredData value, Map<String, Object> properties) {
            super(properties);
            this.value = value;
        }

        private Update() {
            this(null, null);
        }

        public StructuredData getValue() {
            return this.value;
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitData(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            private StructuredData value;

            public Builder withValue(StructuredData value) {
                this.value = value;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.value, this.properties);
            }
        }
    }

    public static final class Blueprint<DataRole extends Role>
    extends AbstractElement.Blueprint {
        private final StructuredData value;
        private final DataRole role;

        public static <R extends Role> Builder<R> builder() {
            return new Builder();
        }

        public Blueprint(DataRole role, StructuredData value, Map<String, Object> properties) {
            super(properties);
            if (value == null) {
                value = StructuredData.get().undefined();
            }
            this.role = role;
            this.value = value;
        }

        private Blueprint() {
            this(null, null, null);
        }

        public StructuredData getValue() {
            return this.value;
        }

        public Role getRole() {
            return this.role;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitData(this, parameter);
        }

        public static final class Builder<R extends Role>
        extends Entity.Blueprint.Builder<Blueprint, Builder<R>> {
            private R role;
            private StructuredData value;

            public Builder<R> withValue(StructuredData value) {
                this.value = value;
                return this;
            }

            public Builder<R> withRole(R role) {
                this.role = role;
                return this;
            }

            @Override
            public Blueprint<R> build() {
                if (this.role == null) {
                    throw new NullPointerException("Data entity role not specified.");
                }
                return new Blueprint<R>(this.role, this.value, this.properties);
            }
        }
    }

    public static interface Role {
        public static Role valueOf(String name) {
            return (Role)RoleInstanceHolder.instances.get(name);
        }

        public static Role[] values() {
            Collection values = RoleInstanceHolder.instances.values();
            return values.toArray(new Role[values.size()]);
        }

        public String name();

        public Filter[] navigateToSchema();

        public boolean isSchema();
    }

    private static final class RoleInstanceHolder {
        private static final HashMap<String, Role> instances = new HashMap();

        private RoleInstanceHolder() {
        }

        static {
            for (Resources.DataRole dataRole : Resources.DataRole.values()) {
                instances.put(dataRole.name(), dataRole);
            }
            for (Enum enum_ : ResourceTypes.DataRole.values()) {
                instances.put(enum_.name(), (Role)((Object)enum_));
            }
            for (Enum enum_ : OperationTypes.DataRole.values()) {
                instances.put(enum_.name(), (Role)((Object)enum_));
            }
        }
    }
}

