/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.paging.PageContext;

public class Page<T>
implements Iterator<T>,
AutoCloseable,
Iterable<T> {
    private Iterator<T> wrapped;
    private final PageContext pageContext;
    private final long totalSize;

    public Page(Iterator<T> wrapped, PageContext pageContext, long totalSize) {
        this.wrapped = wrapped;
        this.pageContext = pageContext;
        this.totalSize = totalSize;
    }

    protected Page(PageContext pageContext, long totalSize) {
        this(null, pageContext, totalSize);
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public List<T> toList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false).collect(Collectors.toList());
    }

    @Override
    public boolean hasNext() {
        return this.wrapped != null && this.wrapped.hasNext();
    }

    @Override
    public T next() {
        if (this.wrapped == null) {
            throw new IllegalStateException("the iterator has been already closed");
        }
        return this.wrapped.next();
    }

    @Override
    public void close() throws IOException {
        this.wrapped = null;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

