/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.paging;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;

public final class TransformingPage<I, O>
extends Page<O> {
    private Function<? super I, ? extends O> conversionFunction;
    private Page<I> wrappedPage;

    public TransformingPage(Page<I> wrappedPage, Function<? super I, ? extends O> conversionFunction) {
        super(wrappedPage.getPageContext(), wrappedPage.getTotalSize());
        if (conversionFunction == null) {
            throw new IllegalArgumentException("conversionFunction can't be null");
        }
        this.conversionFunction = conversionFunction;
        this.wrappedPage = wrappedPage;
    }

    public Function<? super I, ? extends O> getConversionFunction() {
        return this.conversionFunction;
    }

    @Override
    public O next() {
        if (this.conversionFunction == null) {
            throw new NoSuchElementException("the page has been closed");
        }
        return this.conversionFunction.apply(this.getPage().next());
    }

    @Override
    public boolean hasNext() {
        return this.wrappedPage != null && this.wrappedPage.hasNext();
    }

    @Override
    public PageContext getPageContext() {
        return this.getPage().getPageContext();
    }

    @Override
    public long getTotalSize() {
        return this.getPage().getTotalSize();
    }

    @Override
    public List<O> toList() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false).collect(Collectors.toList());
    }

    @Override
    public void close() throws IOException {
        this.wrappedPage = null;
        this.conversionFunction = null;
        super.close();
    }

    private Page<I> getPage() {
        if (this.wrappedPage == null) {
            throw new IllegalStateException("the iterator has been already closed");
        }
        return this.wrappedPage;
    }
}

