/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.io.InputStream;
import java.util.Iterator;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.BaseRelationships;
import org.hawkular.inventory.base.BaseTenants;
import org.hawkular.inventory.base.BaseTransactionFrame;
import org.hawkular.inventory.base.ObservableContext;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import rx.Observable;

public abstract class BaseInventory<E>
implements Inventory {
    public static final Configuration.Property TRANSACTION_RETRIES = Configuration.Property.builder().withPropertyNameAndSystemProperty("hawkular.inventory.transaction.retries").withEnvironmentVariables("HAWKULAR_INVENTORY_TRANSACTION_RETRIES").build();
    private InventoryBackend<E> backend;
    private final ObservableContext observableContext;
    private TraversalContext<E, Tenant> tenantContext;
    private TraversalContext<E, Relationship> relationshipContext;

    protected BaseInventory(InventoryBackend<E> backend, ObservableContext observableContext) {
        this.backend = backend;
        this.observableContext = observableContext;
    }

    protected BaseInventory() {
        this.observableContext = new ObservableContext();
    }

    @Override
    public final void initialize(Configuration configuration) {
        this.backend = this.doInitialize(configuration);
        this.tenantContext = new TraversalContext<Tenant, Tenant>(this, Query.empty(), Query.path().with(With.type(Tenant.class)).get(), this.backend, Tenant.class, configuration, this.observableContext);
        this.relationshipContext = new TraversalContext<Relationship, Relationship>(this, Query.empty(), Query.path().get(), this.backend, Relationship.class, configuration, this.observableContext);
    }

    @Override
    public TransactionFrame newTransactionFrame() {
        return new BaseTransactionFrame<E>(this.backend, this.observableContext, this.tenantContext);
    }

    protected abstract InventoryBackend<E> doInitialize(Configuration var1);

    @Override
    public final void close() throws Exception {
        if (this.backend != null) {
            this.backend.close();
            this.backend = null;
        }
    }

    @Override
    public Tenants.ReadWrite tenants() {
        return new BaseTenants.ReadWrite<E>(this.tenantContext);
    }

    @Override
    public Relationships.Read relationships() {
        return new BaseRelationships.Read<E>(this.relationshipContext);
    }

    public InventoryBackend<E> getBackend() {
        return this.backend;
    }

    @Override
    public boolean hasObservers(Interest<?, ?> interest) {
        return this.observableContext.isObserved(interest);
    }

    public <C, V> Observable<C> observable(Interest<C, V> interest) {
        return this.observableContext.getObservableFor(interest);
    }

    @Override
    public InputStream getGraphSON(String tenantId) {
        return this.getBackend().getGraphSON(tenantId);
    }

    public AbstractElement getElement(CanonicalPath path) {
        try {
            return (AbstractElement)this.getBackend().find(path);
        }
        catch (ElementNotFoundException e) {
            throw new EntityNotFoundException("No element found on path: " + path.toString());
        }
    }

    @Override
    public <T extends Entity<?, ?>> Iterator<T> getTransitiveClosureOver(CanonicalPath startingPoint, Relationships.Direction direction, Class<T> clazz, String ... relationshipNames) {
        return this.getBackend().getTransitiveClosureOver(startingPoint, direction, clazz, relationshipNames);
    }

    public static class Initialized<E>
    extends BaseInventory<E> {
        public Initialized(InventoryBackend<E> backend, ObservableContext observableContext, Configuration configuration) {
            super(backend, observableContext);
            this.initialize(configuration);
        }

        @Override
        protected InventoryBackend<E> doInitialize(Configuration configuration) {
            return this.getBackend();
        }
    }
}

