/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;

public interface ElementTypeVisitor<R, P> {
    public static <R, P> R accept(Class<?> entityType, ElementTypeVisitor<R, P> visitor, P parameter) {
        if (Tenant.class.equals(entityType)) {
            return visitor.visitTenant(parameter);
        }
        if (Environment.class.equals(entityType)) {
            return visitor.visitEnvironment(parameter);
        }
        if (Feed.class.equals(entityType)) {
            return visitor.visitFeed(parameter);
        }
        if (Metric.class.equals(entityType)) {
            return visitor.visitMetric(parameter);
        }
        if (MetricType.class.equals(entityType)) {
            return visitor.visitMetricType(parameter);
        }
        if (Resource.class.equals(entityType)) {
            return visitor.visitResource(parameter);
        }
        if (ResourceType.class.equals(entityType)) {
            return visitor.visitResourceType(parameter);
        }
        if (Relationship.class.equals(entityType)) {
            return visitor.visitRelationship(parameter);
        }
        if (DataEntity.class.equals(entityType)) {
            return visitor.visitData(parameter);
        }
        if (OperationType.class.equals(entityType)) {
            return visitor.visitOperationType(parameter);
        }
        return visitor.visitUnknown(parameter);
    }

    public R visitTenant(P var1);

    public R visitEnvironment(P var1);

    public R visitFeed(P var1);

    public R visitMetric(P var1);

    public R visitMetricType(P var1);

    public R visitResource(P var1);

    public R visitResourceType(P var1);

    public R visitRelationship(P var1);

    public R visitData(P var1);

    public R visitOperationType(P var1);

    public R visitUnknown(P var1);

    public static class Simple<R, P>
    implements ElementTypeVisitor<R, P> {
        private final R defaultValue;

        public Simple() {
            this(null);
        }

        public Simple(R defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected R defaultAction() {
            return this.defaultValue;
        }

        @Override
        public R visitTenant(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitEnvironment(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitFeed(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitMetric(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitMetricType(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitResource(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitResourceType(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitRelationship(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitData(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitOperationType(P parameter) {
            return this.defaultAction();
        }

        @Override
        public R visitUnknown(P parameter) {
            return this.defaultAction();
        }
    }
}

