/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.PathSegmentCodec;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;

public abstract class Path {
    public static final char TYPE_DELIM = ';';
    public static final char PATH_DELIM = '/';
    protected final List<Segment> path;
    protected final int startIdx;
    protected final int endIdx;

    Path() {
        this.path = null;
        this.startIdx = 0;
        this.endIdx = 0;
    }

    Path(int startIdx, int endIdx, List<Segment> path) {
        this.startIdx = startIdx;
        this.endIdx = endIdx;
        this.path = Collections.unmodifiableList(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path fromString(String path, boolean shouldBeAbsolute, ExtenderConstructor extenderConstructor, EnhancedTypeProvider typeProvider) {
        Extender extender = extenderConstructor.create(0, new ArrayList<Segment>());
        int startPos = 0;
        try {
            if (shouldBeAbsolute) {
                if (!path.isEmpty() && path.charAt(0) == '/') {
                    startPos = 1;
                } else {
                    throw new IllegalArgumentException("Supplied path '" + path + "' is not absolute.");
                }
            }
            ParsingProgress progress = new ParsingProgress(startPos, path);
            Decoder dec = new Decoder(typeProvider);
            while (!progress.isFinished()) {
                Segment seg = dec.decodeNext(progress);
                extender.extend(seg);
            }
            Path path2 = extender.get();
            return path2;
        }
        finally {
            if (typeProvider != null) {
                typeProvider.finished();
            }
        }
    }

    public static Path fromString(String path) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromString(path);
        }
        return RelativePath.fromString(path);
    }

    public static Path fromPartiallyUntypedString(String path, TypeProvider typeProvider) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromPartiallyUntypedString(path, typeProvider);
        }
        return RelativePath.fromPartiallyUntypedString(path, typeProvider);
    }

    public static Path fromPartiallyUntypedString(String path, CanonicalPath canonicalPathsOrigin, CanonicalPath relativePathsOrigin, Class<?> intendedFinalType) {
        if (path.charAt(0) == '/') {
            return CanonicalPath.fromPartiallyUntypedString(path, canonicalPathsOrigin, intendedFinalType);
        }
        return RelativePath.fromPartiallyUntypedString(path, relativePathsOrigin, intendedFinalType);
    }

    protected abstract Path newInstance(int var1, int var2, List<Segment> var3);

    public abstract RelativePath toRelativePath();

    public abstract CanonicalPath toCanonicalPath();

    public boolean isCanonical() {
        return this instanceof CanonicalPath;
    }

    public boolean isRelative() {
        return this instanceof RelativePath;
    }

    public boolean isDefined() {
        return this.startIdx >= 0 && this.endIdx > this.startIdx && this.endIdx <= this.path.size();
    }

    public Path up() {
        return this.up(1);
    }

    public Path up(int distance) {
        return this.newInstance(this.startIdx, this.endIdx - distance, this.path);
    }

    public Path down() {
        return this.down(1);
    }

    public Path down(int distance) {
        return this.newInstance(this.startIdx, this.endIdx + distance, this.path);
    }

    public int getDepth() {
        return this.endIdx - this.startIdx - 1;
    }

    public Segment getTop() {
        return this.isDefined() ? this.path.get(this.startIdx) : null;
    }

    public Segment getSegment() {
        return this.isDefined() ? this.path.get(this.endIdx - 1) : null;
    }

    public List<Segment> getPath() {
        return this.isDefined() ? this.path.subList(this.startIdx, this.endIdx) : Collections.emptyList();
    }

    public Iterator<? extends Path> ascendingIterator() {
        return new Iterator<Path>(){
            int idx;
            {
                this.idx = Path.this.endIdx;
            }

            @Override
            public boolean hasNext() {
                return this.idx > Path.this.startIdx;
            }

            @Override
            public Path next() {
                if (this.idx <= Path.this.startIdx) {
                    throw new NoSuchElementException();
                }
                return Path.this.newInstance(Path.this.startIdx, this.idx--, Path.this.path);
            }
        };
    }

    public Iterator<? extends Path> descendingIterator() {
        return new Iterator<Path>(){
            int idx;
            {
                this.idx = Path.this.startIdx + 1;
            }

            @Override
            public boolean hasNext() {
                return this.idx <= Path.this.endIdx;
            }

            @Override
            public Path next() {
                if (this.idx > Path.this.endIdx) {
                    throw new NoSuchElementException();
                }
                return Path.this.newInstance(Path.this.startIdx, this.idx++, Path.this.path);
            }
        };
    }

    public int hashCode() {
        int ret = this.startIdx;
        for (int i = this.startIdx; i < this.endIdx; ++i) {
            ret = 31 * ret + this.path.get(i).hashCode();
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        Path other = (Path)o;
        if (this.endIdx != other.endIdx || this.startIdx != other.startIdx) {
            return false;
        }
        for (int i = this.endIdx - 1; i >= this.startIdx; --i) {
            if (this.path.get(i).equals(other.path.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString();
    }

    static abstract class OperationTypeBuilder<Impl extends Path, SDB extends StructuredDataBuilder<Impl, SDB>>
    extends AbstractBuilder<Impl> {
        OperationTypeBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public SDB data(OperationTypes.DataRole role) {
            this.segments.add(new Segment(DataEntity.class, role.name()));
            return this.structuredDataBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract SDB structuredDataBuilder(List<Segment> var1);
    }

    static abstract class StructuredDataBuilder<Impl extends Path, This extends StructuredDataBuilder<Impl, This>>
    extends AbstractBuilder<Impl> {
        StructuredDataBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public This key(String name) {
            this.segments.add(new Segment(StructuredData.class, name));
            return (This)this;
        }

        public This index(int index) {
            this.segments.add(new Segment(StructuredData.class, "" + index));
            return (This)this;
        }

        @Override
        public Impl get() {
            return super.get();
        }
    }

    static abstract class MetricBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        MetricBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        @Override
        public Impl get() {
            return super.get();
        }
    }

    static abstract class ResourceBuilder<Impl extends Path, This extends ResourceBuilder<Impl, This, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>>
    extends AbstractBuilder<Impl> {
        ResourceBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public This resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return (This)this;
        }

        public SDB data(Resources.DataRole role) {
            this.segments.add(new Segment(DataEntity.class, role.name()));
            return this.structuredDataBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract SDB structuredDataBuilder(List<Segment> var1);
    }

    static abstract class FeedBuilder<Impl extends Path, RTB extends ResourceTypeBuilder<Impl, OTB, SDB>, MTB extends MetricTypeBuilder<Impl>, RB extends ResourceBuilder<Impl, RB, SDB>, MB extends MetricBuilder<Impl>, OTB extends OperationTypeBuilder<Impl, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>>
    extends AbstractBuilder<Impl> {
        FeedBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public RB resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return this.resourceBuilder(this.segments);
        }

        public MB metric(String id) {
            this.segments.add(new Segment(Metric.class, id));
            return this.metricBuilder(this.segments);
        }

        public MTB metricType(String id) {
            this.segments.add(new Segment(MetricType.class, id));
            return this.metricTypeBuilder(this.segments);
        }

        public RTB resourceType(String id) {
            this.segments.add(new Segment(ResourceType.class, id));
            return this.resourceTypeBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract RTB resourceTypeBuilder(List<Segment> var1);

        protected abstract MTB metricTypeBuilder(List<Segment> var1);

        protected abstract RB resourceBuilder(List<Segment> var1);

        protected abstract MB metricBuilder(List<Segment> var1);
    }

    static abstract class EnvironmentBuilder<Impl extends Path, FB extends FeedBuilder<Impl, RTB, MTB, RB, MB, OTB, SDB>, RB extends ResourceBuilder<Impl, RB, SDB>, MB extends MetricBuilder<Impl>, RTB extends ResourceTypeBuilder<Impl, OTB, SDB>, MTB extends MetricTypeBuilder<Impl>, OTB extends OperationTypeBuilder<Impl, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>>
    extends AbstractBuilder<Impl> {
        EnvironmentBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public FB feed(String id) {
            this.segments.add(new Segment(Feed.class, id));
            return this.feedBuilder(this.segments);
        }

        public RB resource(String id) {
            this.segments.add(new Segment(Resource.class, id));
            return this.resourceBuilder(this.segments);
        }

        public MB metric(String id) {
            this.segments.add(new Segment(Metric.class, id));
            return this.metricBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract FB feedBuilder(List<Segment> var1);

        protected abstract RB resourceBuilder(List<Segment> var1);

        protected abstract MB metricBuilder(List<Segment> var1);
    }

    static abstract class MetricTypeBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        MetricTypeBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        @Override
        public Impl get() {
            return super.get();
        }
    }

    static abstract class ResourceTypeBuilder<Impl extends Path, OTB extends OperationTypeBuilder<Impl, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>>
    extends AbstractBuilder<Impl> {
        ResourceTypeBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public SDB data(ResourceTypes.DataRole role) {
            this.segments.add(new Segment(DataEntity.class, role.name()));
            return this.structuredDataBuilder(this.segments);
        }

        public OTB operationType(String id) {
            this.segments.add(new Segment(OperationType.class, id));
            return this.operationTypeBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract OTB operationTypeBuilder(List<Segment> var1);

        protected abstract SDB structuredDataBuilder(List<Segment> var1);
    }

    static abstract class TenantBuilder<Impl extends Path, EB extends EnvironmentBuilder<Impl, FB, RB, MB, RTB, MTB, OTB, SDB>, RTB extends ResourceTypeBuilder<Impl, OTB, SDB>, MTB extends MetricTypeBuilder<Impl>, OTB extends OperationTypeBuilder<Impl, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>, FB extends FeedBuilder<Impl, RTB, MTB, RB, MB, OTB, SDB>, RB extends ResourceBuilder<Impl, RB, SDB>, MB extends MetricBuilder<Impl>>
    extends AbstractBuilder<Impl> {
        TenantBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public EB environment(String id) {
            this.segments.add(new Segment(Environment.class, id));
            return this.environmentBuilder(this.segments);
        }

        public RTB resourceType(String id) {
            this.segments.add(new Segment(ResourceType.class, id));
            return this.resourceTypeBuilder(this.segments);
        }

        public MTB metricType(String id) {
            this.segments.add(new Segment(MetricType.class, id));
            return this.metricTypeBuilder(this.segments);
        }

        @Override
        public Impl get() {
            return super.get();
        }

        protected abstract EB environmentBuilder(List<Segment> var1);

        protected abstract RTB resourceTypeBuilder(List<Segment> var1);

        protected abstract MTB metricTypeBuilder(List<Segment> var1);
    }

    static abstract class RelationshipBuilder<Impl extends Path>
    extends AbstractBuilder<Impl> {
        RelationshipBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        @Override
        public Impl get() {
            return super.get();
        }
    }

    static abstract class Builder<Impl extends Path, TB extends TenantBuilder<Impl, EB, RTB, MTB, OTB, SDB, FB, RB, MB>, EB extends EnvironmentBuilder<Impl, FB, RB, MB, RTB, MTB, OTB, SDB>, RTB extends ResourceTypeBuilder<Impl, OTB, SDB>, MTB extends MetricTypeBuilder<Impl>, RLB extends RelationshipBuilder<Impl>, OTB extends OperationTypeBuilder<Impl, SDB>, SDB extends StructuredDataBuilder<Impl, SDB>, FB extends FeedBuilder<Impl, RTB, MTB, RB, MB, OTB, SDB>, RB extends ResourceBuilder<Impl, RB, SDB>, MB extends MetricBuilder<Impl>>
    extends AbstractBuilder<Impl> {
        Builder(List<Segment> segments, Constructor<Impl> constructor) {
            super(segments, constructor);
        }

        public TB tenant(String id) {
            this.segments.add(new Segment(Tenant.class, id));
            return this.tenantBuilder(this.segments);
        }

        public RLB relationship(String id) {
            this.segments.add(new Segment(Relationship.class, id));
            return this.relationshipBuilder(this.segments);
        }

        protected abstract TB tenantBuilder(List<Segment> var1);

        protected abstract RLB relationshipBuilder(List<Segment> var1);
    }

    static abstract class AbstractBuilder<Impl extends Path> {
        protected final List<Segment> segments;
        protected final Constructor<Impl> constructor;

        AbstractBuilder(List<Segment> segments, Constructor<Impl> constructor) {
            this.segments = segments;
            this.constructor = constructor;
        }

        protected Impl get() {
            return (Impl)((Path)this.constructor.create(0, this.segments.size(), this.segments));
        }
    }

    public static class HintedTypeProvider
    extends StructuredDataHintingTypeProvider {
        private final Class<?> intendedFinalType;
        private final Extender extender;

        public HintedTypeProvider(Class<?> intendedFinalType, Extender extender) {
            this.intendedFinalType = intendedFinalType;
            this.extender = extender;
        }

        @Override
        public void segmentParsed(Segment segment) {
            this.extender.extend(segment);
        }

        @Override
        public Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                return null;
            }
            CanonicalPath full = this.extender.get().toCanonicalPath();
            Class<?> currentType = full.getDepth() >= 0 ? full.getSegment().getElementType() : null;
            Class<?> nextStep = this.unambiguousPathNextStep(this.intendedFinalType, currentType, isLast, new HashMap());
            if (nextStep != null) {
                return new Segment(nextStep, id);
            }
            return null;
        }

        @Override
        public void finished() {
        }

        private Class<?> unambiguousPathNextStep(Class<?> targetType, Class<?> currentType, boolean isLast, Map<Class<?>, Boolean> visitedTypes) {
            if (targetType.equals(currentType)) {
                return targetType;
            }
            HashSet ret = new HashSet();
            this.fillPossiblePathsToTarget(targetType, currentType, ret, visitedTypes, true);
            if (ret.size() == 0) {
                return null;
            }
            if (ret.size() == 1) {
                return (Class)ret.iterator().next();
            }
            if (isLast && ret.contains(this.intendedFinalType)) {
                return this.intendedFinalType;
            }
            throw new IllegalArgumentException("Cannot unambiguously deduce types of the untyped path segments.");
        }

        private boolean fillPossiblePathsToTarget(Class<?> targetType, Class<?> currentType, Set<Class<?>> result, Map<Class<?>, Boolean> visitedTypes, boolean isStart) {
            if (targetType.equals(currentType)) {
                if (isStart) {
                    result.add(currentType);
                }
                return true;
            }
            List<Class<?>> options = CanonicalPath.VALID_PROGRESSIONS.get(currentType);
            if (options == null || options.isEmpty()) {
                return false;
            }
            if (options != null && options.contains(targetType) && isStart) {
                result.add(targetType);
                return true;
            }
            boolean matched = false;
            for (Class<?> option : options) {
                if (!visitedTypes.containsKey(option)) {
                    visitedTypes.put(option, false);
                    if (!this.fillPossiblePathsToTarget(targetType, option, result, visitedTypes, false)) continue;
                    if (isStart) {
                        result.add(option);
                    }
                    visitedTypes.put(option, true);
                    matched = true;
                    continue;
                }
                matched |= visitedTypes.get(option).booleanValue();
            }
            return matched;
        }
    }

    public static class StructuredDataHintingTypeProvider
    implements TypeProvider {
        private boolean insideDataEntity;

        @Override
        public void segmentParsed(Segment segment) {
            this.insideDataEntity = DataEntity.class.equals(segment.getElementType());
        }

        @Override
        public Segment deduceSegment(String type, String id, boolean isLast) {
            if (type == null && this.insideDataEntity) {
                return new Segment(StructuredData.class, id);
            }
            return null;
        }

        @Override
        public void finished() {
            this.insideDataEntity = false;
        }
    }

    public static abstract class Extender {
        private final List<Segment> segments;
        private final Function<List<Segment>, List<Class<?>>> validProgressions;
        private final int from;
        private int checkIndex;

        Extender(int from, List<Segment> segments, boolean mergeWithInitial, Function<List<Segment>, List<Class<?>>> validProgressions) {
            this.from = from;
            this.segments = segments;
            this.validProgressions = validProgressions;
            this.checkIndex = mergeWithInitial ? from : -1;
        }

        protected abstract Path newPath(int var1, int var2, List<Segment> var3);

        public Boolean canExtendTo(Class<?> segmentType) {
            switch (this.checkCanProgress(segmentType, false)) {
                case PROCEED_IF_ID_MATCHES: {
                    return null;
                }
                case PROCEED: 
                case CLEAR_SEGMENTS_AND_JUMP_TO_END: 
                case JUMP_TO_END: {
                    return true;
                }
            }
            return false;
        }

        public boolean canExtendTo(Segment segment) {
            switch (this.checkCanProgress(segment.elementType, Objects.equals(segment, this.segments.get(this.checkIndex)))) {
                case PROCEED: 
                case CLEAR_SEGMENTS_AND_JUMP_TO_END: 
                case JUMP_TO_END: {
                    return true;
                }
            }
            return false;
        }

        public Extender extend(Segment segment) {
            boolean idMatches = this.checkIndex >= 0 && this.checkIndex < this.segments.size() && Objects.equals(segment, this.segments.get(this.checkIndex));
            switch (this.checkCanProgress(segment.getElementType(), idMatches)) {
                case PROCEED_IF_ID_MATCHES: 
                case INVALID_IN_ORIGIN: {
                    throw new IllegalArgumentException("The provided segment " + segment + " does not match the" + " expected origin of the path.");
                }
                case PROCEED: {
                    break;
                }
                case CLEAR_SEGMENTS_AND_JUMP_TO_END: {
                    this.segments.clear();
                    this.checkIndex = 0;
                    break;
                }
                case JUMP_TO_END: {
                    this.checkIndex = this.segments.size();
                    break;
                }
                default: {
                    List<Segment> currentSegs = this.checkIndex >= 0 ? this.segments.subList(this.from, this.checkIndex) : this.segments;
                    List<Class<?>> progress = this.validProgressions.apply(currentSegs);
                    throw new IllegalArgumentException("The provided segment " + segment + " is not valid extension" + " of the path: " + currentSegs + (progress == null ? ". There are no further extensions possible." : ". Valid extension types are: " + progress.stream().map(Class::getSimpleName).collect(Collectors.toList())));
                }
            }
            if (this.checkIndex < 0 || this.checkIndex >= this.segments.size()) {
                this.segments.add(segment);
            }
            if (this.checkIndex >= 0) {
                ++this.checkIndex;
            }
            return this;
        }

        protected void removeLastSegment() {
            if (this.segments.size() > 0) {
                this.segments.remove(this.segments.size() - 1);
                if (this.checkIndex > 0) {
                    --this.checkIndex;
                }
            }
        }

        public Extender extend(Collection<Segment> segments) {
            segments.forEach(this::extend);
            return this;
        }

        public Extender extend(Class<? extends AbstractElement<?, ?>> type, String id) {
            return this.extend(new Segment(type, id));
        }

        public Path get() {
            return this.newPath(this.from, this.segments.size(), this.segments);
        }

        private ProgressCheck checkCanProgress(Class<?> nextSegmentType, boolean idMatches) {
            List<Segment> currentSegs;
            List<Class<?>> progress;
            int indexToCheck = this.checkIndex;
            ProgressCheck ret = ProgressCheck.PROCEED;
            if (this.checkIndex >= 0 && this.checkIndex < this.segments.size()) {
                Segment matching = this.segments.get(this.checkIndex);
                if (nextSegmentType.equals(matching.elementType)) {
                    return idMatches ? ProgressCheck.PROCEED : ProgressCheck.PROCEED_IF_ID_MATCHES;
                }
                if (this.checkIndex == this.from) {
                    if (Relationship.class.equals(nextSegmentType)) {
                        ret = ProgressCheck.CLEAR_SEGMENTS_AND_JUMP_TO_END;
                        indexToCheck = 0;
                    } else {
                        ret = ProgressCheck.JUMP_TO_END;
                        indexToCheck = this.segments.size();
                    }
                } else {
                    return ProgressCheck.INVALID_IN_ORIGIN;
                }
            }
            if ((progress = this.validProgressions.apply(currentSegs = indexToCheck >= 0 ? this.segments.subList(this.from, indexToCheck) : this.segments)) == null || !progress.contains(nextSegmentType)) {
                return ProgressCheck.INVALID;
            }
            return ret;
        }

        private static enum ProgressCheck {
            PROCEED,
            PROCEED_IF_ID_MATCHES,
            INCREMENT_INITIAL_POSITION,
            CLEAR_SEGMENTS_AND_JUMP_TO_END,
            JUMP_TO_END,
            INVALID_IN_ORIGIN,
            INVALID;

        }
    }

    public static final class Segment {
        private final Class<?> elementType;
        private final String entityId;

        private Segment() {
            this(null, null);
        }

        public Segment(Class<?> elementType, String entityId) {
            this.entityId = entityId;
            this.elementType = elementType;
        }

        public <R, P> R accept(ElementTypeVisitor<R, P> visitor, P parameter) {
            return ElementTypeVisitor.accept(this.elementType, visitor, parameter);
        }

        public String getElementId() {
            return this.entityId;
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)o;
            return this.elementType == segment.elementType && Objects.equals(this.entityId, segment.entityId);
        }

        public int hashCode() {
            int result = this.elementType.hashCode();
            result = 31 * result + this.entityId.hashCode();
            return result;
        }

        public String toString() {
            return "Segment[entityId='" + this.entityId + '\'' + ", entityType=" + (this.elementType == null ? "null" : this.elementType.getSimpleName()) + ']';
        }
    }

    static final class Encoder {
        private final Map<Class<?>, String> typeMap;
        private final Function<Segment, Boolean> requiresId;

        public Encoder(Map<Class<?>, String> typeMap, Function<Segment, Boolean> requiresId) {
            this.typeMap = typeMap;
            this.requiresId = requiresId;
        }

        public String encode(String prefix, Path path) {
            StringBuilder bld = new StringBuilder(prefix);
            for (Segment seg : path.getPath()) {
                String type = this.typeMap.get(seg.getElementType());
                if (type != null) {
                    bld.append(type);
                }
                if (seg.getElementId() != null && this.requiresId.apply(seg).booleanValue()) {
                    if (type != null) {
                        bld.append(';');
                    }
                    bld.append(PathSegmentCodec.encode(seg.getElementId()));
                }
                bld.append('/');
            }
            return bld.delete(bld.length() - 1, bld.length()).toString();
        }
    }

    private static final class Decoder {
        private final EnhancedTypeProvider typeProvider;

        Decoder(EnhancedTypeProvider typeProvider) {
            this.typeProvider = typeProvider;
        }

        /*
         * Enabled aggressive block sorting
         */
        Segment decodeNext(ParsingProgress progress) {
            Segment ret;
            String currentIdString;
            StringBuilder currentId = new StringBuilder();
            String currentTypeString = null;
            int state = 0;
            block11: while (!progress.isFinished()) {
                char c = progress.getNextChar();
                switch (state) {
                    case 0: {
                        switch (c) {
                            case ';': {
                                if (currentId.length() == 0) {
                                    throw new IllegalArgumentException("Unspecified entity type id at pos " + progress.getPos() + " in '" + progress.getSource() + "'.");
                                }
                                currentTypeString = currentId.toString();
                                currentId.delete(0, currentId.length());
                                state = 1;
                                break;
                            }
                            case '/': {
                                currentTypeString = currentId.toString();
                                currentId.delete(0, currentId.length());
                                break block11;
                            }
                            default: {
                                currentId.append(c);
                                break;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (c) {
                            case '/': {
                                break block11;
                            }
                            default: {
                                currentId.append(c);
                            }
                        }
                    }
                }
            }
            if ((currentIdString = currentId.toString()).isEmpty()) {
                currentIdString = currentTypeString;
                currentTypeString = null;
                if (state == 1) {
                    currentIdString = currentIdString + ';';
                }
            }
            if ((ret = this.typeProvider.deduceSegment(currentTypeString, currentIdString = PathSegmentCodec.decode(currentIdString), progress.isFinished())) == null) {
                throw new IllegalArgumentException("Unrecognized entity type '" + currentTypeString + "' for segment" + " with id: '" + currentIdString + "' in path '" + progress.getSource() + "'. The following types are recognized: " + this.typeProvider.getValidTypeName());
            }
            this.typeProvider.segmentParsed(ret);
            return ret;
        }
    }

    private static class ParsingProgress {
        private final String source;
        private int pos;

        public ParsingProgress(int pos, String source) {
            this.pos = pos;
            this.source = source;
        }

        public int getPos() {
            return this.pos;
        }

        public char getNextChar() {
            return this.source.charAt(this.pos++);
        }

        public String getSource() {
            return this.source;
        }

        public boolean isFinished() {
            return this.pos >= this.source.length();
        }
    }

    static abstract class EnhancedTypeProvider
    implements TypeProvider {
        EnhancedTypeProvider() {
        }

        abstract Set<String> getValidTypeName();
    }

    @FunctionalInterface
    protected static interface ExtenderConstructor {
        public Extender create(int var1, List<Segment> var2);
    }

    public static interface TypeProvider {
        public void segmentParsed(Segment var1);

        public Segment deduceSegment(String var1, String var2, boolean var3);

        public void finished();
    }

    @FunctionalInterface
    static interface Constructor<Path> {
        public Path create(int var1, int var2, List<Segment> var3);
    }
}

