/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

class Associator<BE, E extends Entity<?, ?>>
extends Traversal<BE, E> {
    protected Associator(TraversalContext<BE, E> context) {
        super(context);
    }

    protected Relationship createAssociation(Class<? extends Entity<?, ?>> sourceType, Relationships.WellKnown relationship, BE target) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        EntityAndPendingNotifications<Relationship> rel = Util.createAssociation(this.context, sourceQuery, sourceType, relationship.name(), target);
        this.context.notifyAll(rel);
        return rel.getEntity();
    }

    protected Relationship deleteAssociation(Class<? extends Entity<?, ?>> sourceType, Relationships.WellKnown relationship, BE target) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        EntityAndPendingNotifications<Relationship> rel = Util.deleteAssociation(this.context, sourceQuery, sourceType, relationship.name(), target);
        this.context.notifyAll(rel);
        return rel.getEntity();
    }

    protected Relationship getAssociation(Class<? extends Entity<?, ?>> sourceType, Path targetPath, Relationships.WellKnown rel) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        Query targetQuery = Util.queryTo(this.context, targetPath);
        Class<?> targetType = targetPath.getSegment().getElementType();
        return Util.getAssociation(this.context, sourceQuery, sourceType, targetQuery, targetType, rel.name());
    }
}

