/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.BaseEnvironments;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseResourceTypes;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseTenants {
    private BaseTenants() {
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, Tenant, Tenant.Update>
    implements Tenants.Single {
        public Single(TraversalContext<BE, Tenant> context) {
            super(context);
        }

        @Override
        public ResourceTypes.ReadWrite feedlessResourceTypes() {
            return new BaseResourceTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }

        @Override
        public MetricTypes.ReadWrite feedlessMetricTypes() {
            return new BaseMetricTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public Environments.ReadWrite environments() {
            return new BaseEnvironments.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, Environment.class).get());
        }

        @Override
        public MetricTypes.Read allMetricTypes() {
            return new BaseMetricTypes.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(MetricType.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Environment.class), Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(MetricType.class)}}).getting(MetricType.class));
        }

        @Override
        public ResourceTypes.Read allResourceTypes() {
            return new BaseResourceTypes.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(ResourceType.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Environment.class), Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(ResourceType.class)}}).getting(ResourceType.class));
        }
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, Tenant, Tenant.Update>
    implements Tenants.Multiple {
        public Multiple(TraversalContext<BE, Tenant> context) {
            super(context);
        }

        @Override
        public ResourceTypes.ReadContained feedlessResourceTypes() {
            return new BaseResourceTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, ResourceType.class).get());
        }

        @Override
        public MetricTypes.ReadContained feedlessMetricTypes() {
            return new BaseMetricTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, MetricType.class).get());
        }

        @Override
        public Environments.ReadContained environments() {
            return new BaseEnvironments.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, Environment.class).get());
        }

        @Override
        public MetricTypes.Read allMetricTypes() {
            return new BaseMetricTypes.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(MetricType.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Environment.class), Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(MetricType.class)}}).getting(MetricType.class));
        }

        @Override
        public ResourceTypes.Read allResourceTypes() {
            return new BaseResourceTypes.Read(this.context.proceed().hop(new Filter[][]{{Related.by(Relationships.WellKnown.contains), With.type(ResourceType.class)}, {Related.by(Relationships.WellKnown.contains), With.type(Environment.class), Related.by(Relationships.WellKnown.contains), With.type(Feed.class), Related.by(Relationships.WellKnown.contains), With.type(ResourceType.class)}}).getting(ResourceType.class));
        }
    }

    public static class Read<BE>
    extends Traversal<BE, Tenant>
    implements Tenants.Read {
        public Read(TraversalContext<BE, Tenant> context) {
            super(context);
        }

        @Override
        public Tenants.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Tenants.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Traversal<BE, Tenant>
    implements Tenants.ReadContained {
        public ReadContained(TraversalContext<BE, Tenant> context) {
            super(context);
        }

        @Override
        public Tenants.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Tenants.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, Tenant, Tenant.Blueprint, Tenant.Update, String>
    implements Tenants.ReadWrite {
        public ReadWrite(TraversalContext<BE, Tenant> context) {
            super(context);
        }

        @Override
        protected String getProposedId(Tenant.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<Tenant> wireUpNewEntity(BE entity, Tenant.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            return new EntityAndPendingNotifications<Tenant>(new Tenant((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.context.backend.extractId(entity))).get(), blueprint.getProperties()), new Notification[0]);
        }

        @Override
        public Tenants.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public Tenants.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public Tenants.Single create(Tenant.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

