/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementTypeVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.ElementNotFoundException;

abstract class Mutator<BE, E extends Entity<?, U>, B extends Blueprint, U extends AbstractElement.Update, Id>
extends Traversal<BE, E> {
    protected Mutator(TraversalContext<BE, E> context) {
        super(context);
    }

    protected abstract String getProposedId(B var1);

    protected final Query doCreate(B blueprint) {
        return this.mutating(transaction -> {
            CanonicalPath entityPath;
            String id = this.getProposedId(blueprint);
            BE parent = this.getParent();
            CanonicalPath parentCanonicalPath = parent == null ? null : this.context.backend.extractCanonicalPath(parent);
            Object containsRel = null;
            if (parent == null) {
                if (this.context.entityClass != Tenant.class) throw new IllegalStateException("Could not find the parent of the entity to be created,yet the entity is not a tenant: " + blueprint);
                entityPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(id)).get();
            } else {
                entityPath = parentCanonicalPath.extend(this.context.entityClass, id).get();
            }
            Object entityObject = this.context.backend.persist(entityPath, (Blueprint)blueprint);
            if (parentCanonicalPath != null) {
                containsRel = this.context.backend.relate(parent, entityObject, Relationships.WellKnown.contains.name(), Collections.emptyMap());
            }
            EntityAndPendingNotifications<E> newEntity = this.wireUpNewEntity(entityObject, blueprint, parentCanonicalPath, parent);
            ArrayList customRelsNotifications = new ArrayList();
            if (blueprint instanceof Entity.Blueprint) {
                Entity.Blueprint b = (Entity.Blueprint)blueprint;
                this.createCustomRelationships(entityObject, Relationships.Direction.outgoing, b.getOutgoingRelationships(), customRelsNotifications);
                this.createCustomRelationships(entityObject, Relationships.Direction.incoming, b.getIncomingRelationships(), customRelsNotifications);
            }
            this.context.backend.commit(transaction);
            this.context.notify(newEntity.getEntity(), Action.created());
            if (containsRel != null) {
                this.context.notify(this.context.backend.convert(containsRel, Relationship.class), Action.created());
            }
            this.context.notifyAll(newEntity);
            customRelsNotifications.forEach(this.context::notify);
            return Query.to(entityPath);
        });
    }

    public final void update(Id id, U update) throws EntityNotFoundException {
        Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
        Util.update(this.context, q, update, (e, u) -> this.preUpdate(id, e, u));
    }

    public final void delete(Id id) throws EntityNotFoundException {
        Query q = id == null ? this.context.select().get() : this.context.select().with(With.id(id.toString())).get();
        Util.delete(this.context, q, e -> this.cleanup(id, e));
    }

    protected void cleanup(Id id, BE entityRepresentation) {
    }

    protected void preUpdate(Id id, BE entityRepresentation, U update) {
    }

    private BE getParent() {
        return (BE)ElementTypeVisitor.accept(this.context.entityClass, new ElementTypeVisitor.Simple<BE, Void>(){

            @Override
            protected BE defaultAction() {
                Object res = Mutator.this.context.backend.querySingle(Mutator.this.context.sourcePath);
                if (res == null) {
                    Class parentEntityClass = null;
                    if (Mutator.this.context.previous != null && Entity.class.isAssignableFrom(Mutator.this.context.previous.entityClass)) {
                        parentEntityClass = Mutator.this.context.previous.entityClass;
                    }
                    throw new EntityNotFoundException(parentEntityClass, Query.filters(Mutator.this.context.sourcePath));
                }
                return res;
            }

            @Override
            public BE visitTenant(Void parameter) {
                return null;
            }
        }, null);
    }

    protected BE relate(BE source, BE target, String relationshipName) {
        RelationshipRules.checkCreate(this.context.backend, source, Relationships.Direction.outgoing, relationshipName, target);
        return this.context.backend.relate(source, target, relationshipName, null);
    }

    protected abstract EntityAndPendingNotifications<E> wireUpNewEntity(BE var1, B var2, CanonicalPath var3, BE var4);

    private void createCustomRelationships(BE entity, Relationships.Direction direction, Map<String, Set<CanonicalPath>> otherEnds, List<Notification<?, ?>> notifications) {
        otherEnds.forEach((name, ends) -> ends.forEach(end -> {
            try {
                Object endObject = this.context.backend.find((CanonicalPath)end);
                Object from = direction == Relationships.Direction.outgoing ? entity : endObject;
                Object to = direction == Relationships.Direction.outgoing ? endObject : entity;
                EntityAndPendingNotifications<Relationship> res = Util.createAssociationNoTransaction(this.context, from, name, to);
                notifications.addAll(res.getNotifications());
            }
            catch (ElementNotFoundException e) {
                throw new EntityNotFoundException(Query.filters(Query.to(end)));
            }
        }));
    }
}

