/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;

public abstract class Entity<B extends org.hawkular.inventory.api.model.Blueprint, U extends AbstractElement.Update>
extends AbstractElement<B, U> {
    Entity() {
    }

    Entity(CanonicalPath path) {
        this(path, null);
    }

    Entity(CanonicalPath path, Map<String, Object> properties) {
        super(path, properties);
        if (!this.getClass().equals(path.getSegment().getElementType())) {
            throw new IllegalArgumentException("Invalid path specified. Trying to create " + this.getClass().getSimpleName() + " but the path points to " + path.getSegment().getElementType().getSimpleName());
        }
    }

    protected void appendToString(StringBuilder toStringBuilder) {
    }

    public final String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[path='").append(this.getPath()).append('\'');
        this.appendToString(bld);
        bld.append(']');
        return bld.toString();
    }

    public static abstract class Blueprint
    extends AbstractElement.Blueprint {
        private final String id;
        private final Map<String, Set<CanonicalPath>> outgoing;
        private final Map<String, Set<CanonicalPath>> incoming;

        protected Blueprint(String id, Map<String, Object> properties) {
            this(id, properties, null, null);
        }

        protected Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(properties);
            this.id = id;
            this.outgoing = outgoing == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(outgoing);
            this.incoming = incoming == null ? Collections.emptyMap() : Blueprint.copyAsUnmodifiable(incoming);
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Set<CanonicalPath>> getOutgoingRelationships() {
            return this.outgoing;
        }

        public Map<String, Set<CanonicalPath>> getIncomingRelationships() {
            return this.incoming;
        }

        private static Map<String, Set<CanonicalPath>> copyAsUnmodifiable(Map<String, Set<CanonicalPath>> map) {
            HashMap ret = new HashMap(map.size());
            map.forEach((k, v) -> ret.put(k, Collections.unmodifiableSet(v)));
            return Collections.unmodifiableMap(ret);
        }

        public static abstract class Builder<Blueprint, This extends Builder<Blueprint, This>>
        extends AbstractElement.Blueprint.Builder<Blueprint, This> {
            protected String id;
            protected Map<String, Set<CanonicalPath>> outgoing;
            protected Map<String, Set<CanonicalPath>> incoming;

            public This withId(String id) {
                this.id = id;
                return (This)((Builder)this.castThis());
            }

            public This withOutgoingRelationships(Map<String, Set<CanonicalPath>> outgoing) {
                this.outgoing = outgoing;
                return (This)((Builder)this.castThis());
            }

            public This withIncomingRelationships(Map<String, Set<CanonicalPath>> incoming) {
                this.incoming = incoming;
                return (This)((Builder)this.castThis());
            }

            public This addOutgoingRelationship(String label, CanonicalPath target) {
                this.outgoing = this.addRelationship(this.outgoing, label, target);
                return (This)((Builder)this.castThis());
            }

            public This addIncomingRelationship(String label, CanonicalPath source) {
                this.incoming = this.addRelationship(this.incoming, label, source);
                return (This)((Builder)this.castThis());
            }

            private Map<String, Set<CanonicalPath>> addRelationship(Map<String, Set<CanonicalPath>> map, String label, CanonicalPath path) {
                Set<CanonicalPath> paths;
                if (map == null) {
                    map = new HashMap<String, Set<CanonicalPath>>();
                }
                if ((paths = map.get(label)) == null) {
                    paths = new HashSet<CanonicalPath>();
                    map.put(label, paths);
                }
                paths.add(path);
                return map;
            }
        }
    }
}

