/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricType;

@XmlRootElement
public final class Metric
extends Entity<Blueprint, Update> {
    private final MetricType type;

    private Metric() {
        this.type = null;
    }

    public Metric(CanonicalPath path, MetricType type) {
        this(path, type, null);
    }

    public Metric(CanonicalPath path, MetricType type, Map<String, Object> properties) {
        super(path, properties);
        this.type = type;
    }

    @Override
    public AbstractElement.Updater<Update, Metric> update() {
        return new AbstractElement.Updater<Update, Metric>(u -> new Metric(this.getPath(), this.getType(), u.getProperties()));
    }

    public MetricType getType() {
        return this.type;
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", definition=").append(this.type);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetric(this, parameter);
    }

    public static final class Update
    extends AbstractElement.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetric(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        @XmlAttribute
        private final String metricTypePath;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this(null, null, null);
        }

        public Blueprint(String metricTypePath, String id) {
            this(metricTypePath, id, Collections.emptyMap());
        }

        public Blueprint(String metricTypePath, String id, Map<String, Object> properties) {
            super(id, properties);
            this.metricTypePath = metricTypePath;
        }

        public Blueprint(String metricTypePath, String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.metricTypePath = metricTypePath;
        }

        public String getMetricTypePath() {
            return this.metricTypePath;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetric(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String metricTypeId;

            public Builder withMetricTypePath(String metricTypePath) {
                this.metricTypeId = metricTypePath;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.metricTypeId, this.id, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

