/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricUnit;

@XmlRootElement
public final class MetricType
extends Entity<Blueprint, Update> {
    @XmlAttribute
    private final MetricUnit unit;
    @XmlAttribute
    private final MetricDataType type;

    private MetricType() {
        this.unit = null;
        this.type = null;
    }

    public MetricType(CanonicalPath path) {
        this(path, MetricUnit.NONE, null, null);
    }

    public MetricType(CanonicalPath path, MetricUnit unit, MetricDataType type) {
        this(path, unit, type, null);
    }

    public MetricType(CanonicalPath path, MetricUnit unit, MetricDataType type, Map<String, Object> properties) {
        super(path, properties);
        this.unit = unit;
        this.type = type;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public MetricDataType getType() {
        return this.type;
    }

    @Override
    public AbstractElement.Updater<Update, MetricType> update() {
        return new AbstractElement.Updater<Update, MetricType>(u -> new MetricType(this.getPath(), MetricType.valueOrDefault(((Update)u).unit, this.unit), this.type, u.getProperties()));
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetricType(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", unit=").append((Object)this.unit);
    }

    public static final class Update
    extends AbstractElement.Update {
        private final MetricUnit unit;

        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null, null);
        }

        public Update(Map<String, Object> properties, MetricUnit unit) {
            super(properties);
            this.unit = unit;
        }

        public MetricUnit getUnit() {
            return this.unit;
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetricType(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            private MetricUnit unit;

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.properties, this.unit);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        @XmlAttribute
        private final MetricUnit unit;
        private final MetricDataType type;

        public static Builder builder(MetricDataType type) {
            return new Builder(type);
        }

        private Blueprint() {
            this((String)null, (MetricUnit)null, (MetricDataType)null, (Map<String, Object>)null);
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type) {
            this(id, unit, type, Collections.emptyMap());
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type, Map<String, Object> properties) {
            super(id, properties);
            this.unit = unit == null ? MetricUnit.NONE : unit;
            this.type = type;
        }

        public Blueprint(String id, MetricUnit unit, MetricDataType type, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
            this.type = type;
            this.unit = unit;
        }

        public MetricUnit getUnit() {
            return this.unit;
        }

        public MetricDataType getType() {
            return this.type;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitMetricType(this, parameter);
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private MetricUnit unit;
            private MetricDataType type;

            public Builder(MetricDataType type) {
                this.type = type;
            }

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            public Builder withType(MetricDataType type) {
                this.type = type;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.unit, this.type, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

