/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;

public final class RelativePath
extends Path
implements Serializable {
    static final Map<String, Class<?>> SHORT_NAME_TYPES = new HashMap();
    static final Map<Class<?>, String> SHORT_TYPE_NAMES = new HashMap();
    private static final Map<Class<?>, List<Class<?>>> VALID_PROGRESSIONS = new HashMap();
    private static final List<Class<?>> ALL_VALID_TYPES = Arrays.asList(Tenant.class, ResourceType.class, MetricType.class, Environment.class, Feed.class, Metric.class, Resource.class, StructuredData.class, Up.class);

    RelativePath(int start, int end, List<Path.Segment> segments) {
        super(start, end, segments);
    }

    public static RelativePath fromString(String path) {
        return RelativePath.fromPartiallyUntypedString(path, new Path.StructuredDataHintingTypeProvider());
    }

    public static RelativePath fromPartiallyUntypedString(String path, Path.TypeProvider typeProvider) {
        return (RelativePath)Path.fromString(path, false, Extender::new, new RelativeTypeProvider(typeProvider));
    }

    public static RelativePath fromPartiallyUntypedString(String path, CanonicalPath initialPosition, Class<?> intendedFinalType) {
        return (RelativePath)Path.fromString(path, false, Extender::new, new RelativeTypeProvider(new Path.HintedTypeProvider(intendedFinalType, new Extender(0, new ArrayList<Path.Segment>(initialPosition.getPath())))));
    }

    public static Extender empty() {
        return new Extender(0, new ArrayList<Path.Segment>());
    }

    public static Builder to() {
        return new Builder((List)new ArrayList());
    }

    @Override
    protected Path newInstance(int startIdx, int endIdx, List<Path.Segment> segments) {
        return new RelativePath(startIdx, endIdx, segments);
    }

    public CanonicalPath applyTo(CanonicalPath path) {
        return this.toCanonicalPath(new ArrayList<Path.Segment>(path.getPath()));
    }

    @Override
    public CanonicalPath toCanonicalPath() {
        return this.toCanonicalPath(new ArrayList<Path.Segment>());
    }

    @Override
    public RelativePath toRelativePath() {
        return this;
    }

    private CanonicalPath toCanonicalPath(List<Path.Segment> startSegments) {
        CanonicalPath.Extender extender = new CanonicalPath.Extender(0, startSegments){

            @Override
            public CanonicalPath.Extender extend(Path.Segment segment) {
                if (Up.class.equals(segment.getElementType())) {
                    this.removeLastSegment();
                } else {
                    super.extend(segment);
                }
                return this;
            }
        };
        this.getPath().forEach(extender::extend);
        return extender.get();
    }

    public Iterator<RelativePath> ascendingIterator() {
        return super.ascendingIterator();
    }

    public Iterator<RelativePath> descendingIterator() {
        return super.descendingIterator();
    }

    @Override
    public RelativePath down() {
        return (RelativePath)super.down();
    }

    @Override
    public RelativePath down(int distance) {
        return (RelativePath)super.down(distance);
    }

    @Override
    public RelativePath up() {
        return (RelativePath)super.up();
    }

    @Override
    public RelativePath up(int distance) {
        return (RelativePath)super.up(distance);
    }

    public RelativePath slide(int startDelta, int endDelta) {
        return new RelativePath(this.startIdx + startDelta, this.endIdx + endDelta, this.path);
    }

    @Override
    public String toString() {
        return new Path.Encoder(SHORT_TYPE_NAMES, s -> !Up.class.equals(s.getElementType())).encode("", this);
    }

    static {
        SHORT_NAME_TYPES.putAll(CanonicalPath.SHORT_NAME_TYPES);
        SHORT_NAME_TYPES.put("..", Up.class);
        SHORT_TYPE_NAMES.putAll(CanonicalPath.SHORT_TYPE_NAMES);
        SHORT_TYPE_NAMES.put(Up.class, "..");
        for (Map.Entry<Class<?>, List<Class<?>>> e : CanonicalPath.VALID_PROGRESSIONS.entrySet()) {
            ArrayList<Class<Up>> andUp = new ArrayList<Class<Up>>((Collection)e.getValue());
            andUp.add(Up.class);
            andUp.trimToSize();
            VALID_PROGRESSIONS.put(e.getKey(), andUp);
        }
    }

    private static class RelativeTypeProvider
    extends Path.EnhancedTypeProvider {
        private final Path.TypeProvider wrapped;

        private RelativeTypeProvider(Path.TypeProvider wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void segmentParsed(Path.Segment segment) {
            if (this.wrapped != null) {
                this.wrapped.segmentParsed(segment);
            }
        }

        @Override
        public Path.Segment deduceSegment(String type, String id, boolean isLast) {
            if (type != null && !type.isEmpty()) {
                Class<?> cls = SHORT_NAME_TYPES.get(type);
                if (!Up.class.equals(cls) && (id == null || id.isEmpty())) {
                    return null;
                }
                if (id == null || id.isEmpty()) {
                    return new Path.Segment(cls, null);
                }
                if (Up.class.equals(cls)) {
                    throw new IllegalArgumentException("The \"up\" path segment cannot have an id.");
                }
                return new Path.Segment(cls, id);
            }
            if (id == null || id.isEmpty()) {
                return null;
            }
            Class<?> cls = SHORT_NAME_TYPES.get(id);
            if (cls == null && this.wrapped != null) {
                return this.wrapped.deduceSegment(type, id, isLast);
            }
            if (Up.class.equals(cls)) {
                return new Path.Segment(cls, null);
            }
            return null;
        }

        @Override
        public void finished() {
            if (this.wrapped != null) {
                this.wrapped.finished();
            }
        }

        @Override
        Set<String> getValidTypeName() {
            return SHORT_NAME_TYPES.keySet();
        }
    }

    public static class Extender
    extends Path.Extender {
        Extender(int from, List<Path.Segment> segments) {
            this(from, segments, segs -> {
                if (segs.isEmpty()) {
                    return ALL_VALID_TYPES;
                }
                Class<?> lastType = ((Path.Segment)segs.get(segs.size() - 1)).getElementType();
                int idx = segs.size() - 2;
                int jump = 1;
                while (Up.class.equals(lastType)) {
                    while (idx >= 0 && Up.class.equals(((Path.Segment)segs.get(idx)).getElementType())) {
                        --idx;
                        ++jump;
                    }
                    if ((idx -= jump) < 0) {
                        return ALL_VALID_TYPES;
                    }
                    if (idx < 0) continue;
                    lastType = ((Path.Segment)segs.get(idx)).getElementType();
                }
                return (List)VALID_PROGRESSIONS.get(lastType);
            });
        }

        Extender(int from, List<Path.Segment> segments, Function<List<Path.Segment>, List<Class<?>>> validProgressions) {
            super(from, segments, false, validProgressions);
        }

        @Override
        protected RelativePath newPath(int startIdx, int endIdx, List<Path.Segment> segments) {
            return new RelativePath(startIdx, endIdx, segments);
        }

        @Override
        public Extender extend(Path.Segment segment) {
            return (Extender)super.extend(segment);
        }

        @Override
        public Extender extend(Collection<Path.Segment> segments) {
            return (Extender)super.extend(segments);
        }

        @Override
        public Extender extend(Class<? extends AbstractElement<?, ?>> type, String id) {
            return (Extender)super.extend(type, id);
        }

        @Override
        public RelativePath get() {
            return (RelativePath)super.get();
        }
    }

    public static class UpBuilder
    extends Path.AbstractBuilder<RelativePath> {
        UpBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public TenantBuilder tenant(String id) {
            this.segments.add(new Path.Segment(Tenant.class, id));
            return new TenantBuilder(this.segments);
        }

        public EnvironmentBuilder environment(String id) {
            this.segments.add(new Path.Segment(Environment.class, id));
            return new EnvironmentBuilder(this.segments);
        }

        public ResourceTypeBuilder resourceType(String id) {
            this.segments.add(new Path.Segment(ResourceType.class, id));
            return new ResourceTypeBuilder(this.segments);
        }

        public MetricTypeBuilder metricType(String id) {
            this.segments.add(new Path.Segment(MetricType.class, id));
            return new MetricTypeBuilder(this.segments);
        }

        public FeedBuilder feed(String id) {
            this.segments.add(new Path.Segment(Feed.class, id));
            return new FeedBuilder(this.segments);
        }

        public ResourceBuilder resource(String id) {
            this.segments.add(new Path.Segment(Resource.class, id));
            return new ResourceBuilder(this.segments);
        }

        public MetricBuilder metric(String id) {
            this.segments.add(new Path.Segment(Metric.class, id));
            return new MetricBuilder(this.segments);
        }

        public StructuredDataBuilder dataEntity(DataEntity.Role role) {
            this.segments.add(new Path.Segment(DataEntity.class, role.name()));
            return new StructuredDataBuilder(this.segments);
        }

        public OperationTypeBuilder operationType(String id) {
            this.segments.add(new Path.Segment(OperationType.class, id));
            return new OperationTypeBuilder(this.segments);
        }

        public StructuredDataBuilder structuredData() {
            return new StructuredDataBuilder(this.segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return this;
        }

        @Override
        public RelativePath get() {
            return (RelativePath)super.get();
        }
    }

    public static final class StructuredDataBuilder
    extends Path.StructuredDataBuilder<RelativePath, StructuredDataBuilder> {
        private StructuredDataBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class RelationshipBuilder
    extends Path.RelationshipBuilder<RelativePath> {
        private RelationshipBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }
    }

    public static final class FeedBuilder
    extends Path.FeedBuilder<RelativePath, ResourceTypeBuilder, MetricTypeBuilder, ResourceBuilder, MetricBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private FeedBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> segments) {
            return new ResourceTypeBuilder((List)segments);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> segments) {
            return new MetricTypeBuilder((List)segments);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class MetricBuilder
    extends Path.MetricBuilder<RelativePath> {
        private MetricBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class ResourceBuilder
    extends Path.ResourceBuilder<RelativePath, ResourceBuilder, StructuredDataBuilder> {
        private ResourceBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class OperationTypeBuilder
    extends Path.OperationTypeBuilder<RelativePath, StructuredDataBuilder> {
        private OperationTypeBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class MetricTypeBuilder
    extends Path.MetricTypeBuilder<RelativePath> {
        private MetricTypeBuilder(List<Path.Segment> segments) {
            super(segments, RelativePath::new);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class ResourceTypeBuilder
    extends Path.ResourceTypeBuilder<RelativePath, OperationTypeBuilder, StructuredDataBuilder> {
        private ResourceTypeBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected OperationTypeBuilder operationTypeBuilder(List<Path.Segment> segments) {
            return new OperationTypeBuilder((List)segments);
        }

        @Override
        protected StructuredDataBuilder structuredDataBuilder(List<Path.Segment> segments) {
            return new StructuredDataBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class EnvironmentBuilder
    extends Path.EnvironmentBuilder<RelativePath, FeedBuilder, ResourceBuilder, MetricBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder> {
        private EnvironmentBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected FeedBuilder feedBuilder(List<Path.Segment> segments) {
            return new FeedBuilder((List)segments);
        }

        @Override
        protected ResourceBuilder resourceBuilder(List<Path.Segment> segments) {
            return new ResourceBuilder((List)segments);
        }

        @Override
        protected MetricBuilder metricBuilder(List<Path.Segment> segments) {
            return new MetricBuilder((List)segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class TenantBuilder
    extends Path.TenantBuilder<RelativePath, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, OperationTypeBuilder, StructuredDataBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private TenantBuilder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected EnvironmentBuilder environmentBuilder(List<Path.Segment> list) {
            return new EnvironmentBuilder((List)list);
        }

        @Override
        protected ResourceTypeBuilder resourceTypeBuilder(List<Path.Segment> list) {
            return new ResourceTypeBuilder((List)list);
        }

        @Override
        protected MetricTypeBuilder metricTypeBuilder(List<Path.Segment> list) {
            return new MetricTypeBuilder((List)list);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class Builder
    extends Path.Builder<RelativePath, TenantBuilder, EnvironmentBuilder, ResourceTypeBuilder, MetricTypeBuilder, RelationshipBuilder, OperationTypeBuilder, StructuredDataBuilder, FeedBuilder, ResourceBuilder, MetricBuilder> {
        private Builder(List<Path.Segment> list) {
            super(list, RelativePath::new);
        }

        @Override
        protected RelationshipBuilder relationshipBuilder(List<Path.Segment> list) {
            return new RelationshipBuilder((List)list);
        }

        @Override
        protected TenantBuilder tenantBuilder(List<Path.Segment> list) {
            return new TenantBuilder((List)list);
        }

        public EnvironmentBuilder environment(String id) {
            this.segments.add(new Path.Segment(Environment.class, id));
            return new EnvironmentBuilder(this.segments);
        }

        public ResourceTypeBuilder resourceType(String id) {
            this.segments.add(new Path.Segment(ResourceType.class, id));
            return new ResourceTypeBuilder(this.segments);
        }

        public MetricTypeBuilder metricType(String id) {
            this.segments.add(new Path.Segment(MetricType.class, id));
            return new MetricTypeBuilder(this.segments);
        }

        public FeedBuilder feed(String id) {
            this.segments.add(new Path.Segment(Feed.class, id));
            return new FeedBuilder(this.segments);
        }

        public ResourceBuilder resource(String id) {
            this.segments.add(new Path.Segment(Resource.class, id));
            return new ResourceBuilder(this.segments);
        }

        public MetricBuilder metric(String id) {
            this.segments.add(new Path.Segment(Metric.class, id));
            return new MetricBuilder(this.segments);
        }

        public StructuredDataBuilder dataEntity(DataEntity.Role role) {
            this.segments.add(new Path.Segment(DataEntity.class, role.name()));
            return new StructuredDataBuilder(this.segments);
        }

        public OperationTypeBuilder operationType(String id) {
            this.segments.add(new Path.Segment(OperationType.class, id));
            return new OperationTypeBuilder(this.segments);
        }

        public StructuredDataBuilder structuredData() {
            return new StructuredDataBuilder(this.segments);
        }

        public UpBuilder up() {
            this.segments.add(new Path.Segment(Up.class, null));
            return new UpBuilder(this.segments);
        }
    }

    public static final class Up {
        private Up() {
        }
    }
}

