/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;

public final class BaseOperationTypes {
    private BaseOperationTypes() {
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.Multiple {
        public Multiple(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.Read<OperationTypes.DataRole> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get());
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.Single {
        public Single(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public Data.ReadWrite<OperationTypes.DataRole> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get());
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, OperationType, OperationType.Update>
    implements OperationTypes.ReadContained {
        public ReadContained(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, OperationType, OperationType.Blueprint, OperationType.Update, String>
    implements OperationTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, OperationType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(OperationType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<OperationType> wireUpNewEntity(BE entity, OperationType.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            return new EntityAndPendingNotifications<OperationType>(new OperationType(parentPath.extend(OperationType.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new Notification[0]);
        }

        @Override
        public OperationTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public OperationTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public OperationTypes.Single create(OperationType.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.replacePath(this.doCreate(blueprint)));
        }
    }
}

