/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class StructuredData {
    private final Serializable value;

    public static Builder get() {
        return new Builder();
    }

    private StructuredData(Serializable value) {
        this.value = value;
    }

    public Serializable getValue() {
        return this.value;
    }

    public boolean isUndefined() {
        return this.value == null;
    }

    public <R, P> R accept(Visitor<R, P> visitor, P parameter) {
        if (this.value == null) {
            return visitor.visitUndefined(parameter);
        }
        if (this.value instanceof List) {
            return visitor.visitList((List)((Object)this.value), parameter);
        }
        if (this.value instanceof Map) {
            return visitor.visitMap((Map)((Object)this.value), parameter);
        }
        if (this.value instanceof Boolean) {
            return visitor.visitBool((Boolean)this.value, parameter);
        }
        if (this.value instanceof Long) {
            return visitor.visitIntegral((Long)this.value, parameter);
        }
        if (this.value instanceof Double) {
            return visitor.visitFloatingPoint((Double)this.value, parameter);
        }
        if (this.value instanceof String) {
            return visitor.visitString((String)((Object)this.value), parameter);
        }
        return visitor.visitUnknown(this.value, parameter);
    }

    public boolean bool() {
        return (Boolean)this.value;
    }

    public long integral() {
        return (Long)this.value;
    }

    public double floatingPoint() {
        return (Double)this.value;
    }

    public String string() {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return (String)((Object)this.value);
    }

    public List<StructuredData> list() {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return (List)((Object)this.value);
    }

    public Map<String, StructuredData> map() {
        if (this.value == null) {
            throw new NullPointerException();
        }
        return (Map)((Object)this.value);
    }

    public Type getType() {
        return this.accept(new Visitor<Type, Void>(){

            @Override
            public Type visitBool(boolean value, Void parameter) {
                return Type.bool;
            }

            @Override
            public Type visitIntegral(long value, Void parameter) {
                return Type.integral;
            }

            @Override
            public Type visitFloatingPoint(double value, Void parameter) {
                return Type.floatingPoint;
            }

            @Override
            public Type visitString(String value, Void parameter) {
                return Type.string;
            }

            @Override
            public Type visitUndefined(Void parameter) {
                return Type.undefined;
            }

            @Override
            public Type visitList(List<StructuredData> value, Void parameter) {
                return Type.list;
            }

            @Override
            public Type visitMap(Map<String, StructuredData> value, Void parameter) {
                return Type.map;
            }

            @Override
            public Type visitUnknown(Serializable value, Void parameter) {
                throw new AssertionError((Object)("Inconsistent StructuredData implementation - cannot determine type of value: " + value));
            }
        }, null);
    }

    public Updater update() {
        return new Updater(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructuredData)) {
            return false;
        }
        StructuredData that = (StructuredData)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        if (this.value == null) {
            return "undefined";
        }
        return this.value.toString();
    }

    public static final class InnerMapUpdater<Parent extends AbstractHierarchyBuilder>
    extends AbstractMapUpdater<InnerMapUpdater<Parent>> {
        private final Parent parent;
        private final Object context;

        public InnerMapUpdater(LinkedHashMap<String, StructuredData> map, Parent parent, Object context) {
            super(map);
            this.parent = parent;
            this.context = context;
        }

        public Parent closeMap() {
            ((AbstractHierarchyBuilder)this.parent).apply(this.context, new StructuredData((Serializable)((Object)Collections.unmodifiableMap(this.map))));
            return this.parent;
        }
    }

    public static final class InnerListUpdater<Parent extends AbstractHierarchyBuilder>
    extends AbstractListUpdater<InnerListUpdater<Parent>> {
        private final Parent parent;
        private final Object context;

        public InnerListUpdater(ArrayList<StructuredData> list, Parent parent, Object context) {
            super(list);
            this.parent = parent;
            this.context = context;
        }

        public Parent closeList() {
            ((AbstractHierarchyBuilder)this.parent).apply(this.context, new StructuredData((Serializable)((Object)Collections.unmodifiableList(this.list))));
            return this.parent;
        }
    }

    public static final class MapUpdater
    extends AbstractMapUpdater<MapUpdater> {
        public MapUpdater(LinkedHashMap<String, StructuredData> map) {
            super(map);
        }

        public StructuredData build() {
            return new StructuredData((Serializable)((Object)Collections.unmodifiableMap(this.map)));
        }
    }

    public static final class ListUpdater
    extends AbstractListUpdater<ListUpdater> {
        public ListUpdater(ArrayList<StructuredData> list) {
            super(list);
        }

        public StructuredData build() {
            return new StructuredData((Serializable)((Object)Collections.unmodifiableList(this.list)));
        }
    }

    private static abstract class AbstractMapUpdater<This extends AbstractMapUpdater<This>>
    extends AbstractHierarchyBuilder {
        protected final LinkedHashMap<String, StructuredData> map;

        private AbstractMapUpdater(LinkedHashMap<String, StructuredData> map) {
            this.map = map;
        }

        public This clear() {
            this.map.clear();
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This remove(String key) {
            this.map.remove(key);
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This putBool(String key, boolean value) {
            this.map.put(key, new StructuredData(Boolean.valueOf(value)));
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This putIntegral(String key, long value) {
            this.map.put(key, new StructuredData(Long.valueOf(value)));
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This putFloatingPoint(String key, double value) {
            this.map.put(key, new StructuredData(Double.valueOf(value)));
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This putString(String key, String value) {
            this.map.put(key, new StructuredData((Serializable)((Object)value)));
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public This putUndefined(String key) {
            this.map.put(key, new StructuredData(null));
            return (This)((AbstractMapUpdater)this.castThis());
        }

        public InnerListUpdater<This> updateList(String key) {
            ArrayList<StructuredData> list = this.map.get(key).value instanceof List ? new ArrayList<StructuredData>((List)((Object)this.map.get(key).value)) : new ArrayList();
            return new InnerListUpdater<AbstractHierarchyBuilder>(list, (AbstractHierarchyBuilder)this.castThis(), key);
        }

        public InnerMapUpdater<This> updateMap(String key) {
            LinkedHashMap map = null != this.map.get(key) && this.map.get(key).value instanceof Map ? new LinkedHashMap((Map)((Object)this.map.get(key).value)) : new LinkedHashMap();
            return new InnerMapUpdater<AbstractHierarchyBuilder>(map, (AbstractHierarchyBuilder)this.castThis(), key);
        }

        @Override
        protected void apply(Object context, StructuredData value) {
            this.map.put((String)context, value);
        }
    }

    public static abstract class AbstractListUpdater<This extends AbstractListUpdater<This>>
    extends AbstractHierarchyBuilder {
        protected final ArrayList<StructuredData> list;

        private AbstractListUpdater(ArrayList<StructuredData> list) {
            this.list = list;
        }

        public This clear() {
            this.list.clear();
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This remove(int index) {
            this.list.remove(index);
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This addBool(boolean value) {
            this.list.add(new StructuredData(Boolean.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This setBool(int index, boolean value) {
            this.list.set(index, new StructuredData(Boolean.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This addIntegral(long value) {
            this.list.add(new StructuredData(Long.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This setIntegral(int index, long value) {
            this.list.set(index, new StructuredData(Long.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This addFloatingPoint(double value) {
            this.list.add(new StructuredData(Double.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This setFloatingPoint(int index, double value) {
            this.list.set(index, new StructuredData(Double.valueOf(value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This addString(String value) {
            this.list.add(new StructuredData((Serializable)((Object)value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This setString(int index, String value) {
            this.list.set(index, new StructuredData((Serializable)((Object)value)));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This addUndefined() {
            this.list.add(new StructuredData(null));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public This setUndefined(int index) {
            this.list.set(index, new StructuredData(null));
            return (This)((AbstractListUpdater)this.castThis());
        }

        public InnerListUpdater<This> addList() {
            return new InnerListUpdater<AbstractHierarchyBuilder>(new ArrayList<StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), null);
        }

        public InnerListUpdater<This> updateList(int index) {
            ArrayList<StructuredData> list = this.list.get(index).value instanceof List ? new ArrayList<StructuredData>((List)((Object)this.list.get(index).value)) : new ArrayList();
            return new InnerListUpdater<AbstractHierarchyBuilder>(list, (AbstractHierarchyBuilder)this.castThis(), index);
        }

        public InnerMapUpdater<This> addMap() {
            return new InnerMapUpdater<AbstractHierarchyBuilder>(new LinkedHashMap<String, StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), null);
        }

        public InnerMapUpdater<This> updateMap(int index) {
            LinkedHashMap<String, StructuredData> map = this.list.get(index).value instanceof Map ? new LinkedHashMap<String, StructuredData>((Map)((Object)this.list.get(index).value)) : new LinkedHashMap();
            return new InnerMapUpdater<AbstractHierarchyBuilder>(map, (AbstractHierarchyBuilder)this.castThis(), index);
        }

        @Override
        protected void apply(Object context, StructuredData value) {
            Integer ctx = (Integer)context;
            if (ctx == null) {
                this.list.add(value);
            } else {
                this.list.set(ctx, value);
            }
        }
    }

    public static final class Updater {
        private final Serializable origValue;

        private Updater(Serializable origValue) {
            this.origValue = origValue;
        }

        public StructuredData toBool(boolean value) {
            return new StructuredData(Boolean.valueOf(value));
        }

        public StructuredData toIntegral(long value) {
            return new StructuredData(Long.valueOf(value));
        }

        public StructuredData toFloatingPoint(double value) {
            return new StructuredData(Double.valueOf(value));
        }

        public StructuredData toString(String value) {
            return new StructuredData((Serializable)((Object)value));
        }

        public StructuredData toUndefined() {
            return new StructuredData(null);
        }

        public ListUpdater toList() {
            if (this.origValue instanceof List) {
                return new ListUpdater(new ArrayList<StructuredData>((List)((Object)this.origValue)));
            }
            return new ListUpdater(new ArrayList<StructuredData>());
        }

        public MapUpdater toMap() {
            if (this.origValue instanceof Map) {
                return new MapUpdater(new LinkedHashMap<String, StructuredData>((Map)((Object)this.origValue)));
            }
            return new MapUpdater(new LinkedHashMap<String, StructuredData>());
        }
    }

    public static final class InnerMapBuilder<Parent extends AbstractHierarchyBuilder>
    extends AbstractMapBuilder<InnerMapBuilder<Parent>> {
        private final Parent parentBuilder;
        private final Object parentContext;

        InnerMapBuilder(LinkedHashMap<String, StructuredData> map, Parent parentBuilder, Object parentContext) {
            super(map);
            this.parentBuilder = parentBuilder;
            this.parentContext = parentContext;
        }

        public Parent closeMap() {
            ((AbstractHierarchyBuilder)this.parentBuilder).apply(this.parentContext, new StructuredData((Serializable)((Object)Collections.unmodifiableMap(this.map))));
            return this.parentBuilder;
        }
    }

    public static abstract class AbstractMapBuilder<This extends AbstractMapBuilder<This>>
    extends AbstractHierarchyBuilder {
        protected final LinkedHashMap<String, StructuredData> map;

        AbstractMapBuilder(LinkedHashMap<String, StructuredData> map) {
            this.map = map;
        }

        public This putBool(String key, boolean value) {
            this.map.put(key, new StructuredData(Boolean.valueOf(value)));
            return (This)((AbstractMapBuilder)this.castThis());
        }

        public This putIntegral(String key, long value) {
            this.map.put(key, new StructuredData(Long.valueOf(value)));
            return (This)((AbstractMapBuilder)this.castThis());
        }

        public This putFloatingPoint(String key, double value) {
            this.map.put(key, new StructuredData(Double.valueOf(value)));
            return (This)((AbstractMapBuilder)this.castThis());
        }

        public This putString(String key, String value) {
            this.map.put(key, new StructuredData((Serializable)((Object)value)));
            return (This)((AbstractMapBuilder)this.castThis());
        }

        public This putUndefined(String key) {
            this.map.put(key, new StructuredData(null));
            return (This)((AbstractMapBuilder)this.castThis());
        }

        public InnerListBuilder<This> putList(String key) {
            return new InnerListBuilder<AbstractHierarchyBuilder>(new ArrayList<StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), key);
        }

        public InnerMapBuilder<This> putMap(String key) {
            return new InnerMapBuilder<AbstractHierarchyBuilder>(new LinkedHashMap<String, StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), key);
        }

        @Override
        protected void apply(Object context, StructuredData value) {
            this.map.put((String)context, value);
        }
    }

    public static final class InnerListBuilder<Parent extends AbstractHierarchyBuilder>
    extends AbstractListBuilder<InnerListBuilder<Parent>> {
        private final Parent parentBuilder;
        private final Object parentContext;

        InnerListBuilder(ArrayList<StructuredData> list, Parent parentBuilder, Object parentContext) {
            super(list);
            this.parentBuilder = parentBuilder;
            this.parentContext = parentContext;
        }

        public Parent closeList() {
            ((AbstractHierarchyBuilder)this.parentBuilder).apply(this.parentContext, new StructuredData((Serializable)((Object)Collections.unmodifiableList(this.list))));
            return this.parentBuilder;
        }
    }

    public static abstract class AbstractListBuilder<This extends AbstractListBuilder<This>>
    extends AbstractHierarchyBuilder {
        protected final ArrayList<StructuredData> list;

        AbstractListBuilder(ArrayList<StructuredData> list) {
            this.list = list;
        }

        public This addBool(boolean value) {
            this.list.add(new StructuredData(Boolean.valueOf(value)));
            return (This)((AbstractListBuilder)this.castThis());
        }

        public This addIntegral(long value) {
            this.list.add(new StructuredData(Long.valueOf(value)));
            return (This)((AbstractListBuilder)this.castThis());
        }

        public This addFloatingPoint(double value) {
            this.list.add(new StructuredData(Double.valueOf(value)));
            return (This)((AbstractListBuilder)this.castThis());
        }

        public This addString(String value) {
            this.list.add(new StructuredData((Serializable)((Object)value)));
            return (This)((AbstractListBuilder)this.castThis());
        }

        public This addUndefined() {
            this.list.add(new StructuredData(null));
            return (This)((AbstractListBuilder)this.castThis());
        }

        public InnerListBuilder<This> addList() {
            return new InnerListBuilder<AbstractHierarchyBuilder>(new ArrayList<StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), null);
        }

        public InnerMapBuilder<This> addMap() {
            return new InnerMapBuilder<AbstractHierarchyBuilder>(new LinkedHashMap<String, StructuredData>(), (AbstractHierarchyBuilder)this.castThis(), null);
        }

        @Override
        protected void apply(Object context, StructuredData value) {
            this.list.add(value);
        }
    }

    public static abstract class AbstractHierarchyBuilder {
        protected abstract void apply(Object var1, StructuredData var2);

        protected <T> T castThis() {
            return (T)this;
        }
    }

    public static final class MapBuilder
    extends AbstractMapBuilder<MapBuilder> {
        public MapBuilder() {
            super(new LinkedHashMap<String, StructuredData>());
        }

        public StructuredData build() {
            return new StructuredData(this.map);
        }
    }

    public static final class ListBuilder
    extends AbstractListBuilder<ListBuilder> {
        public ListBuilder() {
            super(new ArrayList<StructuredData>());
        }

        public StructuredData build() {
            return new StructuredData(this.list);
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public StructuredData bool(Boolean value) {
            return new StructuredData(value);
        }

        public StructuredData integral(Long value) {
            return new StructuredData(value);
        }

        public StructuredData floatingPoint(Double value) {
            return new StructuredData(value);
        }

        public StructuredData string(String value) {
            return new StructuredData((Serializable)((Object)value));
        }

        public StructuredData undefined() {
            return new StructuredData(null);
        }

        public ListBuilder list() {
            return new ListBuilder();
        }

        public MapBuilder map() {
            return new MapBuilder();
        }
    }

    private static class VisitorSpecialization<R, P, T>
    extends Visitor.Simple<R, P> {
        private final Class<?> expectedType;
        private final BiFunction<T, P, R> handler;

        VisitorSpecialization(Class<?> expectedType, BiFunction<T, P, R> handler) {
            this.expectedType = expectedType;
            this.handler = handler;
        }

        @Override
        protected R defaultAction(Serializable value, P parameter) {
            if (value == null && this.expectedType != Void.class) {
                throw new IllegalArgumentException("Expected a value of type " + this.expectedType.getSimpleName() + " but got undefined");
            }
            if (value != null && !this.expectedType.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException("Expected a value of type " + this.expectedType.getSimpleName() + " but got " + value.getClass().getSimpleName());
            }
            return this.handler.apply(value, parameter);
        }
    }

    public static interface Visitor<R, P> {
        public static <R, P> Visitor<R, P> bool(BiFunction<Boolean, P, R> handler) {
            return new VisitorSpecialization<R, P, Boolean>(Boolean.class, handler);
        }

        public static <R, P> Visitor<R, P> integral(BiFunction<Long, P, R> handler) {
            return new VisitorSpecialization<R, P, Long>(Long.class, handler);
        }

        public static <R, P> Visitor<R, P> floatingPoint(BiFunction<Double, P, R> handler) {
            return new VisitorSpecialization<R, P, Double>(Double.class, handler);
        }

        public static <R, P> Visitor<R, P> string(BiFunction<String, P, R> handler) {
            return new VisitorSpecialization<R, P, String>(String.class, handler);
        }

        public static <R, P> Visitor<R, P> undefined(Function<P, R> handler) {
            return new VisitorSpecialization<Object, Object, Object>(Void.class, (v, p) -> handler.apply(p));
        }

        public static <R, P> Visitor<R, P> list(BiFunction<List<StructuredData>, P, R> handler) {
            return new VisitorSpecialization<R, P, List<StructuredData>>(List.class, handler);
        }

        public static <R, P> Visitor<R, P> map(BiFunction<Map<String, StructuredData>, P, R> handler) {
            return new VisitorSpecialization<R, P, Map<String, StructuredData>>(Map.class, handler);
        }

        public R visitBool(boolean var1, P var2);

        public R visitIntegral(long var1, P var3);

        public R visitFloatingPoint(double var1, P var3);

        public R visitString(String var1, P var2);

        public R visitUndefined(P var1);

        public R visitList(List<StructuredData> var1, P var2);

        public R visitMap(Map<String, StructuredData> var1, P var2);

        public R visitUnknown(Serializable var1, P var2);

        public static class Simple<R, P>
        implements Visitor<R, P> {
            protected R defaultAction(Serializable value, P parameter) {
                return null;
            }

            @Override
            public R visitBool(boolean value, P parameter) {
                return this.defaultAction(Boolean.valueOf(value), parameter);
            }

            @Override
            public R visitIntegral(long value, P parameter) {
                return this.defaultAction(Long.valueOf(value), parameter);
            }

            @Override
            public R visitFloatingPoint(double value, P parameter) {
                return this.defaultAction(Double.valueOf(value), parameter);
            }

            @Override
            public R visitString(String value, P parameter) {
                return this.defaultAction((Serializable)((Object)value), parameter);
            }

            @Override
            public R visitUndefined(P parameter) {
                return this.defaultAction(null, parameter);
            }

            @Override
            public R visitUnknown(Serializable value, P parameter) {
                return this.defaultAction(value, parameter);
            }

            @Override
            public R visitList(List<StructuredData> value, P parameter) {
                return this.defaultAction((Serializable)((Object)value), parameter);
            }

            @Override
            public R visitMap(Map<String, StructuredData> value, P parameter) {
                return this.defaultAction((Serializable)((Object)value), parameter);
            }
        }
    }

    public static enum Type {
        bool,
        integral,
        floatingPoint,
        string,
        undefined,
        list,
        map;

    }
}

