/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.base.FilterFragment;
import org.hawkular.inventory.base.PathFragment;
import org.hawkular.inventory.base.QueryFragment;

final class QueryOptimizer {
    private QueryOptimizer() {
    }

    public static void appendOptimized(List<QueryFragment> fragments, QueryFragment ... filters) {
        List<CanonicalPath.Extender> checkers;
        List<QueryFragment> applicableNewFilters = fragments.isEmpty() ? new ArrayList<QueryFragment>(Arrays.asList(filters)) : QueryOptimizer.removeDuplicates(fragments.get(fragments.size() - 1).getFilter(), new ArrayList<QueryFragment>(Arrays.asList(filters)));
        QueryOptimizer.cleanUnnecessaryNoops(applicableNewFilters);
        QueryFragment cpFilter = QueryOptimizer.findLastCanonicalFilterAndPrepareNewFilters(fragments, applicableNewFilters);
        if (cpFilter == null) {
            checkers = Collections.singletonList(CanonicalPath.empty());
        } else {
            With.CanonicalPaths cps = (With.CanonicalPaths)cpFilter.getFilter();
            checkers = Arrays.asList(cps.getPaths()).stream().map(CanonicalPath::modified).collect(Collectors.toList());
        }
        while (!applicableNewFilters.isEmpty()) {
            With.Ids idFilter;
            With.Types typeFilter;
            QueryFragment third;
            QueryFragment second;
            boolean isPath = applicableNewFilters.get(0) instanceof PathFragment;
            QueryFragment first = QueryOptimizer.removeOrReadd(applicableNewFilters, null, null);
            if (first == null || (second = QueryOptimizer.removeOrReadd(applicableNewFilters, first, null)) == null) break;
            QueryFragment queryFragment = third = applicableNewFilters.isEmpty() ? null : applicableNewFilters.remove(0);
            if (cpFilter != null && first.getClass() != cpFilter.getClass()) {
                QueryOptimizer.reAddNonNull(false, fragments, first);
                QueryOptimizer.reAddNonNull(true, applicableNewFilters, second, third);
                checkers = Collections.singletonList(CanonicalPath.empty());
                cpFilter = null;
                continue;
            }
            if (cpFilter == null) {
                typeFilter = QueryOptimizer.choose(With.Types.class, first, second);
                idFilter = QueryOptimizer.choose(With.Ids.class, first, second);
                if (!(third == null || QueryOptimizer.isOutgoingContains(third.getFilter()) && second.getClass() == third.getClass())) {
                    QueryOptimizer.reAddNonNull(true, applicableNewFilters, third);
                }
            } else {
                if (!QueryOptimizer.isOutgoingContains(first.getFilter())) {
                    QueryOptimizer.reAddNonNull(false, fragments, first);
                    QueryOptimizer.reAddNonNull(true, applicableNewFilters, second, third);
                    checkers = Collections.singletonList(CanonicalPath.empty());
                    cpFilter = null;
                    continue;
                }
                typeFilter = QueryOptimizer.choose(With.Types.class, second, third);
                idFilter = QueryOptimizer.choose(With.Ids.class, second, third);
            }
            if (typeFilter == null || idFilter == null) {
                QueryOptimizer.reAddNonNull(false, fragments, first, second, third);
                checkers = Collections.singletonList(CanonicalPath.empty());
                cpFilter = null;
                continue;
            }
            if (typeFilter.getTypes().length != idFilter.getIds().length) {
                QueryOptimizer.reAddNonNull(false, fragments, first, second, third);
                checkers = Collections.singletonList(CanonicalPath.empty());
                cpFilter = null;
                continue;
            }
            boolean checkFailed = false;
            block1: for (CanonicalPath.Extender checker : checkers) {
                for (int n = 0; n < typeFilter.getTypes().length; ++n) {
                    Path.Segment seg = new Path.Segment(typeFilter.getTypes()[n], idFilter.getIds()[n]);
                    if (!checker.canExtendTo(seg)) {
                        if (cpFilter == null) {
                            QueryOptimizer.reAddNonNull(false, fragments, first, second, third);
                        } else {
                            QueryOptimizer.reAddNonNull(false, fragments, first);
                            QueryOptimizer.reAddNonNull(true, applicableNewFilters, second, third);
                            checkers = Collections.singletonList(CanonicalPath.empty());
                            cpFilter = null;
                        }
                        checkFailed = true;
                        break block1;
                    }
                    checker.extend(seg);
                }
            }
            if (checkFailed) continue;
            if (!fragments.isEmpty() && fragments.get(fragments.size() - 1).getFilter() instanceof With.CanonicalPaths) {
                fragments.remove(fragments.size() - 1);
            }
            CanonicalPath[] newPaths = (CanonicalPath[])checkers.stream().map(CanonicalPath.Extender::get).toArray(CanonicalPath[]::new);
            QueryFragment related = cpFilter == null ? third : null;
            cpFilter = isPath ? new PathFragment(With.paths(newPaths)) : new FilterFragment(With.paths(newPaths));
            fragments.add(cpFilter);
            if (related == null) continue;
            QueryOptimizer.reAddNonNull(true, applicableNewFilters, related);
        }
        fragments.addAll(applicableNewFilters);
    }

    private static void cleanUnnecessaryNoops(List<QueryFragment> filters) {
    }

    private static <T> void reAddNonNull(boolean atBeginning, List<T> list, T ... objs) {
        int pos = atBeginning ? 0 : list.size();
        for (int i = objs.length - 1; i >= 0; --i) {
            T o = objs[i];
            if (o == null) continue;
            list.add(pos, o);
        }
    }

    private static QueryFragment removeOrReadd(List<QueryFragment> fragments, QueryFragment first, QueryFragment second) {
        if (fragments.isEmpty()) {
            QueryOptimizer.addIfNotNull(fragments, first);
            QueryOptimizer.addIfNotNull(fragments, second);
            return null;
        }
        return fragments.remove(0);
    }

    private static <T> void addIfNotNull(Collection<T> col, T el) {
        if (el != null) {
            col.add(el);
        }
    }

    private static <T extends Filter> T choose(Class<T> type, QueryFragment ... objects) {
        for (QueryFragment o : objects) {
            if (o == null || !type.equals(o.getFilter().getClass())) continue;
            return (T)((Filter)type.cast(o.getFilter()));
        }
        return null;
    }

    private static boolean isOutgoingContains(Filter f) {
        if (!(f instanceof Related)) {
            return false;
        }
        Related rel = (Related)f;
        return rel.getEntityRole() == Related.EntityRole.SOURCE && Relationships.WellKnown.contains.name().equals(rel.getRelationshipName());
    }

    private static QueryFragment findLastCanonicalFilterAndPrepareNewFilters(List<QueryFragment> fragments, List<QueryFragment> newFilters) {
        if (fragments.isEmpty()) {
            return null;
        }
        Filter last = fragments.get(fragments.size() - 1).getFilter();
        QueryFragment ret = null;
        if (last instanceof With.CanonicalPaths) {
            HashSet<String> filterIds;
            HashSet filterTypes;
            QueryFragment f;
            ret = fragments.get(fragments.size() - 1);
            CanonicalPath[] sources = ((With.CanonicalPaths)last).getPaths();
            Set expectedClasses = Arrays.asList(sources).stream().map(s -> s.getSegment().getElementType()).collect(Collectors.toSet());
            Set expectedIds = Arrays.asList(sources).stream().map(s -> s.getSegment().getElementId()).collect(Collectors.toSet());
            Iterator<QueryFragment> it = newFilters.iterator();
            while (it.hasNext() && !((f = it.next()).getFilter() instanceof With.Types ? !expectedClasses.equals(filterTypes = new HashSet(Arrays.asList(((With.Types)f.getFilter()).getTypes()))) : !(f.getFilter() instanceof With.Ids) || !expectedIds.equals(filterIds = new HashSet<String>(Arrays.asList(((With.Ids)f.getFilter()).getIds()))))) {
                it.remove();
            }
        } else if (fragments.size() > 1) {
            Filter thirdLast;
            Filter secondLast = fragments.get(fragments.size() - 2).getFilter();
            Filter filter = thirdLast = fragments.size() > 2 ? fragments.get(fragments.size() - 3).getFilter() : null;
            if (secondLast instanceof With.CanonicalPaths && last instanceof Related) {
                Related rel = (Related)last;
                if (Relationships.WellKnown.contains.name().equals(rel.getRelationshipName())) {
                    ret = fragments.get(fragments.size() - 2);
                    newFilters.add(0, fragments.remove(fragments.size() - 1));
                }
            } else if (thirdLast instanceof With.CanonicalPaths && secondLast instanceof Related && (last instanceof With.Types || last instanceof With.Ids)) {
                Related rel = (Related)secondLast;
                if (Relationships.WellKnown.contains.name().equals(rel.getRelationshipName())) {
                    ret = fragments.get(fragments.size() - 3);
                    newFilters.add(0, fragments.remove(fragments.size() - 1));
                    newFilters.add(0, fragments.remove(fragments.size() - 1));
                } else {
                    newFilters.add(0, fragments.remove(fragments.size() - 1));
                }
            } else if (!newFilters.isEmpty() && (last instanceof With.Types && newFilters.get(0).getFilter() instanceof With.Ids || last instanceof With.Ids && newFilters.get(0).getFilter() instanceof With.Types)) {
                newFilters.add(0, fragments.remove(fragments.size() - 1));
            }
        } else if (!newFilters.isEmpty() && (last instanceof With.Types && newFilters.get(0).getFilter() instanceof With.Ids || last instanceof With.Ids && newFilters.get(0).getFilter() instanceof With.Types)) {
            newFilters.add(0, fragments.remove(fragments.size() - 1));
        }
        return ret;
    }

    private static List<QueryFragment> removeDuplicates(Filter original, List<QueryFragment> filters) {
        int i;
        List<QueryFragment> ret = filters;
        for (i = 0; i < filters.size() && original.equals(filters.get(i).getFilter()); ++i) {
        }
        if (i > 0) {
            ret = ret.subList(i, ret.size());
        }
        return ret;
    }
}

