/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

class Associator<BE, E extends Entity<?, ?>>
extends Traversal<BE, E> {
    private final Relationships.WellKnown relationship;
    private final Class<? extends Entity<?, ?>> sourceEntityType;

    protected Associator(TraversalContext<BE, E> context, Relationships.WellKnown relationship, Class<? extends Entity<?, ?>> sourceEntityType) {
        super(context);
        this.relationship = relationship;
        this.sourceEntityType = sourceEntityType;
    }

    public Relationship associate(Path id) throws EntityNotFoundException, RelationAlreadyExistsException {
        this.checkPathLegal(id);
        Object target = Util.find(this.context, id);
        return this.createAssociation(this.sourceEntityType, this.relationship, target);
    }

    public Relationship disassociate(Path id) throws EntityNotFoundException {
        this.checkPathLegal(id);
        Object target = Util.find(this.context, id);
        return this.deleteAssociation(this.sourceEntityType, this.relationship, target);
    }

    public Relationship associationWith(Path path) throws RelationNotFoundException {
        return this.getAssociation(this.sourceEntityType, path, this.relationship);
    }

    protected void checkPathLegal(Path targetPath) {
        if (!this.context.entityClass.equals(targetPath.getSegment().getElementType())) {
            throw new IllegalArgumentException("Current position in the inventory traversal expects entities of type " + this.context.entityClass.getSimpleName() + " which is incompatible with the provided path: " + targetPath);
        }
    }

    protected Relationship createAssociation(Class<? extends Entity<?, ?>> sourceType, Relationships.WellKnown relationship, BE target) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        EntityAndPendingNotifications<Relationship> rel = Util.createAssociation(this.context, sourceQuery, sourceType, relationship.name(), target);
        this.context.notifyAll(rel);
        return rel.getEntity();
    }

    protected Relationship deleteAssociation(Class<? extends Entity<?, ?>> sourceType, Relationships.WellKnown relationship, BE target) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        EntityAndPendingNotifications<Relationship> rel = Util.deleteAssociation(this.context, sourceQuery, sourceType, relationship.name(), target);
        this.context.notifyAll(rel);
        return rel.getEntity();
    }

    protected Relationship getAssociation(Class<? extends Entity<?, ?>> sourceType, Path targetPath, Relationships.WellKnown rel) {
        Query sourceQuery = this.context.sourcePath.extend().filter().with(With.type(sourceType)).get();
        Query targetQuery = Util.queryTo(this.context, targetPath);
        Class<?> targetType = targetPath.getSegment().getElementType();
        return Util.getAssociation(this.context, sourceQuery, sourceType, targetQuery, targetType, rel.name());
    }
}

