/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.FeedAlreadyRegisteredException;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.IdentityHash;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.ValidationException;
import org.hawkular.inventory.api.feeds.AcceptWithFallbackFeedIdStrategy;
import org.hawkular.inventory.api.feeds.RandomUUIDFeedIdStrategy;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.PathFragment;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.QueryFragment;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import rx.Subscription;

public abstract class AbstractBaseInventoryPersistenceCheck<E> {
    protected BaseInventory<E> inventory;

    protected abstract BaseInventory<E> instantiateNewInventory();

    protected abstract void destroyStorage() throws Exception;

    @Before
    public void setup() throws Exception {
        Properties ps = new Properties();
        try (FileInputStream f = new FileInputStream(System.getProperty("graph.config"));){
            ps.load(f);
        }
        Configuration config = Configuration.builder().withFeedIdStrategy((FeedIdStrategy)new AcceptWithFallbackFeedIdStrategy((FeedIdStrategy)new RandomUUIDFeedIdStrategy())).withConfiguration(ps).build();
        this.inventory = this.instantiateNewInventory();
        this.inventory.initialize(config);
        try {
            this.inventory.tenants().delete((Object)"com.acme.tenant");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inventory.tenants().delete((Object)"com.example.tenant");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.inventory.tenants().delete((Object)"perf0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setupData();
    }

    private void setupData() throws Exception {
        assert (((Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("com.acme.tenant")).withProperty("kachny", (Object)"moc")).build())).entity()).getId().equals("com.acme.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)new Environment.Blueprint("production"))).entity()).getId().equals("production"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).create((Blueprint)new ResourceType.Blueprint("URL"))).entity()).getId().equals("URL"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessMetricTypes()).create((Blueprint)new MetricType.Blueprint("ResponseTime", MetricUnit.MILLISECONDS, MetricDataType.COUNTER, Long.valueOf(0L)))).entity()).getId().equals("ResponseTime"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"URL")).metricTypes()).associate(((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).metricType("ResponseTime")).get());
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessMetrics()).create((Blueprint)new Metric.Blueprint("/ResponseTime", "host1_ping_response"))).entity()).getId().equals("host1_ping_response"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessResources()).create((Blueprint)new Resource.Blueprint("host1", "/URL"))).entity()).getId().equals("host1"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessResources()).get((Object)"host1")).metrics()).associate((Path)RelativePath.fromString((String)"../m;host1_ping_response"));
        assert (((Feed)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).create(new Feed.Blueprint("feed1", null)).entity()).getId().equals("feed1"));
        ((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feeds()).associate((Path)RelativePath.fromString((String)"../f;feed1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource1", "/URL"))).entity()).getId().equals("feedResource1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource2", "/URL"))).entity()).getId().equals("feedResource2"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource3", "/URL"))).entity()).getId().equals("feedResource3"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metrics()).create((Blueprint)new Metric.Blueprint("/ResponseTime", "feedMetric1"))).entity()).getId().equals("feedMetric1"));
        assert (((Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)new Tenant.Blueprint("com.example.tenant"))).entity()).getId().equals("com.example.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).create((Blueprint)new Environment.Blueprint("test"))).entity()).getId().equals("test"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).create((Blueprint)new ResourceType.Blueprint("Kachna"))).entity()).getId().equals("Kachna"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).create((Blueprint)new ResourceType.Blueprint("Playroom", (Map)new HashMap<String, Object>(){
            {
                this.put("ownedByDepartment", "Facilities");
            }
        }))).entity()).getId().equals("Playroom"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessMetricTypes()).create((Blueprint)new MetricType.Blueprint("Size", MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)))).entity()).getId().equals("Size"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).get((Object)"Playroom")).metricTypes()).associate(RelativePath.to().up().metricType("Size").get());
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).create((Blueprint)new Metric.Blueprint("/Size", "playroom1_size"))).entity()).getId().equals("playroom1_size"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).create((Blueprint)new Metric.Blueprint("/Size", "playroom2_size"))).entity()).getId().equals("playroom2_size"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).create((Blueprint)new Resource.Blueprint("playroom1", "/Playroom"))).entity()).getId().equals("playroom1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).create((Blueprint)new Resource.Blueprint("playroom2", "/Playroom"))).entity()).getId().equals("playroom2"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).metrics()).associate(RelativePath.to().up().metric("playroom1_size").get());
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2")).metrics()).associate(((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get());
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).containedChildren()).create((Blueprint)new Resource.Blueprint("playroom1.1", "/Playroom"))).entity()).getId().equals("playroom1.1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).containedChildren()).create((Blueprint)new Resource.Blueprint("playroom1.2", "/Playroom"))).entity()).getId().equals("playroom1.2"));
        ((Resources.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).allChildren()).associate(((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).resource("playroom2")).get());
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2")).containedChildren()).create((Blueprint)new Resource.Blueprint("playroom2.1", "/Playroom"))).entity()).getId().equals("playroom2.1"));
        Environment test = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).entity();
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2")).metrics()).get((Object)((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get())).relationships(Relationships.Direction.outgoing)).linkWith("yourMom", (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), null);
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2")).metrics()).get((Object)((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get())).relationships(Relationships.Direction.incoming)).linkWith("IamYourFather", (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), (Map)new HashMap<String, Object>(){
            {
                this.put("adult", true);
            }
        });
        StructuredData config = ((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("yes", true)).putBool("no", false)).putIntegral("answer", 42L)).putFloatingPoint("approximateAnswer", 42.0)).putString("kachna", "moc")).putUndefined("nothingToSeeHere")).putList("primitives").addBool(true)).addIntegral(1L)).addFloatingPoint(2.0)).addString("str")).addUndefined()).closeList()).putMap("primitiveMap").putBool("bool", true)).putFloatingPoint("float", 1.0)).putIntegral("int", 2L)).putString("str", "kachna")).putUndefined("undef")).closeMap()).putList("listOfMaps").addMap().putBool("listOfMaps_bool", true)).putString("listOfMaps_string", "kachny")).closeMap()).addMap().putFloatingPoint("listOfMaps_float", 1.0)).closeMap()).closeList()).putList("listOfLists").addList().addBool(true)).addIntegral(1L)).closeList()).closeList()).putMap("mapOfLists").putList("list1").addString("ducks")).addUndefined()).closeList()).putList("list2").addBool(false)).addFloatingPoint(2.0)).closeList()).closeMap()).putMap("mapOfMaps").putMap("map1").putIntegral("int", 42L)).putString("answer", "probably")).closeMap()).putMap("map2").putFloatingPoint("float", 2.0)).closeMap()).closeMap()).build();
        assert (((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.configuration).withValue(config).build()).entity().getValue().equals((Object)config));
        ResourceTypes.Single personType = (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("Person")).build());
        ((Data.ReadWrite)personType.data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.configurationSchema).withValue(((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "Person")).putString("description", "Utterly complete description of a human.")).putString("type", "object")).putMap("properties").putMap("firstName").putString("type", "string")).closeMap()).putMap("lastName").putString("type", "string")).closeMap()).putMap("age").putString("description", "Age in years")).putString("type", "integer")).putIntegral("minimum", 0L)).closeMap()).closeMap()).putList("required").addString("firstName")).addString("lastName")).closeList()).build()).build());
        OperationTypes.Single startOp = (OperationTypes.Single)((OperationTypes.ReadWrite)personType.operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("start")).build());
        ((Data.ReadWrite)startOp.data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.returnType).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "start_returnType")).putString("description", "start operation result")).putString("type", "boolean")).build()).build());
        ((Data.ReadWrite)startOp.data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.parameterTypes).withValue(((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "start_paramTypes")).putString("description", "start operation parameter types")).putString("type", "object")).putMap("properties").putMap("quick").putString("type", "boolean")).closeMap()).closeMap()).build()).build());
        Resources.Single people = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessResources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("people")).withResourceTypePath("/Person").build());
        ((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.containedChildren()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("Alois")).withResourceTypePath("/Person").build())).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.configuration).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("firstName", "Alois")).putString("lastName", "Jirasek")).build()).build());
        ((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.containedChildren()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("Hynek")).withResourceTypePath("/Person").build())).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.configuration).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("firstName", "Hynek")).putString("lastName", "Macha")).build()).build());
        ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("mpRt")).withName("Resource Type in a metadata pack")).build());
        ((Data.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"mpRt")).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.configurationSchema).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "mpRtCs")).putString("type", "string")).build()).build());
        ((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"mpRt")).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("mpRtOt")).build());
        ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"mpRt")).operationTypes()).get((Object)"mpRtOt")).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.returnType).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "mpRtOtRet")).putString("type", "string")).build()).build());
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessMetricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mpMt")).withUnit(MetricUnit.NONE).withInterval(Long.valueOf(0L)).build());
        ((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metadataPacks()).create((Blueprint)MetadataPack.Blueprint.builder().withMembers(new CanonicalPath[]{CanonicalPath.fromString((String)"/t;com.acme.tenant/rt;mpRt"), CanonicalPath.fromString((String)"/t;com.acme.tenant/mt;mpMt")}).build());
    }

    private void teardownData() throws Exception {
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get();
        CanonicalPath environmentPath = tenantPath.extend(Environment.class, "test").get();
        Tenant t = new Tenant(tenantPath);
        Environment e = new Environment(environmentPath);
        MetricType sizeType = new MetricType(tenantPath.extend(MetricType.class, "Size").get());
        ResourceType playRoomType = new ResourceType(tenantPath.extend(ResourceType.class, "Playroom").get());
        ResourceType kachnaType = new ResourceType(tenantPath.extend(ResourceType.class, "Kachna").get());
        Resource playroom1 = new Resource(environmentPath.extend(Resource.class, "playroom1").get(), playRoomType);
        Resource playroom2 = new Resource(environmentPath.extend(Resource.class, "playroom2").get(), playRoomType);
        Metric playroom1Size = new Metric(environmentPath.extend(Metric.class, "playroom1_size").get(), sizeType);
        Metric playroom2Size = new Metric(environmentPath.extend(Metric.class, "playroom2_size").get(), sizeType);
        ((Metrics.ReadAssociate)this.inventory.inspect(playroom2).metrics()).disassociate((Path)playroom2Size.getPath());
        Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)this.inventory.inspect(playroom2).metrics()).get((Object)playroom2Size.getPath())).exists());
        Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)this.inventory.inspect(playroom2).metrics()).get((Object)RelativePath.to().up().metric(playroom2Size.getId()).get())).exists());
        this.inventory.inspect(playroom2Size).delete();
        this.assertDoesNotExist((Entity)playroom2Size);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, kachnaType, playroom1, playroom2, playroom1Size});
        ((Metrics.ReadAssociate)this.inventory.inspect(playroom1).metrics()).disassociate(RelativePath.to().up().metric(playroom1Size.getId()).get());
        Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)this.inventory.inspect(playroom1).metrics()).get((Object)playroom1Size.getPath())).exists());
        Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)this.inventory.inspect(playroom1).metrics()).get((Object)RelativePath.to().up().metric(playroom1Size.getId()).get())).exists());
        ((ResourceTypes.ReadWrite)this.inventory.inspect(t).feedlessResourceTypes()).delete((Object)kachnaType.getId());
        this.assertDoesNotExist((Entity)kachnaType);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2, playroom1Size});
        try {
            ((MetricTypes.ReadWrite)this.inventory.inspect(t).feedlessMetricTypes()).delete((Object)sizeType.getId());
            Assert.fail((String)"Deleting a metric type which references some metrics should not be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((Metrics.ReadWrite)this.inventory.inspect(e).feedlessMetrics()).delete((Object)playroom1Size.getId());
        this.assertDoesNotExist((Entity)playroom1Size);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2});
        ((MetricTypes.ReadWrite)this.inventory.inspect(t).feedlessMetricTypes()).delete((Object)sizeType.getId());
        this.assertDoesNotExist((Entity)sizeType);
        this.assertExists(new Entity[]{t, e, playRoomType, playroom1, playroom2});
        try {
            ((ResourceTypes.ReadWrite)this.inventory.inspect(t).feedlessResourceTypes()).delete((Object)playRoomType.getId());
            Assert.fail((String)"Deleting a resource type which references some resources should not be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ((Resources.ReadWrite)this.inventory.inspect(e).feedlessResources()).delete((Object)playroom1.getId());
        this.assertDoesNotExist((Entity)playroom1);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom2});
        this.inventory.tenants().delete((Object)t.getId());
        this.assertDoesNotExist((Entity)t);
        this.assertDoesNotExist((Entity)e);
        this.assertDoesNotExist((Entity)playRoomType);
        this.assertDoesNotExist((Entity)playroom2);
    }

    private void assertDoesNotExist(Entity e) {
        try {
            this.inventory.inspect((AbstractElement)e, ResolvableToSingle.class).entity();
            Assert.fail((String)(e + " should have been deleted"));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private void assertExists(Entity e) {
        try {
            this.inventory.inspect((AbstractElement)e, ResolvableToSingle.class);
        }
        catch (EntityNotFoundException ignored) {
            Assert.fail((String)(e + " should have been present in the inventory."));
        }
    }

    private void assertExists(Entity ... es) {
        Stream.of(es).forEach(this::assertExists);
    }

    @After
    public void teardown() throws Exception {
        try {
            this.teardownData();
        }
        finally {
            try {
                this.inventory.close();
            }
            finally {
                this.destroyStorage();
            }
        }
    }

    @Test
    public void testTenants() throws Exception {
        Function<String, Void> test = id -> {
            Query query = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)id)})).build();
            Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertTrue((boolean)results.hasNext());
            Object tenant = results.next();
            Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
            String eid = this.inventory.getBackend().extractId(tenant);
            Assert.assertEquals((Object)id, (Object)eid);
            return null;
        };
        test.apply("com.acme.tenant");
        test.apply("com.example.tenant");
        Query query = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Tenant.class))}).build();
        Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
        Assert.assertTrue((boolean)results.hasNext());
        results.next();
        Assert.assertTrue((boolean)results.hasNext());
        results.next();
        Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testEntitiesByRelationships() throws Exception {
        Function<Integer, Function> testHelper = numberOfParents -> parentType -> edgeLabel -> numberOfKids -> childType -> multipleParents -> multipleChildren -> {
            InventoryBackend backend = this.inventory.getBackend();
            Page parents = backend.query(Query.path().with(new Filter[]{With.type((Class)parentType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            List parentsList = parents.toList();
            Page children = backend.query(Query.path().with(new Filter[]{With.type((Class)parentType), Related.by((String)edgeLabel), With.type((Class)childType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            List childrenList = children.toList();
            assert (parentsList.size() == numberOfParents.intValue()) : "There must be exactly " + numberOfParents + " " + parentType + "s " + "that have outgoing edge labeled with " + edgeLabel + ". Backend " + "query returned only " + parentsList.size();
            assert (multipleParents.entities().size() == numberOfParents.intValue()) : "There must be exactly " + numberOfParents + " " + parentType + "s that have outgoing edge labeled with " + edgeLabel + ". Tested API returned only " + multipleParents.entities().size();
            assert (childrenList.size() == numberOfKids.intValue()) : "There must be exactly " + numberOfKids + " " + childType + "s that are directly under " + parentType + " connected with " + edgeLabel + ". Gremlin query returned only " + childrenList.size();
            assert (multipleChildren.entities().size() == numberOfKids.intValue());
        };
        ResolvableToMany parents = (ResolvableToMany)this.inventory.tenants().getAll(new Filter[]{Related.by((String)"contains")});
        ResolvableToMany kids = (ResolvableToMany)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(2)).apply(Environment.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((ResourceTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feedlessResourceTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(5)).apply(ResourceType.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((MetricTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feedlessMetricTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(3)).apply(MetricType.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.by((String)"contains")});
        kids = (ResolvableToMany)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(3)).apply(Metric.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((Resources.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessResources()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(4)).apply(Resource.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((MetricTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feedlessMetricTypes()).getAll(new Filter[0]);
        kids = (ResolvableToMany)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).allMetrics().getAll(new Filter[]{Related.asTargetBy((String)"defines")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(3).apply(MetricType.class)).apply("defines")).apply(4)).apply(Metric.class)).apply(parents)).accept(kids);
    }

    @Test
    public void testRelationshipServiceNamed1() throws Exception {
        Set contains = ((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getSegment().getElementId()) && "URL".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.acme.tenant' must contain ResourceType 'URL'.";
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getSegment().getElementId()) && "production".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.acme.tenant' must contain Environment 'production'.";
        assert (contains.stream().anyMatch(rel -> "com.example.tenant".equals(rel.getSource().getSegment().getElementId()) && "Size".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.example.tenant' must contain MetricType 'Size'.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceNamed2() throws Exception {
        Set contains = ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom1'.";
        assert (contains.stream().anyMatch(rel -> "playroom2".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom2'.";
        assert (contains.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom2_size'.";
        assert (contains.stream().anyMatch(rel -> "playroom1_size".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom1_size'.";
        assert (contains.stream().allMatch(rel -> !"production".equals(rel.getSource().getSegment().getElementId()))) : "Environment 'production' cant be the source of these relationships.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceLinkedWith() throws Exception {
        Set rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getTarget().getSegment().getElementId())) : "Target of relationship 'yourMom' should be the 'test' environment";
        rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.both)).named("IamYourFather").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getSource().getSegment().getElementId())) : "Source of relationship 'IamYourFather' should be the 'test' environment";
    }

    @Test
    public void testRelationshipServiceLinkedWithAndDelete() throws Exception {
        Relationship link = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessResources()).get((Object)"host1")).relationships(Relationships.Direction.incoming)).linkWith("crossTenantLink", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null)).entity();
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).named("crossTenantLink").entities().size() == 1) : "Relation 'crossTenantLink' was not found.";
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(link.getId());
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).named("crossTenantLink").entities().size() == 0) : "Relation 'crossTenantLink' was found.";
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(link.getId());
            assert (false) : "It shouldn't be possible to delete the same relationship twice";
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceUpdateRelationship1() throws Exception {
        String someKey = "k3y";
        String someValue = "v4lu3";
        Relationship rel1 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (null == rel1.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        Relationship rel2 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel2.getId()) && null == rel2.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).update(rel1.getId(), ((Relationship.Update.Builder)Relationship.Update.builder().withProperty("k3y", (Object)"v4lu3")).build());
        Relationship rel3 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessMetrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel3.getId()) && "v4lu3".equals(rel3.getProperties().get("k3y"))) : "There should be the property with key 'k3y' and value 'v4lu3'";
    }

    @Test
    public void testRelationshipServiceGetAllFilters() throws Exception {
        Set rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 4) : "There should be 4 relationships conforming the filters";
        assert (rels.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getSegment().getElementId())));
        assert (rels.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getSegment().getElementId())));
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains"), RelationWith.targetOfType(Metric.class)})).entities();
        assert (rels != null && rels.size() == 2) : "There should be 2 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> Metric.class.equals((Object)rel.getTarget().getSegment().getElementType()))) : "The type of all the targets should be the 'Metric'";
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.incoming)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 1) : "There should be just 1 relationship conforming the filters";
        assert ("com.example.tenant".equals(((Relationship)rels.iterator().next()).getSource().getSegment().getElementId())) : "Tenant 'com.example.tenant' was not found";
        rels = ((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).entities();
        assert (rels != null && rels.size() == 7) : "There should be 6 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> "test".equals(rel.getSource().getSegment().getElementId()) || "production".equals(rel.getSource().getSegment().getElementId()))) : "Source should be either 'test' or 'production'";
        assert (rels.stream().allMatch(rel -> Resource.class.equals((Object)rel.getTarget().getSegment().getElementType()) || Metric.class.equals((Object)rel.getTarget().getSegment().getElementType()))) : "Target should be either a metric or a resource";
    }

    @Test
    public void testRelationshipServiceGetAllFiltersWithSubsequentCalls() throws Exception {
        Metric metric = (Metric)((Metrics.Multiple)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).metrics().getAll(new Filter[]{With.id((String)"playroom1_size")})).entities().iterator().next();
        assert ("playroom1_size".equals(metric.getId())) : "Metric playroom1_size was not found using various relation filters";
        try {
            ((Metrics.Multiple)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class})})).metrics().getAll(new Filter[]{With.id((String)"playroom1_size")})).entities().iterator().next();
            assert (false) : "this code should not be reachable. There should be no metric reachable under 'RelationWith.targetsOfTypes(Resource.class))' filter";
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceCallChaining() throws Exception {
        MetricType metricType = (MetricType)((MetricTypes.Single)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).get((Object)"Playroom")).relationships()).named("incorporates").metricTypes().get((Object)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).metricType("Size")).get())).entity();
        assert ("Size".equals(metricType.getId())) : "ResourceType[Playroom] -incorporates-> MetricType[Size] was not found";
        try {
            ((MetricTypes.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).get((Object)"Playroom")).relationships()).named("contains").metricTypes().getAll(new Filter[]{With.id((String)"Size")})).entities().iterator().next();
            assert (false) : "There is no such an entity satisfying the query, this code shouldn't be reachable";
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Set resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).get((Object)"Playroom")).relationships()).named("defines").resources().getAll(new Filter[0])).entities();
        assert (resources.stream().allMatch(res -> Arrays.asList("playroom1", "playroom2", "playroom1.1", "playroom1.2", "playroom2.1").contains(res.getId()))) : "ResourceType[Playroom] -defines-> resources called playroom*";
        resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).feedlessResourceTypes()).get((Object)"Playroom")).relationships()).named("incorporates").resources().getAll(new Filter[0])).entities();
        assert (resources.isEmpty()) : "No resources should be found under the relationship called incorporates from resource type";
    }

    @Test
    public void testEnvironments() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query q = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)id)})).build();
            Page envs = this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertTrue((boolean)envs.hasNext());
            Environment env = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(id)).entity();
            Assert.assertEquals((Object)id, (Object)env.getId());
            env = (Environment)this.inventory.getBackend().convert(envs.next(), Environment.class);
            Assert.assertTrue((!envs.hasNext() ? 1 : 0) != 0);
            Assert.assertEquals((Object)id, (Object)env.getId());
            return null;
        };
        test.apply("com.acme.tenant", "production");
        test.apply("com.example.tenant", "test");
        Query q = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Environment.class))}).build();
        Assert.assertEquals((long)2L, (long)this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
    }

    @Test
    public void testResourceTypes() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)id)}).get();
            Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertTrue((boolean)results.hasNext());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).feedlessResourceTypes()).get(id)).entity();
            assert (rt.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL");
        test.apply("com.example.tenant", "Kachna");
        test.apply("com.example.tenant", "Playroom");
        Query query = Query.path().with(new Filter[]{With.type(ResourceType.class)}).get();
        Assert.assertEquals((long)5L, (long)this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
    }

    @Test
    public void testMetricDefinitions() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(MetricType.class), With.id((String)id)}).get();
            assert (this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).hasNext());
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).feedlessMetricTypes()).get(id)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "ResponseTime");
        test.apply("com.example.tenant", "Size");
        Query query = Query.path().with(new Filter[]{With.type(MetricType.class)}).get();
        Assert.assertEquals((long)3L, (long)this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
    }

    @Test
    public void testMetricTypesLinkedToResourceTypes() throws Exception {
        TetraFunction<String, String, String, CanonicalPath, Void> test = (tenantId, resourceTypeId, id, path) -> {
            Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)resourceTypeId), Related.by((Relationships.WellKnown)Relationships.WellKnown.incorporates), With.type(MetricType.class), With.id((String)id)}).get();
            assert (this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).hasNext());
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).feedlessResourceTypes()).get(resourceTypeId)).metricTypes()).get(path)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL", "ResponseTime", (CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).metricType("ResponseTime")).get());
        test.apply("com.example.tenant", "Playroom", "Size", (CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).metricType("Size")).get());
    }

    @Test
    public void testMetrics() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, metricDefId, id) -> {
            Metric m = (Metric)((Metrics.Multiple)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metricType(metricDefId)).get()))}, {With.id((String)id)}})).entities().iterator().next();
            assert (m.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "ResponseTime", "host1_ping_response");
        test.apply("com.example.tenant", "test", "Size", "playroom1_size");
        test.apply("com.example.tenant", "test", "Size", "playroom2_size");
        Assert.assertEquals((long)4L, (long)this.inventory.getBackend().query(Query.path().with(new Filter[]{With.type(Metric.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
    }

    @Test
    public void testResources() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceTypeId, id) -> {
            Resource r = (Resource)((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get()))}, {With.id((String)id)}})).entities().iterator().next();
            assert (r.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "URL", "host1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom2");
        Assert.assertEquals((long)12L, (long)this.inventory.getBackend().query(Query.path().with(new Filter[]{With.type(Resource.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
    }

    @Test
    public void testResourcesFilteredByTypeProperty() throws Exception {
        Set resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"Facilities")}})).entities();
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("playroom1", "playroom2")), resources.stream().map(AbstractElement::getId).collect(Collectors.toSet()));
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"kachny")}})).entities();
        Assert.assertTrue((boolean)resources.isEmpty());
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"Facilities")}, {With.id((String)"playroom1")}})).entities();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"playroom1", (Object)((Resource)resources.iterator().next()).getId());
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).getAll(new Filter[]{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.id((String)"playroom1")})).entities();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"playroom1", (Object)((Resource)resources.iterator().next()).getId());
    }

    @Test
    public void testAssociateMetricWithResource() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceId, metricId) -> {
            Metric m = (Metric)((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).get(resourceId)).metrics()).getAll(new Filter[]{With.id((String)metricId)})).entities().iterator().next();
            assert (metricId.equals(m.getId()));
            return null;
        };
        test.apply("com.acme.tenant", "production", "host1", "host1_ping_response");
        test.apply("com.example.tenant", "test", "playroom1", "playroom1_size");
        test.apply("com.example.tenant", "test", "playroom2", "playroom2_size");
    }

    @Test
    public void testOperationTypes() throws Exception {
        OperationTypes.Single ots = (OperationTypes.Single)((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"Person")).operationTypes()).get((Object)"start");
        Assert.assertNotNull((Object)ots.entity());
        ots = (OperationTypes.Single)this.inventory.inspect((CanonicalPath)((CanonicalPath.OperationTypeBuilder)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).resourceType("Person")).operationType("start")).get(), OperationTypes.Single.class);
        Assert.assertEquals((Object)"start", (Object)((OperationType)ots.entity()).getId());
        StructuredData returnTypeSchema = ((Data.Single)((Data.ReadWrite)ots.data()).get((Object)OperationTypes.DataRole.returnType)).entity().getValue();
        StructuredData parametersSchema = ((Data.Single)((Data.ReadWrite)ots.data()).get((Object)OperationTypes.DataRole.parameterTypes)).entity().getValue();
        Assert.assertEquals((Object)"start_returnType", (Object)((StructuredData)returnTypeSchema.map().get("title")).string());
        Assert.assertEquals((Object)"boolean", (Object)((StructuredData)returnTypeSchema.map().get("type")).string());
        Assert.assertEquals((Object)"start_paramTypes", (Object)((StructuredData)parametersSchema.map().get("title")).string());
    }

    @Test
    public void queryMultipleTenants() throws Exception {
        Set tenants = ((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).entities();
        assert (tenants.size() == 2);
    }

    @Test
    public void queryMultipleEnvironments() throws Exception {
        Set environments = ((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).entities();
        assert (environments.size() == 2);
    }

    @Test
    public void queryMultipleResourceTypes() throws Exception {
        Set types = ((ResourceTypes.Multiple)((ResourceTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feedlessResourceTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)5L, (long)types.size());
    }

    @Test
    public void queryMultipleMetricDefs() throws Exception {
        Set types = ((MetricTypes.Multiple)((MetricTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).feedlessMetricTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)types.size());
    }

    @Test
    public void queryMultipleResources() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessResources()).getAll(new Filter[0])).entities();
        assert (rs.size() == 4);
    }

    @Test
    public void queryMultipleMetrics() throws Exception {
        Set ms = ((Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0])).entities();
        assert (ms.size() == 3);
    }

    @Test
    public void testNoTwoFeedsWithSameID() throws Exception {
        Feeds.ReadWrite feeds = (Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds();
        Feed f1 = (Feed)feeds.create(new Feed.Blueprint("feed", null)).entity();
        Feed f2 = null;
        try {
            f2 = (Feed)feeds.create(new Feed.Blueprint("feed", null)).entity();
        }
        catch (FeedAlreadyRegisteredException feedAlreadyRegisteredException) {
            // empty catch block
        }
        f2 = (Feed)feeds.create(new Feed.Blueprint(null, null)).entity();
        assert (f1.getId().equals("feed"));
        assert (!f1.getId().equals(f2.getId()));
    }

    @Ignore
    @Test
    public void testNoTwoEquivalentEntitiesOnTheSamePath() throws Exception {
        try {
            this.inventory.tenants().create((Blueprint)new Tenant.Blueprint("com.acme.tenant"));
            Assert.fail((String)"Creating tenant with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)new Environment.Blueprint("production"));
            Assert.fail((String)"Creating environment with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feedlessResources()).create((Blueprint)new Resource.Blueprint("host1", "URL"));
            Assert.fail((String)"Creating resource with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContainsLoopsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", (CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsDiamondsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).resourceType("URL")).get(), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"URL")).relationships(Relationships.Direction.incoming)).linkWith("contains", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertiesCreated() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        Assert.assertEquals((long)1L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"moc", t.getProperties().get("kachny"));
    }

    @Test
    public void testPropertiesUpdatedOnEntities() throws Exception {
        this.inventory.tenants().update((Object)"com.acme.tenant", (Object)((Tenant.Update.Builder)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        Assert.assertEquals((long)2L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"many", t.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", t.getProperties().get("hammer"));
        ((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).update((Object)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("kachny", (Object)"moc")).build());
        this.testPropertiesCreated();
    }

    @Test
    public void testPropertiesUpdatedOnRelationships() throws Exception {
        Relationship r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), ((Relationship.Update.Builder)((Relationship.Update.Builder)Relationship.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"many", r.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", r.getProperties().get("hammer"));
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), new Relationship.Update(null));
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
    }

    @Test
    public void testPropertiesUpdateOnRelationshipsToEmpty() throws Exception {
        String tenantName = "com.acme.tenant";
        Relationship r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), ((Relationship.Update.Builder)((Relationship.Update.Builder)Relationship.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"many", r.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", r.getProperties().get("hammer"));
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), new Relationship.Update(new HashMap()));
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)0L, (long)r.getProperties().size());
    }

    @Test
    public void testCreationMetricTypeWithProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p1", "1");
        properties.put("p2", "2");
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessMetricTypes()).create((Blueprint)new MetricType.Blueprint("test", MetricUnit.BYTES, MetricDataType.COUNTER, properties, Long.valueOf(0L)));
        Assert.assertThat((Object)((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessMetricTypes()).get((Object)"test")).entity()).getProperties().size(), (Matcher)IsEqual.equalTo((Object)properties.size()));
    }

    @Test
    public void testPaging() throws Exception {
        List allResults = ((Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0])).entities(Pager.unlimited((Order[])new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)})).toList();
        assert (allResults.size() == 3);
        Pager firstPage = new Pager(0, 1, new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)});
        Metrics.Multiple metrics = (Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0]);
        Page ms = metrics.entities(firstPage);
        List msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(1)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(2)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        msList = ms.toList();
        assert (ms.getTotalSize() == 3L);
        assert (msList.size() == 0);
        firstPage = new Pager(0, 1, new Order[]{Order.unspecified()});
        ms = metrics.entities(firstPage);
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        msList = ms.toList();
        assert (ms.getTotalSize() == 3L);
        assert (msList.size() == 0);
    }

    @Test
    public void testGettingResourcesFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).allResources().getAll(new Filter[0])).entities();
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "host1".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource1".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource2".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource3".equals(r.getId())));
    }

    @Test
    public void testGettingMetricsFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).allMetrics().getAll(new Filter[0])).entities();
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "host1_ping_response".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedMetric1".equals(r.getId())));
    }

    @Test
    public void testFilterByPropertyValues() throws Exception {
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"kachny")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"kachna")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"moc")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"malo")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"moc", "malo"})})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"hodne", "malo"})})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"adult")})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"infant")})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)true)})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)false)})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"adult", (Object[])new Object[]{false, true})})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"adult", (Object[])new Object[]{false, "true"})})).anyExists());
    }

    @Test
    public void testResourceHierarchy() throws Exception {
        Resources.Single res = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1");
        Pager pager = Pager.unlimited((Order[])new Order[]{Order.unspecified()});
        Page children = ((Resources.Multiple)((Resources.ReadWrite)res.containedChildren()).getAll(new Filter[0])).entities(pager);
        Assert.assertEquals((long)2L, (long)children.toList().size());
        children = ((Resources.Multiple)((Resources.ReadAssociate)res.allChildren()).getAll(new Filter[0])).entities(pager);
        Assert.assertEquals((long)3L, (long)children.toList().size());
        children = ((Resources.Multiple)((Resources.ReadAssociate)res.allChildren()).getAll(new Filter[]{Related.asTargetWith((CanonicalPath)((Resource)res.entity()).getPath(), (Relationships.WellKnown)Relationships.WellKnown.isParentOf)})).entities(pager);
        Assert.assertEquals((long)3L, (long)children.toList().size());
    }

    @Test
    public void testResourceHierarchyNoLoopsPossible() throws Exception {
        CanonicalPath t = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get();
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).relationships(Relationships.Direction.outgoing)).linkWith(Relationships.WellKnown.isParentOf, t, null);
            Assert.fail((String)"Should not be able to create self-loop in isParentOf using generic relationships");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).entity();
        try {
            ((Resources.ReadAssociate)this.inventory.inspect(r).allChildren()).associate((Path)r.getPath());
            Assert.fail((String)"Should not be able to create self-loop in isParentOf using resource association interface.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Resource r2 = (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2")).entity();
        try {
            ((Relationships.ReadWrite)this.inventory.inspect(r2).relationships(Relationships.Direction.outgoing)).linkWith(Relationships.WellKnown.isParentOf, r.getPath(), null);
            Assert.fail((String)"Should not be possible to create loops in isParentOf using generic relationships.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Resources.ReadAssociate)this.inventory.inspect(r2).allChildren()).associate((Path)r.getPath());
            Assert.fail((String)"Should not be possible to create loops in isParentOf using association interface.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testImpossibleToDeleteContainsRelationship() throws Exception {
        try {
            Set rels = ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).named(Relationships.WellKnown.contains).entities();
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(((Relationship)rels.iterator().next()).getId());
            Assert.fail((String)"Should not be able to delete contains relationship explicitly.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testImpossibleToDeleteIsParentOfWhenTheresContainsToo() throws Exception {
        Set rels = ((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).relationships()).named(Relationships.WellKnown.isParentOf).entities();
        for (Relationship r : rels) {
            if (!r.getTarget().getSegment().getElementId().equals("playroom1.1")) continue;
            try {
                ((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom1")).relationships()).delete(r.getId());
                Assert.fail((String)"Should not be possible to delete isParentOf when there's contains relationship in the same direction, too.");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelativePathHandlingDuringDisassociationWhenThereAreMultipleRels() throws Exception {
        Metric m2;
        Metric m1;
        Feed f;
        block9: {
            CanonicalPath envPath = CanonicalPath.fromString((String)"/t;com.example.tenant/e;test");
            Environments.Single env = (Environments.Single)this.inventory.inspect(envPath, Environments.Single.class);
            Tenants.Single tenant = (Tenants.Single)this.inventory.inspect(envPath.up(), Tenants.Single.class);
            f = null;
            Resource r = null;
            m1 = null;
            m2 = null;
            try {
                r = (Resource)((Resources.Single)((Resources.ReadWrite)env.feedlessResources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("assocR1")).withResourceTypePath("/rt;Playroom").build())).entity();
                m1 = (Metric)((Metrics.Single)((Metrics.ReadWrite)env.feedlessMetrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("assocMetric")).withMetricTypePath("/mt;Size").build())).entity();
                f = (Feed)((Feeds.ReadWrite)tenant.feeds()).create(((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("assocF")).build()).entity();
                m2 = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get((Object)"assocF")).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("assocMetric")).withMetricTypePath("/mt;Size").build())).entity();
                ((Metrics.ReadAssociate)this.inventory.inspect(r).metrics()).associate((Path)m1.getPath());
                ((Metrics.ReadAssociate)this.inventory.inspect(r).metrics()).associate((Path)m2.getPath());
                Assert.assertEquals(new HashSet<Metric>(Arrays.asList(m1, m2)), (Object)((Metrics.Multiple)((Metrics.ReadAssociate)this.inventory.inspect(r).metrics()).getAll(new Filter[0])).entities());
                ((Metrics.ReadAssociate)this.inventory.inspect(r).metrics()).disassociate(Path.fromString((String)"../m;assocMetric"));
                Assert.assertEquals(Collections.singleton(m2), (Object)((Metrics.Multiple)((Metrics.ReadAssociate)this.inventory.inspect(r).metrics()).getAll(new Filter[0])).entities());
                if (r == null) break block9;
            }
            catch (Throwable throwable) {
                if (r != null) {
                    this.inventory.inspect(r).delete();
                }
                if (m1 != null) {
                    this.inventory.inspect(m1).delete();
                }
                if (m2 != null) {
                    this.inventory.inspect(m2).delete();
                }
                if (f != null) {
                    this.inventory.inspect(f).delete();
                }
                throw throwable;
            }
            this.inventory.inspect(r).delete();
        }
        if (m1 != null) {
            this.inventory.inspect(m1).delete();
        }
        if (m2 != null) {
            this.inventory.inspect(m2).delete();
        }
        if (f != null) {
            this.inventory.inspect(f).delete();
        }
    }

    @Test
    public void testCannotCreateOrDeleteHasDataRelationship() throws Exception {
        Relationships.Multiple rels = (Relationships.Multiple)this.inventory.relationships().getAll(new RelationFilter[]{RelationWith.name((String)Relationships.WellKnown.hasData.name()), RelationWith.sourceOfType(DataEntity.class)});
        try {
            Relationship rel = (Relationship)rels.entities().iterator().next();
            ((Relationships.Single)this.inventory.relationships().get(rel.getId())).delete();
            Assert.fail((String)"Explicitly deleting hasData relationship shouldn't be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).linkWith(Relationships.WellKnown.hasData, (CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get(), null);
            Assert.fail((String)"Explicitly creating hasData relationship shouldn't be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInspectChildResource() throws Exception {
        Resources.Single access = (Resources.Single)this.inventory.inspect((CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).resource("playroom1")).resource("playroom1.1")).get(), Resources.Single.class);
        Assert.assertEquals((Object)"playroom1.1", (Object)((Resource)access.entity()).getId());
    }

    @Test
    public void testDescendChildResource() throws Exception {
        Resources.Single r = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).descend((Object)"playroom1", new Path[]{RelativePath.fromString((String)"../r;playroom2")}).get((Object)RelativePath.fromString((String)"r;playroom2.1"));
        Assert.assertEquals((Object)"playroom2.1", (Object)((Resource)r.entity()).getId());
    }

    @Test
    public void testAssociateEnvironmentWithFeeds() throws Exception {
        Assert.assertTrue((boolean)((Feeds.Single)((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feeds()).get((Object)RelativePath.to().up().feed("feed1").get())).exists());
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("staging")).build());
        try {
            ((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"staging")).feeds()).associate(RelativePath.to().up().feed("feed1").get());
            Assert.fail((String)"It should not be possible to associate a feed with more than 1 environment.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).delete((Object)"staging");
        }
    }

    @Test
    public void testCreationUnderNonExistentParentThrowsEntityNotFoundException() throws Exception {
        try {
            ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"no-feed")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("blah")).withResourceTypePath("../../URL").build());
        }
        catch (EntityNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNamePersisted() throws Exception {
        Tenant t = null;
        try {
            t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("named-tenant")).withName("tenant")).build())).entity();
            Assert.assertEquals((Object)"tenant", (Object)t.getName());
            Environment e = (Environment)((Environments.Single)((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("named-env")).withName("env")).build())).entity();
            Assert.assertEquals((Object)"env", (Object)e.getName());
            Feed f = (Feed)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create(((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("named-feed")).withName("feed")).build()).entity();
            Assert.assertEquals((Object)"feed", (Object)f.getName());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("named-resourceType")).withName("resourceType")).build())).entity();
            Assert.assertEquals((Object)"resourceType", (Object)rt.getName());
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).feedlessMetricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("named-metricType")).withUnit(MetricUnit.BITS).withName("metricType")).withInterval(Long.valueOf(0L)).build())).entity();
            Assert.assertEquals((Object)"metricType", (Object)mt.getName());
            OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("named-operationType")).withName("operationType")).build())).entity();
            Assert.assertEquals((Object)"operationType", (Object)ot.getName());
            Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)this.inventory.inspect(f).resources()).create((Blueprint)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("named-resource")).withName("resource")).withResourceTypePath(rt.getPath().toString()).build())).entity();
            Assert.assertEquals((Object)"resource", (Object)r.getName());
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)this.inventory.inspect(f).metrics()).create((Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("named-metric")).withName("metric")).withMetricTypePath(mt.getPath().toString()).build())).entity();
            Assert.assertEquals((Object)"metric", (Object)m.getName());
            try {
                ((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("failing-env")).withProperty("name", (Object)"invalid-property")).build());
                Assert.fail((String)"Should not be possible to create an entity with a property called \"name\".");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            this.inventory.inspect(t).delete();
            throw throwable;
        }
        this.inventory.inspect(t).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNameUpdatable() throws Exception {
        Tenant t = null;
        try {
            t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("named-tenant")).withName("tenant")).build())).entity();
            this.testUpdate((Entity)t, (Entity.Update.Builder)Tenant.Update.builder());
            Environment e = (Environment)((Environments.Single)((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("named-env")).withName("env")).build())).entity();
            this.testUpdate((Entity)e, (Entity.Update.Builder)Environment.Update.builder());
            Feed f = (Feed)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create(((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("named-feed")).withName("feed")).build()).entity();
            this.testUpdate((Entity)f, (Entity.Update.Builder)Feed.Update.builder());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("named-resourceType")).withName("resourceType")).build())).entity();
            this.testUpdate((Entity)rt, (Entity.Update.Builder)ResourceType.Update.builder());
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).feedlessMetricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("named-metricType")).withUnit(MetricUnit.BITS).withName("metricType")).withInterval(Long.valueOf(0L)).build())).entity();
            this.testUpdate((Entity)mt, (Entity.Update.Builder)MetricType.Update.builder());
            OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("named-operationType")).withName("operationType")).build())).entity();
            this.testUpdate((Entity)ot, (Entity.Update.Builder)OperationType.Update.builder());
            Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)this.inventory.inspect(f).resources()).create((Blueprint)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("named-resource")).withName("resource")).withResourceTypePath(rt.getPath().toString()).build())).entity();
            this.testUpdate((Entity)r, (Entity.Update.Builder)Resource.Update.builder());
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)this.inventory.inspect(f).metrics()).create((Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("named-metric")).withName("metric")).withMetricTypePath(mt.getPath().toString()).build())).entity();
            this.testUpdate((Entity)m, (Entity.Update.Builder)Metric.Update.builder());
            try {
                this.inventory.inspect(m).update((Object)((Metric.Update.Builder)Metric.Update.builder().withProperty("name", (Object)"disallowed")).build());
                Assert.fail((String)"A property called \"name\" should not be allowed in updates.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            this.inventory.inspect(t).delete();
            throw throwable;
        }
        this.inventory.inspect(t).delete();
    }

    @Test
    public void testMetadataPackMembershipNonUpdatable() throws Exception {
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
        CanonicalPath rtPath = tenantPath.extend(ResourceType.class, "Person").get();
        MetadataPack pack = (MetadataPack)((MetadataPacks.Multiple)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.inspect(tenantPath, Tenants.Single.class)).metadataPacks()).getAll(new Filter[0])).entities().iterator().next();
        try {
            ((Relationships.ReadWrite)this.inventory.inspect(pack).relationships()).linkWith(Relationships.WellKnown.incorporates, rtPath, null);
            Assert.fail((String)"Adding a resource type to a metadatapack should not be possible after the pack has been created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(rtPath, ResourceTypes.Single.class)).relationships(Relationships.Direction.incoming)).linkWith(Relationships.WellKnown.incorporates, pack.getPath(), null);
            Assert.fail((String)"Adding a resource type to a metadatapack should not be possible after the pack has been created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testModificationsOfEntitiesInMetadataPacksImpossible() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).feedlessMetricTypes()).get((Object)"mpMt")).entity();
        ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).feedlessResourceTypes()).get((Object)"mpRt")).entity();
        try {
            this.inventory.inspect(mt).update((Object)MetricType.Update.builder().withUnit(MetricUnit.PER_DAY).build());
            Assert.fail((String)"Updating a metric type that is a part of metadata pack should not be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("asfd")).build());
            Assert.fail((String)"It should not be possible to add an operation type to a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).delete((Object)"mpRtOt");
            Assert.fail((String)"It should not be possible to delete an operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).delete();
            Assert.fail((String)"It should not be possible to delete an operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.parameterTypes).withValue(StructuredData.get().undefined()).build());
            Assert.fail((String)"It should not be possible to add data to operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).update((DataEntity.Role)OperationTypes.DataRole.returnType, DataEntity.Update.builder().withValue(StructuredData.get().bool(Boolean.valueOf(true))).build());
            Assert.fail((String)"It should not be possible to modify data of operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).delete((Object)OperationTypes.DataRole.returnType);
            Assert.fail((String)"It should not be possible to delete data of operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)this.inventory.inspect(rt).data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.connectionConfigurationSchema).withValue(StructuredData.get().bool(Boolean.valueOf(true))).build());
            Assert.fail((String)"It should not be possible to add an data to a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)ResourceTypes.DataRole.configurationSchema)).delete();
            Assert.fail((String)"It should not be possible to remove data from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)ResourceTypes.DataRole.configurationSchema)).update(DataEntity.Update.builder().withValue(StructuredData.get().undefined()).build());
            Assert.fail((String)"It should not be possible to modify data of a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMetadataPackIdEqualToContentHash() throws Exception {
        MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessMetricTypes()).get((Object)"mpMt")).entity();
        ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feedlessResourceTypes()).get((Object)"mpRt")).entity();
        OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).entity();
        StructuredData configSchema = ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)ResourceTypes.DataRole.configurationSchema)).entity().getValue();
        StructuredData retType = ((Data.Single)((Data.ReadWrite)this.inventory.inspect(ot).data()).get((Object)OperationTypes.DataRole.returnType)).entity().getValue();
        String expectedContentHash = IdentityHash.of((MetadataPack.Members)MetadataPack.Members.builder().with(((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)mt.getType()).withUnit(mt.getUnit()).withInterval(Long.valueOf(0L)).withId(mt.getId())).build()).with(((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(rt.getId())).build()).with(DataEntity.Blueprint.builder().withRole((DataEntity.Role)ResourceTypes.DataRole.configurationSchema).withValue(configSchema).build()).with(((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId(ot.getId())).build()).with(DataEntity.Blueprint.builder().withRole((DataEntity.Role)OperationTypes.DataRole.returnType).withValue(retType).build()).done().done().build());
        Assert.assertTrue((boolean)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metadataPacks()).get((Object)expectedContentHash)).exists());
    }

    private <T extends Entity<B, U>, B extends Blueprint, U extends Entity.Update> void testUpdate(T entity, Entity.Update.Builder<U, ?> update) {
        Class<ResolvableToSingle> cls = ResolvableToSingle.class;
        this.inventory.inspect(entity, cls).update((Object)update.withName("updated").build());
        entity = (Entity)this.inventory.inspect(entity, cls).entity();
        Assert.assertEquals((Object)"updated", (Object)entity.getName());
    }

    @Test
    public void testObserveTenants() throws Exception {
        this.runObserverTest(Tenant.class, 0, 0, () -> {
            this.inventory.tenants().create((Blueprint)new Tenant.Blueprint("xxx"));
            this.inventory.tenants().update((Object)"xxx", (Object)Tenant.Update.builder().build());
            this.inventory.tenants().delete((Object)"xxx");
        });
    }

    @Test
    public void testObserveEnvironments() throws Exception {
        this.runObserverTest(Environment.class, 1, 1, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("xxx")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).update((Object)"xxx", (Object)Environment.Update.builder().build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).delete((Object)"xxx");
            this.inventory.tenants().delete((Object)"t");
        });
    }

    @Test
    public void testObserveResourceTypes() throws Exception {
        this.runObserverTest(ResourceType.class, 3, 3, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).create((Blueprint)new ResourceType.Blueprint("rt"));
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).update((Object)"rt", (Object)new ResourceType.Update(null));
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.COUNTER).withId("mt")).withUnit(MetricUnit.BYTES).withInterval(Long.valueOf(0L)).build())).entity();
            ArrayList createdRelationships = new ArrayList();
            this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
            ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).get((Object)"rt")).metricTypes()).associate((Path)mt.getPath());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).delete((Object)"mt");
            Assert.assertEquals((long)1L, (long)createdRelationships.size());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).delete((Object)"rt");
            this.inventory.tenants().delete((Object)"t");
        });
    }

    @Test
    public void testObserveMetricTypes() throws Exception {
        this.runObserverTest(MetricType.class, 1, 1, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).create((Blueprint)new MetricType.Blueprint("mt", MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)));
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).update((Object)"mt", (Object)MetricType.Update.builder().withUnit(MetricUnit.MILLISECONDS).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).delete((Object)"mt");
        });
    }

    @Test
    public void testObserveMetrics() throws Exception {
        this.runObserverTest(Metric.class, 4, 2, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("e")).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).create((Blueprint)new MetricType.Blueprint("mt", MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)));
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessMetrics()).create((Blueprint)new Metric.Blueprint("/mt", "m"));
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessMetrics()).update((Object)"m", (Object)Metric.Update.builder().build());
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessMetrics()).delete((Object)"m");
        });
    }

    @Test
    public void testObserveResources() throws Exception {
        this.runObserverTest(Resource.class, 8, 3, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("e")).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessMetricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.COUNTER).withId("mt")).withUnit(MetricUnit.BYTES).withInterval(Long.valueOf(0L)).build());
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).create((Blueprint)new Resource.Blueprint("r", "/rt"));
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).update((Object)"r", (Object)Resource.Update.builder().build());
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessMetrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("m")).withMetricTypePath("/mt").build())).entity();
            ArrayList createdRelationships = new ArrayList();
            this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
            ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).get((Object)"r")).metrics()).associate((Path)m.getPath());
            Assert.assertEquals((long)1L, (long)createdRelationships.size());
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).delete((Object)"r");
        });
    }

    @Test
    public void testObserveDataEntities() throws Exception {
        this.runObserverTest(DataEntity.class, 5, 1, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("e")).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).feedlessResourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build());
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).create((Blueprint)new Resource.Blueprint("r", "/rt"));
            Data.ReadWrite dataAccess = (Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"t")).environments()).get((Object)"e")).feedlessResources()).get((Object)"r")).data();
            dataAccess.create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.configuration).build());
            dataAccess.update((DataEntity.Role)Resources.DataRole.configuration, DataEntity.Update.builder().build());
            dataAccess.delete((Object)Resources.DataRole.configuration);
        });
    }

    @Test
    public void testBackendFind() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
        Object entity = backend.find(tenantPath);
        Tenant tenant = (Tenant)backend.convert(entity, Tenant.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)tenant.getId());
        CanonicalPath envPath = tenantPath.extend(Environment.class, "production").get();
        entity = backend.find(envPath);
        Environment env = (Environment)backend.convert(entity, Environment.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)env.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"production", (Object)env.getId());
        entity = backend.find(envPath.extend(Resource.class, "host1").get());
        Resource r = (Resource)backend.convert(entity, Resource.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"production", (Object)r.getPath().ids().getEnvironmentId());
        Assert.assertNull((Object)r.getPath().ids().getFeedId());
        Assert.assertEquals((Object)"host1", (Object)r.getId());
        entity = backend.find(envPath.extend(Metric.class, "host1_ping_response").get());
        Metric m = (Metric)backend.convert(entity, Metric.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"production", (Object)m.getPath().ids().getEnvironmentId());
        Assert.assertNull((Object)m.getPath().ids().getFeedId());
        Assert.assertEquals((Object)"host1_ping_response", (Object)m.getId());
        CanonicalPath feedPath = tenantPath.extend(Feed.class, "feed1").get();
        entity = backend.find(feedPath);
        Feed f = (Feed)backend.convert(entity, Feed.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)f.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"feed1", (Object)f.getId());
        entity = backend.find(feedPath.extend(Resource.class, "feedResource1").get());
        r = (Resource)backend.convert(entity, Resource.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"feed1", (Object)r.getPath().ids().getFeedId());
        Assert.assertEquals((Object)"feedResource1", (Object)r.getId());
        entity = backend.find(feedPath.extend(Metric.class, "feedMetric1").get());
        m = (Metric)backend.convert(entity, Metric.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"feed1", (Object)m.getPath().ids().getFeedId());
        Assert.assertEquals((Object)"feedMetric1", (Object)m.getId());
        entity = backend.find(tenantPath.extend(ResourceType.class, "URL").get());
        ResourceType rt = (ResourceType)backend.convert(entity, ResourceType.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)rt.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"URL", (Object)rt.getId());
        entity = backend.find(tenantPath.extend(MetricType.class, "ResponseTime").get());
        MetricType mt = (MetricType)backend.convert(entity, MetricType.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)mt.getPath().ids().getTenantId());
        Assert.assertEquals((Object)"ResponseTime", (Object)mt.getId());
    }

    @Test
    public void testBackendGetRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get());
        Object environment = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).environment("production")).get());
        Object r = backend.getRelationship(tenant, environment, Relationships.WellKnown.contains.name());
        Relationship rel = (Relationship)backend.convert(r, Relationship.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)rel.getSource().getSegment().getElementId());
        Assert.assertEquals((Object)"production", (Object)rel.getTarget().getSegment().getElementId());
        Assert.assertEquals((Object)"contains", (Object)rel.getName());
    }

    @Test
    public void testBackendGetRelationships() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object entity = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get());
        Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(entity));
        Set rels = backend.getRelationships(entity, Relationships.Direction.both, new String[0]);
        Assert.assertEquals((long)8L, (long)rels.size());
        Function<Set, Stream> checks = es -> es.stream().map(e -> (Relationship)backend.convert(e, Relationship.class));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "production".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "URL".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "Person".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "ResponseTime".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "feed1".equals(r.getTarget().getSegment().getElementId())));
        rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
        Assert.assertTrue((boolean)rels.isEmpty());
        rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[0]);
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "production".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "URL".equals(r.getTarget().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "ResponseTime".equals(r.getTarget().getSegment().getElementId())));
        entity = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get());
        Assert.assertEquals((Object)"test", (Object)backend.extractId(entity));
        rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
        Assert.assertEquals((long)2L, (long)rels.size());
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "contains".equals(r.getName()) && "com.example.tenant".equals(r.getSource().getSegment().getElementId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "yourMom".equals(r.getName()) && "playroom2_size".equals(r.getSource().getSegment().getElementId())));
        rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[]{"IamYourFather"});
        Assert.assertEquals((long)1L, (long)rels.size());
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "IamYourFather".equals(r.getName()) && "playroom2_size".equals(r.getTarget().getSegment().getElementId())));
    }

    @Test
    public void testBackendGetTransitiveClosure() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        TriFunction<Object, Relationships.Direction, String[], Stream> test = (start, direction, name) -> {
            Iterator transitiveClosure = backend.getTransitiveClosureOver(start, direction, name);
            return StreamSupport.stream(Spliterators.spliterator(transitiveClosure, Integer.MAX_VALUE, 0), false).map(e -> (Entity)backend.convert(e, backend.extractType(e)));
        };
        Object env = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).environment("production")).get());
        Object feed = backend.find((CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).feed("feed1")).get());
        Assert.assertEquals((long)4L, (long)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).count());
        Assert.assertFalse((boolean)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).anyMatch(e -> e instanceof Feed && "feed1".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource1".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource2".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource3".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Metric && "feedMetric1".equals(e.getId())));
        Assert.assertEquals((long)1L, (long)test.apply(env, Relationships.Direction.incoming, new String[]{"contains"}).count());
        Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.incoming, new String[]{"contains"}).anyMatch(e -> e instanceof Tenant && "com.acme.tenant".equals(e.getId())));
    }

    @Test
    public void testBackendHasRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get());
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.outgoing, "contains"));
        Assert.assertFalse((boolean)backend.hasRelationship(tenant, Relationships.Direction.incoming, "contains"));
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.both, "contains"));
        Object env = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get());
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, env, "contains"));
        Assert.assertFalse((boolean)backend.hasRelationship(tenant, env, "kachny"));
    }

    @Test
    public void testBackendExtractId() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get());
        Assert.assertEquals((Object)"com.example.tenant", (Object)backend.extractId(tenant));
    }

    @Test
    public void testBackendExtractType() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
        Object entity = backend.find(tenantPath);
        Assert.assertEquals(Tenant.class, (Object)backend.extractType(entity));
        CanonicalPath envPath = tenantPath.extend(Environment.class, "production").get();
        entity = backend.find(envPath);
        Assert.assertEquals(Environment.class, (Object)backend.extractType(entity));
        entity = backend.find(envPath.extend(Resource.class, "host1").get());
        Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
        entity = backend.find(envPath.extend(Metric.class, "host1_ping_response").get());
        Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
        CanonicalPath feedPath = tenantPath.extend(Feed.class, "feed1").get();
        entity = backend.find(feedPath);
        Assert.assertEquals(Feed.class, (Object)backend.extractType(entity));
        entity = backend.find(feedPath.extend(Resource.class, "feedResource1").get());
        Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
        entity = backend.find(feedPath.extend(Metric.class, "feedMetric1").get());
        Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
        entity = backend.find(tenantPath.extend(ResourceType.class, "URL").get());
        Assert.assertEquals(ResourceType.class, (Object)backend.extractType(entity));
        entity = backend.find(tenantPath.extend(MetricType.class, "ResponseTime").get());
        Assert.assertEquals(MetricType.class, (Object)backend.extractType(entity));
    }

    @Test
    public void testBackendQuery() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Pager unlimited = Pager.unlimited((Order[])new Order[]{Order.unspecified()});
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant")}).get();
        Page results = backend.query(q, unlimited);
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(results.next()));
        Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
        q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant"), Related.by((String)"contains"), With.type(Environment.class), With.id((String)"production")}).get();
        results = backend.query(q, unlimited);
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"production", (Object)backend.extractId(results.next()));
        Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
        q = Query.path().with(new Filter[]{With.type(Tenant.class)}).filter().with(new Filter[]{Related.by((String)"contains"), With.type(ResourceType.class), With.id((String)"URL")}).path().with(new Filter[]{Related.by((String)"contains"), With.type(Environment.class)}).get();
        results = backend.query(q, unlimited);
        Assert.assertTrue((boolean)results.hasNext());
        Assert.assertEquals((Object)"production", (Object)backend.extractId(results.next()));
        Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testCreateConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).feedlessResources()).get((Object)"playroom2");
        StructuredData orig = ((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("yes", true)).putBool("no", false)).build();
        ((Data.ReadWrite)res.data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.connectionConfiguration).withValue(orig).build());
        StructuredData retrieved = ((Data.Single)((Data.ReadWrite)res.data()).get((Object)Resources.DataRole.connectionConfiguration)).entity().getValue();
        Assert.assertEquals((Object)orig, (Object)retrieved);
        Assert.assertFalse((boolean)((Data.Single)((Data.ReadWrite)res.data()).get((Object)Resources.DataRole.configuration)).exists());
        ((Data.ReadWrite)res.data()).delete((Object)Resources.DataRole.connectionConfiguration);
        Assert.assertFalse((boolean)((Data.Single)((Data.ReadWrite)res.data()).get((Object)Resources.DataRole.connectionConfiguration)).exists());
    }

    @Test
    public void testUpdateStructuredDataSimpleValue() throws Exception {
        Data.Single dataAccess = (Data.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.example.tenant/e;test/r;playroom1/d;configuration"), Data.Single.class);
        StructuredData origData = dataAccess.entity().getValue();
        Assert.assertNotNull((Object)origData);
        StructuredData modified = ((StructuredData.MapUpdater)origData.update().toMap().putBool("answer", true)).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        StructuredData persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        modified = ((StructuredData.MapUpdater)((StructuredData.InnerListUpdater)modified.update().toMap().updateList("primitives").setBool(0, false)).closeList()).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        modified = ((StructuredData.MapUpdater)modified.update().toMap().remove("answer")).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        dataAccess.update(DataEntity.Update.builder().withValue(origData).build());
    }

    @Test
    public void testFilteringByData() throws Exception {
        Data.Read configs = (Data.Read)((Resources.Multiple)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).allResources().getAll(new Filter[0])).data();
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll(new Filter[]{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get()))})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataValue((Serializable)Boolean.valueOf(false))}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataValue((Serializable)Boolean.valueOf(true))}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.list})}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.bool})}})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.map})}})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.integral})}})).entities().size());
    }

    @Test
    public void testRetrievingDataPortions() throws Exception {
        Data.Single config = (Data.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.example.tenant/e;test/r;playroom1/d;configuration"), Data.Single.class);
        StructuredData allData = config.entity().getValue();
        StructuredData portion = config.data((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get());
        Assert.assertEquals(((StructuredData)allData.map().get("primitives")).list().get(0), (Object)portion);
        portion = config.data(RelativePath.empty().get());
        Assert.assertEquals((Object)allData, (Object)portion);
        portion = config.flatData((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get());
        Assert.assertEquals(((StructuredData)allData.map().get("primitives")).list().get(0), (Object)portion);
        portion = config.flatData(RelativePath.empty().get());
        Assert.assertEquals(Collections.emptyMap(), (Object)portion.getValue());
        portion = config.flatData((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get());
        Assert.assertEquals(Collections.emptyList(), (Object)portion.getValue());
    }

    @Test
    public void testCreateInvalidConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people"), Resources.Single.class);
        try {
            ((Data.ReadWrite)res.data()).create(DataEntity.Blueprint.builder().withRole((DataEntity.Role)Resources.DataRole.configuration).withValue(((StructuredData.MapBuilder)StructuredData.get().map().putBool("firstName", false)).build()).build());
            Assert.fail((String)"Creating a config that doesn't conform to the schema shouldn't be possible.");
        }
        catch (ValidationException e) {
            Assert.assertEquals((long)2L, (long)e.getMessages().size());
            Assert.assertEquals((Object)CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/d;configuration"), (Object)e.getDataPath());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(0)).getSeverity());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(1)).getSeverity());
        }
    }

    @Test
    public void testUpdateWithInvalidConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/r;Alois"), Resources.Single.class);
        try {
            ((Data.Single)((Data.ReadWrite)res.data()).get((Object)Resources.DataRole.configuration)).update(DataEntity.Update.builder().withValue(((StructuredData.MapBuilder)StructuredData.get().map().putBool("firstName", false)).build()).build());
            Assert.fail((String)"Updating a config that doesn't conform to the schema shouldn't be possible.");
        }
        catch (ValidationException e) {
            Assert.assertEquals((long)2L, (long)e.getMessages().size());
            Assert.assertEquals((Object)CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/r;Alois/d;configuration"), (Object)e.getDataPath());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(0)).getSeverity());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(1)).getSeverity());
        }
    }

    @Test
    public void testCreateWithRelationships() throws Exception {
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("env-with-rel")).addOutgoingRelationship("kachna", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get())).addIncomingRelationship("duck", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get())).build());
        Assert.assertTrue((boolean)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships(Relationships.Direction.incoming)).named("kachna").anyExists());
        Assert.assertTrue((boolean)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships(Relationships.Direction.outgoing)).named("duck").anyExists());
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).delete((Object)"env-with-rel");
    }

    private <T extends AbstractElement<?, U>, U extends AbstractElement.Update> void runObserverTest(Class<T> entityClass, int nofCreatedRelationships, int nofDeletedRelationships, Runnable payload) {
        ArrayList createdEntities = new ArrayList();
        ArrayList updatedEntities = new ArrayList();
        ArrayList deletedEntities = new ArrayList();
        ArrayList createdRelationships = new ArrayList();
        ArrayList deletedRelationships = new ArrayList();
        Subscription s1 = this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(createdEntities::add);
        Subscription s2 = this.inventory.observable(Interest.in(entityClass).being(Action.updated())).subscribe(updatedEntities::add);
        Subscription s3 = this.inventory.observable(Interest.in(entityClass).being(Action.deleted())).subscribe(deletedEntities::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.deleted())).subscribe(deletedRelationships::add);
        this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(t -> {});
        payload.run();
        Assert.assertEquals((long)1L, (long)createdEntities.size());
        Assert.assertEquals((long)1L, (long)updatedEntities.size());
        Assert.assertEquals((long)1L, (long)deletedEntities.size());
        Assert.assertEquals((long)nofCreatedRelationships, (long)createdRelationships.size());
        Assert.assertEquals((long)nofDeletedRelationships, (long)deletedRelationships.size());
        s1.unsubscribe();
        s2.unsubscribe();
        s3.unsubscribe();
        Assert.assertTrue((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.created())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.updated())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.deleted())));
    }

    private static interface TetraFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

