/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.base.BaseData;
import org.hawkular.inventory.base.BaseMetricTypes;
import org.hawkular.inventory.base.BaseOperationTypes;
import org.hawkular.inventory.base.BaseResources;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Fetcher;
import org.hawkular.inventory.base.MultipleEntityFetcher;
import org.hawkular.inventory.base.Mutator;
import org.hawkular.inventory.base.Notification;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.SingleEntityFetcher;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.ElementNotFoundException;

public final class BaseResourceTypes {
    private BaseResourceTypes() {
    }

    private static class ResourceTypeDataModificationChecks<BE>
    implements BaseData.DataModificationChecks<BE> {
        private final TraversalContext<BE, ?> context;

        public ResourceTypeDataModificationChecks(TraversalContext<BE, ?> context) {
            this.context = context;
        }

        @Override
        public void preCreate(DataEntity.Blueprint blueprint) {
            Object pack = this.context.backend.querySingle(this.context.select().path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (pack != null) {
                Object rt = this.context.backend.querySingle(this.context.select().get());
                throw new IllegalArgumentException("Data '" + blueprint.getId() + "' cannot be created" + " under resource type " + this.context.backend.extractCanonicalPath(rt) + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void preUpdate(BE dataEntity, DataEntity.Update update) {
            if (update.getValue() == null) {
                return;
            }
            Object mp = this.context.backend.traverseToSingle(dataEntity, Query.path().with(Related.asTargetBy(Relationships.WellKnown.contains), Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get());
            if (mp != null) {
                CanonicalPath dataPath = this.context.backend.extractCanonicalPath(dataEntity);
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be updated" + " under resource type " + dataPath.up() + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }

        @Override
        public void preDelete(BE dataEntity) {
            CanonicalPath dataPath = this.context.backend.extractCanonicalPath(dataEntity);
            Object rt = null;
            try {
                rt = this.context.backend.find(dataPath.up());
            }
            catch (ElementNotFoundException e) {
                Fetcher.throwNotFoundException(this.context);
            }
            if (ReadWrite.isResourceTypeInMetadataPack(this.context, rt)) {
                throw new IllegalArgumentException("Data '" + dataPath.getSegment().getElementId() + "' cannot be deleted" + " under resource type " + dataPath.up() + ", because it is part of a meta data pack." + " Doing this would invalidate meta data pack's identity.");
            }
        }
    }

    public static class Multiple<BE>
    extends MultipleEntityFetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Multiple {
        public Multiple(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.ReadContained metricTypes() {
            return new BaseMetricTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public OperationTypes.ReadContained operationTypes() {
            return new BaseOperationTypes.ReadContained(this.context.proceedTo(Relationships.WellKnown.contains, OperationType.class).get());
        }

        @Override
        public Data.Read<ResourceTypes.DataRole> data() {
            return new BaseData.Read(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new ResourceTypeDataModificationChecks(this.context));
        }
    }

    public static class Single<BE>
    extends SingleEntityFetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Single {
        public Single(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public Resources.Read resources() {
            return new BaseResources.Read(this.context.proceedTo(Relationships.WellKnown.defines, Resource.class).get());
        }

        @Override
        public MetricTypes.ReadAssociate metricTypes() {
            return new BaseMetricTypes.ReadAssociate(this.context.proceedTo(Relationships.WellKnown.incorporates, MetricType.class).get());
        }

        @Override
        public OperationTypes.ReadWrite operationTypes() {
            return new BaseOperationTypes.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, OperationType.class).get());
        }

        @Override
        protected void cleanup(BE deletedEntity) {
            if (ReadWrite.isResourceTypeInMetadataPack(this.context, deletedEntity)) {
                throw new IllegalArgumentException("Cannot delete a resource type that is part of a metadata pack. This would invalidate the meta data pack's identity.");
            }
        }

        @Override
        protected void preUpdate(BE updatedEntity, ResourceType.Update update) {
        }

        @Override
        public Data.ReadWrite<ResourceTypes.DataRole> data() {
            return new BaseData.ReadWrite(this.context.proceedTo(Relationships.WellKnown.contains, DataEntity.class).get(), new ResourceTypeDataModificationChecks(this.context));
        }
    }

    public static class Read<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.Read {
        public Read(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(Path id) throws EntityNotFoundException {
            return new Single(this.context.proceedTo(id));
        }
    }

    public static class ReadContained<BE>
    extends Fetcher<BE, ResourceType, ResourceType.Update>
    implements ResourceTypes.ReadContained {
        public ReadContained(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }
    }

    public static class ReadWrite<BE>
    extends Mutator<BE, ResourceType, ResourceType.Blueprint, ResourceType.Update, String>
    implements ResourceTypes.ReadWrite {
        public ReadWrite(TraversalContext<BE, ResourceType> context) {
            super(context);
        }

        @Override
        protected String getProposedId(ResourceType.Blueprint blueprint) {
            return blueprint.getId();
        }

        @Override
        protected EntityAndPendingNotifications<ResourceType> wireUpNewEntity(BE entity, ResourceType.Blueprint blueprint, CanonicalPath parentPath, BE parent) {
            this.context.backend.update(entity, ResourceType.Update.builder().build());
            return new EntityAndPendingNotifications<ResourceType>(new ResourceType(blueprint.getName(), parentPath.extend(ResourceType.class, this.context.backend.extractId(entity)).get(), blueprint.getProperties()), new Notification[0]);
        }

        @Override
        public ResourceTypes.Multiple getAll(Filter[][] filters) {
            return new Multiple(this.context.proceed().whereAll(filters).get());
        }

        @Override
        public ResourceTypes.Single get(String id) throws EntityNotFoundException {
            return new Single(this.context.proceed().where(With.id(id)).get());
        }

        @Override
        public ResourceTypes.Single create(ResourceType.Blueprint blueprint) throws EntityAlreadyExistsException {
            return new Single(this.context.toCreatedEntity(this.doCreate(blueprint)));
        }

        @Override
        protected void cleanup(String s, BE entityRepresentation) {
            if (ReadWrite.isResourceTypeInMetadataPack(this.context, entityRepresentation)) {
                throw new IllegalArgumentException("Cannot delete a resource type that is part of a metadata pack. This would invalidate the meta data pack's identity.");
            }
        }

        @Override
        protected void preUpdate(String s, BE entityRepresentation, ResourceType.Update update) {
        }

        private static <BE> boolean isResourceTypeInMetadataPack(TraversalContext<BE, ?> context, BE resourceType) {
            return context.backend.traverseToSingle(resourceType, Query.path().with(Related.asTargetBy(Relationships.WellKnown.incorporates), With.type(MetadataPack.class)).get()) != null;
        }
    }
}

