/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.paths.CanonicalPath;
import org.junit.Assert;
import org.junit.Test;

public class StructuredDataTest {
    private static final CanonicalPath owner = (CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("t")).environment("e")).resource("r")).get();
    private StructuredData bool = StructuredData.get().bool(Boolean.valueOf(true));
    private StructuredData integral = StructuredData.get().integral(Long.valueOf(42L));
    private StructuredData floatingPoint = StructuredData.get().floatingPoint(Double.valueOf(1.0));
    private StructuredData string = StructuredData.get().string("kachny");
    private StructuredData list = ((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addIntegral(1L)).build();
    private StructuredData map = ((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("bool", true)).putIntegral("int", 1L)).build();
    private StructuredData listInList = ((StructuredData.ListBuilder)((StructuredData.InnerListBuilder)StructuredData.get().list().addList().addBool(true)).closeList()).build();
    private StructuredData mapInList = ((StructuredData.ListBuilder)((StructuredData.InnerMapBuilder)StructuredData.get().list().addMap().putIntegral("answer", 42L)).closeMap()).build();
    private StructuredData listInMap = ((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)StructuredData.get().map().putList("answer").addIntegral(42L)).closeList()).build();
    private StructuredData mapInMap = ((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)StructuredData.get().map().putMap("answer").putIntegral("answer, really", 42L)).closeMap()).build();

    @Test
    public void testBuilder() throws Exception {
        Assert.assertEquals((Object)42L, (Object)this.integral.getValue());
        Assert.assertEquals((Object)1.0, (Object)this.floatingPoint.getValue());
        Assert.assertEquals((Object)"kachny", (Object)this.string.getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((StructuredData)((List)((Object)this.list.getValue())).get(0)).getValue());
        Assert.assertEquals((Object)1L, (Object)((StructuredData)((List)((Object)this.list.getValue())).get(1)).getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((StructuredData)((Map)((Object)this.map.getValue())).get("bool")).getValue());
        Assert.assertEquals((Object)1L, (Object)((StructuredData)((Map)((Object)this.map.getValue())).get("int")).getValue());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((StructuredData)((List)((Object)((StructuredData)((List)((Object)this.listInList.getValue())).get(0)).getValue())).get(0)).getValue());
        Assert.assertEquals((Object)42L, (Object)((StructuredData)((Map)((Object)((StructuredData)((List)((Object)this.mapInList.getValue())).get(0)).getValue())).get("answer")).getValue());
        Assert.assertEquals((Object)42L, (Object)((StructuredData)((List)((Object)((StructuredData)((Map)((Object)this.listInMap.getValue())).get("answer")).getValue())).get(0)).getValue());
        Assert.assertEquals((Object)42L, (Object)((StructuredData)((Map)((Object)((StructuredData)((Map)((Object)this.mapInMap.getValue())).get("answer")).getValue())).get("answer, really")).getValue());
    }

    @Test
    public void testVisitors() throws Exception {
        this.bool.accept(StructuredData.Visitor.bool((b, p) -> {
            Assert.assertEquals((Object)true, (Object)b);
            return null;
        }), null);
        this.integral.accept(StructuredData.Visitor.integral((i, p) -> {
            Assert.assertEquals((Object)42L, (Object)i);
            return null;
        }), null);
        this.floatingPoint.accept(StructuredData.Visitor.floatingPoint((f, p) -> {
            Assert.assertEquals((Object)1.0, (Object)f);
            return null;
        }), null);
        this.string.accept(StructuredData.Visitor.string((s, p) -> {
            Assert.assertEquals((Object)"kachny", (Object)s);
            return null;
        }), null);
        this.list.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, Void>(){

            public Void visitList(List<StructuredData> value, Void parameter) {
                value.forEach(v -> {
                    Void cfr_ignored_0 = (Void)v.accept((StructuredData.Visitor)this, null);
                });
                return null;
            }

            public Void visitIntegral(long value, Void parameter) {
                Assert.assertEquals((long)1L, (long)value);
                return null;
            }
        }, null);
        this.mapInList.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, Void>(){

            public Void visitList(List<StructuredData> value, Void parameter) {
                value.forEach(v -> {
                    Void cfr_ignored_0 = (Void)v.accept((StructuredData.Visitor)this, null);
                });
                return null;
            }

            public Void visitIntegral(long value, Void parameter) {
                Assert.assertEquals((long)42L, (long)value);
                return null;
            }

            public Void visitMap(Map<String, StructuredData> value, Void parameter) {
                value.get("answer").accept((StructuredData.Visitor)this, null);
                return null;
            }
        }, null);
        this.listInMap.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, Void>(){

            public Void visitList(List<StructuredData> value, Void parameter) {
                value.forEach(v -> {
                    Void cfr_ignored_0 = (Void)v.accept((StructuredData.Visitor)this, null);
                });
                return null;
            }

            public Void visitIntegral(long value, Void parameter) {
                Assert.assertEquals((long)42L, (long)value);
                return null;
            }

            public Void visitMap(Map<String, StructuredData> value, Void parameter) {
                if (!value.containsKey("answer")) {
                    Assert.fail();
                }
                value.get("answer").accept((StructuredData.Visitor)this, null);
                return null;
            }
        }, null);
        this.mapInMap.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, Void>(){

            public Void visitIntegral(long value, Void parameter) {
                Assert.assertEquals((long)42L, (long)value);
                return null;
            }

            public Void visitMap(Map<String, StructuredData> value, Void parameter) {
                if (value.containsKey("answer")) {
                    value.get("answer").accept((StructuredData.Visitor)this, null);
                } else if (value.containsKey("answer, really")) {
                    value.get("answer, really").accept((StructuredData.Visitor)this, null);
                } else {
                    Assert.fail();
                }
                return null;
            }
        }, null);
    }

    @Test
    public void testModification() throws Exception {
        Assert.assertEquals((Object)false, (Object)this.bool.update().toBool(false).getValue());
        Assert.assertEquals((Object)2.0, (Object)this.bool.update().toFloatingPoint(2.0).getValue());
        Assert.assertEquals((Object)1L, (Object)this.bool.update().toIntegral(1L).getValue());
        Assert.assertEquals((Object)"kachny", (Object)this.bool.update().toString("kachny").getValue());
        Assert.assertEquals(Collections.emptyList(), (Object)this.bool.update().toList().build().getValue());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addIntegral(1L)).build(), (Object)((StructuredData.ListUpdater)((StructuredData.ListUpdater)this.bool.update().toList().addBool(true)).addIntegral(1L)).build());
        Assert.assertEquals(Collections.emptyMap(), (Object)this.bool.update().toMap().build().getValue());
        Assert.assertEquals((Object)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("true", true)).putString("str", "str")).build(), (Object)((StructuredData.MapUpdater)((StructuredData.MapUpdater)this.bool.update().toMap().putBool("true", true)).putString("str", "str")).build());
        Assert.assertEquals((Object)this.list, (Object)this.list.update().toList().build());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addString("str")).build(), (Object)((StructuredData.ListUpdater)this.list.update().toList().setString(1, "str")).build());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)((StructuredData.ListBuilder)((StructuredData.ListBuilder)StructuredData.get().list().addBool(true)).addIntegral(1L)).addUndefined()).build(), (Object)((StructuredData.ListUpdater)this.list.update().toList().addUndefined()).build());
        Assert.assertEquals((Object)StructuredData.get().list().build(), (Object)((StructuredData.ListUpdater)this.list.update().toList().clear()).build());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)StructuredData.get().list().addIntegral(1L)).build(), (Object)((StructuredData.ListUpdater)this.list.update().toList().remove(0)).build());
        Assert.assertEquals((Object)this.listInList, (Object)this.listInList.update().toList().build());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)((StructuredData.InnerListBuilder)StructuredData.get().list().addList().addUndefined()).closeList()).build(), (Object)((StructuredData.ListUpdater)((StructuredData.InnerListUpdater)this.listInList.update().toList().updateList(0).setUndefined(0)).closeList()).build());
        Assert.assertEquals((Object)((StructuredData.ListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)StructuredData.get().list().addList().addBool(true)).addBool(false)).closeList()).build(), (Object)((StructuredData.ListUpdater)((StructuredData.InnerListUpdater)this.listInList.update().toList().updateList(0).addBool(false)).closeList()).build());
        Assert.assertEquals((Object)this.map, (Object)this.map.update().toMap().build());
        Assert.assertEquals((Object)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("bool", true)).putString("int", "int")).build(), (Object)((StructuredData.MapUpdater)this.map.update().toMap().putString("int", "int")).build());
        Assert.assertEquals((Object)StructuredData.get().map().build(), (Object)((StructuredData.MapUpdater)this.map.update().toMap().clear()).build());
        Assert.assertEquals((Object)((StructuredData.MapBuilder)StructuredData.get().map().putBool("bool", true)).build(), (Object)((StructuredData.MapUpdater)this.map.update().toMap().remove("int")).build());
        Assert.assertEquals((Object)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("bool", true)).putIntegral("int", 1L)).putMap("new key").putString("p1", "a1")).closeMap()).build(), (Object)((StructuredData.MapUpdater)((StructuredData.InnerMapUpdater)this.map.update().toMap().updateMap("new key").putString("p1", "a1")).closeMap()).build());
    }
}

