/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.FeedAlreadyRegisteredException;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetadataPacks;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.Parents;
import org.hawkular.inventory.api.PathFragment;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.QueryFragment;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.ValidationException;
import org.hawkular.inventory.api.feeds.AcceptWithFallbackFeedIdStrategy;
import org.hawkular.inventory.api.feeds.RandomUUIDFeedIdStrategy;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.SwitchElementType;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.IdentityHash;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.SyncConfiguration;
import org.hawkular.inventory.api.model.SyncHash;
import org.hawkular.inventory.api.model.SyncRequest;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import rx.Observable;
import rx.Subscription;

public abstract class AbstractBaseInventoryTestsuite<E> {
    protected BaseInventory<E> inventory;

    protected static <E> void setupNewInventory(BaseInventory<E> inventory) throws Exception {
        Properties ps = new Properties();
        try (FileInputStream f = new FileInputStream(System.getProperty("graph.config"));){
            ps.load(f);
        }
        Configuration config = Configuration.builder().withFeedIdStrategy((FeedIdStrategy)new AcceptWithFallbackFeedIdStrategy((FeedIdStrategy)new RandomUUIDFeedIdStrategy())).withConfiguration(ps).build();
        inventory.initialize(config);
        try {
            inventory.tenants().delete((Object)"com.acme.tenant");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inventory.tenants().delete((Object)"com.example.tenant");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inventory.tenants().delete((Object)"perf0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static <E> void setupData(BaseInventory<E> inventory) throws Exception {
        ((Tenants.Multiple)inventory.tenants().getAll(new Filter[0])).entities().forEach(t -> inventory.inspect(t).delete());
        assert (((Tenant)((Tenants.Single)inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("com.acme.tenant")).withProperty("kachny", (Object)"moc")).build())).entity()).getId().equals("com.acme.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)new Environment.Blueprint("production"))).entity()).getId().equals("production"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).create((Blueprint)new ResourceType.Blueprint("URL"))).entity()).getId().equals("URL"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).metricTypes()).create((Blueprint)new MetricType.Blueprint("ResponseTime", MetricUnit.MILLISECONDS, MetricDataType.COUNTER, Long.valueOf(0L)))).entity()).getId().equals("ResponseTime"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"URL")).metricTypes()).associate(((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).metricType("ResponseTime")).get());
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metrics()).create((Blueprint)new Metric.Blueprint("/ResponseTime", "host1_ping_response"))).entity()).getId().equals("host1_ping_response"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).create((Blueprint)new Resource.Blueprint("host1", "/URL"))).entity()).getId().equals("host1"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).get((Object)"host1")).allMetrics()).associate((Path)RelativePath.fromString((String)"../m;host1_ping_response"));
        assert (((Feed)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).create((Blueprint)new Feed.Blueprint("feed1", null))).entity()).getId().equals("feed1"));
        ((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feeds()).associate((Path)RelativePath.fromString((String)"../f;feed1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource1", "/URL"))).entity()).getId().equals("feedResource1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource2", "/URL"))).entity()).getId().equals("feedResource2"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).create((Blueprint)new Resource.Blueprint("feedResource3", "/URL"))).entity()).getId().equals("feedResource3"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metrics()).create((Blueprint)new Metric.Blueprint("/ResponseTime", "feedMetric1"))).entity()).getId().equals("feedMetric1"));
        assert (((Tenant)((Tenants.Single)inventory.tenants().create((Blueprint)new Tenant.Blueprint("com.example.tenant"))).entity()).getId().equals("com.example.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).create((Blueprint)new Environment.Blueprint("test"))).entity()).getId().equals("test"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).create((Blueprint)new ResourceType.Blueprint("Kachna"))).entity()).getId().equals("Kachna"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).create((Blueprint)new ResourceType.Blueprint("Playroom", (Map)new HashMap<String, Object>(){
            {
                this.put("ownedByDepartment", "Facilities");
            }
        }))).entity()).getId().equals("Playroom"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).metricTypes()).create((Blueprint)new MetricType.Blueprint("Size", MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)))).entity()).getId().equals("Size"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).get((Object)"Playroom")).metricTypes()).associate(RelativePath.to().up().metricType("Size").get());
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).create((Blueprint)new Metric.Blueprint("/Size", "playroom1_size"))).entity()).getId().equals("playroom1_size"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).create((Blueprint)new Metric.Blueprint("/Size", "playroom2_size"))).entity()).getId().equals("playroom2_size"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).create((Blueprint)new Resource.Blueprint("playroom1", "/Playroom"))).entity()).getId().equals("playroom1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).create((Blueprint)new Resource.Blueprint("playroom2", "/Playroom"))).entity()).getId().equals("playroom2"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).allMetrics()).associate(RelativePath.to().up().metric("playroom1_size").get());
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom2")).allMetrics()).associate(((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get());
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).resources()).create((Blueprint)new Resource.Blueprint("playroom1.1", "/Playroom"))).entity()).getId().equals("playroom1.1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).resources()).create((Blueprint)new Resource.Blueprint("playroom1.2", "/Playroom"))).entity()).getId().equals("playroom1.2"));
        ((Resources.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).allResources()).associate(((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).resource("playroom2")).get());
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom2")).resources()).create((Blueprint)new Resource.Blueprint("playroom2.1", "/Playroom"))).entity()).getId().equals("playroom2.1"));
        Environment test = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).entity();
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom2")).allMetrics()).get((Object)((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get())).relationships(Relationships.Direction.outgoing)).linkWith("yourMom", ((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), null);
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom2")).allMetrics()).get((Object)((CanonicalPath.MetricBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).metric("playroom2_size")).get())).relationships(Relationships.Direction.incoming)).linkWith("IamYourFather", ((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), (Map)new HashMap<String, Object>(){
            {
                this.put("adult", true);
            }
        });
        StructuredData config = ((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("yes", true)).putBool("no", false)).putIntegral("answer", 42L)).putFloatingPoint("approximateAnswer", 42.0)).putString("kachna", "moc")).putUndefined("nothingToSeeHere")).putList("primitives").addBool(true)).addIntegral(1L)).addFloatingPoint(2.0)).addString("str")).addUndefined()).closeList()).putMap("primitiveMap").putBool("bool", true)).putFloatingPoint("float", 1.0)).putIntegral("int", 2L)).putString("str", "kachna")).putUndefined("undef")).closeMap()).putList("listOfMaps").addMap().putBool("listOfMaps_bool", true)).putString("listOfMaps_string", "kachny")).closeMap()).addMap().putFloatingPoint("listOfMaps_float", 1.0)).closeMap()).closeList()).putList("listOfLists").addList().addBool(true)).addIntegral(1L)).closeList()).closeList()).putMap("mapOfLists").putList("list1").addString("ducks")).addUndefined()).closeList()).putList("list2").addBool(false)).addFloatingPoint(2.0)).closeList()).closeMap()).putMap("mapOfMaps").putMap("map1").putIntegral("int", 42L)).putString("answer", "probably")).closeMap()).putMap("map2").putFloatingPoint("float", 2.0)).closeMap()).closeMap()).build();
        assert (((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(config).build()).entity().getValue().equals((Object)config));
        ResourceTypes.Single personType = (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("Person")).build());
        ((Data.ReadWrite)personType.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(((StructuredData.MapBuilder)((StructuredData.InnerListBuilder)((StructuredData.InnerListBuilder)((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "Person")).putString("description", "Utterly complete description of a human.")).putString("type", "object")).putMap("properties").putMap("firstName").putString("type", "string")).closeMap()).putMap("lastName").putString("type", "string")).closeMap()).putMap("age").putString("description", "Age in years")).putString("type", "integer")).putIntegral("minimum", 0L)).closeMap()).closeMap()).putList("required").addString("firstName")).addString("lastName")).closeList()).build()).build());
        OperationTypes.Single startOp = (OperationTypes.Single)((OperationTypes.ReadWrite)personType.operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("start")).build());
        ((Data.ReadWrite)startOp.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "start_returnType")).putString("description", "start operation result")).putString("type", "boolean")).build()).build());
        ((Data.ReadWrite)startOp.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.parameterTypes).withValue(((StructuredData.MapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.InnerMapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "start_paramTypes")).putString("description", "start operation parameter types")).putString("type", "object")).putMap("properties").putMap("quick").putString("type", "boolean")).closeMap()).closeMap()).build()).build());
        Resources.Single people = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("people")).withResourceTypePath("/Person").build());
        ((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("Alois")).withResourceTypePath("/Person").build())).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("firstName", "Alois")).putString("lastName", "Jirasek")).build()).build());
        ((Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("Hynek")).withResourceTypePath("/Person").build())).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("firstName", "Hynek")).putString("lastName", "Macha")).build()).build());
        ((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.resources()).get((Object)"Hynek")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("/Person").withId("Vilem")).build());
        ((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)people.resources()).get((Object)"Hynek")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("/Person").withId("Jarmila")).build());
        ((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("mpRt")).withName("Resource Type in a metadata pack")).build());
        ((Data.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"mpRt")).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "mpRtCs")).putString("type", "string")).build()).build());
        ((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"mpRt")).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("mpRtOt")).build());
        ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"mpRt")).operationTypes()).get((Object)"mpRtOt")).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "mpRtOtRet")).putString("type", "string")).build()).build());
        ((MetricTypes.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mpMt")).withUnit(MetricUnit.NONE).withInterval(Long.valueOf(0L)).build());
        ((MetadataPacks.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).metadataPacks()).create((Blueprint)MetadataPack.Blueprint.builder().withMembers(new CanonicalPath[]{CanonicalPath.fromString((String)"/t;com.acme.tenant/rt;mpRt"), CanonicalPath.fromString((String)"/t;com.acme.tenant/mt;mpMt")}).build());
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).get((Object)"feedResource3")).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("feedResource3-metric")).withMetricTypePath("/ResponseTime").build())).entity()).getId().equals("feedResource3-metric"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("feed1-resourceType")).build())).entity()).getId().equals("feed1-resourceType"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("feed1-metricType")).withUnit(MetricUnit.NONE).withInterval(Long.valueOf(0L)).build())).entity()).getId().equals("feed1-metricType"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).get((Object)"feedResource1")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("feedChildResource")).withResourceTypePath("/URL").build())).entity()).getId().equals("feedChildResource"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <E> void teardownData(BaseInventory<E> inventory) throws Exception {
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get();
        CanonicalPath environmentPath = tenantPath.extend(Environment.SEGMENT_TYPE, "test").get();
        try {
            Tenant t = new Tenant(tenantPath, null);
            Environment e = new Environment(environmentPath, null);
            MetricType sizeType = new MetricType(tenantPath.extend(MetricType.SEGMENT_TYPE, "Size").get(), null, null, null);
            ResourceType playRoomType = new ResourceType(tenantPath.extend(ResourceType.SEGMENT_TYPE, "Playroom").get(), null, null, null);
            ResourceType kachnaType = new ResourceType(tenantPath.extend(ResourceType.SEGMENT_TYPE, "Kachna").get(), null, null, null);
            Resource playroom1 = new Resource(environmentPath.extend(Resource.SEGMENT_TYPE, "playroom1").get(), null, null, null, playRoomType);
            Resource playroom2 = new Resource(environmentPath.extend(Resource.SEGMENT_TYPE, "playroom2").get(), null, null, null, playRoomType);
            Metric playroom1Size = new Metric(environmentPath.extend(Metric.SEGMENT_TYPE, "playroom1_size").get(), null, null, null, sizeType);
            Metric playroom2Size = new Metric(environmentPath.extend(Metric.SEGMENT_TYPE, "playroom2_size").get(), null, null, null, sizeType);
            ((Metrics.ReadAssociate)inventory.inspect(playroom2).allMetrics()).disassociate((Path)playroom2Size.getPath());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)inventory.inspect(playroom2).allMetrics()).get((Object)playroom2Size.getPath())).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)inventory.inspect(playroom2).allMetrics()).get((Object)RelativePath.to().up().metric(playroom2Size.getId()).get())).exists());
            inventory.inspect(playroom2Size).delete();
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)playroom2Size);
            AbstractBaseInventoryTestsuite.assertExists(inventory, new Entity[]{t, e, sizeType, playRoomType, kachnaType, playroom1, playroom2, playroom1Size});
            ((Metrics.ReadAssociate)inventory.inspect(playroom1).allMetrics()).disassociate(RelativePath.to().up().metric(playroom1Size.getId()).get());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)inventory.inspect(playroom1).allMetrics()).get((Object)playroom1Size.getPath())).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadAssociate)inventory.inspect(playroom1).allMetrics()).get((Object)RelativePath.to().up().metric(playroom1Size.getId()).get())).exists());
            ((ResourceTypes.ReadWrite)inventory.inspect(t).resourceTypes()).delete((Object)kachnaType.getId());
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)kachnaType);
            AbstractBaseInventoryTestsuite.assertExists(inventory, new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2, playroom1Size});
            try {
                ((MetricTypes.ReadWrite)inventory.inspect(t).metricTypes()).delete((Object)sizeType.getId());
                Assert.fail((String)"Deleting a metric type which references some metrics should not be possible.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ((Metrics.ReadWrite)inventory.inspect(e).metrics()).delete((Object)playroom1Size.getId());
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)playroom1Size);
            AbstractBaseInventoryTestsuite.assertExists(inventory, new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2});
            ((MetricTypes.ReadWrite)inventory.inspect(t).metricTypes()).delete((Object)sizeType.getId());
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)sizeType);
            AbstractBaseInventoryTestsuite.assertExists(inventory, new Entity[]{t, e, playRoomType, playroom1, playroom2});
            try {
                ((ResourceTypes.ReadWrite)inventory.inspect(t).resourceTypes()).delete((Object)playRoomType.getId());
                Assert.fail((String)"Deleting a resource type which references some resources should not be possible.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ((Resources.ReadWrite)inventory.inspect(e).resources()).delete((Object)playroom1.getId());
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)playroom1);
            AbstractBaseInventoryTestsuite.assertExists(inventory, new Entity[]{t, e, playRoomType, playroom2});
            inventory.tenants().delete((Object)t.getId());
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)t);
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)e);
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)playRoomType);
            AbstractBaseInventoryTestsuite.assertDoesNotExist(inventory, (Entity)playroom2);
        }
        finally {
            Tenants.Single tenant = (Tenants.Single)inventory.inspect(tenantPath, Tenants.Single.class);
            if (tenant.exists()) {
                tenant.delete();
            }
            inventory.tenants().delete((Object)"com.acme.tenant");
        }
    }

    private static void assertDoesNotExist(BaseInventory<?> inventory, Entity e) {
        try {
            inventory.inspect((AbstractElement)e, ResolvableToSingle.class).entity();
            Assert.fail((String)(e + " should have been deleted"));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private static void assertExists(BaseInventory<?> inventory, Entity<?, ?> e) {
        Assert.assertTrue((String)("Entity should exist: " + e), (boolean)inventory.inspect(e, ResolvableToSingle.class).exists());
    }

    private static void assertExists(BaseInventory<?> inventory, Entity ... es) {
        Stream.of(es).forEach(e -> AbstractBaseInventoryTestsuite.assertExists(inventory, e));
    }

    protected abstract BaseInventory<E> getInventoryForTest();

    @Before
    public final void setupData() throws Exception {
        this.inventory = this.getInventoryForTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTenants() throws Exception {
        Function<String, Void> test = id -> {
            Query query = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)id)})).build();
            InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
            try {
                Page results = bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
                Assert.assertTrue((boolean)results.hasNext());
                Object tenant = results.next();
                Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
                String eid = this.inventory.getBackend().extractId(tenant);
                Assert.assertEquals((Object)id, (Object)eid);
            }
            finally {
                bcknd.rollback();
            }
            return null;
        };
        test.apply("com.acme.tenant");
        test.apply("com.example.tenant");
        Query query = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Tenant.class))}).build();
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Page results = bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertTrue((boolean)results.hasNext());
            results.next();
            Assert.assertTrue((boolean)results.hasNext());
            results.next();
            Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
        }
        finally {
            bcknd.rollback();
        }
    }

    @Test
    public void testEntitiesByRelationships() throws Exception {
        Function<Function, Page> inTx = f -> {
            InventoryBackend backend = this.inventory.getBackend().startTransaction();
            Page ret = (Page)f.apply(backend);
            this.inventory.getBackend().rollback();
            return ret;
        };
        Function<Integer, Function> testHelper = numberOfParents -> parentType -> edgeLabel -> numberOfKids -> childType -> multipleParents -> multipleChildren -> {
            Page parents = (Page)inTx.apply(b -> b.query(Query.path().with(new Filter[]{With.type((Class)parentType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})));
            List parentsList = parents.toList();
            Page children = (Page)inTx.apply(b -> b.query(Query.path().with(new Filter[]{With.type((Class)parentType), Related.by((String)edgeLabel), With.type((Class)childType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})));
            List childrenList = children.toList();
            Assert.assertEquals((String)("There must be exactly " + numberOfParents + " " + parentType + "s " + "that " + "have outgoing edge labeled with " + edgeLabel + ". Backend query returned only " + parentsList.size()), (long)numberOfParents.intValue(), (long)parentsList.size());
            Assert.assertEquals((String)("There must be exactly " + numberOfParents + " " + parentType + "s that have outgoing edge labeled with " + edgeLabel + ". Tested API returned only " + multipleParents.entities().size()), (long)numberOfParents.intValue(), (long)multipleParents.entities().size());
            Assert.assertEquals((String)("There must be exactly " + numberOfKids + " " + childType + "s that are directly under " + parentType + " connected with " + edgeLabel + ". Gremlin query returned only " + childrenList.size()), (long)numberOfKids.intValue(), (long)childrenList.size());
            Assert.assertEquals((long)numberOfKids.intValue(), (long)multipleChildren.entities().size());
        };
        ResolvableToMany parents = (ResolvableToMany)this.inventory.tenants().getAll(new Filter[]{Related.by((String)"contains")});
        ResolvableToMany kids = (ResolvableToMany)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(2)).apply(Environment.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((ResourceTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).resourceTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(5)).apply(ResourceType.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((MetricTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).metricTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(3)).apply(MetricType.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.by((String)"contains")});
        kids = (ResolvableToMany)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).metrics()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(3)).apply(Metric.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((Resources.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).resources()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(4)).apply(Resource.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).metricTypesUnder((Tenants.MetricTypeParents[])Parents.any()).getAll(new Filter[0]);
        kids = (ResolvableToMany)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).metricsUnder((Environments.MetricParents[])Parents.any()).getAll(new Filter[0]);
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(4).apply(MetricType.class)).apply("defines")).apply(5)).apply(Metric.class)).apply(parents)).accept(kids);
    }

    @Test
    public void testRelationshipServiceNamed1() throws Exception {
        Set contains = ((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getSegment().getElementId()) && "URL".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.acme.tenant' must contain ResourceType 'URL'.";
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getSegment().getElementId()) && "production".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.acme.tenant' must contain Environment 'production'.";
        assert (contains.stream().anyMatch(rel -> "com.example.tenant".equals(rel.getSource().getSegment().getElementId()) && "Size".equals(rel.getTarget().getSegment().getElementId()))) : "Tenant 'com.example.tenant' must contain MetricType 'Size'.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceNamed2() throws Exception {
        Set contains = ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom1'.";
        assert (contains.stream().anyMatch(rel -> "playroom2".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom2'.";
        assert (contains.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom2_size'.";
        assert (contains.stream().anyMatch(rel -> "playroom1_size".equals(rel.getTarget().getSegment().getElementId()))) : "Environment 'test' must contain 'playroom1_size'.";
        assert (contains.stream().allMatch(rel -> !"production".equals(rel.getSource().getSegment().getElementId()))) : "Environment 'production' cant be the source of these relationships.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceLinkedWith() throws Exception {
        Set rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getTarget().getSegment().getElementId())) : "Target of relationship 'yourMom' should be the 'test' environment";
        rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.both)).named("IamYourFather").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getSource().getSegment().getElementId())) : "Source of relationship 'IamYourFather' should be the 'test' environment";
    }

    @Test
    public void testRelationshipServiceLinkedWithAndDelete() throws Exception {
        Relationship link = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).get((Object)"host1")).relationships(Relationships.Direction.incoming)).linkWith("crossTenantLink", ((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null)).entity();
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).named("crossTenantLink").entities().size() == 1) : "Relation 'crossTenantLink' was not found.";
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(link.getId());
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).named("crossTenantLink").entities().size() == 0) : "Relation 'crossTenantLink' was found.";
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(link.getId());
            assert (false) : "It shouldn't be possible to delete the same relationship twice";
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceUpdateRelationship1() throws Exception {
        String someKey = "k3y";
        String someValue = "v4lu3";
        Relationship rel1 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (null == rel1.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        Relationship rel2 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel2.getId()) && null == rel2.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).update(rel1.getId(), ((Relationship.Update.Builder)Relationship.Update.builder().withProperty("k3y", (Object)"v4lu3")).build());
        Relationship rel3 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).metrics()).get((Object)"playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel3.getId()) && "v4lu3".equals(rel3.getProperties().get("k3y"))) : "There should be the property with key 'k3y' and value 'v4lu3'";
    }

    @Test
    public void testRelationshipServiceGetAllFilters() throws Exception {
        Set rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 4) : "There should be 4 relationships conforming the filters";
        assert (rels.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getSegment().getElementId())));
        assert (rels.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getSegment().getElementId())));
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains"), RelationWith.targetOfType(Metric.class)})).entities();
        assert (rels != null && rels.size() == 2) : "There should be 2 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> SegmentType.m.equals((Object)rel.getTarget().getSegment().getElementType()))) : "The type of all the targets should be the 'Metric'";
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.incoming)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 1) : "There should be just 1 relationship conforming the filters";
        assert ("com.example.tenant".equals(((Relationship)rels.iterator().next()).getSource().getSegment().getElementId())) : "Tenant 'com.example.tenant' was not found";
        rels = ((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).entities();
        assert (rels != null && rels.size() == 7) : "There should be 6 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> "test".equals(rel.getSource().getSegment().getElementId()) || "production".equals(rel.getSource().getSegment().getElementId()))) : "Source should be either 'test' or 'production'";
        assert (rels.stream().allMatch(rel -> SegmentType.r.equals((Object)rel.getTarget().getSegment().getElementType()) || SegmentType.m.equals((Object)rel.getTarget().getSegment().getElementType()))) : "Target should be either a metric or a resource";
    }

    @Test
    public void testRelationshipServiceGetAllFiltersWithSubsequentCalls() throws Exception {
        Metric metric = (Metric)((Metrics.Multiple)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).metrics().getAll(new Filter[]{With.id((String)"playroom1_size")})).entities().iterator().next();
        assert ("playroom1_size".equals(metric.getId())) : "Metric playroom1_size was not found using various relation filters";
        try {
            ((Metrics.Multiple)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class})})).metrics().getAll(new Filter[]{With.id((String)"playroom1_size")})).entities().iterator().next();
            assert (false) : "this code should not be reachable. There should be no metric reachable under 'RelationWith.targetsOfTypes(Resource.class))' filter";
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceCallChaining() throws Exception {
        MetricType metricType = (MetricType)((MetricTypes.Single)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).get((Object)"Playroom")).relationships()).named("incorporates").metricTypes().get((Object)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).metricType("Size")).get())).entity();
        assert ("Size".equals(metricType.getId())) : "ResourceType[Playroom] -incorporates-> MetricType[Size] was not found";
        try {
            ((MetricTypes.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).get((Object)"Playroom")).relationships()).named("contains").metricTypes().getAll(new Filter[]{With.id((String)"Size")})).entities().iterator().next();
            assert (false) : "There is no such an entity satisfying the query, this code shouldn't be reachable";
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Set resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).get((Object)"Playroom")).relationships()).named("defines").resources().getAll(new Filter[0])).entities();
        assert (resources.stream().allMatch(res -> Arrays.asList("playroom1", "playroom2", "playroom1.1", "playroom1.2", "playroom2.1").contains(res.getId()))) : "ResourceType[Playroom] -defines-> resources called playroom*";
        resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).resourceTypes()).get((Object)"Playroom")).relationships()).named("incorporates").resources().getAll(new Filter[0])).entities();
        assert (resources.isEmpty()) : "No resources should be found under the relationship called incorporates from resource type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnvironments() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query q = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)id)})).build();
            Environment env = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(id)).entity();
            Assert.assertEquals((Object)id, (Object)env.getId());
            InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
            try {
                Page envs = bcknd.query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
                Assert.assertTrue((boolean)envs.hasNext());
                env = (Environment)this.inventory.getBackend().convert(envs.next(), Environment.class);
                Assert.assertTrue((!envs.hasNext() ? 1 : 0) != 0);
                Assert.assertEquals((Object)id, (Object)env.getId());
            }
            finally {
                bcknd.rollback();
            }
            return null;
        };
        test.apply("com.acme.tenant", "production");
        test.apply("com.example.tenant", "test");
        Query q = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Environment.class))}).build();
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Assert.assertEquals((long)2L, (long)bcknd.query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
        }
        finally {
            bcknd.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceTypes() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)id)}).get();
            InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
            try {
                Page results = bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
                Assert.assertTrue((boolean)results.hasNext());
            }
            finally {
                bcknd.rollback();
            }
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(id)).entity();
            assert (rt.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL");
        test.apply("com.example.tenant", "Kachna");
        test.apply("com.example.tenant", "Playroom");
        Query query = Query.path().with(new Filter[]{With.type(ResourceType.class)}).get();
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Assert.assertEquals((long)6L, (long)bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
        }
        finally {
            bcknd.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricDefinitions() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(MetricType.class), With.id((String)id)}).get();
            InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
            try {
                assert (bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).hasNext());
            }
            finally {
                bcknd.rollback();
            }
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).metricTypes()).get(id)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "ResponseTime");
        test.apply("com.example.tenant", "Size");
        Query query = Query.path().with(new Filter[]{With.type(MetricType.class)}).get();
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Assert.assertEquals((long)4L, (long)bcknd.query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
        }
        finally {
            bcknd.rollback();
        }
    }

    @Test
    public void testMetricTypesLinkedToResourceTypes() throws Exception {
        TetraFunction<String, String, String, CanonicalPath, Void> test = (tenantId, resourceTypeId, id, path) -> {
            Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)resourceTypeId), Related.by((Relationships.WellKnown)Relationships.WellKnown.incorporates), With.type(MetricType.class), With.id((String)id)}).get();
            InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
            try {
                assert (bcknd.query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).hasNext());
            }
            finally {
                bcknd.rollback();
            }
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).metricTypes()).get(path)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL", "ResponseTime", (CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).metricType("ResponseTime")).get());
        test.apply("com.example.tenant", "Playroom", "Size", (CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).metricType("Size")).get());
    }

    @Test
    public void testMetrics() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, metricDefId, id) -> {
            Metric m = (Metric)((Metrics.Multiple)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).metrics()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metricType(metricDefId)).get()))}, {With.id((String)id)}})).entities().iterator().next();
            assert (m.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "ResponseTime", "host1_ping_response");
        test.apply("com.example.tenant", "test", "Size", "playroom1_size");
        test.apply("com.example.tenant", "test", "Size", "playroom2_size");
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Assert.assertEquals((long)5L, (long)bcknd.query(Query.path().with(new Filter[]{With.type(Metric.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
        }
        finally {
            bcknd.rollback();
        }
    }

    @Test
    public void testResources() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceTypeId, id) -> {
            Resource r = (Resource)((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).resources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).resourceType(resourceTypeId)).get()))}, {With.id((String)id)}})).entities().iterator().next();
            assert (r.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "URL", "host1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom2");
        InventoryBackend bcknd = this.inventory.getBackend().startTransaction();
        try {
            Assert.assertEquals((long)15L, (long)this.inventory.getBackend().query(Query.path().with(new Filter[]{With.type(Resource.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).toList().size());
        }
        finally {
            bcknd.rollback();
        }
    }

    @Test
    public void testResourcesFilteredByTypeProperty() throws Exception {
        Set resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"Facilities")}})).entities();
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList("playroom1", "playroom2")), resources.stream().map(AbstractElement::getId).collect(Collectors.toSet()));
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"kachny")}})).entities();
        Assert.assertTrue((boolean)resources.isEmpty());
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).getAll((Filter[][])new Filter[][]{{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.propertyValue((String)"ownedByDepartment", (Object)"Facilities")}, {With.id((String)"playroom1")}})).entities();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"playroom1", (Object)((Resource)resources.iterator().next()).getId());
        resources = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).getAll(new Filter[]{Defined.by((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get())), With.id((String)"playroom1")})).entities();
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)"playroom1", (Object)((Resource)resources.iterator().next()).getId());
    }

    @Test
    public void testAssociateMetricWithResource() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceId, metricId) -> {
            Metric m = (Metric)((Metrics.Multiple)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).resources()).get(resourceId)).allMetrics()).getAll(new Filter[]{With.id((String)metricId)})).entities().iterator().next();
            assert (metricId.equals(m.getId()));
            return null;
        };
        test.apply("com.acme.tenant", "production", "host1", "host1_ping_response");
        test.apply("com.example.tenant", "test", "playroom1", "playroom1_size");
        test.apply("com.example.tenant", "test", "playroom2", "playroom2_size");
    }

    @Test
    public void testOperationTypes() throws Exception {
        OperationTypes.Single ots = (OperationTypes.Single)((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"Person")).operationTypes()).get((Object)"start");
        Assert.assertNotNull((Object)ots.entity());
        ots = (OperationTypes.Single)this.inventory.inspect((CanonicalPath)((CanonicalPath.OperationTypeBuilder)((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).resourceType("Person")).operationType("start")).get(), OperationTypes.Single.class);
        Assert.assertEquals((Object)"start", (Object)((OperationType)ots.entity()).getId());
        StructuredData returnTypeSchema = ((Data.Single)((Data.ReadWrite)ots.data()).get((Object)DataRole.OperationType.returnType)).entity().getValue();
        StructuredData parametersSchema = ((Data.Single)((Data.ReadWrite)ots.data()).get((Object)DataRole.OperationType.parameterTypes)).entity().getValue();
        Assert.assertEquals((Object)"start_returnType", (Object)((StructuredData)returnTypeSchema.map().get("title")).string());
        Assert.assertEquals((Object)"boolean", (Object)((StructuredData)returnTypeSchema.map().get("type")).string());
        Assert.assertEquals((Object)"start_paramTypes", (Object)((StructuredData)parametersSchema.map().get("title")).string());
    }

    @Test
    public void queryMultipleTenants() throws Exception {
        Set tenants = ((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)tenants.size());
    }

    @Test
    public void queryMultipleEnvironments() throws Exception {
        Set environments = ((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).entities();
        assert (environments.size() == 2);
    }

    @Test
    public void queryMultipleResourceTypes() throws Exception {
        Set types = ((ResourceTypes.Multiple)((ResourceTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).resourceTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)5L, (long)types.size());
    }

    @Test
    public void queryMultipleMetricDefs() throws Exception {
        Set types = ((MetricTypes.Multiple)((MetricTypes.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).metricTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)types.size());
    }

    @Test
    public void queryMultipleResources() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).resources()).getAll(new Filter[0])).entities();
        assert (rs.size() == 4);
    }

    @Test
    public void queryMultipleMetrics() throws Exception {
        Set ms = ((Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).metrics()).getAll(new Filter[0])).entities();
        assert (ms.size() == 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoTwoFeedsWithSameID() throws Exception {
        Feed f2;
        block9: {
            Feed f1 = null;
            f2 = null;
            try {
                Feeds.ReadWrite feeds = (Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds();
                f1 = (Feed)((Feeds.Single)feeds.create((Blueprint)new Feed.Blueprint("feed", null))).entity();
                try {
                    f2 = (Feed)((Feeds.Single)feeds.create((Blueprint)new Feed.Blueprint("feed", null))).entity();
                }
                catch (FeedAlreadyRegisteredException feedAlreadyRegisteredException) {
                    // empty catch block
                }
                f2 = (Feed)((Feeds.Single)feeds.create((Blueprint)new Feed.Blueprint(null, null))).entity();
                assert (f1.getId().equals("feed"));
                assert (!f1.getId().equals(f2.getId()));
                if (f1 == null) break block9;
            }
            catch (Throwable throwable) {
                if (f1 != null) {
                    this.inventory.inspect(f1).delete();
                }
                if (f2 != null) {
                    this.inventory.inspect(f2).delete();
                }
                throw throwable;
            }
            this.inventory.inspect(f1).delete();
        }
        if (f2 != null) {
            this.inventory.inspect(f2).delete();
        }
    }

    @Test
    public void testNoTwoEquivalentEntitiesOnTheSamePath() throws Exception {
        try {
            this.inventory.tenants().create((Blueprint)new Tenant.Blueprint("com.acme.tenant"));
            Assert.fail((String)"Creating tenant with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)new Environment.Blueprint("production"));
            Assert.fail((String)"Creating environment with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).create((Blueprint)new Resource.Blueprint("host1", "URL"));
            Assert.fail((String)"Creating resource with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContainsLoopsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", ((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", ((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships(Relationships.Direction.outgoing)).linkWith("contains", ((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", ((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get(), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsDiamondsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", ((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).resourceType("URL")).get(), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"URL")).relationships(Relationships.Direction.incoming)).linkWith("contains", ((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get(), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertiesCreated() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        Assert.assertEquals((long)1L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"moc", t.getProperties().get("kachny"));
    }

    @Test
    public void testPropertiesUpdatedOnEntities() throws Exception {
        this.inventory.tenants().update((Object)"com.acme.tenant", (Object)((Tenant.Update.Builder)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        Assert.assertEquals((long)2L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"many", t.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", t.getProperties().get("hammer"));
        ((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).update((Object)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("kachny", (Object)"moc")).build());
        this.testPropertiesCreated();
    }

    @Test
    public void testPropertiesUpdatedOnRelationships() throws Exception {
        Relationship r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), ((Relationship.Update.Builder)((Relationship.Update.Builder)Relationship.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        r = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).get(r.getId())).entity();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"many", r.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", r.getProperties().get("hammer"));
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), new Relationship.Update(null));
        r = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).get(r.getId())).entity();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
    }

    @Test
    public void testPropertiesUpdateOnRelationshipsToEmpty() throws Exception {
        String tenantName = "com.acme.tenant";
        Relationship r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), ((Relationship.Update.Builder)((Relationship.Update.Builder)Relationship.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        r = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).get(r.getId())).entity();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"many", r.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", r.getProperties().get("hammer"));
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).update(r.getId(), new Relationship.Update(new HashMap()));
        r = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships()).get(r.getId())).entity();
        Assert.assertEquals((long)0L, (long)r.getProperties().size());
    }

    @Test
    public void testCreationMetricTypeWithProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("p1", "1");
        properties.put("p2", "2");
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("testCreationMetricTypeWithProperties")).build())).metricTypes()).create((Blueprint)new MetricType.Blueprint("test", MetricUnit.BYTES, MetricDataType.COUNTER, properties, Long.valueOf(0L)));
        Assert.assertThat((Object)((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"testCreationMetricTypeWithProperties")).metricTypes()).get((Object)"test")).entity()).getProperties().size(), (Matcher)IsEqual.equalTo((Object)properties.size()));
        this.inventory.tenants().delete((Object)"testCreationMetricTypeWithProperties");
    }

    @Test
    public void testPaging() throws Exception {
        List allResults = ((Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).metrics()).getAll(new Filter[0])).entities(Pager.unlimited((Order[])new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)})).toList();
        assert (allResults.size() == 3);
        Pager firstPage = new Pager(0, 1, new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)});
        Metrics.Multiple metrics = (Metrics.Multiple)((Metrics.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).metrics()).getAll(new Filter[0]);
        Page ms = metrics.entities(firstPage);
        List msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(1)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)msList.get(0)).equals(allResults.get(2)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        msList = ms.toList();
        assert (ms.getTotalSize() == 3L);
        assert (msList.size() == 0);
        firstPage = new Pager(0, 1, new Order[]{Order.unspecified()});
        ms = metrics.entities(firstPage);
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        msList = ms.toList();
        assert (msList.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(msList.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        msList = ms.toList();
        assert (ms.getTotalSize() == 3L);
        assert (msList.size() == 0);
    }

    @Test
    public void testGettingResourcesFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder(new Environments.ResourceParents[]{Environments.ResourceParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource1".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource2".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource3".equals(r.getId())));
    }

    @Test
    public void testGettingMetricsFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder((Environments.MetricParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "host1_ping_response".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedMetric1".equals(r.getId())));
    }

    @Test
    public void testFilterByPropertyValues() throws Exception {
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"kachny")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"v-kachna")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"moc")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"malo")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"moc", "malo"})})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"hodne", "malo"})})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"adult")})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"infant")})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)true)})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)false)})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"adult", (Object[])new Object[]{false, true})})).anyExists());
    }

    @Test
    public void testResourceHierarchy() throws Exception {
        Resources.Single res = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1");
        Pager pager = Pager.unlimited((Order[])new Order[]{Order.unspecified()});
        Page children = ((Resources.Multiple)((Resources.ReadWrite)res.resources()).getAll(new Filter[0])).entities(pager);
        Assert.assertEquals((long)2L, (long)children.toList().size());
        children = ((Resources.Multiple)((Resources.ReadAssociate)res.allResources()).getAll(new Filter[0])).entities(pager);
        Assert.assertEquals((long)3L, (long)children.toList().size());
        children = ((Resources.Multiple)((Resources.ReadAssociate)res.allResources()).getAll(new Filter[]{Related.asTargetWith((CanonicalPath)((Resource)res.entity()).getPath(), (Relationships.WellKnown)Relationships.WellKnown.isParentOf)})).entities(pager);
        Assert.assertEquals((long)3L, (long)children.toList().size());
    }

    @Test
    public void testResourceHierarchyNoLoopsPossible() throws Exception {
        CanonicalPath t = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get();
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).relationships(Relationships.Direction.outgoing)).linkWith(Relationships.WellKnown.isParentOf, (Path)t, null);
            Assert.fail((String)"Should not be able to create self-loop in isParentOf using generic relationships");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).entity();
        try {
            ((Resources.ReadAssociate)this.inventory.inspect(r).allResources()).associate((Path)r.getPath());
            Assert.fail((String)"Should not be able to create self-loop in isParentOf using resource association interface.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Resource r2 = (Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.inspect(t, Tenants.Single.class)).environments()).get((Object)"test")).resources()).get((Object)"playroom2")).entity();
        try {
            ((Relationships.ReadWrite)this.inventory.inspect(r2).relationships(Relationships.Direction.outgoing)).linkWith(Relationships.WellKnown.isParentOf, (Path)r.getPath(), null);
            Assert.fail((String)"Should not be possible to create loops in isParentOf using generic relationships.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Resources.ReadAssociate)this.inventory.inspect(r2).allResources()).associate((Path)r.getPath());
            Assert.fail((String)"Should not be possible to create loops in isParentOf using association interface.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testImpossibleToDeleteContainsRelationship() throws Exception {
        try {
            Set rels = ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).named(Relationships.WellKnown.contains).entities();
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).delete(((Relationship)rels.iterator().next()).getId());
            Assert.fail((String)"Should not be able to delete contains relationship explicitly.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testImpossibleToDeleteIsParentOfWhenTheresContainsToo() throws Exception {
        Set rels = ((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).relationships()).named(Relationships.WellKnown.isParentOf).entities();
        for (Relationship r : rels) {
            if (!r.getTarget().getSegment().getElementId().equals("playroom1.1")) continue;
            try {
                ((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom1")).relationships()).delete(r.getId());
                Assert.fail((String)"Should not be possible to delete isParentOf when there's contains relationship in the same direction, too.");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRelativePathHandlingDuringDisassociationWhenThereAreMultipleRels() throws Exception {
        block13: {
            Metric m2;
            Metric m1;
            Feed f;
            block12: {
                CanonicalPath envPath = CanonicalPath.fromString((String)"/t;com.example.tenant/e;test");
                Environments.Single env = (Environments.Single)this.inventory.inspect(envPath, Environments.Single.class);
                Tenants.Single tenant = (Tenants.Single)this.inventory.inspect(envPath.up(), Tenants.Single.class);
                f = null;
                Resource r = null;
                m1 = null;
                m2 = null;
                try {
                    r = (Resource)((Resources.Single)((Resources.ReadWrite)env.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("assocR1")).withResourceTypePath("/rt;Playroom").build())).entity();
                    m1 = (Metric)((Metrics.Single)((Metrics.ReadWrite)env.metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("assocMetric")).withMetricTypePath("/mt;Size").build())).entity();
                    f = (Feed)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("assocF")).build())).entity();
                    m2 = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)tenant.feeds()).get((Object)"assocF")).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("assocMetric")).withMetricTypePath("/mt;Size").build())).entity();
                    ((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).associate((Path)m1.getPath());
                    ((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).associate((Path)m2.getPath());
                    Assert.assertEquals(new HashSet<Metric>(Arrays.asList(m1, m2)), (Object)((Metrics.Multiple)((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).getAll(new Filter[0])).entities());
                    ((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).disassociate(Path.fromString((String)"../m;assocMetric"));
                    Assert.assertEquals(Collections.singleton(m2), (Object)((Metrics.Multiple)((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).getAll(new Filter[0])).entities());
                    if (r == null) break block12;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break block13;
                }
                finally {
                    if (r != null) {
                        this.inventory.inspect(r).delete();
                    }
                    if (m1 != null) {
                        this.inventory.inspect(m1).delete();
                    }
                    if (m2 != null) {
                        this.inventory.inspect(m2).delete();
                    }
                    if (f != null) {
                        this.inventory.inspect(f).delete();
                    }
                }
                this.inventory.inspect(r).delete();
            }
            if (m1 != null) {
                this.inventory.inspect(m1).delete();
            }
            if (m2 != null) {
                this.inventory.inspect(m2).delete();
            }
            if (f != null) {
                this.inventory.inspect(f).delete();
            }
        }
    }

    @Test
    public void testCannotCreateOrDeleteHasDataRelationship() throws Exception {
        Relationships.Multiple rels = (Relationships.Multiple)this.inventory.relationships().getAll(new RelationFilter[]{RelationWith.sourceOfType(DataEntity.class), RelationWith.name((String)Relationships.WellKnown.hasData.name())});
        try {
            Relationship rel = (Relationship)rels.entities().iterator().next();
            ((Relationships.Single)this.inventory.relationships().get(rel.getId())).delete();
            Assert.fail((String)"Explicitly deleting hasData relationship shouldn't be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).relationships()).linkWith(Relationships.WellKnown.hasData, ((CanonicalPath.ResourceTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).resourceType("Playroom")).get(), null);
            Assert.fail((String)"Explicitly creating hasData relationship shouldn't be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInspectChildResource() throws Exception {
        Resources.Single access = (Resources.Single)this.inventory.inspect((CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).resource("playroom1")).resource("playroom1.1")).get(), Resources.Single.class);
        Assert.assertEquals((Object)"playroom1.1", (Object)((Resource)access.entity()).getId());
    }

    @Test
    public void testDescendChildResource() throws Exception {
        Resources.Single r = (Resources.Single)((Resources.ReadAssociate)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).descend((Object)"playroom1", new Path[]{RelativePath.fromString((String)"../r;playroom2")}).allResources()).get((Object)RelativePath.fromString((String)"r;playroom2.1"));
        Assert.assertEquals((Object)"playroom2.1", (Object)((Resource)r.entity()).getId());
    }

    @Test
    public void testAssociateEnvironmentWithFeeds() throws Exception {
        Assert.assertTrue((boolean)((Feeds.Single)((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).feeds()).get((Object)RelativePath.to().up().feed("feed1").get())).exists());
        ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("staging")).build());
        try {
            ((Feeds.ReadAssociate)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"staging")).feeds()).associate(RelativePath.to().up().feed("feed1").get());
            Assert.fail((String)"It should not be possible to associate a feed with more than 1 environment.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).delete((Object)"staging");
        }
    }

    @Test
    public void testCreationUnderNonExistentParentThrowsEntityNotFoundException() throws Exception {
        try {
            ((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"no-feed")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("blah")).withResourceTypePath("../../URL").build());
            Assert.fail((String)"Should not be able to traverse over non-existent entity.");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNamePersisted() throws Exception {
        Tenant t = null;
        try {
            t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("named-tenant")).withName("tenant")).build())).entity();
            Assert.assertEquals((Object)"tenant", (Object)t.getName());
            Environment e = (Environment)((Environments.Single)((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("named-env")).withName("env")).build())).entity();
            Assert.assertEquals((Object)"env", (Object)e.getName());
            Feed f = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("named-feed")).withName("feed")).build())).entity();
            Assert.assertEquals((Object)"feed", (Object)f.getName());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("named-resourceType")).withName("resourceType")).build())).entity();
            Assert.assertEquals((Object)"resourceType", (Object)rt.getName());
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("named-metricType")).withUnit(MetricUnit.BITS).withName("metricType")).withInterval(Long.valueOf(0L)).build())).entity();
            Assert.assertEquals((Object)"metricType", (Object)mt.getName());
            OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("named-operationType")).withName("operationType")).build())).entity();
            Assert.assertEquals((Object)"operationType", (Object)ot.getName());
            Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)this.inventory.inspect(f).resources()).create((Blueprint)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("named-resource")).withName("resource")).withResourceTypePath(rt.getPath().toString()).build())).entity();
            Assert.assertEquals((Object)"resource", (Object)r.getName());
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)this.inventory.inspect(f).metrics()).create((Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("named-metric")).withName("metric")).withMetricTypePath(mt.getPath().toString()).build())).entity();
            Assert.assertEquals((Object)"metric", (Object)m.getName());
            try {
                ((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("failing-env")).withProperty("name", (Object)"invalid-property")).build());
                Assert.fail((String)"Should not be possible to create an entity with a property called \"name\".");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            this.inventory.inspect(t).delete();
            throw throwable;
        }
        this.inventory.inspect(t).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNameUpdatable() throws Exception {
        Tenant t = null;
        try {
            t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("named-tenant")).withName("tenant")).build())).entity();
            this.testUpdate((Entity)t, (Entity.Update.Builder)Tenant.Update.builder());
            Environment e = (Environment)((Environments.Single)((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("named-env")).withName("env")).build())).entity();
            this.testUpdate((Entity)e, (Entity.Update.Builder)Environment.Update.builder());
            Feed f = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("named-feed")).withName("feed")).build())).entity();
            this.testUpdate((Entity)f, (Entity.Update.Builder)Feed.Update.builder());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("named-resourceType")).withName("resourceType")).build())).entity();
            this.testUpdate((Entity)rt, (Entity.Update.Builder)ResourceType.Update.builder());
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("named-metricType")).withUnit(MetricUnit.BITS).withName("metricType")).withInterval(Long.valueOf(0L)).build())).entity();
            this.testUpdate((Entity)mt, (Entity.Update.Builder)MetricType.Update.builder());
            OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("named-operationType")).withName("operationType")).build())).entity();
            this.testUpdate((Entity)ot, (Entity.Update.Builder)OperationType.Update.builder());
            Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)this.inventory.inspect(f).resources()).create((Blueprint)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("named-resource")).withName("resource")).withResourceTypePath(rt.getPath().toString()).build())).entity();
            this.testUpdate((Entity)r, (Entity.Update.Builder)Resource.Update.builder());
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)this.inventory.inspect(f).metrics()).create((Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("named-metric")).withName("metric")).withMetricTypePath(mt.getPath().toString()).build())).entity();
            this.testUpdate((Entity)m, (Entity.Update.Builder)Metric.Update.builder());
            try {
                this.inventory.inspect(m).update((Object)((Metric.Update.Builder)Metric.Update.builder().withProperty("name", (Object)"disallowed")).build());
                Assert.fail((String)"A property called \"name\" should not be allowed in updates.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (t == null) return;
        }
        catch (Throwable throwable) {
            if (t == null) throw throwable;
            this.inventory.inspect(t).delete();
            throw throwable;
        }
        this.inventory.inspect(t).delete();
    }

    @Test
    public void testMetadataPackMembershipNonUpdatable() throws Exception {
        CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
        CanonicalPath rtPath = tenantPath.extend(ResourceType.SEGMENT_TYPE, "Person").get();
        MetadataPack pack = (MetadataPack)((MetadataPacks.Multiple)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.inspect(tenantPath, Tenants.Single.class)).metadataPacks()).getAll(new Filter[0])).entities().iterator().next();
        try {
            ((Relationships.ReadWrite)this.inventory.inspect(pack).relationships()).linkWith(Relationships.WellKnown.incorporates, (Path)rtPath, null);
            Assert.fail((String)"Adding a resource type to a metadatapack should not be possible after the pack has been created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((ResourceTypes.Single)this.inventory.inspect(rtPath, ResourceTypes.Single.class)).relationships(Relationships.Direction.incoming)).linkWith(Relationships.WellKnown.incorporates, (Path)pack.getPath(), null);
            Assert.fail((String)"Adding a resource type to a metadatapack should not be possible after the pack has been created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testModificationsOfEntitiesInMetadataPacksImpossible() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).entity();
        MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).get((Object)"mpMt")).entity();
        ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).get((Object)"mpRt")).entity();
        try {
            this.inventory.inspect(mt).update((Object)MetricType.Update.builder().withUnit(MetricUnit.PER_DAY).build());
            Assert.fail((String)"Updating a metric type that is a part of metadata pack should not be possible.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("asfd")).build());
            Assert.fail((String)"It should not be possible to add an operation type to a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).delete((Object)"mpRtOt");
            Assert.fail((String)"It should not be possible to delete an operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).delete();
            Assert.fail((String)"It should not be possible to delete an operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.parameterTypes).withValue(StructuredData.get().undefined()).build());
            Assert.fail((String)"It should not be possible to add data to operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).update((DataRole)DataRole.OperationType.returnType, DataEntity.Update.builder().withValue(StructuredData.get().bool(Boolean.valueOf(true))).build());
            Assert.fail((String)"It should not be possible to modify data of operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).data()).delete((Object)DataRole.OperationType.returnType);
            Assert.fail((String)"It should not be possible to delete data of operation type from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.ReadWrite)this.inventory.inspect(rt).data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.connectionConfigurationSchema).withValue(StructuredData.get().bool(Boolean.valueOf(true))).build());
            Assert.fail((String)"It should not be possible to add an data to a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)DataRole.ResourceType.configurationSchema)).delete();
            Assert.fail((String)"It should not be possible to remove data from a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)DataRole.ResourceType.configurationSchema)).update(DataEntity.Update.builder().withValue(StructuredData.get().undefined()).build());
            Assert.fail((String)"It should not be possible to modify data of a resource type in metadata pack.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMetadataPackIdEqualToContentHash() throws Exception {
        MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypes()).get((Object)"mpMt")).entity();
        ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).get((Object)"mpRt")).entity();
        OperationType ot = (OperationType)((OperationTypes.Single)((OperationTypes.ReadWrite)this.inventory.inspect(rt).operationTypes()).get((Object)"mpRtOt")).entity();
        StructuredData configSchema = ((Data.Single)((Data.ReadWrite)this.inventory.inspect(rt).data()).get((Object)DataRole.ResourceType.configurationSchema)).entity().getValue();
        StructuredData retType = ((Data.Single)((Data.ReadWrite)this.inventory.inspect(ot).data()).get((Object)DataRole.OperationType.returnType)).entity().getValue();
        String expectedContentHash = IdentityHash.of((MetadataPack.Members)MetadataPack.Members.builder().with(((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)mt.getMetricDataType()).withUnit(mt.getUnit()).withInterval(Long.valueOf(0L)).withId(mt.getId())).build()).with(((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(rt.getId())).build()).with(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(configSchema).build()).with(((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId(ot.getId())).build()).with(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(retType).build()).done().done().build());
        MetadataPack mp = (MetadataPack)((MetadataPacks.Single)((MetadataPacks.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metadataPacks()).get((Object)expectedContentHash)).entity();
        Assert.assertEquals((Object)expectedContentHash, (Object)mp.getId());
    }

    private <T extends Entity<B, U>, B extends Blueprint, U extends Entity.Update> void testUpdate(T entity, Entity.Update.Builder<U, ?> update) {
        Class<ResolvableToSingle> cls = ResolvableToSingle.class;
        this.inventory.inspect(entity, cls).update((Object)update.withName("updated").build());
        entity = (Entity)this.inventory.inspect(entity, cls).entity();
        Assert.assertEquals((Object)"updated", (Object)entity.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdenticalResourceTypesFound() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(UUID.randomUUID().toString())).build())).entity();
        try {
            Feed f1 = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("f1")).build())).entity();
            Feed f2 = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("f2")).build())).entity();
            ResourceType rt1 = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(f1).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build())).entity();
            ResourceType rt2 = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(f2).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).build())).entity();
            Set identicals = ((ResourceTypes.Multiple)this.inventory.inspect(rt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)2L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(rt1));
            Assert.assertTrue((boolean)identicals.contains(rt2));
            String hash = ((ResourceType)this.inventory.inspect(rt1).entity()).getIdentityHash();
            Assert.assertEquals((Object)hash, (Object)((ResourceType)this.inventory.inspect(rt2).entity()).getIdentityHash());
            DataEntity.Blueprint bl = DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).withValue(((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putString("title", "blah")).putString("type", "string")).build()).build();
            ((Data.ReadWrite)this.inventory.inspect(rt1).data()).create(bl);
            Assert.assertNotEquals((Object)hash, (Object)((ResourceType)this.inventory.inspect(rt1).entity()).getIdentityHash());
            identicals = ((ResourceTypes.Multiple)this.inventory.inspect(rt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)1L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(rt1));
            ((Data.ReadWrite)this.inventory.inspect(rt2).data()).create(bl);
            identicals = ((ResourceTypes.Multiple)this.inventory.inspect(rt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)2L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(rt1));
            Assert.assertTrue((boolean)identicals.contains(rt2));
        }
        finally {
            this.inventory.tenants().delete((Object)t.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdenticalMetricTypesFound() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(UUID.randomUUID().toString())).build())).entity();
        try {
            Feed f1 = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("f1")).build())).entity();
            Feed f2 = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(t).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("f2")).build())).entity();
            MetricType mt1 = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(f1).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mt")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).entity();
            MetricType mt2 = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(f2).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mt")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).entity();
            Set identicals = ((MetricTypes.Multiple)this.inventory.inspect(mt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)2L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(mt1));
            Assert.assertTrue((boolean)identicals.contains(mt2));
            String hash = ((MetricType)this.inventory.inspect(mt1).entity()).getIdentityHash();
            Assert.assertEquals((Object)hash, (Object)((MetricType)this.inventory.inspect(mt2).entity()).getIdentityHash());
            this.inventory.inspect(mt1).update((Object)MetricType.Update.builder().withUnit(MetricUnit.MILLISECONDS).build());
            Assert.assertNotEquals((Object)hash, (Object)((MetricType)this.inventory.inspect(mt1).entity()).getIdentityHash());
            identicals = ((MetricTypes.Multiple)this.inventory.inspect(mt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)1L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(mt1));
            this.inventory.inspect(mt2).update((Object)MetricType.Update.builder().withUnit(MetricUnit.MILLISECONDS).build());
            identicals = ((MetricTypes.Multiple)this.inventory.inspect(mt1).identical().getAll(new Filter[0])).entities();
            Assert.assertEquals((long)2L, (long)identicals.size());
            Assert.assertTrue((boolean)identicals.contains(mt1));
            Assert.assertTrue((boolean)identicals.contains(mt2));
        }
        finally {
            this.inventory.tenants().delete((Object)t.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParentIdentityHashUpdatedWhenChildCreated() throws Exception {
        String tenantId = "testParentIdentityHashUpdatedWhenChildCreated";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            ((ResourceTypes.ReadWrite)f.resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build());
            Resources.Single r = (Resources.Single)((Resources.ReadWrite)f.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("res")).withResourceTypePath("resourceType").build());
            String fHash = IdentityHash.of((Entity)((Entity)f.entity()), this.inventory);
            Assert.assertEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
            ((Data.ReadWrite)r.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(StructuredData.get().integral(Long.valueOf(42L))).build());
            Assert.assertNotEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParentIdentityHashUpdatedWhenChildUpdated() throws Exception {
        String tenantId = "testParentIdentityHashUpdatedWhenChildUpdated";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            ((MetricTypes.ReadWrite)f.metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withUnit(MetricUnit.BITS).withInterval(Long.valueOf(0L)).build());
            String fHash = IdentityHash.of((Entity)((Entity)f.entity()), this.inventory);
            Assert.assertEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
            ((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).get((Object)"metricType")).update((Object)MetricType.Update.builder().withUnit(MetricUnit.BYTES).build());
            Assert.assertNotEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParentIdentityHashUpdatedWhenChildDeleted() throws Exception {
        String tenantId = "testParentIdentityHashUpdatedWhenChildDeleted";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            ((ResourceTypes.ReadWrite)f.resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build());
            ((Resources.ReadWrite)f.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build());
            ((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childRersource")).withResourceTypePath("../resourceType").build());
            String fHash = IdentityHash.of((Entity)((Entity)f.entity()), this.inventory);
            Assert.assertEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
            ((Resources.ReadWrite)f.resources()).delete((Object)"resource");
            Assert.assertNotEquals((Object)fHash, (Object)((Feed)f.entity()).getIdentityHash());
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTreeHash() throws Exception {
        String tenantId = "testTreeHash";
        try {
            Feeds.Single f = ((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create(((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build(), false);
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).entity();
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).entity();
            ((Resources.Single)((Resources.ReadWrite)f.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build())).entity();
            ((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childResource")).withResourceTypePath("../resourceType").build())).entity();
            Metric resourceMetric = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("../metricType").build())).entity();
            Metric feedMetric = (Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("metricType").build())).entity();
            ((Metrics.ReadAssociate)((Resources.ReadWrite)f.resources()).descendContained((RelativePath)((RelativePath.ResourceBuilder)RelativePath.to().resource("resource").resource("childResource")).get()).allMetrics()).associate(RelativePath.to().up().metric("metric").get());
            Resource resource = (Resource)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).entity();
            Resource childResource = (Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).get((Object)"childResource")).entity();
            SyncHash.Tree feedTreeHash = f.treeHash();
            Assert.assertEquals((long)4L, (long)feedTreeHash.getChildren().size());
            Assert.assertEquals((Object)((Feed)f.entity()).getSyncHash(), (Object)feedTreeHash.getHash());
            Assert.assertEquals((Object)rt.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getHash());
            Assert.assertEquals((Object)mt.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"mt;metricType"))).getHash());
            Assert.assertEquals((Object)resource.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"r;resource"))).getHash());
            Assert.assertEquals((Object)feedMetric.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getHash());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"mt;metricType"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getChildren().isEmpty());
            SyncHash.Tree resourceTreeHash = (SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"r;resource"));
            Assert.assertEquals((long)2L, (long)resourceTreeHash.getChildren().size());
            Assert.assertEquals((Object)resourceMetric.getSyncHash(), (Object)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getHash());
            Assert.assertEquals((Object)childResource.getSyncHash(), (Object)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"r;childResource"))).getHash());
            Assert.assertTrue((boolean)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"r;childResource"))).getChildren().isEmpty());
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    @Test
    public void testSynchronizeNew() throws Exception {
        String tenantId = "testSynchronizeNew";
        try {
            Feeds.Single f = ((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create(((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build(), false);
            InventoryStructure.Offline structure = ((InventoryStructure.Builder)((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.Offline.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).addChild((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).addChild((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).startChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build()).addChild((Entity.Blueprint)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childResource")).withResourceTypePath("../resourceType").withProperty("a", (Object)"b")).build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withInterval(Long.valueOf(0L)).withMetricTypePath("../metricType").build())).end()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("metricType").withInterval(Long.valueOf(0L)).build())).build();
            f.synchronize(SyncRequest.syncEverything((InventoryStructure)structure));
            SyncHash.Tree feedTreeHash = f.treeHash();
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).get((Object)"resourceType")).entity();
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).get((Object)"metricType")).entity();
            Resource resource = (Resource)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).entity();
            Metric feedMetric = (Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric")).entity();
            Metric resourceMetric = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).metrics()).get((Object)"metric")).entity();
            Resource childResource = (Resource)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).get((Object)"childResource")).entity();
            Assert.assertEquals((long)4L, (long)feedTreeHash.getChildren().size());
            Assert.assertEquals((Object)((Feed)f.entity()).getSyncHash(), (Object)feedTreeHash.getHash());
            Assert.assertEquals((Object)rt.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getHash());
            Assert.assertEquals((Object)mt.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"mt;metricType"))).getHash());
            Assert.assertEquals((Object)resource.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"r;resource"))).getHash());
            Assert.assertEquals((Object)feedMetric.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getHash());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"mt;metricType"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getChildren().isEmpty());
            SyncHash.Tree resourceTreeHash = (SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"r;resource"));
            Assert.assertEquals((long)2L, (long)resourceTreeHash.getChildren().size());
            Assert.assertEquals((Object)resourceMetric.getSyncHash(), (Object)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getHash());
            Assert.assertEquals((Object)childResource.getSyncHash(), (Object)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"r;childResource"))).getHash());
            Assert.assertEquals((Object)"b", childResource.getProperties().get("a"));
            Assert.assertTrue((boolean)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"m;metric"))).getChildren().isEmpty());
            Assert.assertTrue((boolean)((SyncHash.Tree)resourceTreeHash.getChild(Path.Segment.from((String)"r;childResource"))).getChildren().isEmpty());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    @Test
    public void testSynchronizeNonExistent() throws Exception {
        String tenantId = "testSynchronizeNonExistent";
        try {
            InventoryStructure.Offline structure = ((InventoryStructure.Builder)InventoryStructure.Offline.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).addChild((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).build();
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).get((Object)"feed");
            f.synchronize(SyncRequest.syncEverything((InventoryStructure)structure));
            SyncHash.Tree feedTreeHash = f.treeHash();
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).get((Object)"resourceType")).entity();
            Assert.assertEquals((long)1L, (long)feedTreeHash.getChildren().size());
            Assert.assertEquals((Object)((Feed)f.entity()).getSyncHash(), (Object)feedTreeHash.getHash());
            Assert.assertEquals((Object)rt.getSyncHash(), (Object)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getHash());
            Assert.assertTrue((boolean)((SyncHash.Tree)feedTreeHash.getChild(Path.Segment.from((String)"rt;resourceType"))).getChildren().isEmpty());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    @Test
    public void testSyncNonExistentData() throws Exception {
        String tenantId = "testSyncNonExistentData";
        try {
            InventoryStructure.Offline structure = InventoryStructure.Offline.of((Entity.Blueprint)DataEntity.Blueprint.builder().withRole((DataRole)DataRole.ResourceType.configurationSchema).build()).build();
            ResourceTypes.Single rt = (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build());
            Data.Single d = (Data.Single)((Data.ReadWrite)rt.data()).get((Object)DataRole.ResourceType.configurationSchema);
            d.synchronize(SyncRequest.syncEverything((InventoryStructure)structure));
            SyncHash.Tree dataTreeHash = d.treeHash();
            DataEntity de = d.entity();
            Assert.assertEquals((Object)de.getSyncHash(), (Object)dataTreeHash.getHash());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSynchronizeUpdate() throws Exception {
        String tenantId = "testSynchronizeUpdate";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            ((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).entity();
            ((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).entity();
            ((Resources.Single)((Resources.ReadWrite)f.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build())).entity();
            ((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childResource")).withResourceTypePath("../resourceType").build())).entity();
            ((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("../metricType").build())).entity();
            ((Metrics.Single)((Metrics.ReadWrite)f.metrics()).create((Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("metricType").withProperty("a", (Object)"b")).withProperty("b", (Object)"c")).withName("Metric Name")).build())).entity();
            ((Metrics.ReadAssociate)((Resources.ReadWrite)f.resources()).descendContained((RelativePath)((RelativePath.ResourceBuilder)RelativePath.to().resource("resource").resource("childResource")).get()).allMetrics()).associate(RelativePath.to().up().metric("metric").get());
            ((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).entity();
            ((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).get((Object)"childResource")).entity();
            InventoryStructure.Builder structureBuiler = InventoryStructure.Offline.copy((InventoryStructure)InventoryStructure.of((Entity)((Entity)f.entity()), this.inventory)).asBuilder();
            structureBuiler.getChild(Path.Segment.from((String)"mt;metricType")).replace((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.BYTES).build());
            structureBuiler.getChild(Path.Segment.from((String)"m;metric")).replace((Entity.Blueprint)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("metric")).withMetricTypePath("metricType").withProperty("a", (Object)"c")).withProperty("c", (Object)"d")).withName("Name Of Metric")).build());
            structureBuiler.getChild(Path.Segment.from((String)"r;resource")).remove();
            InventoryStructure.Offline structure = structureBuiler.build();
            f.synchronize(SyncRequest.syncEverything((InventoryStructure)structure));
            Assert.assertTrue((boolean)((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).get((Object)"metricType")).exists());
            Assert.assertEquals((Object)"c", ((Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric")).entity()).getProperties().get("a"));
            Assert.assertEquals((Object)"d", ((Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric")).entity()).getProperties().get("c"));
            Assert.assertEquals((Object)"Name Of Metric", (Object)((Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric")).entity()).getName());
            Assert.assertFalse((boolean)((Metric)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric")).entity()).getProperties().containsKey("b"));
            Assert.assertFalse((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).exists());
            Assert.assertFalse((boolean)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).resources()).get((Object)"childResource")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource")).metrics()).get((Object)"metrics")).exists());
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                ((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).delete();
            }
        }
    }

    private static InventoryStructure<Feed.Blueprint> getSyncConfigStructure() {
        return ((InventoryStructure.Builder)((InventoryStructure.Builder)((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).addChild((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build())).addChild((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withInterval(Long.valueOf(0L)).withUnit(MetricUnit.NONE).build())).startChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("resourceType").withId("resource1")).build()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("../metricType").withId("metric1")).withInterval(Long.valueOf(0L)).build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("../metricType").withId("metric2")).withInterval(Long.valueOf(0L)).build())).end()).startChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("resourceType").withId("resource2")).build()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("../metricType").withId("metric3")).withInterval(Long.valueOf(0L)).build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("../metricType").withId("metric4")).withInterval(Long.valueOf(0L)).build())).addChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource3")).withResourceTypePath("../resourceType").build())).end()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("metricType").withId("metric5")).withInterval(Long.valueOf(0L)).build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("metricType").withId("metric6")).withInterval(Long.valueOf(0L)).build())).build();
    }

    @Test
    public void testSyncConfig_limitTypes_shallow() throws Exception {
        String tenantId = "testSyncConfig_limitTypes_shallow";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            InventoryStructure<Feed.Blueprint> fullStructure = AbstractBaseInventoryTestsuite.getSyncConfigStructure();
            f.synchronize(SyncRequest.syncEverything(fullStructure));
            InventoryStructure.Offline updateStructure = ((InventoryStructure.Builder)((InventoryStructure.ChildBuilder)((InventoryStructure.Builder)((InventoryStructure.Builder)InventoryStructure.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("metricType").withId("metric6")).withInterval(Long.valueOf(0L)).build())).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("metricType").withId("metric7")).withInterval(Long.valueOf(0L)).build())).startChild((Entity.Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withResourceTypePath("resourceType").withId("resource4")).build()).addChild((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withMetricTypePath("../metricType").withId("metric8")).withInterval(Long.valueOf(0L)).build())).end()).build();
            f.synchronize(new SyncRequest(SyncConfiguration.builder().withType(SegmentType.m).build(), (InventoryStructure)updateStructure));
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource4")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource4")).metrics()).get((Object)"metric8")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric7")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric5")).exists());
            Assert.assertTrue((boolean)((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).get((Object)"resourceType")).exists());
            Assert.assertTrue((boolean)((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).get((Object)"metricType")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).metrics()).get((Object)"metric1")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).metrics()).get((Object)"metric2")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).metrics()).get((Object)"metric3")).exists());
            Assert.assertTrue((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).metrics()).get((Object)"metric4")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).resources()).get((Object)"resource3")).exists());
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                this.inventory.tenants().delete((Object)tenantId);
            }
        }
    }

    @Test
    public void testSyncConfig_limitTypes_deep() throws Exception {
        String tenantId = "testSyncConfig_limitTypes_deep";
        try {
            Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
            InventoryStructure<Feed.Blueprint> fullStructure = AbstractBaseInventoryTestsuite.getSyncConfigStructure();
            f.synchronize(SyncRequest.syncEverything(fullStructure));
            InventoryStructure.Offline deleteMetricsStructure = InventoryStructure.of((Entity.Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build()).build();
            f.synchronize(new SyncRequest(SyncConfiguration.builder().withType(SegmentType.m).withDeepSearch(true).build(), (InventoryStructure)deleteMetricsStructure));
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric5")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)f.metrics()).get((Object)"metric6")).exists());
            Assert.assertTrue((boolean)((ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).get((Object)"resourceType")).exists());
            Assert.assertTrue((boolean)((MetricTypes.Single)((MetricTypes.ReadWrite)f.metricTypes()).get((Object)"metricType")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).metrics()).get((Object)"metric1")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource1")).metrics()).get((Object)"metric2")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).metrics()).get((Object)"metric3")).exists());
            Assert.assertFalse((boolean)((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).metrics()).get((Object)"metric4")).exists());
            Assert.assertTrue((boolean)((Resources.Single)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)f.resources()).get((Object)"resource2")).resources()).get((Object)"resource3")).exists());
        }
        catch (Exception t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                this.inventory.tenants().delete((Object)tenantId);
            }
        }
    }

    @Test
    public void testObserveTenants() throws Exception {
        String tid = "testObserveTenants";
        this.runObserverTest(Tenant.class, 0, 0, () -> {
            this.inventory.tenants().create((Blueprint)new Tenant.Blueprint(tid));
            this.inventory.tenants().update((Object)tid, (Object)Tenant.Update.builder().build());
            this.inventory.tenants().delete((Object)tid);
        });
    }

    @Test
    public void testObserveEnvironments() throws Exception {
        String tid = "testObserveEnvironments";
        String eid = "env";
        this.runObserverTest(Environment.class, 1, 1, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId(eid)).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).update((Object)eid, (Object)Environment.Update.builder().build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).delete((Object)eid);
            this.inventory.tenants().delete((Object)tid);
        });
    }

    @Test
    public void testObserveResourceTypes() throws Exception {
        String tid = "testObserveResourceTypes";
        String rtid = "rtype";
        String mtid = "mtype";
        this.runObserverTest(ResourceType.class, 3, 3, () -> {
            this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).create((Blueprint)new ResourceType.Blueprint(rtid));
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).update((Object)rtid, (Object)new ResourceType.Update(null));
            MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.COUNTER).withId(mtid)).withUnit(MetricUnit.BYTES).withInterval(Long.valueOf(0L)).build())).entity();
            ArrayList createdRelationships = new ArrayList();
            this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
            ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).get((Object)rtid)).metricTypes()).associate((Path)mt.getPath());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).delete((Object)mtid);
            Assert.assertEquals((long)1L, (long)createdRelationships.size());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).delete((Object)rtid);
            this.inventory.tenants().delete((Object)tid);
        });
    }

    @Test
    public void testObserveMetricTypes() throws Exception {
        String tid = "testObserveMetricTypes";
        String mtid = "mtype";
        try {
            this.runObserverTest(MetricType.class, 1, 1, () -> {
                this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
                ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).create((Blueprint)new MetricType.Blueprint(mtid, MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)));
                ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).update((Object)mtid, (Object)MetricType.Update.builder().withUnit(MetricUnit.MILLISECONDS).build());
                ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).delete((Object)mtid);
            });
        }
        finally {
            this.inventory.tenants().delete((Object)tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObserveMetrics() throws Exception {
        String tid = "testObserveMetrics";
        String eid = "env";
        String mtid = "mtype";
        String mid = "met";
        try {
            this.runObserverTest(Metric.class, 4, 2, () -> {
                this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
                ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId(eid)).build());
                ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).create((Blueprint)new MetricType.Blueprint(mtid, MetricUnit.BYTES, MetricDataType.COUNTER, Long.valueOf(0L)));
                ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).metrics()).create((Blueprint)new Metric.Blueprint("/" + mtid, mid));
                ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).metrics()).update((Object)mid, (Object)Metric.Update.builder().build());
                ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).metrics()).delete((Object)mid);
            });
        }
        finally {
            this.inventory.tenants().delete((Object)tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObserveResources() throws Exception {
        String tid = "testObserveResources";
        String eid = "env";
        String rtid = "rtype";
        String mtid = "mtype";
        String mid = "met";
        String rid = "res";
        try {
            this.runObserverTest(Resource.class, 8, 3, () -> {
                this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
                ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId(eid)).build());
                ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(rtid)).build());
                ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.COUNTER).withId(mtid)).withUnit(MetricUnit.BYTES).withInterval(Long.valueOf(0L)).build());
                ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).create((Blueprint)new Resource.Blueprint(rid, "/" + rtid));
                ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).update((Object)rid, (Object)Resource.Update.builder().build());
                Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId(mid)).withMetricTypePath("/" + mtid).build())).entity();
                ArrayList createdRelationships = new ArrayList();
                this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
                ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).get((Object)rid)).allMetrics()).associate((Path)m.getPath());
                Assert.assertEquals((long)1L, (long)createdRelationships.size());
                ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).delete((Object)rid);
            });
        }
        finally {
            this.inventory.tenants().delete((Object)tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObserveDataEntities() throws Exception {
        String tid = "testObserveDataEntities";
        String eid = "env";
        String rtid = "rtype";
        String rid = "res";
        try {
            this.runObserverTest(DataEntity.class, 5, 1, () -> {
                this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tid)).build());
                ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId(eid)).build());
                ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(rtid)).build());
                ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).create((Blueprint)new Resource.Blueprint(rid, "/" + rtid));
                Data.ReadWrite dataAccess = (Data.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tid)).environments()).get((Object)eid)).resources()).get((Object)rid)).data();
                dataAccess.create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).build());
                dataAccess.update((DataRole)DataRole.Resource.configuration, DataEntity.Update.builder().build());
                dataAccess.delete((Object)DataRole.Resource.configuration);
            });
        }
        finally {
            this.inventory.tenants().delete((Object)tid);
        }
    }

    @Test
    public void testObserveIdentityHashChangedOnParentOfChangedEntity() throws Exception {
        String tenantId = "testObserveIdentityHashChangedOnParentOfChangedEntity";
        this.testSyncHashObservation(tenantId, updateCounts -> {
            ((MetricTypes.Single)((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)"feed")).metricTypes()).get((Object)"metricType")).update((Object)MetricType.Update.builder().withUnit(MetricUnit.BYTES).build());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(MetricType.class)).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(Feed.class)).intValue());
            Assert.assertTrue((boolean)updateCounts.isEmpty());
        });
    }

    @Test
    public void testObserveSyncHashChangedOnParentOfCreatedEntity() throws Exception {
        String tenantId = "testObserveSyncHashChangedOnParentOfCreatedEntity";
        this.testSyncHashObservation(tenantId, updateCounts -> {
            ((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)"feed")).resources()).get((Object)"resource")).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("childResource")).withResourceTypePath("../resourceType").build());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(Resource.class)).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(Feed.class)).intValue());
            Assert.assertTrue((boolean)updateCounts.isEmpty());
        });
    }

    @Test
    public void testObserveIdentityHashChangedOnParentOfDeletedEntity() throws Exception {
        String tenantId = "testObserveIdentityHashChangedOnParentOfDeletedEntity";
        this.testSyncHashObservation(tenantId, updateCounts -> {
            ((Data.ReadWrite)((OperationTypes.Single)((OperationTypes.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)"feed")).resourceTypes()).get((Object)"resourceType")).operationTypes()).get((Object)"operationType")).data()).delete((Object)DataRole.OperationType.returnType);
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(OperationType.class)).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(ResourceType.class)).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)updateCounts.remove(Feed.class)).intValue());
            Assert.assertTrue((boolean)updateCounts.isEmpty());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSyncHashObservation(String tenantId, Consumer<Map<Class<?>, Integer>> test) throws Exception {
        Subscription subs = null;
        try {
            this.createInventoryForSyncHashChangeObservations(tenantId);
            HashMap updateCounts = new HashMap();
            subs = Observable.merge((Observable)this.inventory.observable(Interest.in(Feed.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(ResourceType.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(MetricType.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(OperationType.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(Resource.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(Metric.class).having(Action.syncHashChanged())), (Observable)this.inventory.observable(Interest.in(DataEntity.class).having(Action.syncHashChanged()))).subscribe(e -> updateCounts.put(e.getClass(), updateCounts.getOrDefault(e.getClass(), 0) + 1));
            test.accept(updateCounts);
        }
        finally {
            if (((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).exists()) {
                this.inventory.tenants().delete((Object)tenantId);
            }
            if (subs != null) {
                subs.unsubscribe();
            }
        }
    }

    private void createInventoryForSyncHashChangeObservations(String tenantId) throws Exception {
        Feeds.Single f = (Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(tenantId)).build())).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build());
        ((MetricTypes.ReadWrite)f.metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("metricType")).withUnit(MetricUnit.BITS).withInterval(Long.valueOf(0L)).build());
        ResourceTypes.Single rt = (ResourceTypes.Single)((ResourceTypes.ReadWrite)f.resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("resourceType")).build());
        OperationTypes.Single ot = (OperationTypes.Single)((OperationTypes.ReadWrite)rt.operationTypes()).create((Blueprint)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("operationType")).build());
        ((Data.ReadWrite)ot.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.OperationType.returnType).withValue(((StructuredData.MapBuilder)StructuredData.get().map().putString("type", "string")).build()).build());
        Resources.Single r = (Resources.Single)((Resources.ReadWrite)f.resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("resource")).withResourceTypePath("resourceType").build());
        ((Data.ReadWrite)r.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(StructuredData.get().integral(Long.valueOf(42L))).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendFind() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
            Object entity = backend.find(tenantPath);
            Tenant tenant = (Tenant)backend.convert(entity, Tenant.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)tenant.getId());
            CanonicalPath envPath = tenantPath.extend(Environment.SEGMENT_TYPE, "production").get();
            entity = backend.find(envPath);
            Environment env = (Environment)backend.convert(entity, Environment.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)env.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"production", (Object)env.getId());
            entity = backend.find(envPath.extend(Resource.SEGMENT_TYPE, "host1").get());
            Resource r = (Resource)backend.convert(entity, Resource.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"production", (Object)r.getPath().ids().getEnvironmentId());
            Assert.assertNull((Object)r.getPath().ids().getFeedId());
            Assert.assertEquals((Object)"host1", (Object)r.getId());
            entity = backend.find(envPath.extend(Metric.SEGMENT_TYPE, "host1_ping_response").get());
            Metric m = (Metric)backend.convert(entity, Metric.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"production", (Object)m.getPath().ids().getEnvironmentId());
            Assert.assertNull((Object)m.getPath().ids().getFeedId());
            Assert.assertEquals((Object)"host1_ping_response", (Object)m.getId());
            CanonicalPath feedPath = tenantPath.extend(Feed.SEGMENT_TYPE, "feed1").get();
            entity = backend.find(feedPath);
            Feed f = (Feed)backend.convert(entity, Feed.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)f.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"feed1", (Object)f.getId());
            entity = backend.find(feedPath.extend(Resource.SEGMENT_TYPE, "feedResource1").get());
            r = (Resource)backend.convert(entity, Resource.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"feed1", (Object)r.getPath().ids().getFeedId());
            Assert.assertEquals((Object)"feedResource1", (Object)r.getId());
            entity = backend.find(feedPath.extend(Metric.SEGMENT_TYPE, "feedMetric1").get());
            m = (Metric)backend.convert(entity, Metric.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"feed1", (Object)m.getPath().ids().getFeedId());
            Assert.assertEquals((Object)"feedMetric1", (Object)m.getId());
            entity = backend.find(tenantPath.extend(ResourceType.SEGMENT_TYPE, "URL").get());
            ResourceType rt = (ResourceType)backend.convert(entity, ResourceType.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)rt.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"URL", (Object)rt.getId());
            entity = backend.find(tenantPath.extend(MetricType.SEGMENT_TYPE, "ResponseTime").get());
            MetricType mt = (MetricType)backend.convert(entity, MetricType.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)mt.getPath().ids().getTenantId());
            Assert.assertEquals((Object)"ResponseTime", (Object)mt.getId());
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendGetRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get());
            Object environment = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).environment("production")).get());
            Object r = backend.getRelationship(tenant, environment, Relationships.WellKnown.contains.name());
            Relationship rel = (Relationship)backend.convert(r, Relationship.class);
            Assert.assertEquals((Object)"com.acme.tenant", (Object)rel.getSource().getSegment().getElementId());
            Assert.assertEquals((Object)"production", (Object)rel.getTarget().getSegment().getElementId());
            Assert.assertEquals((Object)"contains", (Object)rel.getName());
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendGetRelationships() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            Object entity = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get());
            Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(entity));
            Set rels = backend.getRelationships(entity, Relationships.Direction.both, new String[0]);
            Assert.assertEquals((long)8L, (long)rels.size());
            Function<Set, Stream> checks = es -> es.stream().map(e -> (Relationship)backend.convert(e, Relationship.class));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "production".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "URL".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "Person".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "ResponseTime".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "feed1".equals(r.getTarget().getSegment().getElementId())));
            rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
            Assert.assertTrue((boolean)rels.isEmpty());
            rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[0]);
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "production".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "URL".equals(r.getTarget().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getSegment().getElementId()) && "ResponseTime".equals(r.getTarget().getSegment().getElementId())));
            entity = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get());
            Assert.assertEquals((Object)"test", (Object)backend.extractId(entity));
            rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
            Assert.assertEquals((long)2L, (long)rels.size());
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "contains".equals(r.getName()) && "com.example.tenant".equals(r.getSource().getSegment().getElementId())));
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "yourMom".equals(r.getName()) && "playroom2_size".equals(r.getSource().getSegment().getElementId())));
            rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[]{"IamYourFather"});
            Assert.assertEquals((long)1L, (long)rels.size());
            Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "IamYourFather".equals(r.getName()) && "playroom2_size".equals(r.getTarget().getSegment().getElementId())));
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendGetTransitiveClosure() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            TriFunction<Object, Relationships.Direction, String[], Stream> test = (start, direction, name) -> {
                Iterator transitiveClosure = backend.getTransitiveClosureOver(start, direction, name);
                return StreamSupport.stream(Spliterators.spliterator(transitiveClosure, Integer.MAX_VALUE, 0), false).map(e -> (Entity)backend.convert(e, backend.extractType(e)));
            };
            Object env = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).environment("production")).get());
            Object feed = backend.find((CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).feed("feed1")).get());
            Assert.assertEquals((long)8L, (long)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).count());
            Assert.assertFalse((boolean)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).anyMatch(e -> e instanceof Feed && "feed1".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource1".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource2".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Resource && "feedResource3".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.outgoing, new String[]{"contains", "incorporates"}).anyMatch(e -> e instanceof Metric && "feedMetric1".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).anyMatch(e -> e instanceof ResourceType && "feed1-resourceType".equals(e.getId())));
            Assert.assertTrue((boolean)test.apply(feed, Relationships.Direction.outgoing, new String[]{"contains"}).anyMatch(e -> e instanceof MetricType && "feed1-metricType".equals(e.getId())));
            Assert.assertEquals((long)1L, (long)test.apply(env, Relationships.Direction.incoming, new String[]{"contains"}).count());
            Assert.assertTrue((boolean)test.apply(env, Relationships.Direction.incoming, new String[]{"contains"}).anyMatch(e -> e instanceof Tenant && "com.acme.tenant".equals(e.getId())));
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendHasRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get());
            Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.outgoing, "contains"));
            Assert.assertFalse((boolean)backend.hasRelationship(tenant, Relationships.Direction.incoming, "contains"));
            Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.both, "contains"));
            Object env = backend.find((CanonicalPath)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).environment("test")).get());
            Assert.assertTrue((boolean)backend.hasRelationship(tenant, env, "contains"));
            Assert.assertFalse((boolean)backend.hasRelationship(tenant, env, "e-kachny"));
        }
        finally {
            backend.rollback();
        }
    }

    @Test
    public void testBackendExtractId() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            Object tenant = backend.find((CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.example.tenant")).get());
            Assert.assertEquals((Object)"com.example.tenant", (Object)backend.extractId(tenant));
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendExtractType() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            CanonicalPath tenantPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get();
            Object entity = backend.find(tenantPath);
            Assert.assertEquals(Tenant.class, (Object)backend.extractType(entity));
            CanonicalPath envPath = tenantPath.extend(Environment.SEGMENT_TYPE, "production").get();
            entity = backend.find(envPath);
            Assert.assertEquals(Environment.class, (Object)backend.extractType(entity));
            entity = backend.find(envPath.extend(Resource.SEGMENT_TYPE, "host1").get());
            Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
            entity = backend.find(envPath.extend(Metric.SEGMENT_TYPE, "host1_ping_response").get());
            Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
            CanonicalPath feedPath = tenantPath.extend(Feed.SEGMENT_TYPE, "feed1").get();
            entity = backend.find(feedPath);
            Assert.assertEquals(Feed.class, (Object)backend.extractType(entity));
            entity = backend.find(feedPath.extend(Resource.SEGMENT_TYPE, "feedResource1").get());
            Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
            entity = backend.find(feedPath.extend(Metric.SEGMENT_TYPE, "feedMetric1").get());
            Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
            entity = backend.find(tenantPath.extend(ResourceType.SEGMENT_TYPE, "URL").get());
            Assert.assertEquals(ResourceType.class, (Object)backend.extractType(entity));
            entity = backend.find(tenantPath.extend(MetricType.SEGMENT_TYPE, "ResponseTime").get());
            Assert.assertEquals(MetricType.class, (Object)backend.extractType(entity));
        }
        finally {
            backend.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendQuery() throws Exception {
        InventoryBackend backend = this.inventory.getBackend().startTransaction();
        try {
            Pager unlimited = Pager.unlimited((Order[])new Order[]{Order.unspecified()});
            Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant")}).get();
            Page results = backend.query(q, unlimited);
            Assert.assertTrue((boolean)results.hasNext());
            Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(results.next()));
            Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
            q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant"), Related.by((String)"contains"), With.type(Environment.class), With.id((String)"production")}).get();
            results = backend.query(q, unlimited);
            Assert.assertTrue((boolean)results.hasNext());
            Assert.assertEquals((Object)"production", (Object)backend.extractId(results.next()));
            Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
            q = Query.path().with(new Filter[]{With.type(Tenant.class)}).filter().with(new Filter[]{Related.by((String)"contains"), With.type(ResourceType.class), With.id((String)"URL")}).path().with(new Filter[]{Related.by((String)"contains"), With.type(Environment.class)}).get();
            results = backend.query(q, unlimited);
            Assert.assertTrue((boolean)results.hasNext());
            Assert.assertEquals((Object)"production", (Object)backend.extractId(results.next()));
            Assert.assertTrue((!results.hasNext() ? 1 : 0) != 0);
        }
        finally {
            backend.rollback();
        }
    }

    @Test
    public void testCreateConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.example.tenant")).environments()).get((Object)"test")).resources()).get((Object)"playroom2");
        StructuredData orig = ((StructuredData.MapBuilder)((StructuredData.MapBuilder)StructuredData.get().map().putBool("yes", true)).putBool("no", false)).build();
        ((Data.ReadWrite)res.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.connectionConfiguration).withValue(orig).build());
        StructuredData retrieved = ((Data.Single)((Data.ReadWrite)res.data()).get((Object)DataRole.Resource.connectionConfiguration)).entity().getValue();
        Assert.assertEquals((Object)orig, (Object)retrieved);
        Assert.assertFalse((boolean)((Data.Single)((Data.ReadWrite)res.data()).get((Object)DataRole.Resource.configuration)).exists());
        ((Data.ReadWrite)res.data()).delete((Object)DataRole.Resource.connectionConfiguration);
        Assert.assertFalse((boolean)((Data.Single)((Data.ReadWrite)res.data()).get((Object)DataRole.Resource.connectionConfiguration)).exists());
    }

    @Test
    public void testUpdateStructuredDataSimpleValue() throws Exception {
        Data.Single dataAccess = (Data.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.example.tenant/e;test/r;playroom1/d;configuration"), Data.Single.class);
        StructuredData origData = dataAccess.entity().getValue();
        Assert.assertNotNull((Object)origData);
        StructuredData modified = ((StructuredData.MapUpdater)origData.update().toMap().putBool("answer", true)).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        StructuredData persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        modified = ((StructuredData.MapUpdater)((StructuredData.InnerListUpdater)modified.update().toMap().updateList("primitives").setBool(0, false)).closeList()).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        modified = ((StructuredData.MapUpdater)modified.update().toMap().remove("answer")).build();
        dataAccess.update(DataEntity.Update.builder().withValue(modified).build());
        persisted = dataAccess.entity().getValue();
        Assert.assertEquals((Object)modified, (Object)persisted);
        dataAccess.update(DataEntity.Update.builder().withValue(origData).build());
    }

    @Test
    public void testFilteringByData() throws Exception {
        Data.Read configs = (Data.Read)((Resources.Multiple)((Resources.ReadContained)((Environments.Multiple)((Environments.ReadContained)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).resources()).getAll(new Filter[0])).data();
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll(new Filter[]{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get()))})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataValue((Serializable)Boolean.valueOf(false))}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataValue((Serializable)Boolean.valueOf(true))}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.list})}})).entities().size());
        Assert.assertEquals((long)1L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.bool})}})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.map})}})).entities().size());
        Assert.assertEquals((long)0L, (long)((Data.Multiple)configs.getAll((Filter[][])new Filter[][]{{With.dataAt((RelativePath)((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get())), With.dataOfTypes((StructuredData.Type[])new StructuredData.Type[]{StructuredData.Type.integral})}})).entities().size());
    }

    @Test
    public void testRetrievingDataPortions() throws Exception {
        Data.Single config = (Data.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.example.tenant/e;test/r;playroom1/d;configuration"), Data.Single.class);
        StructuredData allData = config.entity().getValue();
        StructuredData portion = config.data((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get());
        Assert.assertEquals(((StructuredData)allData.map().get("primitives")).list().get(0), (Object)portion);
        portion = config.data(RelativePath.empty().get());
        Assert.assertEquals((Object)allData, (Object)portion);
        portion = config.flatData((RelativePath)((RelativePath.StructuredDataBuilder)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).index(0)).get());
        Assert.assertEquals(((StructuredData)allData.map().get("primitives")).list().get(0), (Object)portion);
        portion = config.flatData(RelativePath.empty().get());
        Assert.assertEquals(Collections.emptyMap(), (Object)portion.getValue());
        portion = config.flatData((RelativePath)((RelativePath.StructuredDataBuilder)RelativePath.to().structuredData().key("primitives")).get());
        Assert.assertEquals(Collections.emptyList(), (Object)portion.getValue());
    }

    @Test
    public void testCreateInvalidConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people"), Resources.Single.class);
        try {
            ((Data.ReadWrite)res.data()).create(DataEntity.Blueprint.builder().withRole((DataRole)DataRole.Resource.configuration).withValue(((StructuredData.MapBuilder)StructuredData.get().map().putBool("firstName", false)).build()).build());
            Assert.fail((String)"Creating a config that doesn't conform to the schema shouldn't be possible.");
        }
        catch (ValidationException e) {
            Assert.assertEquals((long)2L, (long)e.getMessages().size());
            Assert.assertEquals((Object)CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/d;configuration"), (Object)e.getDataPath());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(0)).getSeverity());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(1)).getSeverity());
        }
    }

    @Test
    public void testUpdateWithInvalidConfiguration() throws Exception {
        Resources.Single res = (Resources.Single)this.inventory.inspect(CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/r;Alois"), Resources.Single.class);
        try {
            ((Data.Single)((Data.ReadWrite)res.data()).get((Object)DataRole.Resource.configuration)).update(DataEntity.Update.builder().withValue(((StructuredData.MapBuilder)StructuredData.get().map().putBool("firstName", false)).build()).build());
            Assert.fail((String)"Updating a config that doesn't conform to the schema shouldn't be possible.");
        }
        catch (ValidationException e) {
            Assert.assertEquals((long)2L, (long)e.getMessages().size());
            Assert.assertEquals((Object)CanonicalPath.fromString((String)"/t;com.acme.tenant/e;production/r;people/r;Alois/d;configuration"), (Object)e.getDataPath());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(0)).getSeverity());
            Assert.assertEquals((Object)"ERROR", (Object)((ValidationException.ValidationMessage)e.getMessages().get(1)).getSeverity());
        }
    }

    @Test
    public void testCreateWithRelationships() throws Exception {
        try {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).create((Blueprint)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("env-with-rel")).addOutgoingRelationship("kachna", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get())).addIncomingRelationship("duck", (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).get())).build());
            Assert.assertTrue((boolean)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships(Relationships.Direction.incoming)).named("kachna").anyExists());
            Assert.assertTrue((boolean)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).relationships(Relationships.Direction.outgoing)).named("duck").anyExists());
        }
        finally {
            Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"env-with-rel");
            if (env.exists()) {
                env.delete();
            }
        }
    }

    @Test
    public void testResourceOwnedMetrics() throws Exception {
        ((Metrics.Single)((Metrics.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).get((Object)"feedResource3")).metrics()).get((Object)"feedResource3-metric")).exists();
        ((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).get((Object)"feedResource3")).allMetrics()).get((Object)RelativePath.to().metric("feedResource3-metric").get())).exists();
    }

    @Test
    public void testGettingResourceTypesFromTenants() throws Exception {
        Set rts = ((ResourceTypes.Multiple)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rts.size());
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("URL")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("Person")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("mpRt")));
        rts = ((ResourceTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypesUnder((Tenants.ResourceTypeParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)4L, (long)rts.size());
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("URL")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("Person")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("mpRt")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("feed1-resourceType")));
        rts = ((ResourceTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypesUnder(new Tenants.ResourceTypeParents[0]).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rts.size());
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("URL")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("Person")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("mpRt")));
        rts = ((ResourceTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypesUnder(new Tenants.ResourceTypeParents[]{Tenants.ResourceTypeParents.TENANT}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rts.size());
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("URL")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("Person")));
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("mpRt")));
        rts = ((ResourceTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).resourceTypesUnder(new Tenants.ResourceTypeParents[]{Tenants.ResourceTypeParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)rts.size());
        Assert.assertTrue((boolean)rts.stream().anyMatch(rt -> rt.getId().equals("feed1-resourceType")));
    }

    @Test
    public void testGettingMetricTypesFromTenants() throws Exception {
        Set mts = ((MetricTypes.Multiple)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypes()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)mts.size());
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("ResponseTime")));
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("mpMt")));
        mts = ((MetricTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypesUnder(new Tenants.MetricTypeParents[0]).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)mts.size());
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("ResponseTime")));
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("mpMt")));
        mts = ((MetricTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypesUnder((Tenants.MetricTypeParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)mts.size());
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("ResponseTime")));
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("mpMt")));
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("feed1-metricType")));
        mts = ((MetricTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypesUnder(new Tenants.MetricTypeParents[]{Tenants.MetricTypeParents.TENANT}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)mts.size());
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("ResponseTime")));
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("mpMt")));
        mts = ((MetricTypes.Multiple)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).metricTypesUnder(new Tenants.MetricTypeParents[]{Tenants.MetricTypeParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)mts.size());
        Assert.assertTrue((boolean)mts.stream().anyMatch(rt -> rt.getId().equals("feed1-metricType")));
    }

    @Test
    public void testGettingResourcesFromFeeds() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resources()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource2")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource3")));
        rs = ((Resources.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resourcesUnder((Feeds.ResourceParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)4L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource2")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource3")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedChildResource")));
        rs = ((Resources.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resourcesUnder(new Feeds.ResourceParents[]{Feeds.ResourceParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource2")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource3")));
        rs = ((Resources.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).resourcesUnder(new Feeds.ResourceParents[]{Feeds.ResourceParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedChildResource")));
    }

    @Test
    public void testGettingMetricsFromFeeds() throws Exception {
        Set ms = ((Metrics.Multiple)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metrics()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        ms = ((Metrics.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metricsUnder(new Feeds.MetricParents[]{Feeds.MetricParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        ms = ((Metrics.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metricsUnder(new Feeds.MetricParents[]{Feeds.MetricParents.FEED, Feeds.MetricParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedResource3-metric")));
        ms = ((Metrics.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metricsUnder((Feeds.MetricParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedResource3-metric")));
        ms = ((Metrics.Multiple)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).feeds()).get((Object)"feed1")).metricsUnder(new Feeds.MetricParents[]{Feeds.MetricParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedResource3-metric")));
    }

    @Test
    public void testGettingResourcesFromEnvironments() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("host1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("people")));
        rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder((Environments.ResourceParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)10L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("host1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource2")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource3")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedChildResource")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("people")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Hynek")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Alois")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Vilem")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Jarmila")));
        rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder(new Environments.ResourceParents[]{Environments.ResourceParents.ENVIRONMENT}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("host1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("people")));
        rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder(new Environments.ResourceParents[]{Environments.ResourceParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource2")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedResource3")));
        rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder(new Environments.ResourceParents[]{Environments.ResourceParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)5L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Hynek")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Alois")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Vilem")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Jarmila")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedChildResource")));
        rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resourcesUnder(new Environments.ResourceParents[]{Environments.ResourceParents.ENVIRONMENT, Environments.ResourceParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)7L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("host1")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("people")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Hynek")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Alois")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Vilem")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Jarmila")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("feedChildResource")));
    }

    @Test
    public void testGettingMetricsFromEnvironments() throws Exception {
        Set ms = ((Metrics.Multiple)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metrics()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("host1_ping_response")));
        ms = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder(new Environments.MetricParents[]{Environments.MetricParents.ENVIRONMENT}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("host1_ping_response")));
        ms = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder(new Environments.MetricParents[]{Environments.MetricParents.FEED}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        ms = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder(new Environments.MetricParents[]{Environments.MetricParents.RESOURCE}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)1L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedResource3-metric")));
        ms = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder(new Environments.MetricParents[]{Environments.MetricParents.FEED, Environments.MetricParents.ENVIRONMENT}).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("host1_ping_response")));
        ms = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).metricsUnder((Environments.MetricParents[])Parents.any()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)3L, (long)ms.size());
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedMetric1")));
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("host1_ping_response")));
        Assert.assertTrue((boolean)ms.stream().anyMatch(m -> m.getId().equals("feedResource3-metric")));
    }

    @Test
    public void testGettingResourcesFromResources() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).get((Object)"people")).resources()).getAll(new Filter[0])).entities();
        Assert.assertEquals((long)2L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Alois")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Hynek")));
        rs = ((Resources.Multiple)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)"com.acme.tenant")).environments()).get((Object)"production")).resources()).get((Object)"people")).recursiveResources().getAll(new Filter[0])).entities();
        Assert.assertEquals((long)4L, (long)rs.size());
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Alois")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Hynek")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Vilem")));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> r.getId().equals("Jarmila")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssociationsNotDuplicated() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("testAssociationsNotDuplicated")).build())).entity();
        ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).create((Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rtype")).build())).entity();
        MetricType mt = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).create((Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("mtype")).withUnit(MetricUnit.NONE).withInterval(Long.valueOf(0L)).build())).entity();
        Environment env = (Environment)((Environments.Single)((Environments.ReadWrite)this.inventory.inspect(t).environments()).create((Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("env")).build())).entity();
        Resource r = (Resource)((Resources.Single)((Resources.ReadWrite)this.inventory.inspect(env).resources()).create((Blueprint)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("res")).withResourceTypePath(rt.getPath().toString()).build())).entity();
        Metric m = (Metric)((Metrics.Single)((Metrics.ReadWrite)this.inventory.inspect(env).metrics()).create((Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("met")).withMetricTypePath(mt.getPath().toString()).build())).entity();
        try {
            Relationship rel22;
            Relationship rel = ((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).associate((Path)m.getPath());
            Assert.assertNotNull((Object)rel);
            try {
                rel22 = ((Metrics.ReadAssociate)this.inventory.inspect(r).allMetrics()).associate((Path)m.getPath());
                Assert.fail((String)"Should not be possible to create an association twice.");
            }
            catch (RelationAlreadyExistsException rel22) {
                // empty catch block
            }
            try {
                rel22 = (Relationship)((Relationships.Single)((Relationships.ReadWrite)this.inventory.inspect(r).relationships()).linkWith(Relationships.WellKnown.incorporates, (Path)m.getPath(), null)).entity();
                Assert.fail((String)"Should not be possible to create an association twice.");
            }
            catch (RelationAlreadyExistsException relationAlreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            this.inventory.inspect(t).delete();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testNotificationsInTransactionFrame() throws Exception {
        Tenant tenant = null;
        TransactionFrame frame = this.inventory.newTransactionFrame();
        try {
            Inventory inv = frame.boundInventory();
            Integer[] observedCreations = new Integer[]{0};
            Observable obs = inv.observable(Interest.in(Feed.class).being(Action.created()));
            obs.subscribe(t -> {
                Integer n = observedCreations[0];
                Integer n2 = observedCreations[0] = Integer.valueOf(observedCreations[0] + 1);
            });
            tenant = (Tenant)((Tenants.Single)inv.tenants().create((Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("testNotificationsInTransactionFrame")).build())).entity();
            ((Feeds.Single)((Feeds.ReadWrite)inv.inspect(tenant).feeds()).create((Blueprint)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("feed")).build())).entity();
            Feed f = (Feed)((Feeds.Single)((Feeds.ReadWrite)inv.inspect(tenant).feeds()).get((Object)"feed")).entity();
            Assert.assertEquals((long)0L, (long)observedCreations[0].intValue());
            Assert.assertNull((Object)f.getIdentityHash());
            frame.commit();
            Assert.assertEquals((long)1L, (long)observedCreations[0].intValue());
            f = (Feed)((Feeds.Single)((Feeds.ReadWrite)this.inventory.inspect(tenant).feeds()).get((Object)"feed")).entity();
            Assert.assertNotNull((Object)f.getIdentityHash());
            if (tenant == null) return;
        }
        catch (Exception e) {
            try {
                frame.rollback();
                throw e;
            }
            catch (Throwable throwable) {
                if (tenant == null) throw throwable;
                this.inventory.inspect(tenant).delete();
                throw throwable;
            }
        }
        this.inventory.inspect(tenant).delete();
        return;
    }

    @Test
    public void testExecuteQuery() throws Exception {
        Query normalQuery = Query.path().with(new Filter[]{With.type(Tenant.class)}).get();
        Query elementTypeSwitchingQuery = Query.path().with(new Filter[]{With.type(Tenant.class), SwitchElementType.outgoingRelationships()}).get();
        Query elementTypeSwitchingQuery2 = Query.path().with(new Filter[]{With.path((CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.EnvironmentBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("com.acme.tenant")).environment("production")).resource("host1")).get())), SwitchElementType.outgoingRelationships(), RelationWith.name((String)"incorporates"), SwitchElementType.targetEntities(), With.type(Metric.class)}).get();
        Page res = this.inventory.execute(normalQuery, AbstractElement.class, Pager.none());
        List result = res.toList();
        Assert.assertEquals((long)2L, (long)result.size());
        Page res2 = this.inventory.execute(elementTypeSwitchingQuery, Relationship.class, Pager.none());
        result = res2.toList();
        Assert.assertEquals((long)12L, (long)result.size());
        res = this.inventory.execute(elementTypeSwitchingQuery2, AbstractElement.class, Pager.none());
        result = res.toList();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    private <T extends AbstractElement<?, U>, U extends AbstractElement.Update> void runObserverTest(Class<T> entityClass, int nofCreatedRelationships, int nofDeletedRelationships, Runnable payload) {
        ArrayList createdEntities = new ArrayList();
        ArrayList updatedEntities = new ArrayList();
        ArrayList deletedEntities = new ArrayList();
        ArrayList createdRelationships = new ArrayList();
        ArrayList deletedRelationships = new ArrayList();
        Subscription s1 = this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(createdEntities::add);
        Subscription s2 = this.inventory.observable(Interest.in(entityClass).being(Action.updated())).subscribe(updatedEntities::add);
        Subscription s3 = this.inventory.observable(Interest.in(entityClass).being(Action.deleted())).subscribe(deletedEntities::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.deleted())).subscribe(deletedRelationships::add);
        this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(t -> {});
        payload.run();
        Assert.assertEquals((long)1L, (long)createdEntities.size());
        Assert.assertEquals((long)1L, (long)updatedEntities.size());
        Assert.assertEquals((long)1L, (long)deletedEntities.size());
        Assert.assertEquals((long)nofCreatedRelationships, (long)createdRelationships.size());
        Assert.assertEquals((long)nofDeletedRelationships, (long)deletedRelationships.size());
        s1.unsubscribe();
        s2.unsubscribe();
        s3.unsubscribe();
        Assert.assertTrue((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.created())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.updated())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.deleted())));
    }

    private static interface TetraFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

