/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.hawkular.inventory.api.model.ContentHash;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.SegmentType;
import org.junit.Assert;
import org.junit.Test;

public class ContentHashTest {
    @Test
    public void testComputesForEveryEntityType() throws Exception {
        final HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("a", "b");
        props.put("b", "c");
        final String name = "name";
        ElementTypeVisitor<Entity.Blueprint, Void> generator = new ElementTypeVisitor<Entity.Blueprint, Void>(){

            public Entity.Blueprint visitTenant(Void parameter) {
                return ((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).build();
            }

            public Entity.Blueprint visitEnvironment(Void parameter) {
                return ((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).build();
            }

            public Entity.Blueprint visitFeed(Void parameter) {
                return ((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)((Feed.Blueprint.Builder)Feed.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).build();
            }

            public Entity.Blueprint visitMetric(Void parameter) {
                return ((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).withMetricTypePath("../../metricType").withInterval(Long.valueOf(1L)).build();
            }

            public Entity.Blueprint visitMetricType(Void parameter) {
                return ((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder((MetricDataType)MetricDataType.GAUGE).withId("id")).withName(name)).withProperties(props)).withInterval(Long.valueOf(1L)).withUnit(MetricUnit.BYTES).build();
            }

            public Entity.Blueprint visitResource(Void parameter) {
                return ((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).withResourceTypePath("../../resourceType").build();
            }

            public Entity.Blueprint visitResourceType(Void parameter) {
                return ((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).build();
            }

            public Entity.Blueprint visitRelationship(Void parameter) {
                return null;
            }

            public Entity.Blueprint visitData(Void parameter) {
                return ((DataEntity.Blueprint.Builder)((DataEntity.Blueprint.Builder)DataEntity.Blueprint.builder().withId("configuration").withName(name)).withProperties(props)).withValue(StructuredData.get().bool(Boolean.valueOf(true))).build();
            }

            public Entity.Blueprint visitOperationType(Void parameter) {
                return ((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId("id")).withName(name)).withProperties(props)).build();
            }

            public Entity.Blueprint visitMetadataPack(Void parameter) {
                return null;
            }

            public Entity.Blueprint visitUnknown(Void parameter) {
                return null;
            }
        };
        final String commonHash = this.hash(name, props);
        final String metricHash = this.hash("../../mt;metricType1" + name, props);
        final String resourceHash = this.hash("../../rt;resourceType" + name, props);
        final String metricTypeHash = this.hash("" + MetricDataType.GAUGE + MetricUnit.BYTES + "1" + name, props);
        final String dataHash = this.hash(StructuredData.get().bool(Boolean.valueOf(true)).toJSON() + "configuration", props);
        for (SegmentType t : SegmentType.values()) {
            Entity.Blueprint bl = (Entity.Blueprint)ElementTypeVisitor.accept((SegmentType)t, (ElementTypeVisitor)generator, null);
            if (bl == null) continue;
            final String contentHash = ContentHash.of((Entity.Blueprint)bl, (CanonicalPath)((CanonicalPath)((CanonicalPath.ResourceBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant("tnt")).feed("fd")).resource("id")).get()));
            ElementTypeVisitor.accept((SegmentType)t, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Void, Void>(){

                protected Void defaultAction(SegmentType elementType, Void parameter) {
                    Assert.assertEquals((String)("Unexpected content hash for " + elementType.getSimpleName()), (Object)commonHash, (Object)contentHash);
                    return null;
                }

                public Void visitMetric(Void parameter) {
                    Assert.assertEquals((String)"Unexpected content hash for Metric", (Object)metricHash, (Object)contentHash);
                    return null;
                }

                public Void visitMetricType(Void parameter) {
                    Assert.assertEquals((String)"Unexpected content hash for MetricType", (Object)metricTypeHash, (Object)contentHash);
                    return null;
                }

                public Void visitResource(Void parameter) {
                    Assert.assertEquals((String)"Unexpected content hash for Resource", (Object)resourceHash, (Object)contentHash);
                    return null;
                }

                public Void visitData(Void parameter) {
                    Assert.assertEquals((String)"Unexpected content hash for DataEntity", (Object)dataHash, (Object)contentHash);
                    return null;
                }
            }, null);
        }
    }

    private String digest(String content) throws NoSuchAlgorithmException {
        byte[] digest = MessageDigest.getInstance("SHA-1").digest(content.getBytes(Charset.forName("UTF-8")));
        StringBuilder bld = new StringBuilder();
        for (byte b : digest) {
            bld.append(Integer.toHexString(Byte.toUnsignedInt(b)));
        }
        return bld.toString();
    }

    private String hash(String name, Map<String, Object> properties) throws NoSuchAlgorithmException {
        TreeMap sorted = new TreeMap(Comparator.naturalOrder());
        sorted.putAll(properties);
        StringBuilder content = new StringBuilder(name);
        sorted.forEach((k, v) -> content.append((String)k).append(v));
        return this.digest(content.toString());
    }
}

