/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Data;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.OperationTypes;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.EmptyRelativePath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public interface InventoryStructure<Root extends Entity.Blueprint> {
    public static <E extends Entity<B, ?>, B extends Entity.Blueprint> InventoryStructure<B> of(final E rootEntity, final Inventory inventory) {
        return new InventoryStructure<B>(){
            FullNode root;
            HashMap<CanonicalPath, FullNode> cache;
            {
                this.root = new FullNode((Entity.Blueprint)Inventory.asBlueprint(rootEntity), rootEntity);
                this.cache = new HashMap();
            }

            @Override
            public B getRoot() {
                return this.root.entity;
            }

            @Override
            public <EE extends Entity<? extends BB, ?>, BB extends Blueprint> Stream<BB> getChildren(RelativePath parent, Class<EE> childType) {
                final CanonicalPath absoluteParent = rootEntity.getPath().modified().extend((Collection)parent.getPath()).get();
                final SegmentType parentType = absoluteParent.getSegment().getElementType();
                SegmentType childSegment = SegmentType.fromElementType(childType);
                return (Stream)ElementTypeVisitor.accept((SegmentType)childSegment, (ElementTypeVisitor)new ElementTypeVisitor<Stream<BB>, Void>(){

                    public Stream<BB> visitTenant(Void parameter) {
                        if (absoluteParent.isDefined()) {
                            return Stream.empty();
                        }
                        return this.fromRead(inventory.tenants());
                    }

                    public Stream<BB> visitEnvironment(Void parameter) {
                        return this.fromRead(Tenant.class, Tenants.Single.class, Environments.Container::environments);
                    }

                    public Stream<BB> visitFeed(Void parameter) {
                        return this.fromRead(Tenant.class, Tenants.Single.class, Feeds.Container::feeds);
                    }

                    public Stream<BB> visitMetric(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitEnvironment(Void parameter) {
                                return this.fromRead(Environment.class, Environments.Single.class, Metrics.Container::metrics);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, Metrics.Container::metrics);
                            }

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Metrics.Container::metrics);
                            }
                        }, null);
                    }

                    public Stream<BB> visitMetricType(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitTenant(Void parameter) {
                                return this.fromRead(Tenant.class, Tenants.Single.class, MetricTypes.Container::metricTypes);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, MetricTypes.Container::metricTypes);
                            }
                        }, null);
                    }

                    public Stream<BB> visitResource(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitEnvironment(Void parameter) {
                                return this.fromRead(Environment.class, Environments.Single.class, Resources.Container::resources);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, Resources.Container::resources);
                            }

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Resources.Container::resources);
                            }
                        }, null);
                    }

                    public Stream<BB> visitResourceType(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitTenant(Void parameter) {
                                return this.fromRead(Tenant.class, Tenants.Single.class, ResourceTypes.Container::resourceTypes);
                            }

                            public Stream<BB> visitFeed(Void parameter) {
                                return this.fromRead(Feed.class, Feeds.Single.class, ResourceTypes.Container::resourceTypes);
                            }
                        }, null);
                    }

                    public Stream<BB> visitRelationship(Void parameter) {
                        return Stream.empty();
                    }

                    public Stream<BB> visitData(Void parameter) {
                        return (Stream)ElementTypeVisitor.accept((SegmentType)parentType, (ElementTypeVisitor)new ElementTypeVisitor.Simple<Stream<BB>, Void>(){

                            public Stream<BB> visitResource(Void parameter) {
                                return this.fromRead(Resource.class, Resources.Single.class, Data.Container::data);
                            }

                            public Stream<BB> visitResourceType(Void parameter) {
                                return this.fromRead(ResourceType.class, ResourceTypes.Single.class, Data.Container::data);
                            }

                            public Stream<BB> visitOperationType(Void parameter) {
                                return this.fromRead(OperationType.class, OperationTypes.Single.class, Data.Container::data);
                            }
                        }, null);
                    }

                    public Stream<BB> visitOperationType(Void parameter) {
                        return this.fromRead(ResourceType.class, ResourceTypes.Single.class, OperationTypes.Container::operationTypes);
                    }

                    public Stream<BB> visitMetadataPack(Void parameter) {
                        throw new IllegalStateException("Unhandled type of entity in inventory structure: " + parentType);
                    }

                    public Stream<BB> visitUnknown(Void parameter) {
                        throw new IllegalStateException("Unhandled type of entity in inventory structure: " + parentType);
                    }

                    private <P extends Entity<?, PU>, PA extends ResolvableToSingle<P, PU>, PU extends Entity.Update, X extends Entity<XB, ?>, XB extends Entity.Blueprint> Stream<BB> fromRead(Class<P> parentType2, Class<PA> parentAccessType, Function<PA, ResolvingToMultiple<? extends ResolvableToMany<X>>> childAccessSupplier) {
                        Class<AbstractElement<?, ?>> parentSegmentType = AbstractElement.toElementClass(absoluteParent.getSegment().getElementType());
                        if (!absoluteParent.isDefined() || !parentType2.equals(parentSegmentType)) {
                            return Stream.empty();
                        }
                        PA parentAccess = inventory.inspect(absoluteParent, parentAccessType);
                        return this.fromRead(childAccessSupplier.apply(parentAccess));
                    }

                    private <X extends Entity<XB, ?>, XB extends Entity.Blueprint> Stream<BB> fromRead(ResolvingToMultiple<? extends ResolvableToMany<X>> read) {
                        Page<X> it = read.getAll(new Filter[0]).entities(Pager.none());
                        Spliterator<X> sit = Spliterators.spliterator(it, Long.MAX_VALUE, 0);
                        return (Stream)StreamSupport.stream(sit, false).map(e -> {
                            Entity.Blueprint blueprint = (Entity.Blueprint)Inventory.asBlueprint(e);
                            cache.put(e.getPath(), new FullNode(blueprint, e));
                            return blueprint;
                        }).onClose(it::close);
                    }
                }, null);
            }

            @Override
            public Entity.Blueprint get(RelativePath path) {
                FullNode n = this.doGet(path);
                return n == null ? null : n.getEntity();
            }

            @Override
            public FullNode getNode(RelativePath path) {
                return this.doGet(path);
            }

            private FullNode doGet(RelativePath path) {
                CanonicalPath pathToElement = rootEntity.getPath().modified().extend((Collection)path.getPath()).get();
                try {
                    FullNode cached = this.cache.get(pathToElement);
                    if (cached != null) {
                        return cached == FullNode.EMPTY ? null : cached;
                    }
                    Entity entity = (Entity)inventory.inspect(pathToElement, ResolvableToSingle.class).entity();
                    Entity.Blueprint b = (Entity.Blueprint)Inventory.asBlueprint(entity);
                    FullNode ret = new FullNode(b, entity);
                    this.cache.put(entity.getPath(), ret);
                    return ret;
                }
                catch (EntityNotFoundException e) {
                    this.cache.put(pathToElement, FullNode.EMPTY);
                    return null;
                }
            }
        };
    }

    public static <B extends Entity.Blueprint> Builder<B> of(B root) {
        return Offline.of(root);
    }

    public Root getRoot();

    public <E extends Entity<? extends B, ?>, B extends Blueprint> Stream<B> getChildren(RelativePath var1, Class<E> var2);

    public Entity.Blueprint get(RelativePath var1);

    default public FullNode getNode(RelativePath path) {
        Entity.Blueprint bl = this.get(path);
        return bl == null ? null : new FullNode(bl, null);
    }

    default public Stream<Entity.Blueprint> getAllChildren(RelativePath parent) {
        Stream<Entity.Blueprint> ret = Stream.empty();
        RelativePath.Extender check = RelativePath.empty().extend(Blueprint.getSegmentTypeOf(this.getRoot()), ((Entity.Blueprint)this.getRoot()).getId()).extend((Collection)parent.getPath());
        for (SegmentType st : SegmentType.values()) {
            List res;
            if (st == SegmentType.rl || !EntityType.supports(st) || !check.canExtendTo(st).booleanValue()) continue;
            try (Stream next = this.getChildren(parent, Entity.entityTypeFromSegmentType(st));){
                res = next.map(e -> (Entity.Blueprint)e).collect(Collectors.toList());
            }
            ret = Stream.concat(ret, res.stream());
        }
        return ret;
    }

    default public Stream<FullNode> getAllChildrenWithAttachments(RelativePath parent) {
        Stream<FullNode> ret = Stream.empty();
        RelativePath.Extender check = RelativePath.empty().extend(Blueprint.getSegmentTypeOf(this.getRoot()), ((Entity.Blueprint)this.getRoot()).getId()).extend((Collection)parent.getPath());
        RelativePath parentPath = check.get();
        for (SegmentType st : SegmentType.values()) {
            List res;
            if (st == SegmentType.rl || !EntityType.supports(st) || !check.canExtendTo(st).booleanValue()) continue;
            try (Stream next = this.getChildren(parent, Entity.entityTypeFromSegmentType(st));){
                res = next.map(b -> (Entity.Blueprint)b).map(b -> {
                    FullNode attachment = this.getNode(parentPath.modified().extend(st, b.getId()).get());
                    return new FullNode((Entity.Blueprint)b, attachment);
                }).collect(Collectors.toList());
            }
            ret = Stream.concat(ret, res.stream());
        }
        return ret;
    }

    public static final class ChildBuilder<ParentBuilder extends AbstractBuilder<?>>
    extends AbstractBuilder<ChildBuilder<ParentBuilder>> {
        final ParentBuilder parentBuilder;

        private ChildBuilder(ParentBuilder parentBuilder, RelativePath parent, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            super(parent, blueprints, children);
            this.parentBuilder = parentBuilder;
        }

        public ParentBuilder end() {
            return this.parentBuilder;
        }

        public ParentBuilder remove() {
            this.removeAllChildren();
            Set<FullNode> siblings = this.getSiblings();
            FullNode myBlueprint = (FullNode)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            return this.parentBuilder;
        }

        @Override
        void doReplace(Entity.Blueprint blueprint, Object attachment) {
            Set<FullNode> siblings = this.getSiblings();
            FullNode myBlueprint = (FullNode)this.blueprints.remove(this.myPath);
            siblings.remove(myBlueprint);
            FullNode myNode = new FullNode(blueprint, attachment);
            siblings.add(myNode);
            this.children.remove(this.myPath);
            this.myPath = ((AbstractBuilder)this.parentBuilder).myPath.modified().extend(Blueprint.getSegmentTypeOf(blueprint), blueprint.getId()).get();
            this.blueprints.put(this.myPath, myNode);
        }

        private Set<FullNode> getSiblings() {
            FullNode myBlueprint = (FullNode)this.blueprints.get(this.myPath);
            Map siblingsByType = (Map)this.children.get(((AbstractBuilder)this.parentBuilder).myPath);
            EntityType myType = EntityType.of(Blueprint.getEntityTypeOf(myBlueprint.getEntity()));
            return (Set)siblingsByType.get((Object)myType);
        }

        /* synthetic */ ChildBuilder(AbstractBuilder x0, RelativePath x1, Map x2, Map x3, 1 x4) {
            this(x0, x1, (Map<RelativePath, FullNode>)x2, x3);
        }
    }

    public static final class Builder<Root extends Entity.Blueprint>
    extends AbstractBuilder<Builder<Root>> {
        private final Root root;

        private Builder(Root root, Object attachment, RelativePath myPath, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            super(myPath, blueprints, children);
            this.root = root;
            this.blueprints.put(EmptyRelativePath.I, new FullNode((Entity.Blueprint)root, attachment));
        }

        public Builder(Root root) {
            this(root, null);
        }

        public Builder(Root root, Object attachment) {
            this(root, attachment, EmptyRelativePath.I, new HashMap<RelativePath, FullNode>(), new HashMap<RelativePath, Map<EntityType, Set<FullNode>>>());
        }

        public Offline<Root> build() {
            return new Offline((Entity.Blueprint)this.root, this.blueprints, this.children, null);
        }

        @Override
        void doReplace(Entity.Blueprint blueprint, Object attachment) {
            this.blueprints.put(this.myPath, new FullNode(blueprint, attachment));
            this.children.remove(this.myPath);
        }

        /* synthetic */ Builder(Entity.Blueprint x0, Object x1, RelativePath x2, Map x3, Map x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static abstract class AbstractBuilder<This extends AbstractBuilder<?>> {
        RelativePath myPath;
        final Map<RelativePath, Map<EntityType, Set<FullNode>>> children;
        final Map<RelativePath, FullNode> blueprints;

        private AbstractBuilder(RelativePath myPath, Map<RelativePath, FullNode> blueprints, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            this.myPath = myPath;
            this.children = children;
            this.blueprints = blueprints;
        }

        public ChildBuilder<This> startChild(Entity.Blueprint child) {
            return this.startChild(child, null);
        }

        public ChildBuilder<This> startChild(Entity.Blueprint child, Object childAttachment) {
            RelativePath.Extender extender = this.myPath.modified();
            Class childType = Blueprint.getEntityTypeOf(child);
            SegmentType childSeg = Blueprint.getSegmentTypeOf(child);
            if (!extender.canExtendTo(childSeg).booleanValue()) {
                throw new IllegalArgumentException("Cannot extend path " + this.myPath + " with child of type " + childType);
            }
            RelativePath childPath = extender.extend(childSeg, child.getId()).get();
            Set<FullNode> bls = this.getChildrenOfType(EntityType.of(childType));
            FullNode node = new FullNode(child, childAttachment);
            bls.add(node);
            this.blueprints.put(childPath, node);
            return new ChildBuilder((AbstractBuilder)this.castThis(), childPath, this.blueprints, this.children, null);
        }

        public RelativePath getPath() {
            return this.myPath;
        }

        public Entity.Blueprint getBlueprint() {
            return this.blueprints.get(this.myPath).getEntity();
        }

        public FullNode getNode() {
            return this.blueprints.get(this.myPath);
        }

        public ChildBuilder<This> getChild(Path.Segment childPath) {
            Map<EntityType, Set<FullNode>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return null;
            }
            EntityType childType = EntityType.of(childPath.getElementType());
            Set<FullNode> childrenOfType = myChildren.get((Object)childType);
            return childrenOfType.stream().filter(child -> child.getEntity().getId().equals(childPath.getElementId())).findAny().map(child -> {
                RelativePath rp = this.myPath.modified().extend(childPath).get();
                return new ChildBuilder((AbstractBuilder)this.castThis(), rp, this.blueprints, this.children, null);
            }).orElse(null);
        }

        public This removeChild(Path.Segment childPath) {
            ChildBuilder<This> childBuilder = this.getChild(childPath);
            if (childBuilder != null) {
                childBuilder.remove();
            }
            return this.castThis();
        }

        public Set<Path.Segment> getChildrenPaths() {
            Map<EntityType, Set<FullNode>> myChildren = this.children.get(this.myPath);
            if (myChildren == null) {
                return Collections.emptySet();
            }
            return myChildren.values().stream().flatMap(Collection::stream).map(b -> new Path.Segment(Blueprint.getSegmentTypeOf(b.getEntity()), b.getEntity().getId())).collect(Collectors.toSet());
        }

        public This removeAllChildren() {
            this.getChildrenPaths().forEach(this::removeChild);
            this.children.remove(this.myPath);
            return this.castThis();
        }

        public This replace(Entity.Blueprint blueprint) {
            return this.replace(blueprint, null);
        }

        public This replace(Entity.Blueprint blueprint, Object attachment) {
            this.removeAllChildren();
            FullNode myBl = this.blueprints.get(this.myPath);
            if (!myBl.getEntity().getClass().equals(blueprint.getClass())) {
                throw new IllegalArgumentException("Blueprint " + blueprint + " not of the same type as " + myBl.getEntity());
            }
            this.doReplace(blueprint, attachment);
            return this.castThis();
        }

        abstract void doReplace(Entity.Blueprint var1, Object var2);

        Set<FullNode> getChildrenOfType(EntityType childType) {
            Set<FullNode> bls;
            Map<EntityType, Set<FullNode>> cs = this.children.get(this.myPath);
            if (cs == null) {
                cs = new EnumMap<EntityType, Set<FullNode>>(EntityType.class);
                this.children.put(this.myPath, cs);
            }
            if ((bls = cs.get((Object)childType)) == null) {
                bls = new HashSet<FullNode>();
                cs.put(childType, bls);
            }
            return bls;
        }

        public This addChild(Entity.Blueprint child) {
            return this.addChild(child, null);
        }

        public This addChild(Entity.Blueprint child, Object attachment) {
            this.startChild(child, attachment).end();
            return this.castThis();
        }

        public This addChild(InventoryStructure<?> structure, boolean overwrite) {
            return this.addChild(Offline.copy(structure).asBuilder(), overwrite);
        }

        public This addChild(AbstractBuilder<?> structure, boolean overwrite) {
            RelativePath structureRoot = structure.getPath();
            for (Map.Entry<RelativePath, FullNode> e : structure.blueprints.entrySet()) {
                EntityType structureType;
                Set<FullNode> childrenOfType;
                RelativePath parentPath;
                Map<EntityType, Set<FullNode>> parentChildren;
                RelativePath structurePath = e.getKey();
                if (!structureRoot.equals((Object)structurePath) && !structureRoot.isParentOf(structurePath)) continue;
                RelativePath strippedStructurePath = structurePath.slide(structureRoot.getDepth(), 0);
                RelativePath newStructurePath = this.myPath.modified().extend((Collection)strippedStructurePath.getPath()).get();
                if (overwrite || !this.blueprints.containsKey(newStructurePath)) {
                    this.blueprints.put(newStructurePath, e.getValue());
                }
                if ((parentChildren = this.children.get(parentPath = newStructurePath.up())) == null) {
                    parentChildren = new HashMap<EntityType, Set<FullNode>>();
                    this.children.put(parentPath, parentChildren);
                }
                if ((childrenOfType = parentChildren.get((Object)(structureType = EntityType.of(newStructurePath.getSegment().getElementType())))) == null) {
                    childrenOfType = new HashSet<FullNode>();
                    parentChildren.put(structureType, childrenOfType);
                }
                childrenOfType.add(e.getValue());
                Map<EntityType, Set<FullNode>> structureChildren = structure.children.get(structurePath);
                if (structureChildren == null || structureChildren.isEmpty()) continue;
                Map<EntityType, Set<FullNode>> currentChildren = this.children.get(newStructurePath);
                if (currentChildren == null) {
                    currentChildren = new EnumMap<EntityType, Set<FullNode>>(EntityType.class);
                    this.children.put(newStructurePath, currentChildren);
                }
                for (Map.Entry<EntityType, Set<FullNode>> ee : structureChildren.entrySet()) {
                    EntityType entityType = ee.getKey();
                    Set<FullNode> structureBlueprints = ee.getValue();
                    Set<FullNode> currentBlueprints = currentChildren.get((Object)entityType);
                    if (currentBlueprints == null) {
                        currentBlueprints = new HashSet<FullNode>();
                        currentChildren.put(entityType, currentBlueprints);
                    }
                    for (FullNode structureBlueprint : structureBlueprints) {
                        if (!overwrite && currentBlueprints.contains(structureBlueprint)) continue;
                        currentBlueprints.add(structureBlueprint);
                    }
                }
            }
            return this.castThis();
        }

        This castThis() {
            return (This)this;
        }
    }

    @ApiModel(value="InventoryStructure")
    public static class Offline<Root extends Entity.Blueprint>
    implements InventoryStructure<Root>,
    Serializable {
        private final Root root;
        private final Map<RelativePath, Map<EntityType, Set<FullNode>>> children;
        private final Map<RelativePath, FullNode> entities;

        private Offline(Root root, Map<RelativePath, FullNode> entities, Map<RelativePath, Map<EntityType, Set<FullNode>>> children) {
            this.root = root;
            this.children = children;
            this.entities = entities;
        }

        public static <R extends Entity.Blueprint> Offline<R> copy(final InventoryStructure<R> other) {
            List<Entity.Blueprint> acs;
            final HashMap entities = new HashMap();
            ElementTypeVisitor.Simple<Void, RelativePath.Extender> visitor = new ElementTypeVisitor.Simple<Void, RelativePath.Extender>(){

                protected Void defaultAction(SegmentType elementType, RelativePath.Extender parentPath) {
                    Class<?> childType = Entity.typeFromSegmentType(elementType);
                    this.impl(childType, parentPath);
                    return null;
                }

                private <E extends Entity<B, ?>, B extends Entity.Blueprint> void impl(Class<E> childType, RelativePath.Extender parent) {
                    SegmentType childSeg = Entity.segmentTypeFromType(childType);
                    if (parent.canExtendTo(childSeg).booleanValue()) {
                        List<Entity.Blueprint> otherChildren;
                        RelativePath parentPath = parent.get();
                        FullNode parentNode = (FullNode)entities.get(parentPath);
                        if (parentNode == null) {
                            if (parentPath.isDefined()) {
                                throw new IllegalStateException("Could not find the tracked children of a parent " + parentNode + " during inventory structure copy. This is a " + "bug.");
                            }
                            parentNode = new FullNode((Entity.Blueprint)other.getRoot(), other.getNode(EmptyRelativePath.I));
                            entities.put(parentPath, parentNode);
                        }
                        try (Stream s = other.getChildren(parent.get(), childType);){
                            otherChildren = s.collect(Collectors.toList());
                        }
                        otherChildren.forEach(c -> {
                            RelativePath.Extender childPath = parentPath.modified().extend(childSeg, c.getId());
                            RelativePath cp = childPath.get();
                            FullNode childNode = (FullNode)entities.get(cp);
                            if (childNode == null) {
                                childNode = new FullNode((Entity.Blueprint)c, other.getNode(cp));
                                entities.put(cp, childNode);
                            }
                            for (SegmentType childChildSeg : SegmentType.values()) {
                                if (!childPath.canExtendTo(childChildSeg).booleanValue() || !EntityType.supports(childChildSeg)) continue;
                                ElementTypeVisitor.accept((SegmentType)childChildSeg, (ElementTypeVisitor)this, (Object)childPath);
                            }
                        });
                    }
                }
            };
            R root = other.getRoot();
            RelativePath empty = EmptyRelativePath.I;
            try (Stream<Entity.Blueprint> s = other.getAllChildren(empty);){
                acs = s.collect(Collectors.toList());
            }
            acs.forEach(arg_0 -> Offline.lambda$copy$28((ElementTypeVisitor)visitor, empty, arg_0));
            HashMap<RelativePath, Map<EntityType, Set<FullNode>>> children = new HashMap<RelativePath, Map<EntityType, Set<FullNode>>>();
            HashMap<RelativePath, FullNode> blueprints = new HashMap<RelativePath, FullNode>();
            for (Map.Entry e : entities.entrySet()) {
                HashSet<FullNode> childrenBlueprints;
                RelativePath entityPath = (RelativePath)e.getKey();
                FullNode entity = (FullNode)e.getValue();
                blueprints.put(entityPath, entity);
                RelativePath parent = entityPath.up();
                if (parent.equals((Object)entityPath)) continue;
                EntityType entityType = EntityType.of(Blueprint.getEntityTypeOf(entity.getEntity()));
                HashMap<EntityType, HashSet<FullNode>> childrenByType = (HashMap<EntityType, HashSet<FullNode>>)children.get(parent);
                if (childrenByType == null) {
                    childrenByType = new HashMap<EntityType, HashSet<FullNode>>();
                    children.put(parent, childrenByType);
                }
                if ((childrenBlueprints = (HashSet<FullNode>)childrenByType.get((Object)entityType)) == null) {
                    childrenBlueprints = new HashSet<FullNode>();
                    childrenByType.put(entityType, childrenBlueprints);
                }
                childrenBlueprints.add(entity);
            }
            return new Offline<R>(root, blueprints, children);
        }

        public Builder<Root> asBuilder() {
            RelativePath rootPath = EmptyRelativePath.I;
            FullNode attachment = this.getNode(rootPath);
            return new Builder((Entity.Blueprint)this.root, attachment, EmptyRelativePath.I, this.entities, this.children, null);
        }

        public static <R extends Entity.Blueprint> Builder<R> of(R root) {
            return new Builder<R>(root);
        }

        @Override
        public Root getRoot() {
            return this.root;
        }

        @Override
        public <E extends Entity<? extends B, ?>, B extends Blueprint> Stream<B> getChildren(RelativePath parent, Class<E> childType) {
            return this.children.getOrDefault(parent, Collections.emptyMap()).getOrDefault((Object)EntityType.of(childType), Collections.emptySet()).stream().map(FullNode::getEntity);
        }

        @Override
        public Entity.Blueprint get(RelativePath path) {
            return this.entities.getOrDefault(path, FullNode.EMPTY).getEntity();
        }

        @Override
        public FullNode getNode(RelativePath path) {
            return this.entities.get(path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offline offline = (Offline)o;
            if (!((Entity.Blueprint)this.root).equals(offline.root)) {
                return false;
            }
            if (!this.children.equals(offline.children)) {
                return false;
            }
            return this.entities.equals(offline.entities);
        }

        public int hashCode() {
            int result = ((Entity.Blueprint)this.root).hashCode();
            result = 31 * result + this.children.hashCode();
            result = 31 * result + this.entities.hashCode();
            return result;
        }

        private static /* synthetic */ void lambda$copy$28(ElementTypeVisitor visitor, RelativePath empty, Entity.Blueprint b) {
            Void cfr_ignored_0 = (Void)ElementTypeVisitor.accept((SegmentType)Blueprint.getSegmentTypeOf(b), (ElementTypeVisitor)visitor, (Object)empty.modified());
        }

        /* synthetic */ Offline(Entity.Blueprint x0, Map x1, Map x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static enum EntityType {
        feed(Feed.class, Feed.Blueprint.class, SegmentType.f),
        resourceType(ResourceType.class, ResourceType.Blueprint.class, SegmentType.rt),
        metricType(MetricType.class, MetricType.Blueprint.class, SegmentType.mt),
        operationType(OperationType.class, OperationType.Blueprint.class, SegmentType.ot),
        metric(Metric.class, Metric.Blueprint.class, SegmentType.m),
        resource(Resource.class, Resource.Blueprint.class, SegmentType.r),
        dataEntity(DataEntity.class, DataEntity.Blueprint.class, SegmentType.d);

        public final Class<? extends Entity<?, ?>> elementType;
        public final Class<? extends Entity.Blueprint> blueprintType;
        public final SegmentType segmentType;

        public static EntityType of(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.elementType)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of entity: " + type);
        }

        public static EntityType of(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return t;
            }
            throw new IllegalArgumentException("Unsupported type of path segment: " + seg);
        }

        public static boolean supports(SegmentType seg) {
            for (EntityType t : EntityType.values()) {
                if (seg != t.segmentType) continue;
                return true;
            }
            return false;
        }

        public static EntityType ofBlueprint(Class<?> type) {
            for (EntityType t : EntityType.values()) {
                if (!type.equals(t.blueprintType)) continue;
                return t;
            }
            return null;
        }

        private EntityType(Class<? extends Entity<?, ?>> elementType, Class<? extends Entity.Blueprint> blueprintType, SegmentType segmentType) {
            this.elementType = elementType;
            this.blueprintType = blueprintType;
            this.segmentType = segmentType;
        }
    }

    public static final class FullNode {
        static final FullNode EMPTY = new FullNode(null, null);
        private final Entity.Blueprint entity;
        private final Object attachment;

        public FullNode(Entity.Blueprint entity, Object attachment) {
            this.entity = entity;
            this.attachment = attachment;
        }

        public Entity.Blueprint getEntity() {
            return this.entity;
        }

        public Object getAttachment() {
            return this.attachment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FullNode)) {
                return false;
            }
            FullNode fullNode = (FullNode)o;
            return this.entity != null ? this.entity.equals(fullNode.entity) : fullNode.entity == null;
        }

        public int hashCode() {
            return this.entity != null ? this.entity.hashCode() : 0;
        }
    }
}

