/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.hawkular.inventory.bus.Log;

public final class Configuration {
    private final String connectionFactoryJndiName;
    private final String entityChangesTopicName;
    private final String queryQueueName;

    public static Configuration fromProperties(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
        return Configuration.fromMap(map);
    }

    public static Configuration fromMap(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            if (Property.isValid(e.getKey())) continue;
            Log.LOG.unknownConfigurationProperty(e.getKey());
        }
        EnumMap<Property, String> emap = new EnumMap<Property, String>(Property.class);
        map.forEach((k, v) -> emap.put(Property.valueOf(k), (String)v));
        return Configuration.fromEnumMap(emap);
    }

    public static Configuration fromEnumMap(Map<Property, String> map) {
        String connectionFactoryJndiName = null;
        String entityChangesTopicName = null;
        String queryQueueName = null;
        block5: for (Property p : Property.values()) {
            String value = map.get((Object)p);
            if (value == null) {
                value = p.getDefaultValue();
            }
            switch (p) {
                case CONNECTION_FACTORY_JNDI_NAME: {
                    connectionFactoryJndiName = value;
                    continue block5;
                }
                case INVENTORY_CHANGES_TOPIC_NAME: {
                    entityChangesTopicName = value;
                    continue block5;
                }
                case INVENTORY_QUERY_QUEUE_NAME: {
                    queryQueueName = value;
                }
            }
        }
        return new Configuration(connectionFactoryJndiName, entityChangesTopicName, queryQueueName);
    }

    public static Configuration getDefaultConfiguration() {
        return Configuration.fromEnumMap(Collections.emptyMap());
    }

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(String connectionFactoryJndiName, String entityChangesTopicName, String queryQueueName) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
        this.entityChangesTopicName = entityChangesTopicName;
        this.queryQueueName = queryQueueName;
    }

    public String getConnectionFactoryJndiName() {
        return this.connectionFactoryJndiName;
    }

    public String getInventoryChangesTopicName() {
        return this.entityChangesTopicName;
    }

    public String getQueryQueueName() {
        return this.queryQueueName;
    }

    public Builder modify() {
        EnumMap m = new EnumMap(Property.class);
        this.toMap().forEach((k, v) -> m.put(Property.valueOf(k), v));
        return new Builder(m);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(Property.CONNECTION_FACTORY_JNDI_NAME.propertyName, this.connectionFactoryJndiName);
        ret.put(Property.INVENTORY_CHANGES_TOPIC_NAME.propertyName, this.entityChangesTopicName);
        return ret;
    }

    public static final class Builder {
        private final Map<Property, String> config;

        private Builder() {
            this.config = new EnumMap<Property, String>(Property.class);
        }

        private Builder(EnumMap<Property, String> seed) {
            this.config = seed;
        }

        public Builder with(Property property, String value) {
            this.config.put(property, value);
            return this;
        }

        public Configuration build() {
            return Configuration.fromEnumMap(this.config);
        }
    }

    public static enum Property {
        CONNECTION_FACTORY_JNDI_NAME("java:/HawkularBusConnectionFactory", "hawkular.inventory.bus.connectionFactoryJndiName"),
        INVENTORY_CHANGES_TOPIC_NAME("HawkularInventoryChanges", "hawkular.inventory.bus.inventoryChangesTopicName"),
        INVENTORY_QUERY_QUEUE_NAME("HawkularInventoryQuery", "hawkular.inventory.bus.inventoryQueryQueName");

        private final String defaultValue;
        private final String propertyName;

        private Property(String defaultValue, String propertyName) {
            this.defaultValue = defaultValue;
            this.propertyName = propertyName;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public static boolean isValid(String name) {
            for (Property p : Property.values()) {
                if (!p.getPropertyName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

